/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.PreParam;
import com.huawei.ism.tool.infocollect.entity.PreQueryDevNode;
import com.huawei.ism.tool.infocollect.entity.PreQueryResult;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreExecuterCaller
implements Callable<PreQueryResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreExecuterCaller.class);
    private static final String SSH = "SSH";
    private PreParam preParam;
    private PreQueryDevNode queryNode;

    public PreExecuterCaller(PreParam preParam) {
        this.preParam = preParam;
    }

    public void rmThreadName() {
        String oldName = Thread.currentThread().getName();
        String ip = this.queryNode.getIp();
        Thread.currentThread().setName(oldName + "_" + ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreQueryResult call() {
        String scriptPath = this.preParam.getScriptPath();
        PreQueryResult result = new PreQueryResult();
        result.setDevNode(this.queryNode.getDevNode());
        File scriptFile = new File(scriptPath);
        File pyframe = new File(CollectDataContext.PYFRAMEPATH);
        ArrayList<File> pyClassPths = new ArrayList<File>();
        if (!scriptFile.exists()) {
            result.setShow(false);
            return result;
        }
        if (pyframe.exists()) {
            pyClassPths.add(pyframe);
        }
        pyClassPths.add(scriptFile.getParentFile());
        JythonExecuter jythonExecuter = new JythonExecuter(pyClassPths);
        Map<String, Object> params = null;
        try {
            params = this.getParams();
            jythonExecuter.compileScript(scriptFile);
            List reInfo = jythonExecuter.invokeFunction(this.preParam.getMethod(), params);
            if (null == reInfo || reInfo.isEmpty()) {
                result.setShow(false);
                LOGGER.info("The result is empty,which is come back from script.");
            } else {
                Boolean isShow = Boolean.valueOf(reInfo.get(0).toString());
                String remind = reInfo.get(1).toString();
                result.setShow(isShow);
                result.setRemind(remind);
            }
        }
        catch (SignException e) {
            LOGGER.error("script sign exception", (Object)e.getMessage());
            result.setShow(false);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("script file {} not found.", (Object)scriptFile.getName());
            result.setShow(false);
        }
        catch (ToolException e) {
            LOGGER.error("tool exception", (Object)e.getMessage());
            result.setShow(false);
        }
        finally {
            this.clearEvn(params);
        }
        return result;
    }

    private Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            SshConnection ssh = (SshConnection)SshConnectionManager.getSshConnection((DevNode)this.queryNode.getDevNode(), null, (boolean)true, (boolean)false);
            String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
            params.put("lang", language);
            params.put(SSH, ssh);
            params.put("logger", LOGGER);
            params.put("restMamager", RestConnectionManager.class);
        }
        catch (ToolException e) {
            LOGGER.error("init params error.", (Object)e.getMessage());
        }
        return params;
    }

    private void clearEvn(Map<String, Object> params) {
        try {
            SshConnection ssh = (SshConnection)params.get(SSH);
            if (null == ssh) {
                LOGGER.error("Could not get ssh object.");
                return;
            }
            ssh.close();
        }
        catch (RuntimeException e) {
            LOGGER.error("ssh connection is failed.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("close ssh failed", (Throwable)e);
        }
    }

    public void setQueryNode(PreQueryDevNode queryNode) {
        this.queryNode = queryNode;
    }
}

