/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.infocollect.service.logic.NodeCollectStatus;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RestCollectSubTask {
    private String parentTaskId;
    private int subTaskId;
    private int subTaskProgress;
    private boolean hasResultFile = true;
    private boolean downloadFinish = false;
    private boolean failed = false;
    private String errorMsg;
    private Map<Integer, NodeCollectStatus> nodesCollectStatusMap = new KeyOrderedHashMap();

    public RestCollectSubTask(String parentTaskId, int subTaskId) {
        this.parentTaskId = parentTaskId;
        this.subTaskId = subTaskId;
    }

    public RestCollectSubTask(String parentTaskId, int subTaskId, int subTaskProgress, boolean hasResultFile) {
        this(parentTaskId, subTaskId);
        this.subTaskProgress = subTaskProgress;
        this.hasResultFile = hasResultFile;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public List<Integer> getFailedNodesIdList() {
        ArrayList<Integer> failedNodeIdList = new ArrayList<Integer>();
        for (int nodeId : this.nodesCollectStatusMap.keySet()) {
            if (!this.nodesCollectStatusMap.get(nodeId).isNodeCollectFailed()) continue;
            failedNodeIdList.add(nodeId);
        }
        return failedNodeIdList;
    }

    public String getNodesString() {
        Iterator<Map.Entry<Integer, NodeCollectStatus>> entryIterator = this.nodesCollectStatusMap.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (entryIterator.hasNext()) {
            sb.append(entryIterator.next().getKey()).append(',');
        }
        String ret = sb.toString();
        return this.nodesCollectStatusMap.isEmpty() ? "" : ret.substring(0, ret.length() - 1);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isSubTaskSuccess() {
        if (this.nodesCollectStatusMap.isEmpty()) {
            return false;
        }
        for (int serverId : this.nodesCollectStatusMap.keySet()) {
            if (this.nodesCollectStatusMap.get(serverId).isNodeCollectSuccess()) continue;
            return false;
        }
        return true;
    }

    public boolean atLeastOneNodeSuccess() {
        if (this.nodesCollectStatusMap.isEmpty()) {
            return false;
        }
        for (int serverId : this.nodesCollectStatusMap.keySet()) {
            if (!this.nodesCollectStatusMap.get(serverId).isNodeCollectSuccess()) continue;
            return true;
        }
        return false;
    }

    public boolean atLeastOneNodeFailed() {
        if (this.nodesCollectStatusMap.isEmpty()) {
            return false;
        }
        for (int serverId : this.nodesCollectStatusMap.keySet()) {
            if (!this.nodesCollectStatusMap.get(serverId).isNodeCollectFailed()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinished() {
        return this.failed || this.hasResultFile && this.downloadFinish;
    }

    public void setDownloadFinish(boolean downloadFinish) {
        this.downloadFinish = downloadFinish;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public int getSubTaskId() {
        return this.subTaskId;
    }

    public void setSubTaskId(int subTaskId) {
        this.subTaskId = subTaskId;
    }

    public int getSubTaskProgress() {
        return this.subTaskProgress;
    }

    public void setSubTaskProgress(int subTaskProgress) {
        this.subTaskProgress = subTaskProgress;
    }

    public boolean isHasResultFile() {
        return this.hasResultFile;
    }

    public void setHasResultFile(boolean hasResultFile) {
        this.hasResultFile = hasResultFile;
    }

    public Map<Integer, NodeCollectStatus> getNodesCollectStatusMap() {
        return this.nodesCollectStatusMap;
    }

    public void setNodesCollectStatusMap(Map<Integer, NodeCollectStatus> nodesCollectStatusMap) {
        this.nodesCollectStatusMap = nodesCollectStatusMap;
    }

    public String toString() {
        String subTaskProgressDesc = ResourceUtil.getStringWithParams((String)"sub.task.progress", (Object[])new Object[]{this.subTaskId, this.subTaskProgress});
        StringBuilder sb = new StringBuilder(subTaskProgressDesc);
        Set<Integer> nodeIds = this.nodesCollectStatusMap.keySet();
        for (int nid : nodeIds) {
            NodeCollectStatus ncs = this.nodesCollectStatusMap.get(nid);
            if (ncs.isNodeCollectSuccess()) continue;
            sb.append(ncs.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String getMsg() {
        Set<Integer> nodeIds = this.nodesCollectStatusMap.keySet();
        for (int nid : nodeIds) {
            NodeCollectStatus ncs = this.nodesCollectStatusMap.get(nid);
            if (ncs.isNodeCollectSuccess()) continue;
            return this.toString() + System.lineSeparator();
        }
        return "";
    }
}

