/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.config.YamlParser;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.CollectNodeType;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.CollectTimeType;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.PerfCollectTask;
import com.huawei.ism.tool.infocollect.entity.RestQueryItem;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResultUtils;
import com.huawei.ism.tool.infocollect.interf.ICollectTask;
import com.huawei.ism.tool.infocollect.maintainer.CollectManagement;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectLock;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.backgroud.IUiObserver;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.infocollect.service.logic.DStorageConfig;
import com.huawei.ism.tool.infocollect.service.logic.DStorageModuleCollectTask;
import com.huawei.ism.tool.infocollect.service.logic.ExtendedConnectionQueue;
import com.huawei.ism.tool.infocollect.service.logic.NodeCollectStatus;
import com.huawei.ism.tool.infocollect.service.logic.PollTypeCollect;
import com.huawei.ism.tool.infocollect.service.logic.PollTypeCollectByNodes;
import com.huawei.ism.tool.infocollect.service.logic.PollTypeCollectBySubTask;
import com.huawei.ism.tool.infocollect.service.logic.RestCollectSubTask;
import com.huawei.ism.tool.infocollect.service.logic.command.ClearCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateRestCollectEnvCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.DescCommand;
import com.huawei.ism.tool.infocollect.service.logic.inspectcollect.InspectCollectTaskObserver;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeQueryTask;
import com.huawei.ism.tool.infocollect.service.logic.lld.tools.ExportPdfUtil;
import com.huawei.ism.tool.infocollect.util.CountprogressUtil;
import com.huawei.ism.tool.infocollect.util.DStoragePackageUtil;
import com.huawei.ism.tool.infocollect.util.DStoragePatchUtil;
import com.huawei.ism.tool.infocollect.util.DStoragePerfTaskSplitUtil;
import com.huawei.ism.tool.infocollect.util.DataCollectConstants;
import com.huawei.ism.tool.infocollect.util.IPUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.infocollect.util.ProgressUpdateByDow;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.ism.tool.service.common.ITask;
import com.huawei.ism.tool.service.common.entity.Item;
import com.huawei.ism.tool.service.common.server.ExecutorService;
import com.huawei.ism.tool.service.inspect.dstorage.InspectTask;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class RestCollectTask
implements ICollectTask {
    public static final int ERROR_SUB_TASK_NOT_EXIST = 404;
    public static final String TIME_SECONDS = "seconds";
    private static final Long FILE_DELETE_WAIT_TIMEOUT = Long.parseLong(CollectConfigParser.getConfigureValue("fileDeleteWaitTimeOut", "60")) * 1000L;
    private static final String COMMA_SEPARATOR = ",";
    private static final String PERFORMANCE_COLLECT = "performance";
    private static final String PERF_COLLECT_KEY = "perf";
    private static final String SMART = "smart";
    private static final String TIME_FORMATTER_WITH_SPACE = "yyyy-MM-dd HH:mm:ss";
    private static final String PACKAGE_INFO = "pkginfo";
    private static final String BASE_DIR = "base";
    private static final String SYS_TXT = "sysinfo.txt";
    private static final String NODES_TXT = "nodes.txt";
    private static final String DESC_FILE = "desc";
    private static final String DOMAIN_STORAGE_FILE = "domain_storage";
    private static final String TYPE_COLLECT_FILE = "type_collect";
    private static final String CONFIG_DATA = "config_data";
    private static final String DISK_DESTROY_REPORT = "destroy";
    private static final String TIME_STRING = "string";
    private static final String LINE_SPLIT = "\n";
    private static final String TXT = ".txt";
    private static final String START = "START";
    private static final String END = "END";
    private static final String URL = "URL:";
    private static final String VALUE = "VALUE:";
    private static final String NA = "N/A";
    private static final int REST_SUB_TSK_TIME_OUT_SECONDS = 1800;
    private static final int REST_QRY_PGOGRESS_INTERVAL_SECONDS = 8;
    private static final int ERRORCODE_QUERYP_PACKEG = 83887409;
    private static CollectDataContext context = CollectDataContext.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(RestCollectTask.class);
    private static final String CHARSET_NAME = "utf-8";
    private static final int BUFFER_SIZE = 5120;
    private static final String FUSIONSTORAGEUTIL_PATH = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "collect", "products", "FusionStorageUtil");
    private CollectInfo collectInfo = null;
    private final Object lock = new Object();
    private java.util.concurrent.ExecutorService queryModulePrgoressThreadPool;
    private ArrayList<Long> reconnResponseCode = new ArrayList<Long>(Arrays.asList(DataCollectConstants.ERRORCODE_USER_PERMISSION_ERROR));
    private String zipResultFilePthName;
    private DevNode devNode = null;
    private ConcurrentHashMap<CollectModule, DStorageModuleCollectTask> moduleTaskMap = new ConcurrentHashMap();
    private Map<String, Object> collectEnv = new HashMap<String, Object>();
    private CollectStatus nowStatus = CollectStatus.COLLECT_FAILED;
    private boolean allSucc = true;
    private IUiObserver progressObserver;
    private JSONObject failedMsg = new JSONObject();
    private InfocollectUserOpData userOpData = null;
    private int currentItemTaskIdAmount = 1;
    private int itemTaskIdNum = 1;
    private UIProgressObserver ui;
    private ProgressUpdateByDow progressCache = null;
    private PollTypeCollect pollTypeCollect = null;
    private int collectProgressRatio = 50;
    private ExtendedConnectionQueue extendedConnectionQueue;
    private boolean isSupportCollectByInspect = Boolean.parseBoolean(CollectConfigParser.getConfigureValue("isSupportCollectByInspect", "true").trim());
    private final Map<ModeType, Function<ExecuteCollectTaskParam, RestCollectTask>> executionSelector = new ConcurrentHashMap<ModeType, Function<ExecuteCollectTaskParam, RestCollectTask>>();

    public RestCollectTask(CollectInfo collectInfo, DevNode devNode) {
        this.executionSelector.put(ModeType.DOW, this::downTypeCollect);
        this.executionSelector.put(ModeType.PACKAGE, this::packageTypeCollect);
        this.executionSelector.put(ModeType.REST_QUERY, this::restQueryTypeCollect);
        this.executionSelector.put(ModeType.POLL, this::pollTypeCollect);
        this.executionSelector.put(ModeType.INSPECT_COLLECT, this::inspectTypeCollect);
        this.collectInfo = collectInfo;
        this.devNode = devNode;
        this.ui = new UIProgressObserver(devNode);
        this.extendedConnectionQueue = new ExtendedConnectionQueue(devNode);
    }

    public RestCollectTask(CollectInfo collectInfo, DevNode devNode, IUiObserver progressObserver) {
        this(collectInfo, devNode);
        this.progressObserver = progressObserver;
    }

    public IUiObserver getProgressObserver() {
        return this.progressObserver;
    }

    public void setProgressObserver(IUiObserver progressObserver) {
        this.progressObserver = progressObserver;
    }

    @Override
    public final boolean init() {
        if (this.collectInfo != null) {
            this.collectInfo.setCollecting();
        }
        return true;
    }

    public static boolean isMustCollectBySubTask(String moduleId) {
        List<String> modules = Arrays.asList(CONFIG_DATA, DISK_DESTROY_REPORT);
        return modules.contains(moduleId.toLowerCase(Locale.ROOT));
    }

    private ExecuteResult createCollectEnv() {
        CreateRestCollectEnvCommand command = new CreateRestCollectEnvCommand(this.collectInfo);
        this.observeExecuteResult(command.getProcessingResult());
        ExecuteResult endResult = command.process();
        if (!CollectDataContext.getInstance().isStartCollect()) {
            endResult.setResult(false);
            return endResult;
        }
        this.collectEnv = command.getCollectEnv();
        if (!this.updatePatch()) {
            endResult.setResult(false);
            endResult.setDetail(this.devNode.getErrorDecs());
            this.devNode.setErrorDecs("");
            return endResult;
        }
        this.observeExecuteResult(endResult);
        return endResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InfoCollectLock.getInstance().tryLock(this.devNode.getDeviceSerialNumber());
        boolean collectResult = true;
        boolean createCollectEnvResult = true;
        this.initDeviceUserData();
        try {
            CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(false);
            ExecuteResult result = this.createCollectEnv();
            if (!result.isSuccess()) {
                createCollectEnvResult = false;
                SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "failed", "finished", result.getDetail());
                context.putSilentProgress(this.devNode, 100);
                context.updateSilentResult(this.devNode, data);
                this.observeExecuteResult(result);
                return;
            }
            this.doCollect();
            this.upload(this.devNode, this.collectEnv);
            this.recordUserData();
            context.putSilentProgress(this.devNode, 100);
        }
        catch (Exception e) {
            LOGGER.error("execute collect error.", (Throwable)e);
            ExecuteResult result = new ExecuteResult();
            result.setPyResult(true);
            result.setResult(false);
            result.setNowStatus(CollectStatus.COLLECT_FAILED);
            result.setDescription(ResourceUtil.getString((String)"infocollect.detail.postCollect"));
            result.setDetail(ResourceUtil.getString((String)"infocollect.detail.postCollect.remind"));
            this.observeExecuteResult(result);
        }
        finally {
            this.setOnlyRunningMode(true);
            this.doCleanJob(createCollectEnvResult, collectResult);
            if (CollectUIContext.getInstance().getMainDialog() != null) {
                CollectUIContext.getInstance().getMainDialog().getThreads().remove(this.devNode.getDeviceSerialNumber());
            }
            Context.INS.uninstallAutoImportPatch(this.devNode, DstoragePatchInfo.Type.COLLECT, null);
            InfoCollectLock.getInstance().unLock(this.devNode.getDeviceSerialNumber());
        }
    }

    private boolean updatePatch() {
        if (!this.isSupportSimpleCollect()) {
            return true;
        }
        return DStoragePatchUtil.autoImportCollectPatch(this.devNode);
    }

    private boolean isSupportSimpleCollect() {
        return CollectDataContext.getInstance().isForeground() && this.collectInfo.getCollectConfInfo().isSimpleCollect();
    }

    void recordUserData() {
        StringBuffer collectItems = new StringBuffer();
        for (CollectModule collectModule : this.moduleTaskMap.keySet()) {
            DStorageModuleCollectTask dsTask = this.moduleTaskMap.get(collectModule);
            collectItems.append(collectModule.getNameKey());
            collectItems.append(";");
            int failNum = 0;
            if (!dsTask.getModuleResult().isCollectAllInfo()) {
                ++failNum;
                this.userOpData.setFailedItems(dsTask.toString());
            }
            this.userOpData.setFailedItemNum(failNum);
        }
        this.userOpData.setCollectItems(collectItems.toString());
        InfoCollectUtil.localRecordDeviceSn(this.devNode.getDeviceSerialNumber());
    }

    private void upload(DevNode devNodeTemp, Map<String, Object> collectEnvTemp) {
        if (!CollectStatus.COLLECT_FAILED.equals((Object)this.nowStatus)) {
            InfoCollectUtil.upload(this.devNode, this.collectEnv);
        }
    }

    void initDeviceUserData() {
        List<InfocollectUserOpData> userOpList = CollectDataContext.getInstance().getUserOpList();
        this.userOpData = new InfocollectUserOpData();
        this.userOpData.setDevNode(EntityUtils.toNewDev((DevNode)this.devNode));
        this.userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        this.userOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(this.devNode);
        if (conf == null) {
            LOGGER.error("get collectConf is null,set userOpData failed!");
            return;
        }
        List<CollectItem> items = conf.getAllCollectItems();
        List<CollectItem> selectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        if (items.size() > selectItems.size()) {
            this.userOpData.setCollectNodeType(CollectNodeType.NODE);
        }
        if (conf.isEnableDate()) {
            this.userOpData.setCollectTimeType(CollectTimeType.TIME);
        }
        userOpList.add(this.userOpData);
    }

    private List<CollectModule> getSelectModules() {
        if (this.isSupportSimpleCollect()) {
            return InfoConfiguration.getInstance().getCollectConf(this.devNode).buildCommonSimpleCollectModule(this.collectInfo.getCollectConfInfo().getSelectItems());
        }
        List<CollectItem> selectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        ArrayList<CollectModule> selectModules = new ArrayList<CollectModule>();
        if (null == InfoConfiguration.getInstance().getCollectConf(this.devNode)) {
            return selectModules;
        }
        List<CollectModule> collectModules = InfoConfiguration.getInstance().getCollectConf(this.devNode).getModules();
        block0: for (CollectModule cm : collectModules) {
            for (CollectItem ci : selectItems) {
                String itemModuleId = ci.getModuleId();
                if (StringUtils.isNULLStr((String)itemModuleId) || !cm.getModuleId().equalsIgnoreCase(itemModuleId)) continue;
                selectModules.add(cm);
                continue block0;
            }
        }
        return selectModules;
    }

    private void doCollect() throws ToolException {
        List<CollectItem> selectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        List<CollectModule> collectModules = this.getSelectModules();
        this.queryModulePrgoressThreadPool = Executors.newFixedThreadPool(1);
        int moduleCnt = 0;
        int moduleStartProgress = 0;
        int aveProgressPerModule = (int)(100.0 / (double)collectModules.size());
        for (CollectModule cm : collectModules) {
            moduleStartProgress = (++moduleCnt - 1) * aveProgressPerModule + 3;
            if (this.isNeedCollectByInspect(cm)) {
                this.executionSelector.get((Object)ModeType.INSPECT_COLLECT).apply(new ExecuteCollectTaskParam(selectItems, moduleStartProgress, cm, moduleCnt));
                continue;
            }
            this.executionSelector.getOrDefault((Object)ModeType.of(cm.getMode()), this.executionSelector.get((Object)ModeType.POLL)).apply(new ExecuteCollectTaskParam(selectItems, moduleStartProgress, cm, moduleCnt));
        }
        if (this.compressAllResultFiles(moduleStartProgress)) {
            this.updateAllTaskStatus();
        } else {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.allSucc = false;
        }
        if (!StringUtils.isNULLStr((String)this.zipResultFilePthName) && new File(this.zipResultFilePthName).exists()) {
            String collectOverMassage = ResourceUtil.getString((String)"infocollect.detail.collectcommandfinish");
            collectOverMassage = collectOverMassage.replace("{0}", this.zipResultFilePthName);
            this.addDescResult(collectOverMassage);
            InfoCollectCache.getInstance().saveCollectResultFile(this.devNode.getDeviceSerialNumber(), this.zipResultFilePthName);
        }
        this.collectEnv.put("collectRetFileName", new File(this.zipResultFilePthName).getName());
    }

    private boolean isNeedCollectByInspect(CollectModule collectModule) {
        if (!this.isSupportCollectByInspect) {
            return false;
        }
        if (!SMART.equals(collectModule.getModuleId())) {
            return false;
        }
        return DStoragePackageUtil.isHaveToCollectSmartByInspect(this.devNode);
    }

    private RestCollectTask inspectTypeCollect(ExecuteCollectTaskParam executeCollectTaskParam) {
        CollectModule module = executeCollectTaskParam.getCm();
        int moduleStartProgress = executeCollectTaskParam.getModuleStartProgress();
        String exeItemDes = ResourceUtil.getString((String)"execute.ds.storage.module.collect.des") + module.getNameKey() + ResourceUtil.getString((String)"ds.storage.collect.des");
        ExecuteResult thisExeResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, exeItemDes);
        this.observeExecuteResult(thisExeResult);
        try {
            if (!DStoragePackageUtil.isSupportInspectCollect(this.devNode)) {
                this.recordFailedResult(module, thisExeResult, ResourceUtil.getString((String)"infocollect.olddevice.notsupportsmart"));
                return this;
            }
            if (!CollectDeviceService.getInstance().getInspectResourceFile(this.devNode)) {
                this.recordFailedResult(module, thisExeResult, ResourceUtil.getString((String)"collect.by.inspect.download.inspect.resource.fail"));
                return this;
            }
            DStoragePatchUtil.prepareBeforeUpload(this.devNode);
            InspectCollectTaskObserver inspectCollectTaskObserver = new InspectCollectTaskObserver(this.getInspectItems(module));
            String localPath = this.getLocalPath(module.getModuleId());
            TaskResult result = new ExecutorService(localPath, (Observer)inspectCollectTaskObserver).runTasksParallel(this.devNode, this.buildInspectTask(module, localPath, inspectCollectTaskObserver));
            if (!result.isTaskSuccess()) {
                this.recordFailedResult(module, thisExeResult, result.getErrorLocaleDescription());
                return this;
            }
            inspectCollectTaskObserver.checkFinish();
            thisExeResult.setResult(true);
            this.observeExecuteResult(thisExeResult);
            this.initModuleTaskMap(module, thisExeResult);
            this.mergeInspectSmartInfo(module, 0);
            return this;
        }
        catch (ToolException e) {
            this.recordFailedResult(module, thisExeResult, e.getErrorLocaleDescription());
            return this;
        }
        catch (Exception e) {
            LOGGER.error("execute the collect by inspect failed.", (Throwable)e);
            this.recordFailedResult(module, thisExeResult, ResourceUtil.getStringWithParams((String)"collect.by.inspect.exec.fail", (Object[])new Object[]{module.getNameKey()}));
            return this;
        }
    }

    private void recordFailedResult(CollectModule module, ExecuteResult thisExeResult, String errorMsg) {
        thisExeResult.setResult(false);
        thisExeResult.setDetail(errorMsg);
        this.observeExecuteResult(thisExeResult);
        this.saveFailedTask(module, null, thisExeResult);
    }

    private void initModuleTaskMap(CollectModule module, ExecuteResult thisExeResult) {
        DStorageModuleCollectTask dStorageModuleCollectTask = new DStorageModuleCollectTask(module.getModuleId(), thisExeResult, "");
        HashMap<Integer, RestCollectSubTask> subTaskMap = new HashMap<Integer, RestCollectSubTask>();
        subTaskMap.put(0, new RestCollectSubTask(module.getModuleId(), 0));
        dStorageModuleCollectTask.setSubTaskMap(subTaskMap);
        this.moduleTaskMap.put(module, dStorageModuleCollectTask);
    }

    private List<ITask<TaskResult>> buildInspectTask(CollectModule collectModule, String path, InspectCollectTaskObserver inspectCollectTaskObserver) {
        InspectTask inspectTask = new InspectTask(this.devNode, DstoragePatchInfo.Type.INSPECT, this.getInspectItems(collectModule), path);
        inspectTask.addObserver((Observer)inspectCollectTaskObserver);
        return Collections.singletonList(inspectTask);
    }

    private List<Item> getInspectItems(CollectModule collectModule) {
        return YamlParser.getInstance().getItemsById(collectModule.getModuleId()).stream().map(Item::new).collect(Collectors.toList());
    }

    private RestCollectTask downTypeCollect(ExecuteCollectTaskParam executeCollectTaskParam) {
        if (!this.performanceCollect(executeCollectTaskParam.getSelectItems(), executeCollectTaskParam.getModuleStartProgress(), executeCollectTaskParam.getCm())) {
            LOGGER.error("performance info collect failed.");
        }
        return this;
    }

    private RestCollectTask pollTypeCollect(ExecuteCollectTaskParam executeCollectTaskParam) {
        CollectModule cm = executeCollectTaskParam.getCm();
        this.initPollTypeCollect(this.devNode, cm, this.ui);
        if (!this.createModuleCollectTask(this.collectInfo.getCollectConfInfo().getSelectItems(), executeCollectTaskParam.getModuleStartProgress(), cm)) {
            this.setOnlyRunningMode(true);
            return this;
        }
        String moduleTaskId = this.moduleTaskMap.get(cm).getModuleTaskId();
        LOGGER.info("create module:{} collect task success, task id is:{}", (Object)cm.getModuleId(), (Object)moduleTaskId);
        if (!this.creatModuleTaskDir(cm)) {
            this.setOnlyRunningMode(true);
            return this;
        }
        this.queryAndStartAllSubTasksOfModuleTask(cm, this.getSelectModules().size(), executeCollectTaskParam.getModuleCount() - 1);
        this.handleModuleCollectStatus(cm);
        this.updateCollectModuleResult(cm);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestCollectTask restQueryTypeCollect(ExecuteCollectTaskParam executeCollectTaskParam) {
        CollectModule cm = executeCollectTaskParam.getCm();
        DStorageModuleCollectTask dmcr = this.creatdStorageModuleCollectTask(executeCollectTaskParam.getModuleStartProgress(), cm);
        String moduleDirPath = this.collectEnv.get("collectRetDir") + File.separator + cm.getModuleId();
        File moduleDir = new File(moduleDirPath);
        if (!moduleDir.exists() && !moduleDir.mkdirs()) {
            LOGGER.error("create local dir failed. dir : " + moduleDir);
        }
        ProgressUpdateByDow progress = this.creatProgressUpdateByDow(this.ui, 0, 100, false);
        progress.start();
        int taskNum = 0;
        try {
            for (CollectItem collectItem : executeCollectTaskParam.getSelectItems()) {
                if (!this.isInvolvedExecute(cm, collectItem)) continue;
                RestCollectSubTask rcst = new RestCollectSubTask(collectItem.getNameKey(), ++taskNum);
                dmcr.getSubTaskMap().put(taskNum, rcst);
                if (collectItem.getMode() == ModeType.CUSTOM) {
                    this.collectLldInfo(moduleDirPath, taskNum, rcst);
                    continue;
                }
                if (!this.collectRestQueryItems(collectItem, rcst, moduleDirPath)) continue;
                this.updateNodeRusultInfo(taskNum, rcst, "success", NA);
            }
        }
        finally {
            progress.setTaskFinish(true);
            this.summarizeResults(dmcr, taskNum);
        }
        return this;
    }

    private boolean isInvolvedExecute(CollectModule collectModule, CollectItem collectItem) {
        return collectModule.getItems().contains(collectItem) && collectItem.getMode() != ModeType.MOVE;
    }

    private void collectLldInfo(String moduleDirPath, int taskNum, RestCollectSubTask rcst) {
        String exportFilePath = moduleDirPath + File.separator + "DistributedStorage_LLD.xls";
        NodeQueryTask queryTask = new NodeQueryTask(this.devNode, exportFilePath);
        if (queryTask.execute()) {
            this.updateNodeRusultInfo(taskNum, rcst, "success", NA);
            return;
        }
        rcst.setFailed(true);
        rcst.setErrorMsg(ResourceUtil.getString((String)"lld.info.export.failed.desc"));
    }

    private DStorageModuleCollectTask creatdStorageModuleCollectTask(int moduleStartProgress, CollectModule cm) {
        String exeItemDes = ResourceUtil.getString((String)"execute.ds.storage.module.collect.des") + cm.getNameKey() + ResourceUtil.getString((String)"ds.storage.collect.des");
        ExecuteResult thisExeResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, exeItemDes);
        thisExeResult.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        this.observeExecuteResult(thisExeResult);
        DStorageModuleCollectTask dmcr = new DStorageModuleCollectTask(cm.getModuleId(), thisExeResult, "");
        this.moduleTaskMap.put(cm, dmcr);
        return dmcr;
    }

    private void updateNodeRusultInfo(int taskNum, RestCollectSubTask rcst, String success, String nodeIp) {
        NodeCollectStatus nodeStatus = new NodeCollectStatus(taskNum, success, nodeIp);
        rcst.getNodesCollectStatusMap().put(taskNum, nodeStatus);
    }

    private void summarizeResults(DStorageModuleCollectTask dmcr, int taskNum) {
        dmcr.setSubTaskNum(taskNum);
        StringBuffer erroInfo = new StringBuffer();
        CollectStatus status = this.judgeSubTaskCollectStatus(dmcr.getSubTaskMap(), erroInfo);
        this.syncCollectStatus2UI(status, dmcr.getModuleResult(), erroInfo);
    }

    private boolean collectRestQueryItems(CollectItem collectItem, RestCollectSubTask rcst, String moduleDirPath) {
        File resultFile;
        String resultPath = moduleDirPath + File.separator + collectItem.getId() + TXT;
        if (!this.createResultFile(collectItem, rcst, resultPath, resultFile = new File(resultPath))) {
            return false;
        }
        ArrayList<String> failedCommandList = new ArrayList<String>();
        List<RestQueryItem> restQueryItems = collectItem.getRestQueryItems();
        try (FileOutputStream fos = new FileOutputStream(resultFile);
             OutputStreamWriter write = new OutputStreamWriter((OutputStream)fos, "UTF-8");){
            this.excAndWriter(restQueryItems, failedCommandList, write);
        }
        catch (Exception e) {
            LOGGER.error("write result error :", (Throwable)e);
            rcst.setErrorMsg(ResourceUtil.getString((String)"execute.url.error"));
            rcst.setFailed(true);
            return false;
        }
        return this.getResult(rcst, failedCommandList);
    }

    private boolean getResult(RestCollectSubTask rcst, List<String> failedCommandList) {
        if (failedCommandList.isEmpty()) {
            return true;
        }
        rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"some.execute.url.error", (Object[])new Object[]{String.join((CharSequence)LINE_SPLIT, failedCommandList)}));
        rcst.setFailed(true);
        return false;
    }

    private boolean createResultFile(CollectItem collectItem, RestCollectSubTask rcst, String resultPath, File resultFile) {
        try {
            resultFile.createNewFile();
        }
        catch (IOException e) {
            LOGGER.error("Create result File error, path is: " + resultPath);
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"create.result.file.error", (Object[])new Object[]{collectItem.getId()}));
            rcst.setFailed(true);
            return false;
        }
        return true;
    }

    private void excAndWriter(List<RestQueryItem> restQueryItems, List<String> failedCommandList, Writer write) {
        String urlHead = RestUtil.getDstorageUrlHead((DevNode)this.devNode);
        restQueryItems.forEach(restQueryItem -> {
            String url = urlHead + restQueryItem.getUrl();
            try {
                write.write(this.getCommandResult(url, failedCommandList));
                write.flush();
            }
            catch (IOException e) {
                LOGGER.error("Write url result error, url is: " + url, (Throwable)e);
                failedCommandList.add(url);
            }
        });
    }

    private String getCommandResult(String url, List<String> failedCommandList) {
        StringBuffer result = new StringBuffer();
        result.append(START).append(LINE_SPLIT).append(URL).append(url).append(LINE_SPLIT);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            ResponseInfo resp = conn.execGet(url);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execGet(url);
            }
            result.append(VALUE).append(resp.getContent()).append(LINE_SPLIT);
        }
        catch (Exception e) {
            LOGGER.error("Execute url error, url is: " + url, (Throwable)e);
            failedCommandList.add(url);
            result.append(ResourceUtil.getString((String)"execute.url.error") + LINE_SPLIT);
        }
        result.append(END).append(LINE_SPLIT).append(LINE_SPLIT);
        return result.toString();
    }

    private RestCollectTask packageTypeCollect(ExecuteCollectTaskParam executeCollectTaskParam) {
        this.startRestCheckItem(executeCollectTaskParam.getSelectItems(), executeCollectTaskParam.getModuleStartProgress(), executeCollectTaskParam.getCm());
        this.executRestCheckItem(executeCollectTaskParam.getSelectItems(), executeCollectTaskParam.getModuleStartProgress(), executeCollectTaskParam.getCm());
        return this;
    }

    private void mergeAllNodeSmartInfo(CollectModule cm, int subTaskId) {
        RestCollectSubTask subTask = this.moduleTaskMap.get(cm).getSubTaskMap().get(subTaskId);
        String resultPath = this.collectEnv.get("collectRetDir") + File.separator + "disksmartinfo";
        String smartSourceFiles = this.collectEnv.get("collectRetDir") + File.separator + cm.getModuleId();
        File[] smartFiles = new File(smartSourceFiles).listFiles();
        if (smartFiles == null || smartFiles.length == 0) {
            LOGGER.error("SmartInfo result file is null.");
            return;
        }
        HashMap<String, Object> envTemp = new HashMap<String, Object>();
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        envTemp.put("isAllSelectedWithoutStorageNodes", this.isAllSelectedWithoutStorageNodes());
        envTemp.put("lang", language);
        envTemp.put("logger", LOGGER);
        CollectManagement collectManagement = new CollectManagement(this.devNode);
        envTemp.put("fileAssistant", FileAssistant.class);
        envTemp.put("devNode", this.devNode);
        envTemp.put("smartSourceFiles", smartSourceFiles);
        envTemp.put("resultPath", resultPath);
        envTemp.put("needUnzipped", !this.isNeedDownByNodes());
        String name = "smartSum";
        String mergePyScriptPath = FUSIONSTORAGEUTIL_PATH + File.separator + "smartSum.py";
        File mergePyScript = new File(mergePyScriptPath);
        File pakage = new File(FUSIONSTORAGEUTIL_PATH);
        JythonExecuter executor = new JythonExecuter(pakage);
        try {
            executor.compileScript(mergePyScript);
            List pyResult = executor.invokeFunction(name, envTemp);
            if (!((Boolean)pyResult.get(0)).booleanValue()) {
                subTask.setErrorMsg((String)pyResult.get(1));
                subTask.setFailed(true);
                this.creatFailureNodeInfo(subTask);
                LOGGER.error("DiskSmartInfo merge fail,ErrorMsg is :" + pyResult.get(1));
            }
        }
        catch (ToolException e) {
            subTask.setErrorMsg(ResourceUtil.getString((String)"disk.smart.merge.file.info"));
            subTask.setFailed(true);
            this.creatFailureNodeInfo(subTask);
            LOGGER.error("DiskSmartInfo merge is error : ", (Throwable)e);
        }
        catch (Exception e) {
            subTask.setErrorMsg(ResourceUtil.getString((String)"disk.smart.merge.file.info"));
            subTask.setFailed(true);
            this.creatFailureNodeInfo(subTask);
            LOGGER.error("DiskSmartInfo merge is error : ", (Throwable)e);
        }
    }

    private void mergeInspectSmartInfo(CollectModule collectModule, int subTaskId) {
        String smartSourceFiles = this.collectEnv.get("collectRetDir") + File.separator + collectModule.getModuleId();
        File[] smartFiles = new File(smartSourceFiles).listFiles();
        if (smartFiles == null || smartFiles.length == 0) {
            LOGGER.error("SmartInfo result file is null.");
            return;
        }
        HashMap<String, Object> envTemp = new HashMap<String, Object>();
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        envTemp.put("isAllSelectedWithoutStorageNodes", this.isAllSelectedWithoutStorageNodes());
        envTemp.put("fileAssistant", FileAssistant.class);
        envTemp.put("lang", language);
        envTemp.put("logger", LOGGER);
        envTemp.put("devNode", this.devNode);
        envTemp.put("smartSourceFiles", smartSourceFiles);
        String resultPath = this.collectEnv.get("collectRetDir") + File.separator + "disksmartinfo";
        envTemp.put("resultPath", resultPath);
        envTemp.put("needUnzipped", !this.isNeedDownByNodes());
        String name = "smart_sum_for_inspect";
        String mergePyScriptPath = FUSIONSTORAGEUTIL_PATH + File.separator + "smartSum.py";
        File mergePyScript = new File(mergePyScriptPath);
        File pakage = new File(FUSIONSTORAGEUTIL_PATH);
        JythonExecuter executor = new JythonExecuter(pakage);
        RestCollectSubTask subTask = this.moduleTaskMap.get(collectModule).getSubTaskMap().get(subTaskId);
        try {
            executor.compileScript(mergePyScript);
            List pyResult = executor.invokeFunction(name, envTemp);
            if (!((Boolean)pyResult.get(0)).booleanValue()) {
                subTask.setErrorMsg((String)pyResult.get(1));
                subTask.setFailed(true);
                this.creatFailureNodeInfo(subTask);
                LOGGER.error("DiskSmartInfo by inspect merge fail,ErrorMsg is :" + pyResult.get(1));
            }
        }
        catch (ToolException e) {
            subTask.setErrorMsg(ResourceUtil.getString((String)"disk.smart.merge.file.info"));
            subTask.setFailed(true);
            this.creatFailureNodeInfo(subTask);
            LOGGER.error("DiskSmartInfo by inspect merge is error : ", (Throwable)e);
        }
        catch (Exception e) {
            subTask.setErrorMsg(ResourceUtil.getString((String)"disk.smart.merge.file.info"));
            subTask.setFailed(true);
            this.creatFailureNodeInfo(subTask);
            LOGGER.error("DiskSmartInfo by inspect merge is error : ", (Throwable)e);
        }
    }

    private void transformDiskDataErasureReportToPdf(CollectModule cm, int subTaskId) {
        String csvFile;
        String sourceFiles = this.collectEnv.get("collectRetDir") + File.separator + cm.getModuleId();
        RestCollectSubTask subTask = this.moduleTaskMap.get(cm).getSubTaskMap().get(subTaskId);
        try {
            csvFile = ExportPdfUtil.decompressDiskDestroyReport(sourceFiles);
        }
        catch (IOException e) {
            LOGGER.error("Failed to decompress disk data erasure report.", (Throwable)e);
            subTask.setErrorMsg(ResourceUtil.getString((String)"disk.data.erasure.report.decompress.fail"));
            subTask.setFailed(true);
            this.creatFailureNodeInfo(subTask);
            return;
        }
        if (!ExportPdfUtil.parseDiskDataErasureReportAndGeneralPdf(csvFile, this.devNode)) {
            subTask.setErrorMsg(ResourceUtil.getString((String)"disk.data.erasure.report.transform.to.pdf.fail"));
            subTask.setFailed(true);
            this.creatFailureNodeInfo(subTask);
        }
    }

    private boolean isAllSelectedWithoutStorageNodes() {
        return this.devNode.getClusterNodes().stream().filter(clusterNode -> clusterNode.isSelected()).noneMatch(selectedClusterNode -> selectedClusterNode.includedStorageService());
    }

    private void startRestCheckItem(List<CollectItem> selectItems, int moduleStartProgress, CollectModule cm) {
        String startItemDes = ResourceUtil.getString((String)"start.ds.storage.module.collect.des") + cm.getNameKey() + ResourceUtil.getString((String)"ds.storage.collect.des");
        ExecuteResult thisInitResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, startItemDes);
        this.observeExecuteResult(thisInitResult);
        thisInitResult.setResult(true);
        this.observeExecuteResult(thisInitResult);
    }

    private void executRestCheckItem(List<CollectItem> selectItems, int moduleStartProgress, CollectModule cm) {
        DStorageModuleCollectTask dmcr = this.creatdStorageModuleCollectTask(moduleStartProgress, cm);
        int progressPieceLength = this.getProgressPieceLength(selectItems, cm);
        int taskNum = 0;
        for (CollectItem collectItem : selectItems) {
            if (!cm.getItems().contains(collectItem)) continue;
            int progressLast = (++taskNum - 1) * progressPieceLength;
            RestCollectSubTask rcst = new RestCollectSubTask(collectItem.getNameKey(), taskNum);
            dmcr.getSubTaskMap().put(taskNum, rcst);
            String packageURL = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + collectItem.getPackageURL().replace("{system_esn}", this.devNode.getDeviceSerialNumber());
            if (!this.exePackageURL(packageURL, rcst)) continue;
            this.ui.updateProgress(progressLast += progressPieceLength / 10, "");
            String datePath = this.queryUrlPackegResulte(collectItem, rcst, taskNum, progressPieceLength);
            this.ui.updateProgress(progressLast += progressPieceLength * 4 / 10, "");
            if (rcst.isFailed()) continue;
            String downURL = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + collectItem.getDownURL().replace("{system_esn}", this.devNode.getDeviceSerialNumber()) + datePath;
            String localPath = this.collectEnv.get("collectRetDir") + File.separator + cm.getModuleId();
            File localPathFile = new File(localPath);
            if (!localPathFile.exists() && !localPathFile.mkdirs()) {
                LOGGER.error("create local dir failed. dir : " + localPath);
            }
            if (!this.exeDowURL(downURL, rcst, localPath, progressLast, progressPieceLength)) continue;
            this.updateNodeRusultInfo(taskNum, rcst, "success", NA);
        }
        this.summarizeResults(dmcr, taskNum);
    }

    private int getProgressPieceLength(List<CollectItem> selectItems, CollectModule cm) {
        int progressBlock = 0;
        for (CollectItem collectItem : selectItems) {
            if (!cm.getItems().contains(collectItem)) continue;
            ++progressBlock;
        }
        int progressPieceLength = 100 / Math.max(1, progressBlock);
        boolean progressLast = false;
        return progressPieceLength;
    }

    private void syncCollectStatus2UI(CollectStatus status, ExecuteResult result, StringBuffer errInfo) {
        result.setNowStatus(status);
        boolean success = status == CollectStatus.COLLECT_FINISHED;
        result.setCollectAllInfo(success);
        result.setResult(success);
        result.setDetail(success ? ResourceUtil.getString((String)"infocollect.sus.info") : errInfo.toString());
        this.observeExecuteResult(result);
    }

    private CollectStatus judgeSubTaskCollectStatus(Map<Integer, RestCollectSubTask> subTaskMap, StringBuffer errInfo) {
        if (subTaskMap.isEmpty()) {
            return CollectStatus.COLLECT_FINISHED;
        }
        int failedItemNum = 0;
        for (int subTaskId : subTaskMap.keySet()) {
            RestCollectSubTask subTask = subTaskMap.get(subTaskId);
            if (!subTask.isFailed()) continue;
            ++failedItemNum;
            errInfo.append(subTask.getErrorMsg());
        }
        if (failedItemNum == 0) {
            return CollectStatus.COLLECT_FINISHED;
        }
        if (failedItemNum == subTaskMap.size()) {
            return CollectStatus.COLLECT_FAILED;
        }
        return CollectStatus.COLLECT_FINISHED_NOTALL;
    }

    private boolean exePackageURL(String url, RestCollectSubTask rcst) {
        ResponseInfo resp = null;
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execGet(url);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execGet(url);
            }
        }
        catch (JSONException e) {
            LOGGER.error(rcst.getParentTaskId() + ",execute PackageURL error,JSONException is happen.");
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.Package.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
        }
        catch (Exception e) {
            LOGGER.error(rcst.getParentTaskId() + ",execute PackageURL error.");
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.Package.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
        }
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode && -1L != errorCode) {
            LOGGER.error(rcst.getParentTaskId() + ",execute PackageURL have errorCode,is " + errorCode);
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.Package.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
        }
        return !rcst.isFailed();
    }

    private String queryUrlPackegResulte(CollectItem collectItem, RestCollectSubTask rcst, int taskNum, int progressPieceLength) {
        String packageResult = null;
        boolean query = true;
        String getpathURL = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + collectItem.getGetpathURL().replace("{system_esn}", this.devNode.getDeviceSerialNumber());
        int pNum = 0;
        int progressLast = (taskNum - 1) * progressPieceLength + progressPieceLength / 10;
        int querLeng = progressPieceLength * 4 / 10;
        boolean queryReconnected = false;
        while (query) {
            ResponseInfo resp;
            block4: {
                pNum = this.getpNum(pNum, progressLast, querLeng);
                try {
                    RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                    resp = conn.execGet(getpathURL);
                    if (queryReconnected || !this.needReConnResponseCode(conn, resp)) break block4;
                    resp = conn.execGet(getpathURL);
                    queryReconnected = true;
                }
                catch (Exception e) {
                    this.processToolException(rcst);
                    query = false;
                    continue;
                }
            }
            long errorCode = this.getErrorCode(resp);
            if (0L != errorCode && -1L != errorCode) {
                if (errorCode == 83887409L) continue;
                this.processError(rcst, errorCode);
                query = false;
                continue;
            }
            if (this.isContinue(resp)) continue;
            packageResult = this.getDataFromResponse(resp, rcst);
            query = false;
        }
        return packageResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDataFromResponse(ResponseInfo resp, RestCollectSubTask rcst) {
        String string;
        block9: {
            String packageResult;
            block7: {
                String string2;
                block8: {
                    packageResult = null;
                    if (resp != null && resp.getContent() != null) break block7;
                    string2 = packageResult;
                    if (packageResult != null) break block8;
                    LOGGER.error("Package result ResponseInfo not have data.");
                    rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.queryPackegResulte.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
                    rcst.setFailed(true);
                }
                return string2;
            }
            try {
                JSONObject pathJson = new JSONObject(resp.getContent());
                if (resp.getContent().contains("data")) {
                    packageResult = pathJson.getStringOrDefault("data", null);
                }
                string = packageResult;
                if (packageResult != null) break block9;
            }
            catch (JSONException e) {
                String string3;
                block10: {
                    try {
                        LOGGER.error("parse package result response error", (Throwable)e);
                        string3 = packageResult;
                        if (packageResult != null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (packageResult == null) {
                            LOGGER.error("Package result ResponseInfo not have data.");
                            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.queryPackegResulte.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
                            rcst.setFailed(true);
                        }
                        throw throwable;
                    }
                    LOGGER.error("Package result ResponseInfo not have data.");
                    rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.queryPackegResulte.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
                    rcst.setFailed(true);
                }
                return string3;
            }
            LOGGER.error("Package result ResponseInfo not have data.");
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.queryPackegResulte.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
        }
        return string;
    }

    private boolean isContinue(ResponseInfo resp) {
        long resultCode = this.getResultCode(resp);
        return resultCode == 83887409L;
    }

    private void processError(RestCollectSubTask rcst, long errorCode) {
        LOGGER.error(rcst.getParentTaskId() + ",execute PackegResulte have errorCode,is " + errorCode);
        rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.queryPackegResulte.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
        rcst.setFailed(true);
    }

    private void processToolException(RestCollectSubTask rcst) {
        LOGGER.error(rcst.getParentTaskId() + ",execute PackegResulte error.");
        rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.queryPackegResulte.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
        rcst.setFailed(true);
    }

    private int getpNum(int pNum, int progressLast, int querLeng) {
        int nowProgress = progressLast + CountprogressUtil.countProgtessProgressive(pNum + 1, querLeng);
        this.ui.updateProgress(nowProgress, "");
        this.sleep();
        return pNum + 1;
    }

    private void sleep() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread sleep error");
        }
    }

    private boolean exeDowURL(String url, RestCollectSubTask rcst, String downPath, int progressLast, int progressPieceLength) {
        ResponseInfo resp;
        ProgressUpdateByDow progress = this.creatProgressUpdateByDow(this.ui, progressLast, progressPieceLength, false);
        progress.start();
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execGetFile(url, null, downPath);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execGetFile(url, null, downPath);
            }
        }
        catch (ToolException e) {
            LOGGER.error(rcst.getParentTaskId() + ",execute DowURL error.");
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.down.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
            return false;
        }
        catch (Exception e) {
            LOGGER.error(rcst.getParentTaskId() + ",execute DowURL error.");
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.down.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
            return false;
        }
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode && -1L != errorCode) {
            LOGGER.error(rcst.getParentTaskId() + ",execute DowURL have errorCode,is " + errorCode);
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.down.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
        }
        if (!RestCollectTask.downloadFileExist(resp)) {
            LOGGER.error(rcst.getParentTaskId() + ",execute DowURL,rest is not have tgz file.");
            rcst.setErrorMsg(ResourceUtil.getStringWithParams((String)"rest.url.task.down.file.info", (Object[])new Object[]{rcst.getParentTaskId()}));
            rcst.setFailed(true);
        }
        progress.setTaskFinish(true);
        return !rcst.isFailed();
    }

    private void handleModuleCollectStatus(CollectModule cm) {
        DStorageModuleCollectTask dsmcr = this.moduleTaskMap.get(cm);
        dsmcr.updateModuleResult();
        this.observeExecuteResult(dsmcr.getModuleResult());
    }

    private void updateAllTaskStatus() {
        Set moduleSet = this.moduleTaskMap.keySet();
        CollectStatus status = CollectStatus.COLLECT_FINISHED;
        if (moduleSet.isEmpty()) {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.allSucc = false;
            return;
        }
        long failedModuleNum = this.getFailedModuleNum(moduleSet);
        if (failedModuleNum == (long)moduleSet.size()) {
            this.nowStatus = CollectStatus.COLLECT_FAILED;
            this.allSucc = false;
            return;
        }
        if (failedModuleNum == 0L) {
            this.nowStatus = CollectStatus.COLLECT_FINISHED;
            this.allSucc = true;
            return;
        }
        this.nowStatus = CollectStatus.COLLECT_FINISHED_NOTALL;
        this.allSucc = false;
    }

    private long getFailedModuleNum(Set<CollectModule> moduleSet) {
        return moduleSet.stream().map(collectModule -> this.moduleTaskMap.get(collectModule)).filter(dsmcr -> dsmcr.atLeastOneNodeFailed() || dsmcr.isTaskFailed() || dsmcr.isHasDownNodeFile()).count();
    }

    private boolean compressAllResultFiles(int moduleStartProgress) {
        boolean compressSuccess;
        String startItemDes = ResourceUtil.getString((String)"infocollect.detail.compressed.file");
        ExecuteResult thisInitResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, startItemDes);
        this.observeExecuteResult(thisInitResult);
        this.ui.updateProgress(0, "");
        ProgressUpdateByDow progress = this.creatProgressUpdateByDow(this.ui, 0, 100, false);
        progress.start();
        String collectRetRootPth = (String)this.collectEnv.get("collectRetDir");
        File rootPthFile = new File(collectRetRootPth);
        String pkginfoPath = rootPthFile.getParent() + File.separator + PACKAGE_INFO;
        String logInfoPath = rootPthFile.getParent() + File.separator + "log";
        File pkginfo = new File(pkginfoPath);
        if (!pkginfo.exists() && pkginfo.mkdir()) {
            pkginfo.mkdir();
            try {
                this.descFileCreate(pkginfo);
                new File(pkginfo, DOMAIN_STORAGE_FILE).createNewFile();
                new File(pkginfo, TYPE_COLLECT_FILE).createNewFile();
                InfoCollectUtil.copyToolIni(pkginfoPath);
                this.addBaseDir(collectRetRootPth);
                if (AbstractUserOpDataSev.isSourceLogExists()) {
                    this.copyCollectLog(logInfoPath);
                }
                this.zipResultFilePthName = rootPthFile.getParentFile().getCanonicalPath() + ".7z";
            }
            catch (Exception e) {
                LOGGER.error("create file failed :" + pkginfo, (Throwable)e);
                this.zipResultFilePthName = rootPthFile.getParent() + ".7z";
            }
        }
        File resultFile = new File(this.zipResultFilePthName);
        boolean compressResult = this.executeCompress(collectRetRootPth, pkginfoPath, logInfoPath);
        boolean bl = compressSuccess = compressResult && resultFile.exists() && resultFile.isFile();
        if (compressSuccess) {
            thisInitResult.setResult(true);
            com.huawei.ism.tool.infocollect.util.FilesUtil.deleteFileAfterReleased(rootPthFile.getParentFile(), FILE_DELETE_WAIT_TIMEOUT);
        } else {
            thisInitResult.setNowStatus(CollectStatus.COLLECT_FAILED);
            thisInitResult.setDetail(ResourceUtil.getString((String)"infocollect.detail.compressed.file.failed"));
            thisInitResult.setResult(false);
        }
        progress.setTaskFinish(true);
        this.observeExecuteResult(thisInitResult);
        return compressSuccess;
    }

    boolean executeCompress(String collectRetRootPth, String pkginfoPath, String logInfoPath) {
        return InfoCollectUtil.isDmeIqEnv() ? FileAssistant.compressFile7zByMX0((String)this.zipResultFilePthName, (String[])new String[]{collectRetRootPth, pkginfoPath}) : FileAssistant.compressFile7zByMX0((String)this.zipResultFilePthName, (String[])new String[]{collectRetRootPth, pkginfoPath, logInfoPath});
    }

    private void copyCollectLog(String logInfoPath) {
        File logInfo = new File(logInfoPath);
        if (!logInfo.exists()) {
            logInfo.mkdir();
        }
        AbstractUserOpDataSev.copyLogInfo((File)logInfo);
    }

    private void stopProgress() {
        if (this.progressCache != null) {
            this.progressCache.setTaskFinish(true);
        }
    }

    protected ProgressUpdateByDow creatProgressUpdateByDow(UIProgressObserver ui, int progressLast, int progressPieceLength, boolean taskFinish) {
        this.stopProgress();
        this.progressCache = new ProgressUpdateByDow(ui, progressLast, progressPieceLength, taskFinish);
        return this.progressCache;
    }

    void descFileCreate(File pkginfo) {
        File desc = new File(pkginfo, DESC_FILE);
        try (BufferedWriter csvWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(desc), CHARSET_NAME), 5120);){
            desc.createNewFile();
            csvWriter.write("deviceSN=${" + this.devNode.getDeviceSerialNumber() + "}");
            csvWriter.newLine();
            csvWriter.write("fileCreateTime=" + new Date().getTime());
            csvWriter.newLine();
            csvWriter.write("tool-version={" + String.join((CharSequence)LINE_SPLIT, UserOpDataSaveUtil.getAllToolVersion()) + "}");
            csvWriter.newLine();
            csvWriter.flush();
        }
        catch (Exception e) {
            LOGGER.error("Create pkginfo desc file error .", (Throwable)e);
        }
    }

    private String addBaseDir(String rootPath) {
        String baseDir = rootPath + File.separator + BASE_DIR;
        ArrayList<String> sysInfos = new ArrayList<String>();
        ArrayList<String> nodeInfos = new ArrayList<String>();
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMATTER_WITH_SPACE);
        if (this.devNode != null) {
            StringBuffer sysInfo = new StringBuffer();
            sysInfo.append(this.devNode.getDeviceSerialNumber()).append(COMMA_SEPARATOR).append(this.devNode.getDeviceName()).append(COMMA_SEPARATOR).append(this.devNode.getProductModel()).append(" ").append(DevInfoUtil.getCompleteDevVersion((DevNode)this.devNode)).append(COMMA_SEPARATOR).append(format.format(new Date()));
            sysInfos.add(sysInfo.toString());
            FilesUtil.writeStringToFile(sysInfos, (String)baseDir, (String)SYS_TXT);
            for (ClusterNode cn : this.devNode.getClusterNodes()) {
                StringBuffer nodeInfo = new StringBuffer();
                String boomCode = cn.getSerialNumber().length() > 10 ? cn.getSerialNumber().substring(2, 10) : " ";
                nodeInfo.append(cn.getManagementIp()).append(COMMA_SEPARATOR).append(cn.getSerialNumber()).append(COMMA_SEPARATOR).append(boomCode).append(COMMA_SEPARATOR).append(cn.getName()).append(COMMA_SEPARATOR).append(cn.getModel()).append(COMMA_SEPARATOR).append(cn.getCabinet()).append(COMMA_SEPARATOR).append(cn.getSlotNumber());
                nodeInfos.add(nodeInfo.toString());
            }
            FilesUtil.writeStringToFile(nodeInfos, (String)baseDir, (String)NODES_TXT);
        }
        return baseDir;
    }

    private void deleteModuleTask(CollectModule cm) {
        if (100 != this.moduleTaskMap.get(cm).getTaskProgress()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread sleep error: ", (Throwable)e);
            }
        }
        if (100 != this.moduleTaskMap.get(cm).getTaskProgress()) {
            LOGGER.warn("Collection item TaskProgress not is 100%.");
            this.moduleTaskMap.get(cm).setTaskProgress(100);
            this.updateRestCollectionTaskProgress(cm);
        }
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        String moduleTaskId = dmcr.getModuleTaskId();
        String infoCollectModuleTaskUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)this.devNode, (String)moduleTaskId);
        ResponseInfo resp = null;
        try {
            long errorCode;
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execDelete(infoCollectModuleTaskUri);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execDelete(infoCollectModuleTaskUri);
            }
            if (0L != (errorCode = this.getErrorCode(resp))) {
                LOGGER.error("delete task:" + moduleTaskId + " failed, and error code is:" + errorCode);
            } else {
                LOGGER.info("delete module:{} collect task:{}success.", (Object)cm.getModuleId(), (Object)moduleTaskId);
            }
        }
        catch (Exception e) {
            LOGGER.error("delete module:" + cm.getModuleId() + " collect task:" + moduleTaskId + " exception:" + e);
        }
        this.cleanPollTypeCollect();
    }

    private void cleanPollTypeCollect() {
        if (this.pollTypeCollect != null) {
            this.pollTypeCollect.clean();
        }
    }

    private void postPollTypeCollect() {
        if (this.pollTypeCollect != null) {
            this.pollTypeCollect.post();
        }
    }

    private boolean createModuleCollectTask(List<CollectItem> selectItems, int moduleStartProgress, CollectModule cm) {
        ResponseInfo resp;
        String startCollectionUri = RestUtil.getInfoCollectUri((DevNode)this.devNode);
        Map<String, Object> reqParam = this.pollTypeCollect.getCreateCollectTaskParm(selectItems);
        String startItemDes = ResourceUtil.getString((String)"start.ds.storage.module.collect.des") + cm.getNameKey() + ResourceUtil.getString((String)"ds.storage.collect.des");
        ExecuteResult thisInitResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, startItemDes);
        this.observeExecuteResult(thisInitResult);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execPost(startCollectionUri, reqParam);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execPost(startCollectionUri, reqParam);
            }
        }
        catch (JSONException e) {
            LOGGER.error("Start module " + cm.getModuleId() + " info collection exception,,JSONException is happen. " + (Object)((Object)e));
            thisInitResult.setResult(false);
            thisInitResult.setDetail(ResourceUtil.getString((String)"start.create.module.collect.task.exception"));
            this.observeExecuteResult(thisInitResult);
            this.saveFailedTask(cm, reqParam, thisInitResult);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Start module " + cm.getModuleId() + " info collection exception, " + e);
            thisInitResult.setResult(false);
            thisInitResult.setDetail(ResourceUtil.getString((String)"start.create.module.collect.task.exception"));
            this.observeExecuteResult(thisInitResult);
            this.saveFailedTask(cm, reqParam, thisInitResult);
            return false;
        }
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode) {
            LOGGER.error("Start module " + cm.getModuleId() + " info collection failed, and error code is:" + errorCode);
            thisInitResult.setResult(false);
            if (-1L == errorCode) {
                thisInitResult.setDetail(ResourceUtil.getString((String)"start.create.module.collect.task.exception"));
            } else {
                thisInitResult.setDetail(this.getErrorDesAndSuggest(resp));
            }
            this.observeExecuteResult(thisInitResult);
            this.saveFailedTask(cm, reqParam, thisInitResult);
            return false;
        }
        JSONObject taskIdObj = (JSONObject)resp.getContentMap().get("data");
        return this.handleResult(moduleStartProgress, cm, reqParam, thisInitResult, taskIdObj);
    }

    private boolean handleResult(int moduleStartProgress, CollectModule cm, Map<String, Object> reqParam, ExecuteResult thisInitResult, JSONObject taskIdObj) {
        if (taskIdObj.has("task_id")) {
            String taskId = taskIdObj.getString("task_id");
            LOGGER.info("module {}, task id:{}", (Object)cm.getModuleId(), (Object)taskId);
            thisInitResult.setResult(true);
            this.observeExecuteResult(thisInitResult);
            String exeItemDes = ResourceUtil.getString((String)"execute.ds.storage.module.collect.des") + cm.getNameKey() + ResourceUtil.getString((String)"ds.storage.collect.des");
            ExecuteResult thisExeResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, exeItemDes);
            this.observeExecuteResult(thisExeResult);
            DStorageModuleCollectTask dmcr = new DStorageModuleCollectTask(cm.getModuleId(), thisExeResult, taskId);
            this.moduleTaskMap.put(cm, dmcr);
            return true;
        }
        LOGGER.error("can not parse the task id.");
        thisInitResult.setResult(false);
        thisInitResult.setDetail(ResourceUtil.getString((String)"parse.module.collect.task.id.failed"));
        this.observeExecuteResult(thisInitResult);
        this.saveFailedTask(cm, reqParam, thisInitResult);
        return false;
    }

    protected Object getSelectedTime(String selected, String timeType) {
        String dateString = "";
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMATTER_WITH_SPACE);
        if (this.collectInfo.getSettingConfInfo() != null) {
            dateString = selected.equals("start") ? (String)this.collectInfo.getSettingConfInfo().getSettingInfo().get("startTime") : (String)this.collectInfo.getSettingConfInfo().getSettingInfo().get("endTime");
        }
        switch (timeType) {
            case "string": {
                if (!dateString.isEmpty()) {
                    return dateString.replaceAll("[^\\d]+", "");
                }
                return "";
            }
            case "seconds": {
                if (!dateString.isEmpty()) {
                    try {
                        long senconds = sdf.parse(dateString).getTime() / 1000L;
                        return senconds;
                    }
                    catch (ParseException e) {
                        LOGGER.error("parse " + selected + "time failed", (Throwable)e);
                    }
                }
                return 0L;
            }
        }
        return null;
    }

    protected void saveFailedTask(CollectModule cm, Map<String, Object> reqParam, ExecuteResult thisInitResult) {
        DStorageModuleCollectTask dmcr = new DStorageModuleCollectTask(cm.getModuleId(), thisInitResult, null);
        dmcr.setTaskFailed(true);
        this.moduleTaskMap.put(cm, dmcr);
    }

    private boolean performanceCollect(List<CollectItem> selectItems, int moduleStartProgress, CollectModule cm) {
        this.startRestCheckItem(selectItems, moduleStartProgress, cm);
        Integer[] items = this.constructPerformanceItems(selectItems, cm);
        String startItemDes = ResourceUtil.getString((String)"execute.ds.storage.module.collect.des") + cm.getNameKey() + ResourceUtil.getString((String)"ds.storage.collect.des");
        ExecuteResult thisInitResult = ExecuteResultUtils.newExeResult(moduleStartProgress, null, startItemDes);
        this.observeExecuteResult(thisInitResult);
        DStorageModuleCollectTask dmcr = new DStorageModuleCollectTask(cm.getModuleId(), thisInitResult, "");
        this.moduleTaskMap.put(cm, dmcr);
        int progressPieceLength = 99;
        int progressLast = 1;
        ProgressUpdateByDow progress = this.creatProgressUpdateByDow(this.ui, progressLast, progressPieceLength, false);
        progress.start();
        String localPath = this.collectEnv.get("collectRetDir") + File.separator + PERF_COLLECT_KEY;
        File localPathFile = new File(localPath);
        if (!localPathFile.exists() && !localPathFile.mkdirs()) {
            LOGGER.error("create local dir failed. dir : " + localPath);
            return false;
        }
        boolean collectResult = this.buildPerfCollectTask().stream().allMatch(perfCollectTask -> this.collectPerfTask((PerfCollectTask)perfCollectTask, items, localPath, thisInitResult));
        return this.updatePerformanceCollectTaskResult(collectResult, thisInitResult, dmcr, progress);
    }

    private boolean collectPerfTask(PerfCollectTask perfCollectTask, Integer[] items, String localPath, ExecuteResult thisInitResult) {
        String startCollectionUri = RestUtil.getPerformanceCollectUri((DevNode)this.devNode);
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("begin_time", perfCollectTask.getStartTime());
        reqParam.put("end_time", perfCollectTask.getEndTime());
        reqParam.put("object_type", items);
        reqParam.put("topN", DStorageConfig.getDSTORAGE_COLLECT_TOPN());
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            ResponseInfo resp = conn.execGetFile(startCollectionUri, reqParam, localPath);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execGetFile(startCollectionUri, reqParam, localPath);
            }
            if (this.dowloadPerfFailed(thisInitResult, resp)) {
                return false;
            }
            this.renameToDate(resp, localPath, perfCollectTask.getStartTime(), perfCollectTask.getEndTime());
        }
        catch (JSONException e) {
            LOGGER.error("Start permance collection JSONException. ", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Start permance collection exception. ", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean dowloadPerfFailed(ExecuteResult thisInitResult, ResponseInfo resp) {
        if (null == resp) {
            LOGGER.error("collection permance failed.");
            return true;
        }
        if (this.responseInfoHasError(thisInitResult, resp)) {
            return true;
        }
        if (!RestCollectTask.downloadFileExist(resp)) {
            LOGGER.error("Result file not exist.");
            return true;
        }
        return false;
    }

    private void renameToDate(ResponseInfo resp, String localPath, Long startTime, Long endTime) {
        String filePath = (String)resp.getContentMap().get("filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        String newFilePath = localPath + File.separator + this.getDate(startTime) + "_" + this.getDate(endTime) + ".zip";
        file.renameTo(new File(newFilePath));
    }

    private String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date(time * 1000L));
    }

    private void handleException(ExecuteResult thisInitResult, DStorageModuleCollectTask dmcr) {
        dmcr.setTaskFailed(true);
        thisInitResult.setResult(false);
        thisInitResult.setNowStatus(CollectStatus.COLLECT_FAILED);
        thisInitResult.setDetail(ResourceUtil.getString((String)"start.create.performance.collect.exception"));
        this.observeExecuteResult(thisInitResult);
    }

    private List<PerfCollectTask> buildPerfCollectTask() {
        Long end;
        Long[] times = this.getDefaultStartTimeLong();
        Long start = (Long)this.getSelectedTime("start", TIME_SECONDS);
        if (start == 0L) {
            start = times[0];
        }
        if ((end = (Long)this.getSelectedTime("end", TIME_SECONDS)) == 0L) {
            end = times[1];
        }
        return DStoragePerfTaskSplitUtil.getPerfCollectTaskList(start, end, this.devNode);
    }

    private boolean responseInfoHasError(ExecuteResult thisInitResult, ResponseInfo resp) {
        long statusCode;
        long l = statusCode = resp.getStatusLine() == null ? -1L : (long)resp.getStatusLine().getStatusCode();
        if (200L != statusCode) {
            LOGGER.error("performance collect failed,service is unavaliable and status code is:" + statusCode);
            thisInitResult.setDetail(ResourceUtil.getString((String)"start.create.performance.collect.exception"));
            return true;
        }
        long resultCode = this.getResultCode(resp);
        if (!resp.getContentType().equalsIgnoreCase("application/octet-stream")) {
            LOGGER.error("Start performance collection failed, and error code is:" + resultCode);
            if (-211L == resultCode) {
                thisInitResult.setDetail(ResourceUtil.getString((String)"performance.collet.no.data"));
            } else {
                thisInitResult.setDetail(this.getErrorDesAndSuggest(resp));
            }
            this.observeExecuteResult(thisInitResult);
            return true;
        }
        return false;
    }

    private Long[] getDefaultStartTimeLong() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -7);
        Date date = calendar.getTime();
        return new Long[]{date.getTime() / 1000L, now.getTime() / 1000L};
    }

    private boolean updatePerformanceCollectTaskResult(boolean collectResult, ExecuteResult thisInitResult, DStorageModuleCollectTask dmcr, ProgressUpdateByDow progress) {
        progress.setTaskFinish(true);
        dmcr.setTaskFailed(!collectResult);
        thisInitResult.setResult(collectResult);
        thisInitResult.setCollectAllInfo(collectResult);
        if (!collectResult) {
            thisInitResult.setNowStatus(CollectStatus.COLLECT_FAILED);
            if (StringUtils.isNULLStr((String)thisInitResult.getDetail())) {
                thisInitResult.setDetail(ResourceUtil.getString((String)"download.performance.result.failed"));
            }
            LOGGER.error("download performance collect file finished, the file request may failed.");
        } else {
            thisInitResult.setNowStatus(CollectStatus.COLLECT_FINISHED);
            thisInitResult.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        }
        this.observeExecuteResult(thisInitResult);
        return collectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryAndStartAllSubTasksOfModuleTask(CollectModule cm, int moduleCnt, int moduleIndx) {
        if (this.moduleTaskMap.isEmpty()) {
            LOGGER.error("no module task is running...");
            return;
        }
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        ExecuteResult moduleCollectResult = dmcr.getModuleResult();
        String moduleTaskId = dmcr.getModuleTaskId();
        String infoCollectModuleTaskUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)this.devNode, (String)moduleTaskId);
        try {
            long errorCode;
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            ResponseInfo resp = conn.execGet(infoCollectModuleTaskUri);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execGet(infoCollectModuleTaskUri);
            }
            if (0L != (errorCode = this.getErrorCode(resp))) {
                LOGGER.error("query tasks:" + moduleTaskId + " failed, and error code is:" + errorCode);
                String detailInfo = ResourceUtil.getString((String)"query.module.collect.task.failed") + this.getErrorDesAndSuggest(resp);
                moduleCollectResult.setDetail(detailInfo);
                moduleCollectResult.setResult(false);
                this.observeExecuteResult(moduleCollectResult);
                dmcr.setTaskFailed(true);
                return;
            }
            this.queryModulePrgoressThreadPool.submit(new QueryModuleProgressTask(cm, moduleCnt, moduleIndx));
            JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
            JSONArray subTaskIdArray = taskData.getJSONArray("sub_tasks");
            ArrayList<Integer> otherTasks = new ArrayList<Integer>();
            int firstTaskId = -1;
            dmcr.setSubTaskNum(subTaskIdArray.length());
            firstTaskId = this.getFirstTaskId(dmcr, moduleTaskId, subTaskIdArray, otherTasks, firstTaskId);
            if (firstTaskId == -1 && otherTasks.isEmpty()) {
                this.processCondition(dmcr, moduleCollectResult, moduleTaskId);
                return;
            }
            this.currentItemTaskIdAmount = 1 + otherTasks.size();
            this.queryInfoCollectSubTaskDetail(cm, moduleTaskId, firstTaskId, otherTasks);
        }
        catch (Throwable t) {
            LOGGER.error("query module task:" + moduleTaskId + " exception:" + t);
            this.processError(dmcr, moduleCollectResult);
        }
        finally {
            this.deleteModuleTask(cm);
        }
    }

    private void processCondition(DStorageModuleCollectTask dmcr, ExecuteResult moduleCollectResult, String moduleTaskId) {
        LOGGER.error("Parse module task:" + moduleTaskId + " failed, because no valid sub task found.");
        String detailInfo = ResourceUtil.getString((String)"parse.module.sub.task.failed");
        moduleCollectResult.setDetail(detailInfo);
        moduleCollectResult.setResult(false);
        this.observeExecuteResult(moduleCollectResult);
        dmcr.setTaskFailed(true);
    }

    private void processError(DStorageModuleCollectTask dmcr, ExecuteResult moduleCollectResult) {
        String detailInfo = ResourceUtil.getString((String)"query.or.parse.module.task.failed");
        moduleCollectResult.setDetail(detailInfo);
        moduleCollectResult.setResult(false);
        this.observeExecuteResult(moduleCollectResult);
        dmcr.setTaskFailed(true);
    }

    private int getFirstTaskId(DStorageModuleCollectTask dmcr, String moduleTaskId, JSONArray subTaskIdArray, List<Integer> otherTasks, int firstTaskId) {
        int result = firstTaskId;
        for (int j = 0; j < subTaskIdArray.length(); ++j) {
            int subTaskId = subTaskIdArray.getInt(j);
            RestCollectSubTask rcst = dmcr.getSubTaskMap().get(subTaskId);
            if (null == rcst) {
                rcst = new RestCollectSubTask(moduleTaskId, subTaskId);
            }
            dmcr.getSubTaskMap().put(subTaskId, rcst);
            if (0 != j) {
                otherTasks.add(subTaskId);
                continue;
            }
            result = subTaskId;
        }
        return result;
    }

    private void queryInfoCollectSubTaskDetail(CollectModule cm, String moduleTaskId, int firstSubTaskId, List<Integer> otherTaskIds) {
        HashMap<String, String> reqPara = new HashMap<String, String>();
        reqPara.put("task_id", moduleTaskId);
        reqPara.put("sub_task_id", String.valueOf(firstSubTaskId));
        this.itemTaskIdNum = 1;
        if (!this.querySubTaskAndDownloadResult(cm, moduleTaskId, firstSubTaskId, reqPara)) {
            LOGGER.error("sub task[" + firstSubTaskId + "] not finished, may timed out or exception...");
        }
        for (int subTaskId : otherTaskIds) {
            ++this.itemTaskIdNum;
            if (!this.startSubTask(cm, moduleTaskId, reqPara, subTaskId)) continue;
            reqPara.put("sub_task_id", String.valueOf(subTaskId));
            this.querySubTaskAndDownloadResult(cm, moduleTaskId, subTaskId, reqPara);
        }
        if (cm.getModuleId().equalsIgnoreCase(SMART)) {
            this.postPollTypeCollect();
            this.mergeAllNodeSmartInfo(cm, firstSubTaskId);
        }
        if (cm.getModuleId().equalsIgnoreCase(DISK_DESTROY_REPORT)) {
            this.postPollTypeCollect();
            this.transformDiskDataErasureReportToPdf(cm, firstSubTaskId);
        }
        this.updateRestCollectionTaskProgress(cm);
    }

    private boolean creatModuleTaskDir(CollectModule cm) {
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        ExecuteResult moduleCollectResult = dmcr.getModuleResult();
        String localPath = this.collectEnv.get("collectRetDir") + File.separator + dmcr.getModuleId();
        File localPathFile = new File(localPath);
        if (!localPathFile.exists() && !localPathFile.mkdirs()) {
            String detailInfo = ResourceUtil.getStringWithParams((String)"creat.directory.failed", (Object[])new Object[]{localPath});
            LOGGER.error("create local dir failed. dir : {}", (Object)localPath);
            moduleCollectResult.setDetail(detailInfo);
            moduleCollectResult.setResult(false);
            this.observeExecuteResult(moduleCollectResult);
            dmcr.setTaskFailed(true);
            return false;
        }
        return true;
    }

    private boolean startSubTask(CollectModule cm, String moduleTaskId, Map<String, String> reqPara, int subTaskId) {
        String infoCollectSubTaskUri = RestUtil.getInfoCollectSubTaskUri((DevNode)this.devNode);
        String urlParam = "?task_id=" + reqPara.get("task_id");
        RestConnection conn = null;
        Map param = null;
        try {
            long errorCode;
            conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            ResponseInfo resp = conn.execPut(infoCollectSubTaskUri + urlParam, param);
            if (this.needReConnResponseCode(conn, resp)) {
                resp = conn.execPut(infoCollectSubTaskUri + urlParam, param);
            }
            if (0L != (errorCode = this.getResultCode(resp))) {
                LOGGER.error("Execute task:{} sub task:{} failed, and error code is: {}", new Object[]{moduleTaskId, subTaskId, errorCode});
                this.setSubTaskFailed(cm, subTaskId, ResourceUtil.getStringWithParams((String)"start.sub.task.result.failed.code", (Object[])new Object[]{moduleTaskId, subTaskId, String.valueOf(errorCode)}));
                return false;
            }
        }
        catch (ToolException e) {
            LOGGER.error("execute next task: {} sub task: {} exception", new Object[]{moduleTaskId, subTaskId, e});
            this.setSubTaskFailed(cm, subTaskId, ResourceUtil.getStringWithParams((String)"start.sub.task.result.failed", (Object[])new Object[]{moduleTaskId, subTaskId}));
            return false;
        }
        catch (Exception e) {
            LOGGER.error("execute next task: {} sub task: {} exception", new Object[]{moduleTaskId, subTaskId, e});
            this.setSubTaskFailed(cm, subTaskId, ResourceUtil.getStringWithParams((String)"start.sub.task.result.failed", (Object[])new Object[]{moduleTaskId, subTaskId}));
            return false;
        }
        LOGGER.info("Start sub task {} success, begin to loop query status and download sub task result.", (Object)subTaskId);
        return true;
    }

    private boolean querySubTaskAndDownloadResult(CollectModule cm, String moduleTaskId, int subTaskId, Map<String, String> reqPara) {
        String infoCollectSubTaskUri = RestUtil.getInfoCollectSubTaskUri((DevNode)this.devNode);
        int qryCnt = 225;
        int progressPieceLength = 50 / this.currentItemTaskIdAmount;
        int progressLast = (this.itemTaskIdNum - 1) * progressPieceLength * 2;
        boolean queryReconned = false;
        for (int i = 0; i < qryCnt; ++i) {
            try {
                int nowProgress = progressLast + CountprogressUtil.countProgtessProgressive(i, progressPieceLength);
                this.ui.updateProgress(this.moduleTaskMap.get(cm).getModuleResult(), nowProgress, "");
                Thread.sleep(8000L);
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                ResponseInfo resp = conn.execGet(infoCollectSubTaskUri, reqPara);
                if (!queryReconned && this.needReConnResponseCode(conn, resp)) {
                    resp = conn.execGet(infoCollectSubTaskUri, reqPara);
                    queryReconned = true;
                }
                if (this.parseSubTaskQueryRespAndDownLoadFile(cm, moduleTaskId, subTaskId, resp)) continue;
                this.ui.updateProgress(this.moduleTaskMap.get(cm).getModuleResult(), this.itemTaskIdNum * 100 / this.currentItemTaskIdAmount, "");
                LOGGER.info("sub task finished.");
                return true;
            }
            catch (Throwable t) {
                LOGGER.error("other exception occurred:" + t);
            }
        }
        this.setSubTaskFailed(cm, subTaskId, ResourceUtil.getString((String)"query.or.down.load.sub.task.result.file.time.out"));
        return false;
    }

    protected void setSubTaskFailed(CollectModule cm, int subTaskId, String errMsg) {
        RestCollectSubTask scst = this.moduleTaskMap.get(cm).getSubTaskMap().get(subTaskId);
        if (null == scst) {
            return;
        }
        scst.setFailed(true);
        scst.setErrorMsg(errMsg);
        this.creatFailureNodeInfo(scst);
        LOGGER.error("Collect module [{}] sub task id : {} collect failed.", (Object)cm.getModuleId(), (Object)subTaskId);
    }

    private void creatFailureNodeInfo(RestCollectSubTask scst) {
        if (scst.getNodesCollectStatusMap().isEmpty()) {
            this.updateNodeRusultInfo(scst.getSubTaskId(), scst, "failure", " ");
            return;
        }
        for (NodeCollectStatus statu : scst.getNodesCollectStatusMap().values()) {
            statu.setServerTaskStatus("failure");
        }
    }

    private boolean parseSubTaskQueryRespAndDownLoadFile(CollectModule cm, String moduleTaskId, int subTaskId, ResponseInfo resp) {
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        RestCollectSubTask moduleSubTask = dmcr.getSubTaskMap().get(subTaskId);
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode) {
            LOGGER.warn("query tasks:" + moduleTaskId + " failed, and error code is:" + errorCode);
            if (errorCode == -1L || errorCode == 404L) {
                this.setSubTaskFailed(cm, subTaskId, ResourceUtil.getString((String)"query.or.down.load.sub.task.result.file.failed"));
                return false;
            }
            return true;
        }
        JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
        int subTaskProgress = taskData.getInt("progress");
        boolean isSubTaskHasFile = taskData.getBoolean("sub_task_result");
        moduleSubTask.setSubTaskProgress(subTaskProgress);
        moduleSubTask.setHasResultFile(isSubTaskHasFile);
        JSONArray serverDetailArray = taskData.getJSONArray("server_detail");
        Map<Integer, NodeCollectStatus> nodeStatusMap = moduleSubTask.getNodesCollectStatusMap();
        for (int i = 0; i < serverDetailArray.length(); ++i) {
            int serverId = serverDetailArray.getJSONObject(i).getInt("server_id");
            String serverStatus = serverDetailArray.getJSONObject(i).getString("server_task_status");
            NodeCollectStatus nodeStatus = nodeStatusMap.getOrDefault(serverId, new NodeCollectStatus(serverId, serverStatus, this.getClusterNodeIP(serverId)));
            nodeStatusMap.putIfAbsent(serverId, nodeStatus);
            nodeStatus.setServerTaskStatus(serverStatus);
        }
        if (subTaskProgress == 100) {
            int progressPieceLength = 50 / this.currentItemTaskIdAmount;
            int progressLast = (this.itemTaskIdNum - 1) * progressPieceLength * 2 + this.collectProgressRatio / this.currentItemTaskIdAmount;
            this.ui.updateProgress(dmcr.getModuleResult(), progressLast, "");
        }
        this.pollTypeCollect.initSubTask(subTaskId, moduleTaskId, dmcr);
        return this.pollTypeCollect.executeSubTaskDown(subTaskProgress, isSubTaskHasFile);
    }

    public static boolean downloadFileExist(ResponseInfo resp) {
        Map restContentMap = resp.getContentMap();
        String filePath = restContentMap.getOrDefault("filePath", "");
        File file = new File(filePath);
        if (StringUtils.isNULLStr((String)filePath)) {
            LOGGER.info("Download file : {} result : {}", (Object)filePath, (Object)false);
            return false;
        }
        boolean success = file.exists() && file.isFile();
        LOGGER.info("Download file : {} result : {}", (Object)filePath, (Object)success);
        return success;
    }

    private long getErrorCode(ResponseInfo resp) {
        if (null == resp || !resp.getContentMap().containsKey("errorCode")) {
            LOGGER.error("resp null or resp does not contain error code.");
            return -1L;
        }
        return (Long)resp.getContentMap().get("errorCode");
    }

    private long getResultCode(ResponseInfo resp) {
        if (null == resp || !resp.getContent().contains("code")) {
            LOGGER.error("resp null or resp does not contain result code.");
            return -1L;
        }
        JSONObject content = new JSONObject(resp.getContent());
        return content.getJSONObject("result").getLong("code");
    }

    private String getErrorDesAndSuggest(ResponseInfo resp) {
        String errorDetail = "";
        if (null != resp && null != resp.getContentMap().get("description")) {
            errorDetail = "error: " + resp.getContentMap().get("description");
        }
        if (null != resp && null != resp.getContentMap().get("suggestion")) {
            errorDetail = errorDetail + System.lineSeparator() + "suggestion: " + resp.getContentMap().get("suggestion");
        }
        return errorDetail;
    }

    private Integer[] constructPerformanceItems(List<CollectItem> selectItems, CollectModule cm) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (CollectItem ci : selectItems) {
            int intId;
            String microSrvId = ci.getMicroServiceId();
            String collectType = ci.getModuleId();
            if (!collectType.equalsIgnoreCase(PERFORMANCE_COLLECT) || items.contains(intId = Integer.parseInt(microSrvId))) continue;
            items.add(intId);
        }
        return items.toArray(new Integer[items.size()]);
    }

    protected void updateRestCollectionTaskProgress(CollectModule collectingModule) {
        DStorageModuleCollectTask dmct = this.moduleTaskMap.get(collectingModule);
        ExecuteResult moduleExecuteResult = dmct.getModuleResult();
        Set<Integer> subTaskIdSet = dmct.getSubTaskMap().keySet();
        String taskProgressDesc = ResourceUtil.getStringWithParams((String)"module.task.progress", (Object[])new Object[]{dmct.getTaskProgress()});
        StringBuilder detailStringBuild = new StringBuilder();
        for (Integer subTaskId : subTaskIdSet) {
            RestCollectSubTask subTask = dmct.getSubTaskMap().get(subTaskId);
            String errMsg = subTask.getErrorMsg();
            if (subTask.isFailed() && !StringUtils.isNULLStr((String)errMsg)) {
                detailStringBuild.append(subTask.getErrorMsg());
                detailStringBuild.append("\r\n");
                continue;
            }
            detailStringBuild.append(subTask.getMsg());
        }
        if (!StringUtils.isNULLStr((String)detailStringBuild.toString())) {
            detailStringBuild.insert(0, taskProgressDesc);
        } else {
            detailStringBuild.append(ResourceUtil.getString((String)"infocollect.sus.info"));
        }
        moduleExecuteResult.setDetail(detailStringBuild.toString());
        this.moduleTaskMap.get(collectingModule).updateModuleResult();
    }

    private void updateCollectModuleResult(CollectModule cm) {
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        ExecuteResult moduleExecuteResult = dmcr.getModuleResult();
        if (dmcr.isModuleCollectFinished()) {
            if (dmcr.isTaskFailed()) {
                moduleExecuteResult.setResult(false);
                moduleExecuteResult.setCollectAllInfo(false);
            } else {
                moduleExecuteResult.setResult(dmcr.atLeastOneNodeSuccess());
                moduleExecuteResult.setCollectAllInfo(dmcr.isModuleAllCollectSuccess());
            }
            LOGGER.info("module[{}] collect finished:{}", (Object)dmcr.getModuleId(), (Object)dmcr.getModuleResult().toString());
        } else {
            moduleExecuteResult.setResult(null);
            moduleExecuteResult.setNowStatus(CollectStatus.COLLECTING);
        }
    }

    private void addDescResult(String msg) {
        DescCommand collectOverCommand = new DescCommand(msg, true);
        ExecuteResult result = collectOverCommand.process();
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        result.setProgress(92);
        this.observeExecuteResult(result);
    }

    private void doCleanJob(boolean createCollectEnvResult, boolean collectResult) {
        String infoCollectDir = InfoCollectDirPropertiesUtil.getProperty();
        String ip = IPUtil.ipV6ToPeriod(this.devNode.getIp());
        String collectDir = infoCollectDir + File.separator + ip + "_" + this.devNode.getDeviceSerialNumber();
        String collectRet = collectDir + File.separator + this.collectEnv.get("collectRetFileName");
        this.collectInfo.setCollectRetFilePath(collectRet);
        if (createCollectEnvResult) {
            this.queryModulePrgoressThreadPool.shutdownNow();
        }
        if (!CollectDataContext.getInstance().isStartCollect()) {
            LOGGER.info("not collecting...");
            return;
        }
        RestConnectionManager.releaseConn((DevNode)this.devNode);
        this.extendedConnectionQueue.clean();
        ClearCollectEnvCommand command = new ClearCollectEnvCommand(this.collectInfo.getDevNode(), this.collectInfo);
        ExecuteResult result = command.process();
        this.observeExecuteResult(result);
        boolean programResult = createCollectEnvResult && collectResult;
        String collectOverDesc = ResourceUtil.getString((String)"lld.collect.finished");
        DescCommand descCommand = new DescCommand(collectOverDesc, programResult, this.collectInfo, Color.RED);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        result = descCommand.process();
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        if (CollectStatus.COLLECT_FINISHED.equals((Object)this.nowStatus) && !this.allSucc) {
            this.nowStatus = CollectStatus.COLLECT_FINISHED_NOTALL;
        }
        LOGGER.info("collect status:{}", (Object)this.nowStatus);
        result.setNowStatus(this.nowStatus);
        LOGGER.info("collect finished.");
        CollectDataContext.getInstance().getCollectInfo(this.devNode).setProcessFinished(true);
        this.observeExecuteResult(result);
    }

    public void observeExecuteResult(ExecuteResult result) {
        if (result == null) {
            return;
        }
        result.setDevNode(this.collectInfo.getDevNode());
        CollectDataContext.getInstance().getCollectInfo(this.devNode).addExecuteResult(result);
        CollectDataContext.getInstance().getIuiCallBack().uiCallBack(this.devNode);
        this.updateSilenceInfo(result);
    }

    public void setOnlyRunningMode(boolean onlyRunningMode) {
        this.collectInfo.setOnlyRunningMode(onlyRunningMode);
    }

    private void updateSilenceInfo(ExecuteResult result) {
        if (!context.isBackground()) {
            return;
        }
        CollectStatus collectStatus = result.getNowStatus();
        if (CollectStatus.COLLECT_FINISHED_NOTALL.equals((Object)collectStatus) || CollectStatus.COLLECT_FAILED.equals((Object)collectStatus)) {
            this.failedMsg.put(result.getDescription(), (Object)result.getDetail());
        }
        context.putSilentProgress(this.devNode, this.collectInfo.getCurrentProgress());
        SilentProcessData data = new SilentProcessData(EntityUtils.toNewDev((DevNode)this.devNode), "", "running", "");
        context.updateSilentResult(this.devNode, data);
    }

    @Override
    public JSONObject getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(JSONObject failedMsg) {
        this.failedMsg = failedMsg;
    }

    public CollectInfo getCollectInfo() {
        return this.collectInfo;
    }

    private String getClusterNodeIP(int serviceId) {
        for (ClusterNode clusterNode : this.devNode.getClusterNodes()) {
            if (serviceId != clusterNode.getId()) continue;
            return clusterNode.getManagementIp();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needReConnResponseCode(RestConnection conn, ResponseInfo resp) throws ToolException {
        long errorCode = this.getErrorCode(resp);
        for (Long reconnCode : this.reconnResponseCode) {
            if (errorCode != reconnCode) continue;
            Object object = this.lock;
            synchronized (object) {
                conn.reLogin();
            }
            LOGGER.info("Reconnect session by special error code {}", (Object)reconnCode);
            return true;
        }
        return false;
    }

    public String getLocalPath(String moduleId) {
        return (String)this.collectEnv.get("collectRetDir") + File.separator + moduleId;
    }

    private void initPollTypeCollect(DevNode devNode, CollectModule cm, UIProgressObserver ui) {
        if (this.isNeedDownByNodes() && !RestCollectTask.isMustCollectBySubTask(cm.getModuleId())) {
            this.pollTypeCollect = new PollTypeCollectByNodes(cm, this, devNode, ui);
            this.collectProgressRatio = 100;
        } else {
            this.pollTypeCollect = new PollTypeCollectBySubTask(cm, this, devNode, ui);
        }
    }

    public boolean isNeedDownByNodes() {
        if (null == InfoConfiguration.getInstance().getPackageConf(this.devNode)) {
            return false;
        }
        return !InfoConfiguration.getInstance().getPackageConf(this.devNode).isCompression();
    }

    public ExtendedConnectionQueue getExtendedConnectionQueue() {
        return this.extendedConnectionQueue;
    }

    public int getCurrentItemTaskIdAmount() {
        return this.currentItemTaskIdAmount;
    }

    public int getItemTaskIdNum() {
        return this.itemTaskIdNum;
    }

    private class ExecuteCollectTaskParam {
        private List<CollectItem> selectItems;
        private int moduleStartProgress;
        private CollectModule cm;
        private int moduleCount;

        public ExecuteCollectTaskParam(List<CollectItem> selectItems, int moduleStartProgress, CollectModule cm, int moduleCount) {
            this.selectItems = selectItems;
            this.moduleStartProgress = moduleStartProgress;
            this.cm = cm;
            this.moduleCount = moduleCount;
        }

        public List<CollectItem> getSelectItems() {
            return this.selectItems;
        }

        public int getModuleStartProgress() {
            return this.moduleStartProgress;
        }

        public CollectModule getCm() {
            return this.cm;
        }

        public int getModuleCount() {
            return this.moduleCount;
        }
    }

    class QueryModuleProgressTask
    implements Runnable {
        private CollectModule cm;
        private int moduleCnt;
        private int moduleIndex;

        public QueryModuleProgressTask(CollectModule cm, int moduleCnt, int moduleIndex) {
            this.cm = cm;
            this.moduleCnt = moduleCnt;
            this.moduleIndex = moduleIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RestConnection conn = null;
            DStorageModuleCollectTask dmcr = (DStorageModuleCollectTask)RestCollectTask.this.moduleTaskMap.get(this.cm);
            String moduleTaskId = dmcr.getModuleTaskId();
            String infoCollectModuleTaskUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)RestCollectTask.this.devNode, (String)moduleTaskId);
            int failedTimes = 0;
            while (failedTimes < 5) {
                try {
                    Thread.sleep(5000L);
                    Object object = RestCollectTask.this.lock;
                    synchronized (object) {
                        if (null != conn && !conn.isLogin()) {
                            ++failedTimes;
                            continue;
                        }
                        conn = RestConnectionManager.getRestConnection((DevNode)RestCollectTask.this.devNode);
                    }
                    ResponseInfo resp = conn.execGet(infoCollectModuleTaskUri);
                    long errorCode = RestCollectTask.this.getErrorCode(resp);
                    if (0L != errorCode) {
                        LOGGER.error("query tasks:" + moduleTaskId + " failed: " + ++failedTimes + " times , and error code is:" + errorCode);
                        if (404L != errorCode) continue;
                        LOGGER.info("Task may be deleted, loop query end.");
                        return;
                    }
                    failedTimes = 0;
                    int taskProgress = this.getTaskProgress(dmcr, resp);
                    if (taskProgress < 100) continue;
                    LOGGER.info("module [{}] finished, query progress loop over...", (Object)this.cm.getModuleId());
                    break;
                }
                catch (InterruptedException ie) {
                    LOGGER.error("module [{}] interrupted, query thread pool may be shutdown ...", (Object)this.cm.getModuleId());
                    break;
                }
                catch (Throwable t) {
                    LOGGER.error("query module task progress exception:" + t);
                }
            }
        }

        private int getTaskProgress(DStorageModuleCollectTask dmcr, ResponseInfo resp) {
            JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
            int taskOpcode = taskData.getInt("opcode");
            dmcr.setOpcode(taskOpcode);
            int taskProgress = taskData.getInt("progress");
            dmcr.setTaskProgress(taskProgress);
            int preProgress = (int)((double)this.moduleIndex * (100.0 / (double)this.moduleCnt));
            int totalProgress = preProgress + (int)((double)taskProgress * 1.0 / (double)this.moduleCnt);
            if (totalProgress >= 100) {
                --totalProgress;
            }
            dmcr.getModuleResult().setProgress(totalProgress);
            RestCollectTask.this.updateRestCollectionTaskProgress(this.cm);
            return taskProgress;
        }
    }
}

