/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.SFTPProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.SshProtocolItem;
import com.huawei.ism.tool.infocollect.entity.command.TlvProtocolItem;
import com.huawei.ism.tool.infocollect.maintainer.CollectManagement;
import com.huawei.ism.tool.infocollect.maintainer.CommonMethod;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import com.huawei.ism.tool.infocollect.service.logic.command.SshManager;
import com.huawei.ism.tool.infocollect.ui.support.StopFlag;
import com.huawei.ism.tool.infocollect.util.CompressFile;
import com.huawei.ism.tool.infocollect.util.IPUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonContextAdapter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class CreateCollectEnvCommand
implements CollectCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateCollectEnvCommand.class);
    private static final int CONNECTION_ERROR = 1;
    private static final int ENVIRONMENT_ERROR = 2;
    private static final int SUCCESS = 3;
    private static final int CURRENT_PROGRESS = 2;
    private ICollectInfo collectInfo = null;
    private Map<String, Object> collectEnv = new HashMap<String, Object>();
    private DevNode devNode = null;
    private boolean isIntegrateEnv;

    public CreateCollectEnvCommand(ICollectInfo collectInfo, boolean isIntegrateEnv) {
        this.collectInfo = collectInfo;
        this.devNode = collectInfo.getDevNode();
        this.isIntegrateEnv = isIntegrateEnv;
    }

    @Override
    public ExecuteResult process() {
        ExecuteResult result = this.getProcessingResult();
        result.setResult(true);
        String detailInfo = result.getDetail();
        detailInfo = detailInfo.replace("\r", "");
        detailInfo = detailInfo.replace("\n", "");
        result.setDetail(detailInfo);
        try {
            if (!this.preInitCheck(result)) {
                return result;
            }
            this.initCommonEnv();
            this.initTimeSetting();
            this.initFor9000();
            this.replantMaintainerEnv();
            this.setLoginInfo();
            this.set7zCommandEnv();
            this.initSettingInfo();
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("create collect env error!!!", (Object)e.getMessage());
            result.setResult(false);
        }
        this.setDetilinfo(result.isSuccess(), result, 3);
        return result;
    }

    private void initSettingInfo() {
        CollectInfo info;
        if (this.collectInfo instanceof CollectInfo && null != (info = (CollectInfo)this.collectInfo).getSettingConfInfo()) {
            this.collectEnv.put("SettingInfo", info.getSettingConfInfo().getSettingInfo());
        }
    }

    private void initFor9000() {
        String mode = CollectDataContext.getInstance().getMode();
        this.collectEnv.put("isTiming", mode.contains("timetask"));
    }

    private void initCommonEnv() {
        this.collectEnv.put("progressObserver", new UIProgressObserver(this.devNode));
        this.collectEnv.put("isOEMTool", com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isOEM());
        this.collectEnv.put("soltIdStr", this.devNode.getDeviceNodeIds());
        String nodeCfgObj = this.devNode.getMiniSystemProperties().getOrDefault("nodeCfg", "0");
        this.collectEnv.put("nodeCfg", nodeCfgObj);
        this.collectEnv.put("collecManagementObj", new CollectManagement(this.devNode));
        String debug = this.devNode.getDeveloperPwd();
        this.collectEnv.put("developer", debug);
        this.collectEnv.put("debug", debug);
        this.collectEnv.put("collectAllInfo", true);
        this.collectEnv.put("not_support", false);
        String fileName = this.getFileName(this.devNode);
        this.collectEnv.put("collectRetFileName", fileName);
        String tmpDir = fileName.substring(0, fileName.lastIndexOf(".7z"));
        this.collectEnv.put("tmpDir", tmpDir);
        this.basicEnvInit();
        this.collectEnv.put("collectInfo", this.collectInfo);
        this.collectEnv.put("selectedDiskList", CollectDataContext.getInstance().getSelectedDiskForPython(this.devNode));
        this.collectEnv.put("selectedDiskListForOs9000", CollectDataContext.getInstance().getSelectedDiskWithNodeForPython(this.devNode));
        this.collectEnv.put("stop", new StopFlag(false));
    }

    public void basicEnvInit() {
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        this.collectEnv.put("lang", language);
        this.collectEnv.put("devNode", this.devNode);
        this.collectEnv.put("sshManager", SshManager.INS);
        this.collectEnv.put("context", CollectDataContext.getInstance().getTempProtocols());
        this.collectEnv.put("logger", ToolLoggerFactory.getLoggerInStandAlone((String)"infoCollectLog"));
        this.collectEnv.put("devIp", this.devNode.getIp());
        this.prepareSshConnection();
        JythonContextAdapter jca = new JythonContextAdapter(this.devNode);
        this.collectEnv.put("cbbContext", jca.getContextMap());
        this.collectEnv.put("toolName", "infoCollect");
        this.collectEnv.put("toolDir", ApplicationContext.getInstance().getWorkPath());
        this.collectEnv.put("upgradeTargetVersion", CollectDataContext.getInstance().getUpgTgtVersionMap().get(this.devNode.getDeviceSerialNumber()));
        this.collectEnv.put("upgradeExtend", CollectDataContext.getInstance().getUpgExtendMap().get(this.devNode.getDeviceSerialNumber()));
        this.collectEnv.put("isSupportUpgradeCollect", this.isSupportUpgradeCollect());
    }

    boolean isSupportUpgradeCollect() {
        if (!InfoCollectUtil.isA800Zone(this.devNode)) {
            LOGGER.info("The {} is not an A800 zone device.", (Object)this.devNode.getIp());
            return false;
        }
        return InfoCollectUtil.isSupportUpgradeCollect();
    }

    private void prepareSshConnection() {
        if (this.collectEnv.containsKey("SSH")) {
            return;
        }
        SshProtocolItem sshProtocolItem = new SshProtocolItem(this.devNode.getPort());
        Object sshCon = sshProtocolItem.createProtocolObject(this.devNode);
        if (null == sshCon) {
            return;
        }
        this.collectEnv.put("SSH", sshCon);
    }

    private void initTimeSetting() {
        CollectConfInfo cci = this.collectInfo.getCollectConfInfo();
        if (null != cci) {
            CollectDuration duration = cci.getDuration();
            this.collectEnv.putAll(this.collectInfo.getCollectConfInfo().getCollectProperties());
            if (duration == null) {
                return;
            }
            Date startDate = duration.getStartDate();
            Date endDate = duration.getEndDate();
            if (null != startDate && null != endDate) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat precisionFormat = new SimpleDateFormat("HHmmss");
                this.collectEnv.put("startTime", format.format(startDate));
                this.collectEnv.put("startTimePrecision", precisionFormat.format(startDate));
                this.collectEnv.put("endTime", format.format(endDate));
                this.collectEnv.put("endTimePrecision", precisionFormat.format(endDate));
            }
        }
    }

    private boolean initResultDir(ExecuteResult result) {
        File file = new File(InfoCollectUtil.getDevCollectDir(this.devNode));
        LOGGER.info(String.format(Locale.ROOT, "Infocollect path is: %s", FilesUtil.getCanonicalPath((File)file)));
        if (!file.exists() && !file.mkdirs()) {
            LOGGER.error("create target folder error!");
            result.setResult(false);
            this.setDetilinfo(false, result, 2);
            return false;
        }
        this.collectEnv.put("collectRetDir", file.getAbsoluteFile().toString());
        return true;
    }

    private boolean preInitCheck(ExecuteResult result) {
        if (this.isSilenceCall()) {
            LOGGER.warn(String.format(Locale.ROOT, "selected item is empty,dev version \uff1a %s", this.devNode.getDeviceType().toString()));
            result.setDetail(ResourceUtil.getString((String)"infocollect.collect.silence.unsupport"));
            result.setResult(false);
            return false;
        }
        InfoConfiguration infoConfiguration = InfoConfiguration.getInstance();
        CollectConf collectConf = infoConfiguration.getCollectConf(this.devNode);
        if (null == collectConf) {
            result.setResult(false);
            return false;
        }
        if (!this.createProItem(result, collectConf.getComandConf().getProtocolItems())) {
            return false;
        }
        this.collectEnv.put("restMamager", RestConnectionManager.class);
        if (this.isIntegrateEnv) {
            return false;
        }
        return this.initResultDir(result);
    }

    private boolean isSilenceCall() {
        return !CollectDataContext.getInstance().isForeground() && this.collectInfo.getCollectConfInfo() != null && this.collectInfo.getCollectConfInfo().getSelectItems().isEmpty();
    }

    private boolean createProItem(ExecuteResult result, List<ProtocolItem> protocolItems) {
        for (ProtocolItem protocolItem : protocolItems) {
            Object protocol;
            if (protocolItem instanceof SFTPProtocolItem) {
                protocolItem = new SFTPProtocolItem();
                LOGGER.info("creart sftp connection. ");
                this.setSSH(protocolItem);
            }
            if ((protocol = protocolItem.createProtocolObject(this.devNode)) == null && !(protocolItem instanceof TlvProtocolItem)) {
                LOGGER.error("create protocol Object error!!!");
                result.setResult(false);
                this.setDetilinfo(false, result, 1);
                return false;
            }
            if (null != protocol && protocol instanceof PwdException) {
                result.setResult(false);
                result.setDetail(((PwdException)protocol).getErrorMsg());
                return false;
            }
            if (null != protocol && protocol instanceof UserStatusException) {
                result.setResult(false);
                result.setDetail(((UserStatusException)protocol).getDes());
                return false;
            }
            this.collectEnv.put(protocolItem.getProtocolName(), protocol);
            CollectDataContext.getInstance().getTempProtocols().addProtocol(this.devNode, protocol);
        }
        return true;
    }

    private void setDetilinfo(boolean isResult, ExecuteResult result, int type) {
        if (!isResult && type == 1) {
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollect.init.error1"));
        } else if (!isResult && type == 2) {
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollect.init.error2"));
        } else {
            result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        }
    }

    private void setSSH(ProtocolItem protocolItem) {
        SFTPProtocolItem ftpItem = (SFTPProtocolItem)protocolItem;
        Object sshObject = this.collectEnv.get("SSH");
        if (sshObject != null) {
            ftpItem.setConnection((SshConnection)sshObject);
        }
    }

    private void replantMaintainerEnv() {
        this.collectEnv.put("currSysTime", CommonMethod.getCurrentDateStrLine());
        this.collectEnv.put("compress", new CompressFile());
    }

    private void setLoginInfo() {
        this.collectEnv.put("username", this.devNode.getLoginUser().getUserName());
        String pwd = this.devNode.getLoginUser().getPassword();
        this.collectEnv.put("password", pwd);
        pwd = "";
    }

    private void set7zCommandEnv() {
        this.collectEnv.put("7z_command", ApplicationContext.getInstance().getWorkPath() + File.separator + "utils" + File.separator + "7z" + File.separator + "7za.exe");
    }

    private String getFileName(DevNode dev) {
        String ip = IPUtil.ipV6ToPeriod(dev.getIp());
        return ip + "_" + CommonMethod.getCurrentDateStrLine() + ".7z";
    }

    public Map<String, Object> getCollectEnv() {
        return this.collectEnv;
    }

    public ExecuteResult getProcessingResult() {
        ExecuteResult result = new ExecuteResult();
        result.setProgress(2);
        result.setResult(null);
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.initenv"));
        return result;
    }
}

