/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.callback.UIProgressObserver;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class CreateFcvCollectEnvCommand
implements CollectCommand {
    private static final Logger log = LoggerFactory.getLogger(CreateFcvCollectEnvCommand.class);
    private static final int CURRENT_PROGRESS = 2;
    private final DevNode devNode;
    private Map<String, Object> collectEnv = new HashMap<String, Object>();

    @Override
    public ExecuteResult process() {
        ExecuteResult result = this.getCreateFcvEnvInitResult();
        result.setResult(true);
        if (!this.preInitCheck(result)) {
            return result;
        }
        this.initCommonEnv();
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        return result;
    }

    private boolean preInitCheck(ExecuteResult result) {
        return this.initCollectRetDir(result);
    }

    private void initCommonEnv() {
        this.collectEnv.put("devNode", this.devNode);
        this.collectEnv.put("logger", log);
        this.collectEnv.put("progressObserver", new UIProgressObserver(this.devNode));
        this.collectEnv.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
    }

    private boolean initCollectRetDir(ExecuteResult result) {
        File resultFile = new File(InfoCollectUtil.getDevCollectDir(this.devNode));
        log.info("The result file path is {}", (Object)FilesUtil.getCanonicalPath((File)resultFile));
        if (!resultFile.exists() && !resultFile.mkdirs()) {
            log.error("Create result file failed!!!");
            result.setResult(false);
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollect.init.error2"));
            return false;
        }
        this.collectEnv.put("collectRetDir", resultFile.getAbsoluteFile().toString());
        return true;
    }

    public ExecuteResult getCreateFcvEnvInitResult() {
        ExecuteResult result = new ExecuteResult();
        result.setProgress(2);
        result.setResult(null);
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.initenv"));
        return result;
    }

    public CreateFcvCollectEnvCommand(DevNode devNode) {
        this.devNode = devNode;
    }

    public Map<String, Object> getCollectEnv() {
        return this.collectEnv;
    }
}

