/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.maintainer.CollectManagement;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import com.huawei.ism.tool.infocollect.util.IPUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRestCollectEnvCommand
implements CollectCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateRestCollectEnvCommand.class);
    private static final int CONNECTION_ERROR = 1;
    private static final int ENVIRONMENT_ERROR = 2;
    private static final int SUCCESS = 3;
    private static final int INIT_ENV_PROGRESS = 2;
    private static final String COLLECT_PACKAGE_NAME = "DataCollect_%s_%s";
    private ICollectInfo collectInfo;
    private Map<String, Object> collectEnv = new HashMap<String, Object>();
    private DevNode devNode;

    public CreateRestCollectEnvCommand(ICollectInfo collectInfo) {
        this.collectInfo = collectInfo;
        this.devNode = collectInfo.getDevNode();
    }

    @Override
    public ExecuteResult process() {
        ExecuteResult result = this.getProcessingResult();
        result.setResult(true);
        if (!CollectDataContext.getInstance().isForeground() && this.collectInfo.getCollectConfInfo().getSelectItems().isEmpty()) {
            LOGGER.warn("selected item is empty,dev version : {}", (Object)this.devNode.getDeviceType().toString());
            result.setDetail(ResourceUtil.getString((String)"infocollect.collect.silence.unsupport"));
            result.setResult(false);
            return result;
        }
        String detailInfo = this.getDetailInfo(result);
        result.setDetail(detailInfo);
        try {
            InfoConfiguration infoConfiguration = InfoConfiguration.getInstance();
            CollectConf collectConf = infoConfiguration.getCollectConf(this.devNode);
            if (null == collectConf || !collectConf.isInited()) {
                result.setResult(false);
                return result;
            }
            RestConnectionManager.releaseConn((DevNode)this.devNode);
            RestConnectionManager.getDstorageLoginRestConnection((DevNode)this.devNode);
            String sn = this.devNode.getDeviceSerialNumber();
            String collectRetRootPth = InfoCollectDirPropertiesUtil.getProperty() + File.separator + IPUtil.ipV6ToPeriod(this.devNode.getIp()) + "_" + (StringUtils.isNULLStr((String)sn) ? this.devNode.getProductVersion() : sn);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String zipRootDir = collectRetRootPth + File.separator + String.format(Locale.ENGLISH, COLLECT_PACKAGE_NAME, IPUtil.ipV6ToPeriod(this.devNode.getIp()), sdf.format(new Date())) + File.separator + "DataCollect";
            File file = new File(zipRootDir);
            LOGGER.info("InfoCollect path is:{}", (Object)zipRootDir);
            if (!file.exists() && !file.mkdirs()) {
                LOGGER.error("create target folder error!!!,file name:" + zipRootDir);
                result.setResult(false);
                this.setDetilinfo(false, result, 2);
                return result;
            }
            this.setEnv(file);
        }
        catch (Throwable e) {
            LOGGER.error("Create collect env error!!!", e);
            result.setResult(false);
        }
        CollectDataContext.getInstance().setStartCollect(true);
        this.setDetilinfo(result.isSuccess(), result, 3);
        return result;
    }

    private void setEnv(File file) {
        CollectInfo info;
        this.collectEnv.put("collectRetDir", file.getAbsoluteFile().toString());
        CollectManagement collectManagement = new CollectManagement(this.devNode);
        this.collectEnv.put("collecManagementObj", collectManagement);
        this.collectEnv.put("collecRemotePath", "");
        if (this.collectInfo instanceof CollectInfo && null != (info = (CollectInfo)this.collectInfo).getSettingConfInfo()) {
            this.collectEnv.put("SettingInfo", info.getSettingConfInfo().getSettingInfo());
        }
    }

    private String getDetailInfo(ExecuteResult result) {
        String detailInfo = result.getDetail();
        detailInfo = detailInfo.replace("\r\n", "");
        detailInfo = detailInfo.replace("\r", "");
        detailInfo = detailInfo.replace("\n", "");
        return detailInfo;
    }

    private void setDetilinfo(boolean isResult, ExecuteResult result, int type) {
        if (!isResult && type == 1) {
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollect.init.error1"));
        } else if (!isResult && type == 2) {
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollect.init.error2"));
        } else {
            result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        }
    }

    public Map<String, Object> getCollectEnv() {
        return this.collectEnv;
    }

    public ExecuteResult getProcessingResult() {
        ExecuteResult result = new ExecuteResult();
        result.setProgress(2);
        result.setResult(null);
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.initenv"));
        return result;
    }
}

