/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import java.awt.Color;

public class DescCommand
implements CollectCommand {
    private String description = "";
    private Boolean result = null;
    private ICollectInfo collectInfo = null;
    private Color color = null;

    public DescCommand(String description) {
        this.description = description;
    }

    public DescCommand(String description, Boolean result) {
        this(description);
        this.result = result;
    }

    public DescCommand(String description, Boolean result, ICollectInfo collectInfo) {
        this(description, result);
        this.collectInfo = collectInfo;
    }

    public DescCommand(String description, Boolean result, ICollectInfo collectInfo, Color color) {
        this(description, result, collectInfo);
        this.color = color;
    }

    @Override
    public ExecuteResult process() {
        ExecuteResult executeResult = new ExecuteResult();
        executeResult.setResult(this.result);
        if (null != this.collectInfo) {
            executeResult.setProgress(this.collectInfo.getCurrentProgress() + 1);
        }
        executeResult.setDescription(this.description);
        if (null != this.color) {
            executeResult.setColor(this.color);
        }
        return executeResult;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

