/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.CommandConf;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.List;

public class GainExecuteScriptCommand
implements CollectCommand {
    private ICollectInfo collectInfo = null;
    private DevNode devNode = null;
    private List<ScriptItem> executeScripts = new ArrayList<ScriptItem>();

    public GainExecuteScriptCommand(ICollectInfo collectInfo) {
        this.collectInfo = collectInfo;
        this.devNode = collectInfo.getDevNode();
    }

    @Override
    public ExecuteResult process() {
        ExecuteResult result = new ExecuteResult();
        result.setProgress(1);
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.checkcommand"));
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(this.devNode);
        if (null == conf) {
            result.setResult(false);
            return result;
        }
        CommandConf commandConf = conf.getComandConf();
        if (commandConf == null) {
            result.setResult(false);
            return result;
        }
        List<CollectItem> collectItems = this.collectInfo.getCollectConfInfo().getSelectItems();
        this.executeScripts = commandConf.getSelectScriptItems(collectItems);
        if (this.executeScripts.isEmpty()) {
            result.setResult(false);
            return result;
        }
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        return result;
    }

    public List<ScriptItem> getExecuteScripts() {
        return this.executeScripts;
    }
}

