/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import com.huawei.ism.tool.infocollect.util.GroupFcvComputeNodes;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GainFcvExecuteScriptCommand
implements CollectCommand {
    private static final Logger log = LoggerFactory.getLogger(GainFcvExecuteScriptCommand.class);
    private static final String COLLECT_COMPUTE_NODES_STEP_NAME = "collect_compute_nodes";
    private ICollectInfo collectInfo;
    private DevNode devNode;
    private List<ScriptItem> executeScripts = new ArrayList<ScriptItem>();

    public GainFcvExecuteScriptCommand(ICollectInfo collectInfo) {
        this.collectInfo = collectInfo;
        this.devNode = collectInfo.getDevNode();
    }

    @Override
    public ExecuteResult process() {
        ExecuteResult result = new ExecuteResult();
        result.setProgress(1);
        result.setDescription(ResourceUtil.getString((String)"infocollect.detail.checkcommand"));
        CollectConf conf = InfoConfiguration.getInstance().getCollectConf(this.devNode);
        if (!this.checkConf(conf, result)) {
            result.setResult(false);
            return result;
        }
        if (!this.initComputeNodesInfo(result, conf)) {
            log.error("init compute nodes info failed.");
            result.setResult(false);
            return result;
        }
        result.setResult(true);
        result.setDetail(ResourceUtil.getString((String)"infocollect.sus.info"));
        return result;
    }

    private boolean initComputeNodesInfo(ExecuteResult result, CollectConf conf) {
        if (!GroupFcvComputeNodes.createComputeNodesGroups(this.devNode)) {
            log.error("Create Compute Nodes Groups failed.");
            result.setDetail(ResourceUtil.getString((String)"infocollect.obtain.fcv.information.error"));
            return false;
        }
        this.executeScripts = conf.getComandConf().getFcvSelectScriptItems();
        if (this.executeScripts.isEmpty()) {
            log.error("The executeScripts is empty!!!");
            result.setDetail(ResourceUtil.getString((String)"infocollect.obtain.fcv.item.error"));
            return false;
        }
        this.saveGroupsInfo();
        return true;
    }

    private void saveGroupsInfo() {
        int groupsSize = CollectDataContext.getInstance().getDevComputeNodesGroupsInfo().get(this.devNode).size();
        this.executeScripts.stream().filter(item -> COLLECT_COMPUTE_NODES_STEP_NAME.equals(item.getStep())).forEach(item -> item.setGroupsCount(groupsSize));
    }

    private boolean checkConf(CollectConf conf, ExecuteResult result) {
        if (conf == null) {
            log.error("The collectConf is null!!!");
            result.setDetail(ResourceUtil.getString((String)"infocollect.obtain.collect.configuration.error"));
            return false;
        }
        if (conf.getComandConf() == null) {
            log.error("The comandConf is null!!!");
            result.setDetail(ResourceUtil.getString((String)"infocollect.obtain.collect.commands.error"));
            return false;
        }
        return true;
    }

    public List<ScriptItem> getExecuteScripts() {
        return this.executeScripts;
    }
}

