/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.command;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.service.logic.command.CollectCommand;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonCommand
implements CollectCommand {
    public static final int PYTHON_OVER_PROGRESS = 92;
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonCommand.class);
    private ScriptItem item = null;
    private Map<String, Object> env = null;
    private JythonExecuter executor = null;
    private int progress = 0;

    public PythonCommand(Map<String, Object> env, String scriptPath) {
        this.executor = this.createJythonExecutor(scriptPath);
        this.env = env;
    }

    private JythonExecuter createJythonExecutor(String scriptPath) {
        try {
            if (StringUtils.isNULLStr((String)scriptPath)) {
                LOGGER.info("scriptPath is NULL!!!!");
                return new JythonExecuter();
            }
            File pyframe = new File(CollectDataContext.PYFRAMEPATH);
            File scriptPathFile = new File(scriptPath);
            if (scriptPathFile.exists() && scriptPathFile.isDirectory()) {
                ArrayList<File> pyClassPths = new ArrayList<File>();
                if (pyframe.exists()) {
                    pyClassPths.add(pyframe);
                }
                pyClassPths.add(scriptPathFile);
                LOGGER.info("scriptPath is {}", (Object)scriptPath);
                return new JythonExecuter(pyClassPths);
            }
            LOGGER.info("scriptPath is not exist or not a folder:{}", (Object)scriptPath);
            return new JythonExecuter();
        }
        catch (RuntimeException e) {
            LOGGER.error("init JythonExecutor failed!", (Throwable)e);
            return null;
        }
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setScriptItem(ScriptItem scriptItem) {
        this.item = scriptItem;
    }

    public ExecuteResult newProcessingResult() {
        ExecuteResult result = new ExecuteResult();
        result.setPyResult(true);
        result.setProgress(this.progress);
        result.setResult(null);
        result.setNowStatus(CollectStatus.COLLECTING);
        result.setDescription(this.item.getDescriptionKey());
        result.setConcurrentDepthCollect(this.item.isConcurrentDepthCollect());
        result.setDepthCollectConcurrentItemNames(this.item.getDepthCollectConcurrentItemsName());
        return result;
    }

    @Override
    public ExecuteResult process() {
        ExecuteResult result = this.setResult();
        try {
            File pyFile = new File(this.item.getScriptFileName());
            this.env.put("currentScriptPath", pyFile.getParent());
            this.env.put("not_support", false);
            this.executor.compileScript(pyFile);
            List pyResult = this.executor.invokeFunction(this.item.getMainMethod(), this.env);
            Boolean retState = Boolean.valueOf(pyResult.get(0).toString());
            String pyResults = pyResult.get(0).toString() + pyResult.get(1).toString();
            LOGGER.info("python process result:{}", (Object)pyResults);
            result.setResult(retState);
            result.setResultInfoMap(this.env.getOrDefault("resultInfoMap", Collections.emptyMap()));
            this.processResult(result);
            Object resultMsg = this.env.get("py_detail");
            if (!retState.booleanValue()) {
                this.retFailProcess(result, resultMsg);
            } else if (!result.isCollectAllInfo() && null != resultMsg) {
                result.setDetail(ResourceUtil.getStringWithParams((String)"infocollect.error.infocollectdetail2", (Object[])new Object[]{String.valueOf(resultMsg)}));
            } else {
                Boolean matchUnSupport = MapUtils.getBoolean(this.env, (Object)"not_support", null);
                boolean retNotSupport = matchUnSupport != null && matchUnSupport != false;
                result.setUnableSupport(retNotSupport);
                String successDetail = retNotSupport ? (String)resultMsg : ResourceUtil.getString((String)"infocollect.sus.info");
                result.setDetail(successDetail);
            }
        }
        catch (SignException e) {
            LOGGER.error("execute python failed,SignException file:" + this.item.getScriptFileName(), (Object)e.toString());
            result.setDetail(e.getErrorMsg());
            result.setResult(false);
        }
        catch (ToolException e) {
            LOGGER.error("invoke function failed,ToolException file:" + this.item.getScriptFileName() + e.toString());
            result.setDetail(ResourceUtil.getStringWithParams((String)"infocollect.error.infocollectdetail", (Object[])new Object[]{ResourceUtil.getString((String)"infocollect.error.infocollectdetail.error")}));
            result.setResult(false);
        }
        catch (Exception e) {
            LOGGER.error("execute python failed,file:" + this.item.getScriptFileName() + e.toString());
            LOGGER.error("execute cause:" + e.getCause());
            result.setDetail(ResourceUtil.getStringWithParams((String)"infocollect.error.infocollectdetail", (Object[])new Object[]{ResourceUtil.getString((String)"infocollect.error.infocollectdetail.error")}));
            result.setResult(false);
        }
        return result;
    }

    private void retFailProcess(ExecuteResult result, Object resultMsg) {
        if (null == resultMsg || StringUtils.isNULLStr((String)String.valueOf(resultMsg))) {
            result.setDetail(ResourceUtil.getString((String)"infocollect.error.infocollectdetail"));
        } else if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(String.valueOf(resultMsg))) {
            result.setDetail(ResourceUtil.getStringWithParams((String)"infocollect.error.infocollectdetail2", (Object[])new Object[]{ResourceUtil.getString((String)"infocollect.error.timeout.msg")}));
        } else {
            result.setDetail(ResourceUtil.getStringWithParams((String)"infocollect.error.infocollectdetail2", (Object[])new Object[]{String.valueOf(resultMsg)}));
        }
    }

    private void processResult(ExecuteResult result) {
        boolean collectall;
        Object collectAll = this.env.get("collectAllInfo");
        Object resultDict = this.env.get("collectResultDict");
        if (null != resultDict) {
            Map resultMap = (Map)PyJavaUtils.converBaseType((PyObject)((PyObject)resultDict));
            CollectDataContext.getInstance().getLastDiskLogResultMap().put((DevNode)this.env.get("devNode"), resultMap);
        }
        if (null != collectAll && !(collectall = ((Boolean)this.env.get("collectAllInfo")).booleanValue())) {
            result.setCollectAllInfo(false);
            this.env.put("collectAllInfo", true);
        }
    }

    private ExecuteResult setResult() {
        ExecuteResult result = new ExecuteResult();
        result.setPyResult(true);
        result.setUnableSupport(false);
        result.setProgress(this.progress);
        result.setDescription(this.item.getDescriptionKey());
        result.setItem(this.item);
        result.setConcurrentDepthCollect(this.item.isConcurrentDepthCollect());
        result.setDepthCollectConcurrentItemNames(this.item.getDepthCollectConcurrentItemsName());
        return result;
    }

    public void clearUp() {
        try {
            if (this.executor != null) {
                this.executor.cleanup();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("python executor cleanup run time error!", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("python executor cleanup error!", (Throwable)e);
        }
    }

    public Map<String, Object> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, Object> env) {
        this.env = env;
    }
}

