/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.inspectcollect;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.common.entity.Item;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.stream.Collectors;

public class InspectCollectTaskObserver
implements Observer {
    private static final String COMMA_SEPARATOR = ",";
    private List<Item> items;

    @Override
    public void update(Observable observable, Object arg) {
        if (arg instanceof Item) {
            Item currentItem = (Item)arg;
            this.items.stream().filter(item -> item.getId().equals(currentItem.getId())).findFirst().ifPresent(item -> {
                item.setNodeStatus(currentItem.getNodeStatus());
                item.setProgress(currentItem.getProgress());
                item.setErrorMessage(currentItem.getErrorMessage());
                item.setDownload(currentItem.isDownload());
                item.setStatus(currentItem.getStatus());
            });
        }
    }

    public boolean checkFinish() throws ToolException {
        String timeOutItems = this.items.stream().filter(item -> item.getNodeStatus().isEmpty()).map(Item::getId).collect(Collectors.joining(COMMA_SEPARATOR));
        if (!StringUtils.isNULLStr((String)timeOutItems)) {
            throw new ToolException("collect.by.inspect.exec.timeout", (Object[])new String[]{timeOutItems});
        }
        String downloadFailItems = this.items.stream().filter(item -> !item.isDownload()).map(Item::getId).collect(Collectors.joining(COMMA_SEPARATOR));
        if (!StringUtils.isNULLStr((String)downloadFailItems)) {
            throw new ToolException("collect.by.inspect.download.fail", (Object[])new String[]{downloadFailItems});
        }
        return true;
    }

    public InspectCollectTaskObserver(List<Item> items) {
        this.items = items;
    }
}

