/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetWorkType;
import com.huawei.ism.tool.infocollect.util.NetworkUtil;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class IpAddress {
    private String subnetPrefix;
    private String ipAddress;
    private String defaultGateway;
    @JSONField(name="ip_usage")
    private List<String> ipUsages = new ArrayList<String>();
    private String portName;

    public boolean isNetWorkType(NetWorkType networkType) {
        if (!CollectionUtil.isEmpty(this.ipUsages)) {
            return this.ipUsages.stream().anyMatch(ipUsage -> ipUsage.equals(networkType.getNetworkType()));
        }
        return false;
    }

    public boolean isShareIp() {
        return this.ipUsages.contains(NetWorkType.STORAGE_FRONTEND.getNetworkType()) && this.ipUsages.contains(NetWorkType.STORAGE_BACKEND.getNetworkType());
    }

    public String getDefaultGateway() {
        return NetworkUtil.transferGateWay(this.defaultGateway);
    }

    public void setSubnetPrefix(String subnetPrefix) {
        this.subnetPrefix = subnetPrefix;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    public void setIpUsages(List<String> ipUsages) {
        this.ipUsages = ipUsages;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getSubnetPrefix() {
        return this.subnetPrefix;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public List<String> getIpUsages() {
        return this.ipUsages;
    }

    public String getPortName() {
        return this.portName;
    }
}

