/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.entity;

import com.huawei.ism.tool.infocollect.service.logic.lld.entity.IpAddress;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetWorkType;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetworkPlatform;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.ServiceTypeEnum;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.SheetTable;
import com.huawei.ism.tool.infocollect.util.NetworkUtil;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class LldInfo
implements SheetTable {
    private String clusterName;
    private String floatingIpAddress;
    private String serviceTypeGenera;
    private String productionVersion;
    private String nodeModel;
    private String nodeName;
    private String storagePool;
    private String storagePoolId;
    private String diskPoolName;
    private String diskPoolId;
    private String cabinet;
    private String role;
    private String bmcIp;
    private String bmcGateway;
    private String bmcVlan;
    private String managementInternalIp;
    private String managementGateway;
    private String managementSubnetPrefix;
    private String storageFrontendSpeed;
    private String storageFrontendProtocol;
    private String storageFrontendBondMode;
    private String storageFrontendPortNumber;
    private String storageFrontendIp;
    private String storageFrontendGateway;
    private String storageFrontendVlanName;
    private String storageFrontSubnetPrefix;
    private String storageBackendSpeed;
    private String storageBackendProtocol;
    private String storageBackendBondMode;
    private String storageBackendPortNumber;
    private String storageBackendIp;
    private String storageBackendGateway;
    private String storageBackendVlanName;
    private String storageBackendSubnetPrefix;
    private String iscsiSpeed;
    private String iscsiProtocol;
    private String iscsiBondMode;
    private String iscsiPortNumber;
    private String storageMediaType;
    private String cacheMediaType;
    private String mainStorageCapacity;
    private String mainStorageQuantity;
    private String cacheStorageCapacity;
    private String cacheStorageQuantity;
    private List<NetworkPlatform> storageFrontendMultiIps;
    private List<NetworkPlatform> storageBackendMultiIps;
    private List<NetworkPlatform> storageCtrlNetworks;
    private List<NetworkPlatform> iscsiIps;

    @Override
    public List<String> getPropertyValues() {
        return Arrays.asList(this.getClusterName(), this.getFloatingIpAddress(), this.getServiceTypeGenera(), this.getProductionVersion(), this.getNodeModel(), this.getNodeName(), this.getStoragePool(), this.getStoragePoolId(), this.getDiskPoolName(), this.getDiskPoolId(), this.getCabinet(), this.getRole(), this.getBmcIp(), this.getManagementInternalIp(), this.getManagementGateway(), this.getManagementSubnetPrefix(), this.getStorageFrontendSpeed(), this.getStorageFrontendProtocol(), this.getStorageFrontendBondMode(), this.getStorageFrontendPortNumber(), this.getStorageFrontendIp(), this.getStorageFrontendGateway(), this.getStorageFrontendVlanName(), this.getStorageFrontSubnetPrefix(), this.getStorageBackendSpeed(), this.getStorageBackendProtocol(), this.getStorageBackendBondMode(), this.getStorageBackendPortNumber(), this.getStorageBackendIp(), this.getStorageBackendGateway(), this.getStorageBackendVlanName(), this.getStorageBackendSubnetPrefix(), this.getIscsiSpeed(), this.getIscsiProtocol(), this.getIscsiBondMode(), this.getIscsiPortNumber(), this.getStorageMediaType(), this.getMainStorageCapacity(), this.getMainStorageQuantity(), this.getCacheMediaType(), this.getCacheStorageCapacity(), this.getCacheStorageQuantity());
    }

    public static LldInfo trans2LLdInfo(NodeInfo nodeInfo) {
        Optional<IpAddress> manageIpAddress = nodeInfo.getIpAddressByNetType(NetWorkType.MANAGEMENT_INTERNAL);
        LldInfoBuilder lldInfo = LldInfo.builder().clusterName(nodeInfo.getClusterName()).floatingIpAddress(nodeInfo.getFloatingIpAddress()).serviceTypeGenera(ServiceTypeEnum.getByType(nodeInfo.getServiceTypeGenera())).productionVersion(nodeInfo.getProductVersion()).nodeModel(nodeInfo.getModel()).cabinet(nodeInfo.getCabinet()).bmcIp(nodeInfo.getBmcIp()).role(nodeInfo.getRole()).managementInternalIp(nodeInfo.getManagementInternalIp()).managementGateway(manageIpAddress.map(IpAddress::getDefaultGateway).orElse("")).managementSubnetPrefix(manageIpAddress.map(NetworkUtil::changePrefixToMask).orElse("")).nodeName(nodeInfo.getName()).mainStorageCapacity(nodeInfo.getMainStorageCapacity()).mainStorageQuantity(nodeInfo.getMainStorageQuantity()).cacheStorageCapacity(nodeInfo.getCacheStorageCapacity()).cacheStorageQuantity(nodeInfo.getCacheStorageQuantity());
        LldInfo.setStorageFrontNet(nodeInfo, lldInfo);
        LldInfo.setStorageBackNet(nodeInfo, lldInfo);
        LldInfo.setStorageCtrlNet(nodeInfo, lldInfo);
        LldInfo.setStorageIscsiNet(nodeInfo, lldInfo);
        LldInfo.buildPoolInfo(lldInfo, nodeInfo);
        return lldInfo.build();
    }

    private static void setStorageCtrlNet(NodeInfo nodeInfo, LldInfoBuilder lldInfo) {
        List storageCtrlNets = nodeInfo.getNetworkPlatformMap().getOrDefault((Object)NetWorkType.STORAGE_CTRL_NETWORK, Collections.emptyList());
        lldInfo.storageCtrlNetworks(storageCtrlNets.stream().filter(LldInfo::isNetWorkTypeValid).collect(Collectors.toList()));
    }

    private static boolean isNetWorkTypeValid(NetworkPlatform storageCtrlNet) {
        return !StringUtils.isNULLStr((String)storageCtrlNet.getNetworkType());
    }

    private static void setStorageFrontNet(NodeInfo nodeInfo, LldInfoBuilder lldInfo) {
        List storageFrontNets = nodeInfo.getNetworkPlatformMap().getOrDefault((Object)NetWorkType.STORAGE_FRONTEND, Collections.emptyList());
        storageFrontNets.stream().filter(LldInfo::isNetWorkTypeValid).findFirst().ifPresent(frontendNet -> LldInfo.updateFrontendIpInfo(frontendNet, storageFrontNets, lldInfo));
    }

    private static void updateFrontendIpInfo(NetworkPlatform frontendNet, List<NetworkPlatform> frontendNets, LldInfoBuilder lldInfo) {
        lldInfo.storageFrontendSpeed(frontendNet.getSpeed()).storageFrontendProtocol(frontendNet.getTransferProtocol()).storageFrontendBondMode(frontendNet.getBondMode()).storageFrontendPortNumber(frontendNet.getPortNum()).storageFrontendGateway(frontendNet.getGateway());
        if (frontendNet.isMultiIp()) {
            lldInfo.storageFrontendMultiIps(frontendNets);
            return;
        }
        lldInfo.storageFrontendIp(frontendNet.getIpAddress()).storageFrontendVlanName(frontendNet.getVlan()).storageFrontSubnetPrefix(frontendNet.getSubnetPrefix());
    }

    private static void setStorageBackNet(NodeInfo nodeInfo, LldInfoBuilder lldInfo) {
        List storageBackNets = nodeInfo.getNetworkPlatformMap().getOrDefault((Object)NetWorkType.STORAGE_BACKEND, Collections.emptyList());
        storageBackNets.stream().filter(LldInfo::isNetWorkTypeValid).findFirst().ifPresent(backendNet -> LldInfo.updateBackendIpInfo(backendNet, storageBackNets, lldInfo));
    }

    private static void updateBackendIpInfo(NetworkPlatform backendNet, List<NetworkPlatform> backendNets, LldInfoBuilder lldInfo) {
        lldInfo.storageBackendSpeed(backendNet.getSpeed()).storageBackendProtocol(backendNet.getTransferProtocol()).storageBackendBondMode(backendNet.getBondMode()).storageBackendPortNumber(backendNet.getPortNum()).storageBackendGateway(backendNet.getGateway());
        if (backendNet.isMultiIp()) {
            lldInfo.storageBackendMultiIps(backendNets);
            return;
        }
        lldInfo.storageBackendIp(backendNet.getIpAddress()).storageBackendVlanName(backendNet.getVlan()).storageBackendSubnetPrefix(backendNet.getSubnetPrefix());
    }

    private static void setStorageIscsiNet(NodeInfo nodeInfo, LldInfoBuilder lldInfo) {
        List iscsiNets = nodeInfo.getNetworkPlatformMap().getOrDefault((Object)NetWorkType.ISCSI, Collections.emptyList());
        iscsiNets.stream().filter(LldInfo::isNetWorkTypeValid).findFirst().ifPresent(iscsiNet -> {
            lldInfo.iscsiSpeed(iscsiNet.getSpeed()).iscsiProtocol(iscsiNet.getTransferProtocol()).iscsiBondMode(iscsiNet.getBondMode()).iscsiPortNumber(iscsiNet.getPortNum());
            lldInfo.iscsiIps(iscsiNets);
        });
    }

    private static void buildPoolInfo(LldInfoBuilder lldInfo, NodeInfo nodeInfo) {
        if (nodeInfo.getDiskPool() != null) {
            LldInfo.buildDiskAndStorPoolInfo(lldInfo, nodeInfo);
            return;
        }
        if (nodeInfo.getStoragePool() != null) {
            LldInfo.buildStorPoolInfo(lldInfo, nodeInfo);
        }
    }

    private static void buildDiskAndStorPoolInfo(LldInfoBuilder lldInfo, NodeInfo nodeInfo) {
        FusionStorStoragePool pool = nodeInfo.getDiskPool();
        lldInfo.diskPoolName(pool.getName()).diskPoolId(pool.getId()).storageMediaType(pool.getStorageMediaType()).cacheMediaType(pool.getCacheMediaType());
        if (nodeInfo.getStoragePool() != null) {
            FusionStorStoragePool fusionStorStoragePool = nodeInfo.getStoragePool();
            lldInfo.storagePool(fusionStorStoragePool.getName()).storagePoolId(fusionStorStoragePool.getId());
        }
    }

    private static void buildStorPoolInfo(LldInfoBuilder lldInfo, NodeInfo nodeInfo) {
        FusionStorStoragePool fusionStorStoragePool = nodeInfo.getStoragePool();
        lldInfo.storagePool(fusionStorStoragePool.getName()).storagePoolId(fusionStorStoragePool.getId()).storageMediaType(fusionStorStoragePool.getStorageMediaType()).cacheMediaType(fusionStorStoragePool.getCacheMediaType());
    }

    LldInfo(String clusterName, String floatingIpAddress, String serviceTypeGenera, String productionVersion, String nodeModel, String nodeName, String storagePool, String storagePoolId, String diskPoolName, String diskPoolId, String cabinet, String role, String bmcIp, String bmcGateway, String bmcVlan, String managementInternalIp, String managementGateway, String managementSubnetPrefix, String storageFrontendSpeed, String storageFrontendProtocol, String storageFrontendBondMode, String storageFrontendPortNumber, String storageFrontendIp, String storageFrontendGateway, String storageFrontendVlanName, String storageFrontSubnetPrefix, String storageBackendSpeed, String storageBackendProtocol, String storageBackendBondMode, String storageBackendPortNumber, String storageBackendIp, String storageBackendGateway, String storageBackendVlanName, String storageBackendSubnetPrefix, String iscsiSpeed, String iscsiProtocol, String iscsiBondMode, String iscsiPortNumber, String storageMediaType, String cacheMediaType, String mainStorageCapacity, String mainStorageQuantity, String cacheStorageCapacity, String cacheStorageQuantity, List<NetworkPlatform> storageFrontendMultiIps, List<NetworkPlatform> storageBackendMultiIps, List<NetworkPlatform> storageCtrlNetworks, List<NetworkPlatform> iscsiIps) {
        this.clusterName = clusterName;
        this.floatingIpAddress = floatingIpAddress;
        this.serviceTypeGenera = serviceTypeGenera;
        this.productionVersion = productionVersion;
        this.nodeModel = nodeModel;
        this.nodeName = nodeName;
        this.storagePool = storagePool;
        this.storagePoolId = storagePoolId;
        this.diskPoolName = diskPoolName;
        this.diskPoolId = diskPoolId;
        this.cabinet = cabinet;
        this.role = role;
        this.bmcIp = bmcIp;
        this.bmcGateway = bmcGateway;
        this.bmcVlan = bmcVlan;
        this.managementInternalIp = managementInternalIp;
        this.managementGateway = managementGateway;
        this.managementSubnetPrefix = managementSubnetPrefix;
        this.storageFrontendSpeed = storageFrontendSpeed;
        this.storageFrontendProtocol = storageFrontendProtocol;
        this.storageFrontendBondMode = storageFrontendBondMode;
        this.storageFrontendPortNumber = storageFrontendPortNumber;
        this.storageFrontendIp = storageFrontendIp;
        this.storageFrontendGateway = storageFrontendGateway;
        this.storageFrontendVlanName = storageFrontendVlanName;
        this.storageFrontSubnetPrefix = storageFrontSubnetPrefix;
        this.storageBackendSpeed = storageBackendSpeed;
        this.storageBackendProtocol = storageBackendProtocol;
        this.storageBackendBondMode = storageBackendBondMode;
        this.storageBackendPortNumber = storageBackendPortNumber;
        this.storageBackendIp = storageBackendIp;
        this.storageBackendGateway = storageBackendGateway;
        this.storageBackendVlanName = storageBackendVlanName;
        this.storageBackendSubnetPrefix = storageBackendSubnetPrefix;
        this.iscsiSpeed = iscsiSpeed;
        this.iscsiProtocol = iscsiProtocol;
        this.iscsiBondMode = iscsiBondMode;
        this.iscsiPortNumber = iscsiPortNumber;
        this.storageMediaType = storageMediaType;
        this.cacheMediaType = cacheMediaType;
        this.mainStorageCapacity = mainStorageCapacity;
        this.mainStorageQuantity = mainStorageQuantity;
        this.cacheStorageCapacity = cacheStorageCapacity;
        this.cacheStorageQuantity = cacheStorageQuantity;
        this.storageFrontendMultiIps = storageFrontendMultiIps;
        this.storageBackendMultiIps = storageBackendMultiIps;
        this.storageCtrlNetworks = storageCtrlNetworks;
        this.iscsiIps = iscsiIps;
    }

    public static LldInfoBuilder builder() {
        return new LldInfoBuilder();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setFloatingIpAddress(String floatingIpAddress) {
        this.floatingIpAddress = floatingIpAddress;
    }

    public void setServiceTypeGenera(String serviceTypeGenera) {
        this.serviceTypeGenera = serviceTypeGenera;
    }

    public void setProductionVersion(String productionVersion) {
        this.productionVersion = productionVersion;
    }

    public void setNodeModel(String nodeModel) {
        this.nodeModel = nodeModel;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setStoragePool(String storagePool) {
        this.storagePool = storagePool;
    }

    public void setStoragePoolId(String storagePoolId) {
        this.storagePoolId = storagePoolId;
    }

    public void setDiskPoolName(String diskPoolName) {
        this.diskPoolName = diskPoolName;
    }

    public void setDiskPoolId(String diskPoolId) {
        this.diskPoolId = diskPoolId;
    }

    public void setCabinet(String cabinet) {
        this.cabinet = cabinet;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setBmcIp(String bmcIp) {
        this.bmcIp = bmcIp;
    }

    public void setBmcGateway(String bmcGateway) {
        this.bmcGateway = bmcGateway;
    }

    public void setBmcVlan(String bmcVlan) {
        this.bmcVlan = bmcVlan;
    }

    public void setManagementInternalIp(String managementInternalIp) {
        this.managementInternalIp = managementInternalIp;
    }

    public void setManagementGateway(String managementGateway) {
        this.managementGateway = managementGateway;
    }

    public void setManagementSubnetPrefix(String managementSubnetPrefix) {
        this.managementSubnetPrefix = managementSubnetPrefix;
    }

    public void setStorageFrontendSpeed(String storageFrontendSpeed) {
        this.storageFrontendSpeed = storageFrontendSpeed;
    }

    public void setStorageFrontendProtocol(String storageFrontendProtocol) {
        this.storageFrontendProtocol = storageFrontendProtocol;
    }

    public void setStorageFrontendBondMode(String storageFrontendBondMode) {
        this.storageFrontendBondMode = storageFrontendBondMode;
    }

    public void setStorageFrontendPortNumber(String storageFrontendPortNumber) {
        this.storageFrontendPortNumber = storageFrontendPortNumber;
    }

    public void setStorageFrontendIp(String storageFrontendIp) {
        this.storageFrontendIp = storageFrontendIp;
    }

    public void setStorageFrontendGateway(String storageFrontendGateway) {
        this.storageFrontendGateway = storageFrontendGateway;
    }

    public void setStorageFrontendVlanName(String storageFrontendVlanName) {
        this.storageFrontendVlanName = storageFrontendVlanName;
    }

    public void setStorageFrontSubnetPrefix(String storageFrontSubnetPrefix) {
        this.storageFrontSubnetPrefix = storageFrontSubnetPrefix;
    }

    public void setStorageBackendSpeed(String storageBackendSpeed) {
        this.storageBackendSpeed = storageBackendSpeed;
    }

    public void setStorageBackendProtocol(String storageBackendProtocol) {
        this.storageBackendProtocol = storageBackendProtocol;
    }

    public void setStorageBackendBondMode(String storageBackendBondMode) {
        this.storageBackendBondMode = storageBackendBondMode;
    }

    public void setStorageBackendPortNumber(String storageBackendPortNumber) {
        this.storageBackendPortNumber = storageBackendPortNumber;
    }

    public void setStorageBackendIp(String storageBackendIp) {
        this.storageBackendIp = storageBackendIp;
    }

    public void setStorageBackendGateway(String storageBackendGateway) {
        this.storageBackendGateway = storageBackendGateway;
    }

    public void setStorageBackendVlanName(String storageBackendVlanName) {
        this.storageBackendVlanName = storageBackendVlanName;
    }

    public void setStorageBackendSubnetPrefix(String storageBackendSubnetPrefix) {
        this.storageBackendSubnetPrefix = storageBackendSubnetPrefix;
    }

    public void setIscsiSpeed(String iscsiSpeed) {
        this.iscsiSpeed = iscsiSpeed;
    }

    public void setIscsiProtocol(String iscsiProtocol) {
        this.iscsiProtocol = iscsiProtocol;
    }

    public void setIscsiBondMode(String iscsiBondMode) {
        this.iscsiBondMode = iscsiBondMode;
    }

    public void setIscsiPortNumber(String iscsiPortNumber) {
        this.iscsiPortNumber = iscsiPortNumber;
    }

    public void setStorageMediaType(String storageMediaType) {
        this.storageMediaType = storageMediaType;
    }

    public void setCacheMediaType(String cacheMediaType) {
        this.cacheMediaType = cacheMediaType;
    }

    public void setMainStorageCapacity(String mainStorageCapacity) {
        this.mainStorageCapacity = mainStorageCapacity;
    }

    public void setMainStorageQuantity(String mainStorageQuantity) {
        this.mainStorageQuantity = mainStorageQuantity;
    }

    public void setCacheStorageCapacity(String cacheStorageCapacity) {
        this.cacheStorageCapacity = cacheStorageCapacity;
    }

    public void setCacheStorageQuantity(String cacheStorageQuantity) {
        this.cacheStorageQuantity = cacheStorageQuantity;
    }

    public void setStorageFrontendMultiIps(List<NetworkPlatform> storageFrontendMultiIps) {
        this.storageFrontendMultiIps = storageFrontendMultiIps;
    }

    public void setStorageBackendMultiIps(List<NetworkPlatform> storageBackendMultiIps) {
        this.storageBackendMultiIps = storageBackendMultiIps;
    }

    public void setStorageCtrlNetworks(List<NetworkPlatform> storageCtrlNetworks) {
        this.storageCtrlNetworks = storageCtrlNetworks;
    }

    public void setIscsiIps(List<NetworkPlatform> iscsiIps) {
        this.iscsiIps = iscsiIps;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getFloatingIpAddress() {
        return this.floatingIpAddress;
    }

    public String getServiceTypeGenera() {
        return this.serviceTypeGenera;
    }

    public String getProductionVersion() {
        return this.productionVersion;
    }

    public String getNodeModel() {
        return this.nodeModel;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public String getStoragePoolId() {
        return this.storagePoolId;
    }

    public String getDiskPoolName() {
        return this.diskPoolName;
    }

    public String getDiskPoolId() {
        return this.diskPoolId;
    }

    public String getCabinet() {
        return this.cabinet;
    }

    public String getRole() {
        return this.role;
    }

    public String getBmcIp() {
        return this.bmcIp;
    }

    public String getBmcGateway() {
        return this.bmcGateway;
    }

    public String getBmcVlan() {
        return this.bmcVlan;
    }

    public String getManagementInternalIp() {
        return this.managementInternalIp;
    }

    public String getManagementGateway() {
        return this.managementGateway;
    }

    public String getManagementSubnetPrefix() {
        return this.managementSubnetPrefix;
    }

    public String getStorageFrontendSpeed() {
        return this.storageFrontendSpeed;
    }

    public String getStorageFrontendProtocol() {
        return this.storageFrontendProtocol;
    }

    public String getStorageFrontendBondMode() {
        return this.storageFrontendBondMode;
    }

    public String getStorageFrontendPortNumber() {
        return this.storageFrontendPortNumber;
    }

    public String getStorageFrontendIp() {
        return this.storageFrontendIp;
    }

    public String getStorageFrontendGateway() {
        return this.storageFrontendGateway;
    }

    public String getStorageFrontendVlanName() {
        return this.storageFrontendVlanName;
    }

    public String getStorageFrontSubnetPrefix() {
        return this.storageFrontSubnetPrefix;
    }

    public String getStorageBackendSpeed() {
        return this.storageBackendSpeed;
    }

    public String getStorageBackendProtocol() {
        return this.storageBackendProtocol;
    }

    public String getStorageBackendBondMode() {
        return this.storageBackendBondMode;
    }

    public String getStorageBackendPortNumber() {
        return this.storageBackendPortNumber;
    }

    public String getStorageBackendIp() {
        return this.storageBackendIp;
    }

    public String getStorageBackendGateway() {
        return this.storageBackendGateway;
    }

    public String getStorageBackendVlanName() {
        return this.storageBackendVlanName;
    }

    public String getStorageBackendSubnetPrefix() {
        return this.storageBackendSubnetPrefix;
    }

    public String getIscsiSpeed() {
        return this.iscsiSpeed;
    }

    public String getIscsiProtocol() {
        return this.iscsiProtocol;
    }

    public String getIscsiBondMode() {
        return this.iscsiBondMode;
    }

    public String getIscsiPortNumber() {
        return this.iscsiPortNumber;
    }

    public String getStorageMediaType() {
        return this.storageMediaType;
    }

    public String getCacheMediaType() {
        return this.cacheMediaType;
    }

    public String getMainStorageCapacity() {
        return this.mainStorageCapacity;
    }

    public String getMainStorageQuantity() {
        return this.mainStorageQuantity;
    }

    public String getCacheStorageCapacity() {
        return this.cacheStorageCapacity;
    }

    public String getCacheStorageQuantity() {
        return this.cacheStorageQuantity;
    }

    public List<NetworkPlatform> getStorageFrontendMultiIps() {
        return this.storageFrontendMultiIps;
    }

    public List<NetworkPlatform> getStorageBackendMultiIps() {
        return this.storageBackendMultiIps;
    }

    public List<NetworkPlatform> getStorageCtrlNetworks() {
        return this.storageCtrlNetworks;
    }

    public List<NetworkPlatform> getIscsiIps() {
        return this.iscsiIps;
    }

    public static class LldInfoBuilder {
        private String clusterName;
        private String floatingIpAddress;
        private String serviceTypeGenera;
        private String productionVersion;
        private String nodeModel;
        private String nodeName;
        private String storagePool;
        private String storagePoolId;
        private String diskPoolName;
        private String diskPoolId;
        private String cabinet;
        private String role;
        private String bmcIp;
        private String bmcGateway;
        private String bmcVlan;
        private String managementInternalIp;
        private String managementGateway;
        private String managementSubnetPrefix;
        private String storageFrontendSpeed;
        private String storageFrontendProtocol;
        private String storageFrontendBondMode;
        private String storageFrontendPortNumber;
        private String storageFrontendIp;
        private String storageFrontendGateway;
        private String storageFrontendVlanName;
        private String storageFrontSubnetPrefix;
        private String storageBackendSpeed;
        private String storageBackendProtocol;
        private String storageBackendBondMode;
        private String storageBackendPortNumber;
        private String storageBackendIp;
        private String storageBackendGateway;
        private String storageBackendVlanName;
        private String storageBackendSubnetPrefix;
        private String iscsiSpeed;
        private String iscsiProtocol;
        private String iscsiBondMode;
        private String iscsiPortNumber;
        private String storageMediaType;
        private String cacheMediaType;
        private String mainStorageCapacity;
        private String mainStorageQuantity;
        private String cacheStorageCapacity;
        private String cacheStorageQuantity;
        private List<NetworkPlatform> storageFrontendMultiIps;
        private List<NetworkPlatform> storageBackendMultiIps;
        private List<NetworkPlatform> storageCtrlNetworks;
        private List<NetworkPlatform> iscsiIps;

        LldInfoBuilder() {
        }

        public LldInfoBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public LldInfoBuilder floatingIpAddress(String floatingIpAddress) {
            this.floatingIpAddress = floatingIpAddress;
            return this;
        }

        public LldInfoBuilder serviceTypeGenera(String serviceTypeGenera) {
            this.serviceTypeGenera = serviceTypeGenera;
            return this;
        }

        public LldInfoBuilder productionVersion(String productionVersion) {
            this.productionVersion = productionVersion;
            return this;
        }

        public LldInfoBuilder nodeModel(String nodeModel) {
            this.nodeModel = nodeModel;
            return this;
        }

        public LldInfoBuilder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public LldInfoBuilder storagePool(String storagePool) {
            this.storagePool = storagePool;
            return this;
        }

        public LldInfoBuilder storagePoolId(String storagePoolId) {
            this.storagePoolId = storagePoolId;
            return this;
        }

        public LldInfoBuilder diskPoolName(String diskPoolName) {
            this.diskPoolName = diskPoolName;
            return this;
        }

        public LldInfoBuilder diskPoolId(String diskPoolId) {
            this.diskPoolId = diskPoolId;
            return this;
        }

        public LldInfoBuilder cabinet(String cabinet) {
            this.cabinet = cabinet;
            return this;
        }

        public LldInfoBuilder role(String role) {
            this.role = role;
            return this;
        }

        public LldInfoBuilder bmcIp(String bmcIp) {
            this.bmcIp = bmcIp;
            return this;
        }

        public LldInfoBuilder bmcGateway(String bmcGateway) {
            this.bmcGateway = bmcGateway;
            return this;
        }

        public LldInfoBuilder bmcVlan(String bmcVlan) {
            this.bmcVlan = bmcVlan;
            return this;
        }

        public LldInfoBuilder managementInternalIp(String managementInternalIp) {
            this.managementInternalIp = managementInternalIp;
            return this;
        }

        public LldInfoBuilder managementGateway(String managementGateway) {
            this.managementGateway = managementGateway;
            return this;
        }

        public LldInfoBuilder managementSubnetPrefix(String managementSubnetPrefix) {
            this.managementSubnetPrefix = managementSubnetPrefix;
            return this;
        }

        public LldInfoBuilder storageFrontendSpeed(String storageFrontendSpeed) {
            this.storageFrontendSpeed = storageFrontendSpeed;
            return this;
        }

        public LldInfoBuilder storageFrontendProtocol(String storageFrontendProtocol) {
            this.storageFrontendProtocol = storageFrontendProtocol;
            return this;
        }

        public LldInfoBuilder storageFrontendBondMode(String storageFrontendBondMode) {
            this.storageFrontendBondMode = storageFrontendBondMode;
            return this;
        }

        public LldInfoBuilder storageFrontendPortNumber(String storageFrontendPortNumber) {
            this.storageFrontendPortNumber = storageFrontendPortNumber;
            return this;
        }

        public LldInfoBuilder storageFrontendIp(String storageFrontendIp) {
            this.storageFrontendIp = storageFrontendIp;
            return this;
        }

        public LldInfoBuilder storageFrontendGateway(String storageFrontendGateway) {
            this.storageFrontendGateway = storageFrontendGateway;
            return this;
        }

        public LldInfoBuilder storageFrontendVlanName(String storageFrontendVlanName) {
            this.storageFrontendVlanName = storageFrontendVlanName;
            return this;
        }

        public LldInfoBuilder storageFrontSubnetPrefix(String storageFrontSubnetPrefix) {
            this.storageFrontSubnetPrefix = storageFrontSubnetPrefix;
            return this;
        }

        public LldInfoBuilder storageBackendSpeed(String storageBackendSpeed) {
            this.storageBackendSpeed = storageBackendSpeed;
            return this;
        }

        public LldInfoBuilder storageBackendProtocol(String storageBackendProtocol) {
            this.storageBackendProtocol = storageBackendProtocol;
            return this;
        }

        public LldInfoBuilder storageBackendBondMode(String storageBackendBondMode) {
            this.storageBackendBondMode = storageBackendBondMode;
            return this;
        }

        public LldInfoBuilder storageBackendPortNumber(String storageBackendPortNumber) {
            this.storageBackendPortNumber = storageBackendPortNumber;
            return this;
        }

        public LldInfoBuilder storageBackendIp(String storageBackendIp) {
            this.storageBackendIp = storageBackendIp;
            return this;
        }

        public LldInfoBuilder storageBackendGateway(String storageBackendGateway) {
            this.storageBackendGateway = storageBackendGateway;
            return this;
        }

        public LldInfoBuilder storageBackendVlanName(String storageBackendVlanName) {
            this.storageBackendVlanName = storageBackendVlanName;
            return this;
        }

        public LldInfoBuilder storageBackendSubnetPrefix(String storageBackendSubnetPrefix) {
            this.storageBackendSubnetPrefix = storageBackendSubnetPrefix;
            return this;
        }

        public LldInfoBuilder iscsiSpeed(String iscsiSpeed) {
            this.iscsiSpeed = iscsiSpeed;
            return this;
        }

        public LldInfoBuilder iscsiProtocol(String iscsiProtocol) {
            this.iscsiProtocol = iscsiProtocol;
            return this;
        }

        public LldInfoBuilder iscsiBondMode(String iscsiBondMode) {
            this.iscsiBondMode = iscsiBondMode;
            return this;
        }

        public LldInfoBuilder iscsiPortNumber(String iscsiPortNumber) {
            this.iscsiPortNumber = iscsiPortNumber;
            return this;
        }

        public LldInfoBuilder storageMediaType(String storageMediaType) {
            this.storageMediaType = storageMediaType;
            return this;
        }

        public LldInfoBuilder cacheMediaType(String cacheMediaType) {
            this.cacheMediaType = cacheMediaType;
            return this;
        }

        public LldInfoBuilder mainStorageCapacity(String mainStorageCapacity) {
            this.mainStorageCapacity = mainStorageCapacity;
            return this;
        }

        public LldInfoBuilder mainStorageQuantity(String mainStorageQuantity) {
            this.mainStorageQuantity = mainStorageQuantity;
            return this;
        }

        public LldInfoBuilder cacheStorageCapacity(String cacheStorageCapacity) {
            this.cacheStorageCapacity = cacheStorageCapacity;
            return this;
        }

        public LldInfoBuilder cacheStorageQuantity(String cacheStorageQuantity) {
            this.cacheStorageQuantity = cacheStorageQuantity;
            return this;
        }

        public LldInfoBuilder storageFrontendMultiIps(List<NetworkPlatform> storageFrontendMultiIps) {
            this.storageFrontendMultiIps = storageFrontendMultiIps;
            return this;
        }

        public LldInfoBuilder storageBackendMultiIps(List<NetworkPlatform> storageBackendMultiIps) {
            this.storageBackendMultiIps = storageBackendMultiIps;
            return this;
        }

        public LldInfoBuilder storageCtrlNetworks(List<NetworkPlatform> storageCtrlNetworks) {
            this.storageCtrlNetworks = storageCtrlNetworks;
            return this;
        }

        public LldInfoBuilder iscsiIps(List<NetworkPlatform> iscsiIps) {
            this.iscsiIps = iscsiIps;
            return this;
        }

        public LldInfo build() {
            return new LldInfo(this.clusterName, this.floatingIpAddress, this.serviceTypeGenera, this.productionVersion, this.nodeModel, this.nodeName, this.storagePool, this.storagePoolId, this.diskPoolName, this.diskPoolId, this.cabinet, this.role, this.bmcIp, this.bmcGateway, this.bmcVlan, this.managementInternalIp, this.managementGateway, this.managementSubnetPrefix, this.storageFrontendSpeed, this.storageFrontendProtocol, this.storageFrontendBondMode, this.storageFrontendPortNumber, this.storageFrontendIp, this.storageFrontendGateway, this.storageFrontendVlanName, this.storageFrontSubnetPrefix, this.storageBackendSpeed, this.storageBackendProtocol, this.storageBackendBondMode, this.storageBackendPortNumber, this.storageBackendIp, this.storageBackendGateway, this.storageBackendVlanName, this.storageBackendSubnetPrefix, this.iscsiSpeed, this.iscsiProtocol, this.iscsiBondMode, this.iscsiPortNumber, this.storageMediaType, this.cacheMediaType, this.mainStorageCapacity, this.mainStorageQuantity, this.cacheStorageCapacity, this.cacheStorageQuantity, this.storageFrontendMultiIps, this.storageBackendMultiIps, this.storageCtrlNetworks, this.iscsiIps);
        }

        public String toString() {
            return "LldInfo.LldInfoBuilder(clusterName=" + this.clusterName + ", floatingIpAddress=" + this.floatingIpAddress + ", serviceTypeGenera=" + this.serviceTypeGenera + ", productionVersion=" + this.productionVersion + ", nodeModel=" + this.nodeModel + ", nodeName=" + this.nodeName + ", storagePool=" + this.storagePool + ", storagePoolId=" + this.storagePoolId + ", diskPoolName=" + this.diskPoolName + ", diskPoolId=" + this.diskPoolId + ", cabinet=" + this.cabinet + ", role=" + this.role + ", bmcIp=" + this.bmcIp + ", bmcGateway=" + this.bmcGateway + ", bmcVlan=" + this.bmcVlan + ", managementInternalIp=" + this.managementInternalIp + ", managementGateway=" + this.managementGateway + ", managementSubnetPrefix=" + this.managementSubnetPrefix + ", storageFrontendSpeed=" + this.storageFrontendSpeed + ", storageFrontendProtocol=" + this.storageFrontendProtocol + ", storageFrontendBondMode=" + this.storageFrontendBondMode + ", storageFrontendPortNumber=" + this.storageFrontendPortNumber + ", storageFrontendIp=" + this.storageFrontendIp + ", storageFrontendGateway=" + this.storageFrontendGateway + ", storageFrontendVlanName=" + this.storageFrontendVlanName + ", storageFrontSubnetPrefix=" + this.storageFrontSubnetPrefix + ", storageBackendSpeed=" + this.storageBackendSpeed + ", storageBackendProtocol=" + this.storageBackendProtocol + ", storageBackendBondMode=" + this.storageBackendBondMode + ", storageBackendPortNumber=" + this.storageBackendPortNumber + ", storageBackendIp=" + this.storageBackendIp + ", storageBackendGateway=" + this.storageBackendGateway + ", storageBackendVlanName=" + this.storageBackendVlanName + ", storageBackendSubnetPrefix=" + this.storageBackendSubnetPrefix + ", iscsiSpeed=" + this.iscsiSpeed + ", iscsiProtocol=" + this.iscsiProtocol + ", iscsiBondMode=" + this.iscsiBondMode + ", iscsiPortNumber=" + this.iscsiPortNumber + ", storageMediaType=" + this.storageMediaType + ", cacheMediaType=" + this.cacheMediaType + ", mainStorageCapacity=" + this.mainStorageCapacity + ", mainStorageQuantity=" + this.mainStorageQuantity + ", cacheStorageCapacity=" + this.cacheStorageCapacity + ", cacheStorageQuantity=" + this.cacheStorageQuantity + ", storageFrontendMultiIps=" + this.storageFrontendMultiIps + ", storageBackendMultiIps=" + this.storageBackendMultiIps + ", storageCtrlNetworks=" + this.storageCtrlNetworks + ", iscsiIps=" + this.iscsiIps + ")";
        }
    }
}

