/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.entity;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;

public enum NetWorkType {
    STORAGE_FRONTEND("storage_frontend", ResourceUtil.getString((String)"storage.front.end.plane")),
    STORAGE_BACKEND("storage_backend", ResourceUtil.getString((String)"storage.back.end.plane")),
    MANAGEMENT_INTERNAL("management_internal", "unknown"),
    STORAGE_CTRL_NETWORK("storage_ctrl_network", "unknown"),
    ISCSI("iscsi", "unknown");

    private final String networkType;
    private final String inputTableName;

    public static String getByType(String netWorkType) {
        return Arrays.stream(NetWorkType.values()).filter(type -> type.getNetworkType().equalsIgnoreCase(netWorkType)).findFirst().map(NetWorkType::getInputTableName).orElse("");
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public String getInputTableName() {
        return this.inputTableName;
    }

    private NetWorkType(String networkType, String inputTableName) {
        this.networkType = networkType;
        this.inputTableName = inputTableName;
    }
}

