/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Bond;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.IpAddress;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.IscsiNode;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.IscsiPortal;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetWorkType;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetworkPlatform;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.PhysicalPort;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Vlan;
import com.huawei.ism.tool.infocollect.util.NetworkUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo {
    private static final Logger log = LoggerFactory.getLogger(NodeInfo.class);
    private static final String STORAGE_NODE = "storage";
    private String clusterName;
    private String floatingIpAddress;
    private String serviceTypeGenera;
    private String productVersion;
    private String id;
    private String name;
    @JSONField(name="role")
    private List<String> roles = new ArrayList<String>();
    private String cabinet;
    private String managementInternalIp;
    @JSONField(name="ip_address_list")
    private List<IpAddress> ipAddresses = new ArrayList<IpAddress>();
    @JSONField(name="vlan_list")
    private List<Vlan> vlans = new ArrayList<Vlan>();
    @JSONField(name="bond_list")
    private List<Bond> bonds = new ArrayList<Bond>();
    @JSONField(name="physical_ports")
    private List<PhysicalPort> physicalPorts = new ArrayList<PhysicalPort>();
    private FusionStorStoragePool diskPool;
    private FusionStorStoragePool storagePool;
    private String bmcIp;
    private String model;
    private String mainStorageCapacity;
    private String mainStorageQuantity;
    private String cacheStorageCapacity;
    private String cacheStorageQuantity;
    private Map<NetWorkType, List<NetworkPlatform>> networkPlatformMap = new HashMap<NetWorkType, List<NetworkPlatform>>();

    @NotNull
    public String getRole() {
        return String.join((CharSequence)",", this.roles);
    }

    @NotNull
    public String getVlanName(NetWorkType netWorkType) {
        if (CollectionUtil.isEmpty(this.vlans)) {
            return "";
        }
        return this.getIpAddressByNetType(netWorkType).map(this::findMatchVlanName).orElse("");
    }

    private String findMatchVlanName(IpAddress ipAddress) {
        return this.vlans.stream().filter(vlan -> vlan.getVlanName().equals(ipAddress.getPortName())).findFirst().map(vlan -> String.valueOf(vlan.getVlanTag())).orElse("");
    }

    public Optional<IpAddress> getIpAddressByNetType(NetWorkType netWorkType) {
        return this.ipAddresses.stream().filter(ipAddress -> ipAddress.isNetWorkType(netWorkType)).findFirst();
    }

    public void buildNetworkPlatformMap(DevNode devNode) {
        this.networkPlatformMap.put(NetWorkType.STORAGE_FRONTEND, NetworkUtil.getStorageNetWorkPlatform(devNode, this, NetWorkType.STORAGE_FRONTEND));
        this.networkPlatformMap.put(NetWorkType.STORAGE_BACKEND, NetworkUtil.getStorageNetWorkPlatform(devNode, this, NetWorkType.STORAGE_BACKEND));
        this.networkPlatformMap.put(NetWorkType.ISCSI, NetworkUtil.getIscsiNetWorkPlatform(devNode, this, NetWorkType.ISCSI));
        this.networkPlatformMap.put(NetWorkType.STORAGE_CTRL_NETWORK, NetworkUtil.getStorageNetWorkPlatform(devNode, this, NetWorkType.STORAGE_CTRL_NETWORK));
    }

    public String getTransferProtocol(IpAddress ipAddress) {
        String portName = ipAddress.getPortName();
        if (StringUtils.isNULLStr((String)portName)) {
            return "";
        }
        return this.getVlans().stream().filter(vlan -> portName.equalsIgnoreCase(vlan.getVlanName())).findFirst().map(vlan -> vlan.getTransferProtocol(this)).orElse(this.getTransferFromBonds(portName));
    }

    private String getTransferFromBonds(String portName) {
        return this.getBonds().stream().filter(bond -> portName.equalsIgnoreCase(bond.getBondName())).findFirst().map(bond -> bond.getTransferProtocol(this)).orElse(this.getTransferProtocolFromPhysicalPorts(portName));
    }

    public String getTransferProtocolFromPhysicalPorts(String portName) {
        return this.getPhysicalPorts().stream().filter(physiclPort -> portName.equalsIgnoreCase(physiclPort.getPortName())).findFirst().map(PhysicalPort::getTransferProtocol).orElse("");
    }

    public String getBondModeByPortName(String portName) {
        if (StringUtils.isNULLStr((String)portName)) {
            return "";
        }
        return this.getBonds().stream().filter(bond -> portName.equals(bond.getBondName())).findFirst().map(Bond::getBondMode).orElse("");
    }

    public List<IpAddress> getIpAddressByIscsiNode(IscsiNode iscsiNode) {
        if (StringUtils.isNULLStr((String)this.managementInternalIp)) {
            log.warn("managerIp is null");
            return Collections.emptyList();
        }
        List<String> iscsiPortals = this.findIscsiPortal(this.managementInternalIp, iscsiNode);
        return this.findIpAddress(this, iscsiPortals);
    }

    private List<IpAddress> findIpAddress(NodeInfo nodeInfo, List<String> iscsiPortal) {
        return iscsiPortal.stream().map(iscsi -> this.getIpAddressByIscsiPortal(nodeInfo, (String)iscsi)).collect(Collectors.toList());
    }

    private IpAddress getIpAddressByIscsiPortal(NodeInfo nodeInfo, String iscsiPortal) {
        return nodeInfo.getIpAddresses().stream().filter(ipAddress -> iscsiPortal.contains(ipAddress.getIpAddress())).findFirst().orElse(new IpAddress());
    }

    private List<String> findIscsiPortal(String managerIp, IscsiNode iscsiNode) {
        return iscsiNode.getIscsiNodes().stream().filter(IscsiNode::isSuccess).filter(IscsiNode::isIscsiStatusOn).filter(iscsi -> managerIp.equalsIgnoreCase(iscsi.getNodeMgrIp())).findFirst().map(IscsiNode::getIscsiPortals).map(portals -> portals.stream().map(IscsiPortal::getIscsiPortal)).map(stream -> stream.collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public boolean isStorageNode() {
        return this.roles.stream().anyMatch(nodeRole -> nodeRole.equalsIgnoreCase(STORAGE_NODE));
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setFloatingIpAddress(String floatingIpAddress) {
        this.floatingIpAddress = floatingIpAddress;
    }

    public void setServiceTypeGenera(String serviceTypeGenera) {
        this.serviceTypeGenera = serviceTypeGenera;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setCabinet(String cabinet) {
        this.cabinet = cabinet;
    }

    public void setManagementInternalIp(String managementInternalIp) {
        this.managementInternalIp = managementInternalIp;
    }

    public void setIpAddresses(List<IpAddress> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public void setVlans(List<Vlan> vlans) {
        this.vlans = vlans;
    }

    public void setBonds(List<Bond> bonds) {
        this.bonds = bonds;
    }

    public void setPhysicalPorts(List<PhysicalPort> physicalPorts) {
        this.physicalPorts = physicalPorts;
    }

    public void setDiskPool(FusionStorStoragePool diskPool) {
        this.diskPool = diskPool;
    }

    public void setStoragePool(FusionStorStoragePool storagePool) {
        this.storagePool = storagePool;
    }

    public void setBmcIp(String bmcIp) {
        this.bmcIp = bmcIp;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMainStorageCapacity(String mainStorageCapacity) {
        this.mainStorageCapacity = mainStorageCapacity;
    }

    public void setMainStorageQuantity(String mainStorageQuantity) {
        this.mainStorageQuantity = mainStorageQuantity;
    }

    public void setCacheStorageCapacity(String cacheStorageCapacity) {
        this.cacheStorageCapacity = cacheStorageCapacity;
    }

    public void setCacheStorageQuantity(String cacheStorageQuantity) {
        this.cacheStorageQuantity = cacheStorageQuantity;
    }

    public void setNetworkPlatformMap(Map<NetWorkType, List<NetworkPlatform>> networkPlatformMap) {
        this.networkPlatformMap = networkPlatformMap;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getFloatingIpAddress() {
        return this.floatingIpAddress;
    }

    public String getServiceTypeGenera() {
        return this.serviceTypeGenera;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getCabinet() {
        return this.cabinet;
    }

    public String getManagementInternalIp() {
        return this.managementInternalIp;
    }

    public List<IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public List<Vlan> getVlans() {
        return this.vlans;
    }

    public List<Bond> getBonds() {
        return this.bonds;
    }

    public List<PhysicalPort> getPhysicalPorts() {
        return this.physicalPorts;
    }

    public FusionStorStoragePool getDiskPool() {
        return this.diskPool;
    }

    public FusionStorStoragePool getStoragePool() {
        return this.storagePool;
    }

    public String getBmcIp() {
        return this.bmcIp;
    }

    public String getModel() {
        return this.model;
    }

    public String getMainStorageCapacity() {
        return this.mainStorageCapacity;
    }

    public String getMainStorageQuantity() {
        return this.mainStorageQuantity;
    }

    public String getCacheStorageCapacity() {
        return this.cacheStorageCapacity;
    }

    public String getCacheStorageQuantity() {
        return this.cacheStorageQuantity;
    }

    public Map<NetWorkType, List<NetworkPlatform>> getNetworkPlatformMap() {
        return this.networkPlatformMap;
    }
}

