/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.entity;

import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Cluster;
import com.huawei.ism.tool.infocollect.service.logic.lld.service.ClusterInfoService;
import com.huawei.ism.tool.infocollect.service.logic.lld.service.ClusterNodeService;
import com.huawei.ism.tool.infocollect.service.logic.lld.tools.ExportLldExcelUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeQueryTask {
    private static final Logger log = LoggerFactory.getLogger(NodeQueryTask.class);
    private DevNode devNode;
    private String resultDir;

    public boolean execute() {
        try {
            Optional<Cluster> cluster = ClusterInfoService.queryClusterInfo(this.devNode);
            if (!cluster.isPresent()) {
                boolean bl = false;
                return bl;
            }
            ClusterNodeService.getInstance().setPools2Nodes(this.devNode, cluster.get().getClusterNodeInfos());
            boolean bl = ExportLldExcelUtil.export2LldExcel(cluster.get(), this.resultDir);
            return bl;
        }
        catch (ToolException e) {
            log.error(e.getErrorLocaleDescription());
        }
        catch (IOException e) {
            log.error("Failed to parse the node information.", (Throwable)e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)this.devNode);
        }
        return false;
    }

    public NodeQueryTask(DevNode devNode, String resultDir) {
        this.devNode = devNode;
        this.resultDir = resultDir;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setResultDir(String resultDir) {
        this.resultDir = resultDir;
    }
}

