/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.entity;

import com.huawei.ism.tool.infocollect.service.logic.lld.entity.SheetTable;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.StoragePoolInfo;
import java.util.Arrays;
import java.util.List;

public class StoragePoolSheetInfo
implements SheetTable {
    private String poolName;
    private String poolId;
    private String encryptType;
    private String securityLevel;
    private String redundancyPolicy;
    private String replicationFactor;
    private String numDataUnits;
    private String numParityUnits;
    private String poolNodeNum;

    @Override
    public List<String> getPropertyValues() {
        return Arrays.asList(this.getPoolName(), this.getPoolId(), this.getPoolNodeNum(), this.getSecurityLevel(), this.getEncryptType(), this.getRedundancyPolicy(), this.getReplicationFactor(), this.getNumDataUnits(), this.getNumParityUnits());
    }

    public static StoragePoolSheetInfo trans2StoragePoolSheetInfo(StoragePoolInfo storagePoolInfo) {
        return StoragePoolSheetInfo.builder().poolName(storagePoolInfo.getPoolName()).poolId(storagePoolInfo.getPoolId()).poolNodeNum(StoragePoolSheetInfo.processingNumbers(storagePoolInfo.getPoolNodeNum())).securityLevel(storagePoolInfo.getSecurityLevel()).encryptType(storagePoolInfo.getEncryptType()).redundancyPolicy(storagePoolInfo.getRedundancyPolicy()).replicationFactor(StoragePoolSheetInfo.processingNumbers(storagePoolInfo.getReplicationFactor())).numDataUnits(StoragePoolSheetInfo.processingNumbers(storagePoolInfo.getNumDataUnits())).numParityUnits(StoragePoolSheetInfo.processingNumbers(storagePoolInfo.getNumParityUnits())).build();
    }

    private static String processingNumbers(int num) {
        return num == 0 ? "" : String.valueOf(num);
    }

    StoragePoolSheetInfo(String poolName, String poolId, String encryptType, String securityLevel, String redundancyPolicy, String replicationFactor, String numDataUnits, String numParityUnits, String poolNodeNum) {
        this.poolName = poolName;
        this.poolId = poolId;
        this.encryptType = encryptType;
        this.securityLevel = securityLevel;
        this.redundancyPolicy = redundancyPolicy;
        this.replicationFactor = replicationFactor;
        this.numDataUnits = numDataUnits;
        this.numParityUnits = numParityUnits;
        this.poolNodeNum = poolNodeNum;
    }

    public static StoragePoolSheetInfoBuilder builder() {
        return new StoragePoolSheetInfoBuilder();
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public String getEncryptType() {
        return this.encryptType;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public String getRedundancyPolicy() {
        return this.redundancyPolicy;
    }

    public String getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getNumDataUnits() {
        return this.numDataUnits;
    }

    public String getNumParityUnits() {
        return this.numParityUnits;
    }

    public String getPoolNodeNum() {
        return this.poolNodeNum;
    }

    public static class StoragePoolSheetInfoBuilder {
        private String poolName;
        private String poolId;
        private String encryptType;
        private String securityLevel;
        private String redundancyPolicy;
        private String replicationFactor;
        private String numDataUnits;
        private String numParityUnits;
        private String poolNodeNum;

        StoragePoolSheetInfoBuilder() {
        }

        public StoragePoolSheetInfoBuilder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public StoragePoolSheetInfoBuilder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public StoragePoolSheetInfoBuilder encryptType(String encryptType) {
            this.encryptType = encryptType;
            return this;
        }

        public StoragePoolSheetInfoBuilder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        public StoragePoolSheetInfoBuilder redundancyPolicy(String redundancyPolicy) {
            this.redundancyPolicy = redundancyPolicy;
            return this;
        }

        public StoragePoolSheetInfoBuilder replicationFactor(String replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public StoragePoolSheetInfoBuilder numDataUnits(String numDataUnits) {
            this.numDataUnits = numDataUnits;
            return this;
        }

        public StoragePoolSheetInfoBuilder numParityUnits(String numParityUnits) {
            this.numParityUnits = numParityUnits;
            return this;
        }

        public StoragePoolSheetInfoBuilder poolNodeNum(String poolNodeNum) {
            this.poolNodeNum = poolNodeNum;
            return this;
        }

        public StoragePoolSheetInfo build() {
            return new StoragePoolSheetInfo(this.poolName, this.poolId, this.encryptType, this.securityLevel, this.redundancyPolicy, this.replicationFactor, this.numDataUnits, this.numParityUnits, this.poolNodeNum);
        }

        public String toString() {
            return "StoragePoolSheetInfo.StoragePoolSheetInfoBuilder(poolName=" + this.poolName + ", poolId=" + this.poolId + ", encryptType=" + this.encryptType + ", securityLevel=" + this.securityLevel + ", redundancyPolicy=" + this.redundancyPolicy + ", replicationFactor=" + this.replicationFactor + ", numDataUnits=" + this.numDataUnits + ", numParityUnits=" + this.numParityUnits + ", poolNodeNum=" + this.poolNodeNum + ")";
        }
    }
}

