/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Cluster;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.DiskRoleEnum;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeStorageInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.StoragePoolInfo;
import com.huawei.ism.tool.infocollect.util.QueryInfoUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInfoService {
    private static final Logger log = LoggerFactory.getLogger(ClusterInfoService.class);
    private static final String DS_NETWORK_SERVICE_URI = "/api/v2/network_service/servers";
    private static final String NODE_STORAGE_DISK_INFO = "/dsware/service/resource/queryDiskInfo";
    private static final String STORAGE_STORAGE_POOL_INFO = "/dsware/service/resource/queryStoragePool";
    private static final String SUCCESS = "0";

    public static Optional<Cluster> queryClusterInfo(DevNode devNode) throws ToolException {
        try {
            Optional<Cluster> cluster = ClusterInfoService.getBaseCluster(devNode);
            if (cluster.isPresent()) {
                ClusterInfoService.intNodeInfo(devNode, cluster.get());
                ClusterInfoService.setDiskSize(devNode, cluster.get());
                ClusterInfoService.fillBmcAndDeviceInfo(cluster.get(), devNode);
                ClusterInfoService.setStoragePoolInfo(devNode, cluster.get());
            }
            return cluster;
        }
        catch (JSONException e) {
            log.error("An error occurred when parsing the JSON character string.");
            throw new ToolException("parse.content.error", (Throwable)e);
        }
        catch (ToolException e) {
            log.error("Connection exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("unknown error happened");
            throw new ToolException("parse.content.error", (Throwable)e);
        }
    }

    private static void setStoragePoolInfo(DevNode devNode, Cluster cluster) throws ToolException {
        ResponseInfo responseInfo = ClusterInfoService.queryStoragePoolInfo(devNode);
        cluster.setStoragePools(ClusterInfoService.parseStoragePoolResponse(responseInfo));
    }

    private static List<StoragePoolInfo> parseStoragePoolResponse(ResponseInfo responseInfo) {
        JSONObject jsonObject = JSON.parseObject((String)responseInfo.getContent());
        JSONArray storagePools = jsonObject.getJSONArray("storagePools");
        if (CollectionUtils.isEmpty((Collection)storagePools)) {
            return Collections.emptyList();
        }
        return storagePools.stream().map(JSON::toJSONString).map(storage -> (StoragePoolInfo)JSON.parseObject((String)storage, StoragePoolInfo.class)).collect(Collectors.toList());
    }

    private static ResponseInfo queryStoragePoolInfo(DevNode devNode) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (restConnection == null) {
            log.info("Failed to obtain the connection.");
            return new ResponseInfo();
        }
        String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
        return restConnection.execGet(baseUri + STORAGE_STORAGE_POOL_INFO);
    }

    private static void setDiskSize(DevNode devNode, Cluster cluster) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (restConnection == null) {
            log.info("Failed to obtain the connection.");
        }
        String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
        for (NodeInfo nodeInfo : cluster.getClusterNodeInfos()) {
            ClusterInfoService.queryNodeStorageCapacityInfo(restConnection, baseUri, nodeInfo);
        }
    }

    private static Optional<Cluster> getBaseCluster(DevNode devNode) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (restConnection == null) {
            log.info("Failed to obtain the connection.");
            return Optional.empty();
        }
        String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
        ResponseInfo responseInfo = restConnection.execPost(baseUri + DS_NETWORK_SERVICE_URI, new HashMap());
        return Optional.ofNullable(JSON.parseObject((String)responseInfo.getContent(), Cluster.class));
    }

    private static void intNodeInfo(DevNode devNode, Cluster cluster) throws ToolException {
        List<NodeInfo> clusterNodeInfos = cluster.getClusterNodeInfos();
        for (NodeInfo nodeInfo : clusterNodeInfos) {
            nodeInfo.setProductVersion(devNode.getProductVersion());
            nodeInfo.buildNetworkPlatformMap(devNode);
            nodeInfo.setFloatingIpAddress(devNode.getIp());
            nodeInfo.setServiceTypeGenera(QueryInfoUtil.queryDevServiceTypeInfo(devNode));
        }
    }

    private static void fillBmcAndDeviceInfo(Cluster cluster, DevNode devNode) {
        cluster.getClusterNodeInfos().forEach(clusterNode -> {
            clusterNode.setClusterName(devNode.getDeviceName());
            devNode.getClusterNodes().stream().filter(node1 -> clusterNode.getId().equals(Integer.toString(node1.getId()))).findFirst().ifPresent(value -> clusterNode.setBmcIp(value.getBmcIp()));
        });
    }

    public static void queryNodeStorageCapacityInfo(RestConnection restConnection, String baseUri, NodeInfo nodeInfo) {
        try {
            ClusterInfoService.queryNodeStorageInfo(restConnection, baseUri, nodeInfo.getManagementInternalIp()).filter(info -> SUCCESS.equals(info.getResult())).ifPresent(info -> ClusterInfoService.setDiskInfo(nodeInfo, info));
        }
        catch (JSONException e) {
            log.error("An error occurred when parsing the JSON character string.");
        }
        catch (ToolException e) {
            log.error("Connection exception", (Throwable)e);
        }
        catch (Exception e) {
            log.error("unknown error happened:{}", (Object)e.getMessage());
        }
    }

    private static void setDiskInfo(NodeInfo nodeInfo, NodeStorageInfo diskInfo) {
        nodeInfo.setMainStorageCapacity(diskInfo.getDiskSize(DiskRoleEnum.MAIN_STORAGE));
        nodeInfo.setMainStorageQuantity(diskInfo.getDiskQuantity(DiskRoleEnum.MAIN_STORAGE));
        nodeInfo.setCacheStorageCapacity(diskInfo.getDiskSize(DiskRoleEnum.CACHE_STORAGE));
        nodeInfo.setCacheStorageQuantity(diskInfo.getDiskQuantity(DiskRoleEnum.CACHE_STORAGE));
    }

    private static Optional<NodeStorageInfo> queryNodeStorageInfo(RestConnection restConnection, String baseUri, String managerIp) throws ToolException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("ip", managerIp);
        ResponseInfo responseInfo = restConnection.execGet(baseUri + NODE_STORAGE_DISK_INFO, param);
        return Optional.ofNullable(JSON.parseObject((String)responseInfo.getContent(), NodeStorageInfo.class));
    }

    private ClusterInfoService() {
    }
}

