/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeInfo;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.ism.tool.service.rest.query.NodePoolService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeService {
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeService.class);
    private static final ClusterNodeService INS = new ClusterNodeService();
    NodePoolService nodePoolService = new NodePoolService();

    public static synchronized ClusterNodeService getInstance() {
        return INS;
    }

    public void setPools2Nodes(DevNode devNode, List<NodeInfo> nodes) throws ToolException {
        Map<String, NodeInfo> ip2Node = this.parseNodeInfo(nodes);
        this.queryDiskPools(devNode).forEach(diskPool -> this.setDiskPool2Node(ip2Node, (FusionStorStoragePool)diskPool, devNode));
        this.queryStorPools(devNode).forEach(storPool -> this.setStorPool2Node(ip2Node, (FusionStorStoragePool)storPool, devNode));
    }

    private List<FusionStorStoragePool> queryDiskPools(DevNode devNode) throws ToolException {
        return DevInfoUtil.isSupportDiskPool((DevNode)devNode) ? this.getNodePoolService().queryPoolsBasicInfo(devNode) : Collections.emptyList();
    }

    private List<FusionStorStoragePool> queryStorPools(DevNode devNode) throws ToolException {
        return DevInfoUtil.isSupportDiskPool((DevNode)devNode) ? this.getNodePoolService().queryNodePool(devNode) : this.getNodePoolService().queryPoolsBasicInfo(devNode);
    }

    private void setDiskPool2Node(Map<String, NodeInfo> ip2Node, FusionStorStoragePool diskPool, DevNode devNode) {
        try {
            String response = this.getNodePoolService().getNodeDiskInfo(diskPool.getId(), devNode, true);
            this.getMatchNodeInfo(ip2Node, response).forEach(nodeInfo -> nodeInfo.setDiskPool(diskPool));
        }
        catch (ToolException e) {
            log.error("query disk pool node disk failed.", (Throwable)e);
        }
    }

    private void setStorPool2Node(Map<String, NodeInfo> ip2Node, FusionStorStoragePool storPool, DevNode devNode) {
        try {
            String response = this.getNodePoolService().getNodeDiskInfo(storPool.getId(), devNode, false);
            this.getMatchNodeInfo(ip2Node, response).forEach(nodeInfo -> nodeInfo.setStoragePool(storPool));
        }
        catch (ToolException e) {
            log.error("query stor pool node disk failed.", (Throwable)e);
        }
    }

    private List<NodeInfo> getMatchNodeInfo(Map<String, NodeInfo> ip2Node, String response) {
        JSONArray nodesFromPools = JSON.parseArray((String)response);
        return nodesFromPools.stream().filter(nodeObject -> nodeObject instanceof JSONObject).map(nodeObject -> (JSONObject)nodeObject).filter(this::isNormalNode).map(node -> (NodeInfo)ip2Node.get(node.getString("nodeMgrIp"))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean isNormalNode(Object devNode) {
        JSONObject nodeInfoObject = JSON.parseObject((String)JSON.toJSONString((Object)devNode));
        if (!"0".equals(nodeInfoObject.getString("errorCode"))) {
            log.info("Node query failed");
            return false;
        }
        return true;
    }

    private Map<String, NodeInfo> parseNodeInfo(List<NodeInfo> nodes) {
        if (CollectionUtil.isEmpty(nodes)) {
            return Collections.emptyMap();
        }
        return nodes.stream().collect(Collectors.toMap(NodeInfo::getManagementInternalIp, ele -> ele, (firstNode, secondNode) -> firstNode));
    }

    public NodePoolService getNodePoolService() {
        return this.nodePoolService;
    }
}

