/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.tools;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Cluster;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.LldInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.LldTableInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetWorkType;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetworkPlatform;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.SheetTable;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.StoragePoolSheetInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportLldExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportLldExcelUtil.class);
    public static final String TEMPLATE_FILE_PATH = "/config/template/" + ResourceUtil.getString((String)"lld.template");
    private static final int TABLE_LENGTH = 25;
    private static final int CONTROL_IP_LENGTH = 3;

    public static boolean export2LldExcel(Cluster cluster, String path) throws IOException {
        File target = new File(path);
        try {
            FileUtils.createFile((File)target);
            ExportLldExcelUtil.writeExcel(ExportLldExcelUtil.creatLldTableInfo(cluster), path);
        }
        catch (Exception e) {
            log.error("Failed to create the file.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static LldTableInfo creatLldTableInfo(Cluster cluster) {
        List<LldInfo> lldInfos = cluster.getClusterNodeInfos().stream().filter(NodeInfo::isStorageNode).map(LldInfo::trans2LLdInfo).collect(Collectors.toList());
        List<StoragePoolSheetInfo> storagePoolSheetInfos = cluster.getStoragePools().stream().map(StoragePoolSheetInfo::trans2StoragePoolSheetInfo).collect(Collectors.toList());
        LldTableInfo lldTableInfo = new LldTableInfo();
        lldTableInfo.setLldInfos(lldInfos);
        lldTableInfo.setStoragePools(storagePoolSheetInfos);
        return lldTableInfo;
    }

    public static void writeExcel(LldTableInfo lldTableInfo, String path) throws ToolException, IOException {
        try (InputStream files = ExportLldExcelUtil.class.getResourceAsStream(TEMPLATE_FILE_PATH);){
            if (files == null) {
                throw new ToolException("template file not exist");
            }
            try (HSSFWorkbook workbook = new HSSFWorkbook(files);
                 FileOutputStream fos = new FileOutputStream(path);){
                ExportLldExcelUtil.writeDistributedStorageLld(lldTableInfo.getLldInfos(), workbook);
                ExportLldExcelUtil.writeMultiIp(lldTableInfo.getLldInfos(), workbook);
                ExportLldExcelUtil.writeIscsi(lldTableInfo.getLldInfos(), workbook);
                ExportLldExcelUtil.writeStoraPoolInfo(lldTableInfo.getStoragePools(), workbook);
                workbook.write((OutputStream)fos);
            }
            catch (ToolException | IOException e) {
                log.error("write excel error");
                throw e;
            }
        }
    }

    private static void writeStoraPoolInfo(List<StoragePoolSheetInfo> storagePools, HSSFWorkbook workbook) {
        HSSFSheet distributedStorageLld = workbook.getSheet(ResourceUtil.getString((String)"infocollect.collect.storagePool"));
        if (distributedStorageLld == null) {
            log.error("An error occurred when obtaining the table Distributed Storage LLD");
            return;
        }
        for (int rowIndex = 0; rowIndex < storagePools.size(); ++rowIndex) {
            ExportLldExcelUtil.writeContentRow((Sheet)distributedStorageLld, rowIndex, storagePools.get(rowIndex));
        }
    }

    private static void writeDistributedStorageLld(List<LldInfo> lldInfos, HSSFWorkbook workbook) throws ToolException {
        HSSFSheet distributedStorageLld = workbook.getSheet(ResourceUtil.getString((String)"infocollect.collect.lld"));
        if (distributedStorageLld == null) {
            log.error("An error occurred when obtaining the table Distributed Storage LLD");
            return;
        }
        for (int rowIndex = 0; rowIndex < lldInfos.size(); ++rowIndex) {
            ExportLldExcelUtil.writeContentRow((Sheet)distributedStorageLld, rowIndex, lldInfos.get(rowIndex));
        }
    }

    private static void writeContentRow(Sheet sheet, int rowIndex, SheetTable lldInfo) {
        Row row = sheet.createRow(rowIndex + 1);
        ExportLldExcelUtil.writeCells(row, lldInfo);
    }

    private static void writeCells(Row row, SheetTable lldInfo) {
        List<String> cellValues = lldInfo.getPropertyValues();
        for (int cellIndex = 0; cellIndex < cellValues.size(); ++cellIndex) {
            ExportLldExcelUtil.createContentCell(row, cellIndex, cellValues.get(cellIndex));
        }
    }

    private static void createContentCell(Row row, int index, String value) {
        Cell cell = row.createCell(index);
        cell.setCellValue(value);
    }

    private static void writeMultiIp(List<LldInfo> lldInfos, HSSFWorkbook workbook) {
        HSSFSheet multiIpSheet = workbook.getSheet(ResourceUtil.getString((String)"infocollect.collect.multi.ip"));
        if (multiIpSheet == null) {
            log.error("An error occurred when obtaining the sheet Multi-IP Storage Network Config");
            return;
        }
        int startRowIndex = 2;
        for (LldInfo lldInfo : lldInfos) {
            startRowIndex = ExportLldExcelUtil.writeSingleClusterNodeMultiIpInfo((Sheet)multiIpSheet, startRowIndex, lldInfo);
        }
    }

    private static int writeSingleClusterNodeMultiIpInfo(Sheet multiIpSheet, int startRowIndex, LldInfo lldInfo) {
        List<String> storageBackendInfo;
        List<String> storageFrontendInfo = ExportLldExcelUtil.getMultIpInfos(lldInfo.getStorageFrontendMultiIps(), lldInfo.getStorageCtrlNetworks(), lldInfo.getBmcIp());
        int tempIndex = startRowIndex;
        if (!CollectionUtil.isEmpty(storageFrontendInfo)) {
            ExportLldExcelUtil.writeMultiIpRowInfo(multiIpSheet, tempIndex++, storageFrontendInfo);
        }
        if (!CollectionUtil.isEmpty(storageBackendInfo = ExportLldExcelUtil.getMultIpInfos(lldInfo.getStorageBackendMultiIps(), Collections.emptyList(), lldInfo.getBmcIp()))) {
            ExportLldExcelUtil.writeMultiIpRowInfo(multiIpSheet, tempIndex++, storageBackendInfo);
        }
        return tempIndex;
    }

    private static void writeMultiIpRowInfo(Sheet sheet, int rowIndex, List<String> netWorkPlatformInfo) {
        Row row = sheet.createRow(rowIndex);
        if (CollectionUtil.isEmpty(netWorkPlatformInfo)) {
            return;
        }
        for (int cellIndex = 0; cellIndex < netWorkPlatformInfo.size(); ++cellIndex) {
            ExportLldExcelUtil.createContentCell(row, cellIndex, netWorkPlatformInfo.get(cellIndex));
        }
    }

    private static void writeIscsi(List<LldInfo> lldInfos, HSSFWorkbook workbook) {
        HSSFSheet iscsiSheet = workbook.getSheet(ResourceUtil.getString((String)"infocollect.collect.iscsi"));
        if (iscsiSheet == null) {
            log.error("An error occurred when obtaining the sheet.");
            return;
        }
        int rowIndex = 2;
        for (LldInfo lldInfo : lldInfos) {
            List<String> iscsiInfo = ExportLldExcelUtil.getIscsiInfos(lldInfo.getIscsiIps(), lldInfo.getBmcIp());
            ExportLldExcelUtil.writeMultiIpRowInfo((Sheet)iscsiSheet, rowIndex, iscsiInfo);
            ++rowIndex;
        }
    }

    private static List<String> getMultIpInfos(List<NetworkPlatform> networkPlatforms, List<NetworkPlatform> storageCtrlNetworks, String bmcIp) {
        if (CollectionUtil.isEmpty(networkPlatforms)) {
            return Collections.emptyList();
        }
        ArrayList<String> multiInfos = new ArrayList<String>();
        multiInfos.add(bmcIp);
        multiInfos.add(NetWorkType.getByType(networkPlatforms.stream().findFirst().map(NetworkPlatform::getNetworkType).orElse("")));
        List netWorkInfo = networkPlatforms.stream().flatMap(ipInfo -> ExportLldExcelUtil.getNetWorkInfo(ipInfo).stream()).collect(Collectors.toList());
        multiInfos.addAll(netWorkInfo);
        if (CollectionUtil.isEmpty(storageCtrlNetworks)) {
            return multiInfos;
        }
        if (25 - multiInfos.size() > 3) {
            multiInfos.addAll(Arrays.asList(new String[25 - multiInfos.size() - 3]));
        }
        multiInfos.addAll(ExportLldExcelUtil.addControlParams(storageCtrlNetworks));
        return multiInfos;
    }

    private static List<String> getNetWorkInfo(NetworkPlatform networkPlatform) {
        return Arrays.asList(networkPlatform.getPortName(), networkPlatform.getVlan(), networkPlatform.getIpVersion(), networkPlatform.getIpAddress(), networkPlatform.getSubnetPrefix());
    }

    private static List<String> addControlParams(List<NetworkPlatform> networkPlatform) {
        return networkPlatform.stream().flatMap(netWorkInfo -> Stream.of(netWorkInfo.getIpAddress(), netWorkInfo.getSubnetPrefix(), netWorkInfo.getGateway())).collect(Collectors.toList());
    }

    private static List<String> getIscsiInfos(List<NetworkPlatform> networkPlatforms, String bmcIp) {
        if (CollectionUtil.isEmpty(networkPlatforms)) {
            return Collections.emptyList();
        }
        ArrayList<String> iscsiInfos = new ArrayList<String>();
        iscsiInfos.add(bmcIp);
        List netWorkInfo = networkPlatforms.stream().flatMap(ipInfo -> ExportLldExcelUtil.getNetWorkInfo(ipInfo).stream()).collect(Collectors.toList());
        iscsiInfos.addAll(netWorkInfo);
        return iscsiInfos;
    }

    private ExportLldExcelUtil() {
    }
}

