/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.service.logic.lld.tools;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.infocollect.util.DiskPDfUtils;
import com.huawei.ism.tool.infocollect.util.PdfInfo;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.python.modules.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportPdfUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportPdfUtil.class);

    public static String decompressDiskDestroyReport(String sourcePath) throws IOException {
        File sourceFile = new File(sourcePath);
        String diskDataErasureReportFile = ExportPdfUtil.getDiskDataErasureReportPath(sourceFile);
        try {
            if (!ExportPdfUtil.decompressInnermostFile(sourceFile, diskDataErasureReportFile)) {
                log.error("decompress innermost file fail");
            }
        }
        finally {
            FileUtils.deleteFile((File)sourceFile);
        }
        return diskDataErasureReportFile;
    }

    private static String getDiskDataErasureReportPath(File sourceFile) {
        String diskDataErasureReportPath = sourceFile.getParent() + File.separator + "disk_data_erasure_report";
        if (!new File(diskDataErasureReportPath).exists()) {
            FileUtils.createDir((String)diskDataErasureReportPath);
        }
        return diskDataErasureReportPath + File.separator + "data_erasure_report.csv";
    }

    private static boolean decompressInnermostFile(File sourceFile, String targetPath) throws IOException {
        if (!sourceFile.exists()) {
            log.error("decompress innermost file: file not exist");
            return false;
        }
        if (sourceFile.isDirectory()) {
            File[] sourceFileList = sourceFile.listFiles();
            if (sourceFileList == null || sourceFileList.length != 1) {
                log.error("decompress innermost file: number of files is not 1");
                return false;
            }
            return ExportPdfUtil.decompressInnermostFile(sourceFileList[0], targetPath);
        }
        String fileName = sourceFile.getName();
        String tempPath = sourceFile.getParent() + File.separator + "temp";
        if (fileName.endsWith(".zip")) {
            ZipUtils.decompressFileForWindows((File)sourceFile, (String)tempPath);
            return ExportPdfUtil.decompressInnermostFile(new File(tempPath), targetPath);
        }
        if (fileName.endsWith(".tar") || fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
            ZipUtils.decompressTarGzFile((File)sourceFile, (String)tempPath);
            return ExportPdfUtil.decompressInnermostFile(new File(tempPath), targetPath);
        }
        return sourceFile.renameTo(new File(targetPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean parseDiskDataErasureReportAndGeneralPdf(String csvFile, DevNode devNode) {
        try (CSVParser csvParser = CSVParser.parse((File)new File(csvFile), (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]));){
            List<Map<String, String>> csvData = csvParser.getRecords().stream().map(CSVRecord::toMap).peek(ExportPdfUtil::repairDiskSn).collect(Collectors.toList());
            if (csvData.isEmpty()) {
                log.info("device:[{}] parse disk data erasure report result is empty", (Object)devNode.getIp());
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = ExportPdfUtil.generalPdf(csvData, csvFile, devNode);
            return bl;
        }
        catch (IOException e) {
            log.error("device:[{}] parse disk data erasure report fail:\n{}", (Object)devNode.getIp(), (Object)e);
            return false;
        }
    }

    private static void repairDiskSn(Map<String, String> singleData) {
        if (!singleData.containsKey("SN")) {
            return;
        }
        String updateSn = singleData.get("SN").replaceAll("=|\"", "");
        singleData.put("SN", updateSn);
    }

    public static boolean generalPdf(List<Map<String, String>> csvData, String csvFile, DevNode devNode) {
        String pdfFile = new File(csvFile).getParent() + File.separator + ResourceUtil.getString((String)"disk.data.erasure.report.name");
        PdfInfo pdfInfo = new PdfInfo();
        pdfInfo.setStorageName(devNode.getDeviceName());
        pdfInfo.setTime(Time.ctime().toString());
        pdfInfo.setStorageSerial(devNode.getDeviceSerialNumber());
        pdfInfo.setProductMode(devNode.getProductModel());
        pdfInfo.setProductVersion(devNode.getProductVersion());
        pdfInfo.setQuantityOfDisksErased(String.valueOf(csvData.size()));
        pdfInfo.getScreenshotContainsDisk().addAll(csvData);
        DiskPDfUtils diskPDfUtils = new DiskPDfUtils(pdfFile, pdfInfo, true);
        return diskPDfUtils.buildDiskPDf();
    }

    private ExportPdfUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

