/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicemanager.service.implement.BaseExecuter;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.HyperMetroDevTipsDialog;
import com.huawei.ism.tool.devicemanager.ui.listener.ConfirmAction;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectUtil;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.service.PreConditionServer;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCons;
import com.huawei.ism.tool.infocollect.service.callback.ReDetailListCallback;
import com.huawei.ism.tool.infocollect.service.logic.LoadingRunnable;
import com.huawei.ism.tool.infocollect.ui.CollectTaskAction;
import com.huawei.ism.tool.infocollect.ui.CreateEnvAdnSubmitDiskQryRunnable;
import com.huawei.ism.tool.infocollect.ui.DetailListerListener;
import com.huawei.ism.tool.infocollect.ui.ExploreButtonListener;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainLayout;
import com.huawei.ism.tool.infocollect.ui.ListMouseAdapter;
import com.huawei.ism.tool.infocollect.ui.ListSelectionModelListener;
import com.huawei.ism.tool.infocollect.ui.RefurbishRunnable;
import com.huawei.ism.tool.infocollect.ui.ShowPreCollectItem;
import com.huawei.ism.tool.infocollect.ui.SplitPakageDialog;
import com.huawei.ism.tool.infocollect.ui.main.DeviceAddListener;
import com.huawei.ism.tool.infocollect.ui.main.DirSetupButtonListener;
import com.huawei.ism.tool.infocollect.ui.main.DownLoadAction;
import com.huawei.ism.tool.infocollect.ui.main.ShowSupportProductListener;
import com.huawei.ism.tool.infocollect.ui.setup.ConfirmationWithSignDialog;
import com.huawei.ism.tool.infocollect.ui.setup.SetTaskThreadNumbersDialog;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboUtil;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.PackageA800Cluster;
import com.huawei.ism.tool.infocollect.ui.support.CollectMainWindowListener;
import com.huawei.ism.tool.infocollect.ui.support.CollectStatusCell;
import com.huawei.ism.tool.infocollect.ui.support.DeviceSetupIcon;
import com.huawei.ism.tool.infocollect.util.ApplyRange;
import com.huawei.ism.tool.infocollect.util.DeviceCliCommandCheckUtil;
import com.huawei.ism.tool.infocollect.util.FailedDevParser;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.infocollect.util.QueryUpgradeStates;
import com.huawei.ism.tool.infocollect.util.SceneDataExtendUtil;
import com.huawei.ism.tool.lifecycle.model.stm.StmReportMessage;
import com.huawei.ism.tool.lifecycle.util.StmReportUtil;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.CheckDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.ResultDevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.utils.ResourceUsageService;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InfoDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.RootPaneUI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class InfoCollectMainDialog
extends JDialog
implements ReDetailListCallback {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectMainDialog.class);
    private static final long serialVersionUID = 1L;
    private static final String ADD_TASK_SUCCE = "true";
    private static final String IP_SEPARATE = ", ";
    private static final String JSON_SCENE = "jsonScene";
    private static final String TROUBLE_SHOOTING = "Troubleshooting";
    private static final String CLI = "cli";
    private static final String RUNNING_DATA = "running_data";
    private static final String LOG = "log";
    private static final String ALL_LOG = "all_log";
    private static final String EVENT = "event";
    private static final String HAS_CONFIG_AND_EVENT = "two_item";
    private static final String DORADO_MIN_PRODUCT_VERSION = "6.1.6RC1";
    private static final String OCEAN_PROTEXT_MIN_PRODUCT_VERSION = "1.3.RC1";
    private static final String DORADO = "Dorado";
    private static final int MAX_SUBMIT_QRY_DISK_THREAD_POOL_SIZE = 25;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoCollectMainDialog.class);
    private static final String DOWN_FILE_SUCCESS = "true";
    private InfoCollectMainLayout infoCollectMainLayout = null;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private List<DevNode> supports = new ArrayList<DevNode>();
    private List<DevNode> faildDevNodes;
    private transient Map<String, Map<String, Thread>> threads = new HashMap<String, Map<String, Thread>>();

    public InfoCollectMainDialog(Window parent) {
        super(parent);
        this.initUI();
        this.addListener();
        this.daemonThread();
        CollectDataContext.getInstance().setInfoCollectMainDialog(this);
    }

    public void init() {
        try {
            InfoConfiguration.getInstance().init();
            FailedDevParser par = new FailedDevParser();
            this.faildDevNodes = par.getFailedDevNode();
            this.initData();
            this.initSelected();
            this.initUpgradeCheckSceneDevTargetVersion();
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("info collect dialog failed", (Throwable)e);
        }
    }

    private void initUI() {
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.infoCollectMainLayout = new InfoCollectMainLayout();
        this.setLayout(new BorderLayout());
        this.add(this.infoCollectMainLayout);
        this.setTitle(ResourceUtil.getString((String)"infocollect.enter.name"));
        this.setModal(true);
        this.setResizable(false);
        this.add(this.infoCollectMainLayout);
        this.setIconImage(ResourceUtil.getImage((String)"datacollect.png").getImage());
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initUpgradeCheckSceneDevTargetVersion() {
        if (!SceneUtils.isScene() || !SceneUtils.isPreUpgradeCheckSubScene()) {
            return;
        }
        List devsXML = SceneXmlData.getInstance().loadSceneFromFile();
        SceneDataSerialize dataOperate = new SceneDataSerialize();
        Map upgradeSettings = (Map)dataOperate.deserialize();
        Map<String, Map<String, String>> sceneDataExt = new SceneDataExtendUtil().parseSceneDataExt();
        if (null == upgradeSettings) {
            return;
        }
        if (null == devsXML || devsXML.isEmpty()) {
            LOGGER.error("dev xml is null or empty.");
            return;
        }
        for (com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode : devsXML) {
            String devSn = devNode.getDeviceSerialNumber();
            String key = devNode.getIp() + "_" + devSn;
            UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
            if (null == data) continue;
            CollectDataContext.getInstance().getUpgTgtVersionMap().put(devSn, data.getTargetVersion());
            Map<String, String> extendData = sceneDataExt.get(key);
            extendData.put("upgradeMode", data.getUpgradeMode());
            CollectDataContext.getInstance().getUpgExtendMap().put(devSn, extendData);
        }
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpActionCallBack) {
        this.rootPaneUI.setHelpActionCallBack(helpActionCallBack);
    }

    private void initData() {
        List<DevNode> devNodes = this.getDevNodeList();
        this.infoCollectMainLayout.getDeviceTable().removeAll();
        Iterator<DevNode> iterator = devNodes.iterator();
        ArrayList<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
        while (iterator.hasNext()) {
            DevNode node = iterator.next();
            if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(node)) {
                InfoCollectUtil.getComputeStorageDevs(node).forEach(devNode -> this.addDeviceData(failRet, (DevNode)devNode));
                continue;
            }
            this.addDeviceData(failRet, node);
        }
        if (!failRet.isEmpty()) {
            SubDialogUtils.showMultiInfoDialogOnTop((String)ResourceUtil.getString((String)"devicemanager.layout.initdate.nosupportdev"), (String[])new String[]{ResourceUtil.getString((String)"devicemanager.layout.initdate.nosupportdevip"), ResourceUtil.getString((String)"devicemanager.layout.initdate.nosupportdevsn")}, failRet);
        }
        int dataTurboNodeNumber = CollectDataContext.getInstance().getDataTurboNodeNumber();
        if (InfoCollectUtil.isSupportA800Scene() && dataTurboNodeNumber > 0) {
            log.info("A800 DataTurbo devNode number is {}", (Object)dataTurboNodeNumber);
            this.initAiDevNodeMap(devNodes);
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"infocollect.main.dialog.oceanstor.dataturbo.tips", (Object[])new Object[]{this.getOmNodesIp(devNodes)}));
        }
    }

    private void initAiDevNodeMap(List<DevNode> devNodes) {
        log.info("There are some DataTurbo devices({}), start init aiDevNode.", this.getOmNodesIp(devNodes));
        devNodes.stream().filter(InfoCollectUtil::isA800Om).forEach(this::saveAiNode);
    }

    private void saveAiNode(DevNode omDevNode) {
        DpcCollectUtil.getAiDevNode(omDevNode).ifPresent(devNode -> CollectDataContext.getInstance().getAiDevNodeMap().put(omDevNode.getIp(), (AiDevNode)devNode));
    }

    @NotNull
    private List<String> getOmNodesIp(List<DevNode> devNodes) {
        return devNodes.stream().filter(InfoCollectUtil::isA800Om).map(DevNode::getIp).collect(Collectors.toList());
    }

    private void addDeviceData(ArrayList<ArrayList<Object>> failRet, DevNode node) {
        if (InfoCollectUtil.isSupportDev(node)) {
            LOGGER.info("{} is support.", (Object)node.getIp());
            this.supports.add(node);
            this.infoCollectMainLayout.getDeviceTableModel().addRow(new TableRow[]{this.constructDeviceTableRow(node)});
            if (CollectDataContext.getInstance().isScene() && CollectDataContext.getInstance().sceneSelectDevNode(node.getDeviceSerialNumber())) {
                int rowNum = this.infoCollectMainLayout.getDeviceTable().getRowCount() - 1;
                this.infoCollectMainLayout.getDeviceTable().addRowSelectionInterval(rowNum, rowNum);
            }
        } else {
            ArrayList<String> unSupportDev = new ArrayList<String>();
            unSupportDev.add(node.getIp());
            unSupportDev.add(node.getDeviceSerialNumber());
            failRet.add(unSupportDev);
            LOGGER.info("{} is not support.", (Object)node.getIp());
        }
    }

    public void submitSingleDiskQueryTask(DevNode deviceNode) {
        CreateEnvAdnSubmitDiskQryRunnable runnable = new CreateEnvAdnSubmitDiskQryRunnable(deviceNode, this);
        ToolThreadFactory.newDefaultThread((Runnable)runnable).start();
    }

    public void submitBatchDiskQueryTask(List<DevNode> deviceNodes) {
        if (null == deviceNodes || deviceNodes.isEmpty()) {
            LOGGER.info("Device node list is null, return directly.");
            return;
        }
        LOGGER.info("Begin to submit all disk query tasks.");
        ExecutorService threadPool = Executors.newFixedThreadPool(25);
        for (DevNode deviceNode : deviceNodes) {
            CreateEnvAdnSubmitDiskQryRunnable runnable = new CreateEnvAdnSubmitDiskQryRunnable(deviceNode, this);
            threadPool.execute(runnable);
        }
        LOGGER.info("All disk query tasks have been commited.");
        threadPool.shutdown();
    }

    private List<DevNode> getDevNodeList() {
        List<DevNode> devices = CollectDeviceService.getInstance().getAllDevNode();
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>(devices);
        if (null != this.faildDevNodes && !this.faildDevNodes.isEmpty()) {
            for (DevNode devNode : this.faildDevNodes) {
                if (this.checkExist(devices, devNode)) continue;
                devNodes.add(devNode);
            }
        } else {
            ToolLoggerFactory.getLogger(this.getClass()).error("Failed DevNodes is empty.");
        }
        return devNodes;
    }

    private boolean checkExist(List<DevNode> devices, DevNode devNode) {
        for (DevNode devNodeTmp : devices) {
            if (!devNodeTmp.getIp().equals(devNode.getIp())) continue;
            return true;
        }
        return false;
    }

    public void refreshDevList() {
        HashMap<DevNode, TableRow> nodeMap = new HashMap<DevNode, TableRow>();
        List list = this.infoCollectMainLayout.getDeviceTableModel().getAllRows();
        for (TableRow row : list) {
            DevNode node = (DevNode)row.getUserObject();
            nodeMap.put(node, row);
        }
        List<DevNode> devs = this.getDevNodeList();
        for (DevNode node : devs) {
            if (nodeMap.containsKey(node) && !InfoCollectUtil.isSupportDev(node)) {
                this.infoCollectMainLayout.getDeviceTableModel().removeRow(new TableRow[]{(TableRow)nodeMap.get(node)});
                continue;
            }
            if (!InfoCollectUtil.isSupportDev(node) || nodeMap.containsKey(node)) continue;
            TableRow<DevNode, String> row = this.constructDeviceTableRow(node);
            this.infoCollectMainLayout.getDeviceTableModel().addRow(new TableRow[]{row});
        }
    }

    private void initSelected() {
        for (DevNode devNode : this.supports) {
            int index = this.supports.indexOf(devNode);
            if (this.faildDevNodes == null || !this.faildDevNodes.contains(devNode)) continue;
            this.infoCollectMainLayout.getDeviceTable().addRowSelectionInterval(index, index);
        }
    }

    public TableRow<DevNode, String> constructDeviceTableRow(DevNode deviceNode) {
        DefaultTableRow row = new DefaultTableRow(this.infoCollectMainLayout.getDeviceTableModel().getColumnCount(), (Object)deviceNode, (Object)(deviceNode.getDeviceSerialNumber() + deviceNode.getDeviceType()));
        String deviceName = deviceNode.getDeviceName();
        String deviceType = deviceNode.getDeviceType().toString();
        if (ApplicationContext.getInstance().isOEM()) {
            deviceType = deviceNode.getOemModel();
        }
        if (StringUtils.isNULLStr((String)deviceName)) {
            deviceName = "--";
        }
        if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(deviceNode)) {
            deviceName = ResourceUtil.getStringWithParams((String)"infocollect.device.name", (Object[])new Object[]{deviceName, deviceNode.getIp()});
        }
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(deviceNode);
        int currentProgress = 0;
        CollectStatus status = CollectStatus.NOT_COLLECT;
        if (collectInfo != null) {
            currentProgress = collectInfo.getCurrentProgress();
            status = collectInfo.getCollectStatus();
        }
        int index = 0;
        String t300ShownName = CollectDataContext.getInstance().getT3000ShowName().get(deviceNode);
        row.setValueAt(index++, (Object)(null == t300ShownName ? deviceName : t300ShownName));
        row.setValueAt(index++, (Object)deviceType);
        row.setValueAt(index++, (Object)deviceNode.getProductVersion());
        row.setValueAt(index++, (Object)new IpAddressStrategy(deviceNode.getIp()));
        row.setValueAt(index++, (Object)new IsmTableCell.ProgressCell(currentProgress));
        row.setValueAt(index++, (Object)new CollectStatusCell(status));
        row.setValueAt(index++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infocollect.setup"), new DeviceSetupIcon(deviceNode, this).getAction()));
        return row;
    }

    public void addListener() {
        this.addWindowListener(new CollectMainWindowListener(this));
        this.infoCollectMainLayout.getAddDeviceLabel().addMouseListener((MouseListener)new DeviceAddListener(this, this.infoCollectMainLayout));
        this.infoCollectMainLayout.getHostInfoCollectCmdLinkLbl().addClickListener((ToolHyperLinkLabel.ClickListener)new DownLoadAction(this, "commandTemplate"));
        this.infoCollectMainLayout.getSupportProductLabel().addMouseListener((MouseListener)new ShowSupportProductListener(this));
        this.infoCollectMainLayout.getExploreButton().addActionListener(new ExploreButtonListener());
        this.infoCollectMainLayout.getDirSetupButton().addActionListener(new DirSetupButtonListener(this));
        this.infoCollectMainLayout.getSplitButton().addActionListener(new SplitPakageDialog((Window)this));
        this.infoCollectMainLayout.getCollectButton().addActionListener(new CollectTaskAction(this));
        this.infoCollectMainLayout.getSetConcurrentDevButton().addActionListener(new SetTaskThreadNumbersDialog((Window)this));
        this.infoCollectMainLayout.getPackageA800ClusterButton().addActionListener(new PackageA800Cluster(this));
        DetailListerListener detailListerListener = new DetailListerListener(this);
        this.infoCollectMainLayout.getDeviceTable().addMouseListener((MouseListener)detailListerListener);
        ListSelectionModel model = this.infoCollectMainLayout.getDeviceTable().getSelectionModel();
        model.addListSelectionListener(new ListSelectionModelListener(this));
        this.infoCollectMainLayout.getDetailList().addMouseListener(new ListMouseAdapter(this));
    }

    public void refurbishDetailList() {
        this.infoCollectMainLayout.getDetailList().setListData(new ExecuteResult[0]);
        DevNode devNode = this.getCurrentChosenDevNode();
        SwingUtilities.invokeLater(new RefurbishRunnable(devNode, this));
    }

    public DevNode getCurrentChosenDevNode() {
        int[] rows = this.infoCollectMainLayout.getDeviceTable().getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        int index = this.infoCollectMainLayout.getDeviceTable().convertRowIndexToModel(rows[0]);
        TableRow row = this.infoCollectMainLayout.getDeviceTableModel().getRow(index);
        DevNode devNode = (DevNode)row.getUserObject();
        return devNode;
    }

    private void getBottomDetailList() {
        JScrollBar bar = this.infoCollectMainLayout.getDetailListScrolPane().getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
    }

    public void setListData(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        List<ExecuteResult> execResultList = InfoCollectService.getInstance().getExecuteResults(devNode);
        if (null != execResultList && !execResultList.isEmpty()) {
            DefaultListModel listMode = this.infoCollectMainLayout.getDetailListMode();
            listMode.removeAllElements();
            for (ExecuteResult executeResult : execResultList) {
                executeResult.setIcon(ResourceUtil.getImage((String)"loading.gif"));
                listMode.addElement(executeResult);
            }
            this.infoCollectMainLayout.getDetailList().setModel(listMode);
            this.infoCollectMainLayout.getDetailList().repaint();
        }
    }

    private void daemonThread() {
        Thread thread = ToolThreadFactory.newDefaultThread((Runnable)new LoadingRunnable(this.infoCollectMainLayout), (String)"Refresh Thread!");
        thread.setDaemon(true);
        thread.start();
    }

    public void doCollectJob() {
        CollectDataContext.getInstance().setForeProcessRunning(true);
        List<DevNode> devices = this.getSelectedDevNode();
        if (!this.checkDeviceParamSetting(devices)) {
            return;
        }
        if (!this.queryDevStatus()) {
            log.error("query device status failed.");
            return;
        }
        devices = this.getSelectedDevNode();
        if (!this.checkDeviceStatus(devices)) {
            return;
        }
        this.saveDevsPuStartupScenarioResult(devices);
        this.modifyCliCollectionLogic(this.filterNonA800OmDev(devices));
        this.saveCliCollectionInfo(devices);
        StmReportUtil.reportStmMessage((StmReportMessage)new StmReportMessage("002", devices.size()), (String)"collect");
        this.doCollect(devices);
    }

    private boolean checkDeviceStatus(List<DevNode> devices) {
        if (!this.checkSelectDevices(devices)) {
            return false;
        }
        if (!this.checkA800ZoneUpgradeStatus(devices)) {
            return false;
        }
        if (!this.checkDevCollect(devices)) {
            log.error("Failed to check the collection items of device settings.");
            return false;
        }
        if (!this.checkDiskSize()) {
            log.error("The disk space of the storage directory is less than 2 GB.");
            return false;
        }
        if (!this.checkDpcDiskSize(devices)) {
            log.error("Failed to verify the DPC hard disk space.");
            return false;
        }
        if (ResourceUsageService.hasHardwareHighUsageNode((JDialog)this, devices)) {
            log.warn("Nodes with high hardware usage.");
            return false;
        }
        if (DeviceCliCommandCheckUtil.hasShortKeepAliveTime(this, devices)) {
            log.warn("The session timeout duration of the flash device is less than 30 minutes.");
            return false;
        }
        return true;
    }

    private boolean checkDpcDiskSize(List<DevNode> devices) {
        List omList = devices.stream().filter(InfoCollectUtil::isA800Om).collect(Collectors.toList());
        if (omList.size() == 0) {
            log.info("The dataturbo client does not exist. The disk space verification is skipped.");
            return true;
        }
        String infoCollectDir = InfoCollectDirPropertiesUtil.getProperty();
        if (StringUtils.isNULLStr((String)infoCollectDir)) {
            infoCollectDir = String.join((CharSequence)File.separator, FileUtils.getDefaultDirectory().getAbsolutePath(), "infoCollect", "data", "collect");
        }
        int nodeNumbers = DataTurboUtil.dpcSelectNodes(CollectDataContext.getInstance().getCollectNodeMap().get(((DevNode)omList.get(0)).getIp())).size();
        File selectLocal = new File(infoCollectDir);
        long freeSpace = selectLocal.getFreeSpace() / 0x100000L;
        if (freeSpace < (long)nodeNumbers * 200L) {
            String description = ResourceUtil.getStringWithParams((String)"infocollect.remind.check.dpc.disk.size", (Object[])new Object[]{nodeNumbers, (long)nodeNumbers * 200L, freeSpace});
            WarningDialog warningDialog = DialogUtils.createYesAndNoDialog((JDialog)this, (String)description);
            log.info("Number of DPC nodes: {}, available local disk space: {}, selected status: {}", new Object[]{nodeNumbers, freeSpace, warningDialog.getValue()});
            return warningDialog.getValue() != 1 && warningDialog.getValue() != -1;
        }
        return true;
    }

    private boolean checkA800ZoneUpgradeStatus(List<DevNode> devices) {
        if (!InfoCollectUtil.isSupportA800Scene()) {
            return true;
        }
        List zones = devices.stream().filter(InfoCollectUtil::isA800Zone).filter(QueryUpgradeStates::isUpgradeMode).collect(Collectors.toList());
        if (zones.size() == 0) {
            log.info("The A800 zone device is not upgrading.");
            return true;
        }
        List isUpgradeIps = zones.stream().filter(dev -> !QueryUpgradeStates.allowCollect(dev)).map(DevNode::getIp).collect(Collectors.toList());
        if (isUpgradeIps.size() != 0 && InfoCollectUtil.isSupportUpgradeCollect()) {
            log.info("In the configuration file, information collection during the upgrade is configured.");
            ConfirmationWithSignDialog signDialog = new ConfirmationWithSignDialog((Window)this, ResourceUtil.getString((String)"a800.zone.collect.is.upgrading.prompt.info"));
            signDialog.setVisible(true);
            if (0 == signDialog.getResultValue()) {
                log.info("detected user confirmed this operation!");
                return true;
            }
            log.warn("The customer does not click OK.");
            return false;
        }
        if (isUpgradeIps.size() != 0) {
            log.info("The device ({}) is currently being upgraded.", isUpgradeIps);
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"a800.zone.collect.upgrade.status.error"));
            return false;
        }
        ConfirmationWithSignDialog signDialog = new ConfirmationWithSignDialog((Window)this, ResourceUtil.getString((String)"a800.zone.collect.upgrade.prompt.info"));
        signDialog.setVisible(true);
        if (0 == signDialog.getResultValue()) {
            log.info("detected user confirmed this operation!");
            return true;
        }
        log.warn("The customer does not click OK.");
        return false;
    }

    private boolean checkDeviceParamSetting(List<DevNode> devices) {
        if (CollectDataContext.getInstance().isForeground() && !this.checkParamSetting(this.filterNonA800OmDev(devices))) {
            log.error("No parameter is set for the DsStorage.");
            return false;
        }
        if (!this.checkStorageParamSetting(devices)) {
            log.error("No parameter is set for scenario-based storage.");
            return false;
        }
        if (!this.checkDataTurboParamSetting(devices)) {
            log.error("No parameter is set for A800 DataTurbo.");
            return false;
        }
        return true;
    }

    private boolean checkDataTurboParamSetting(List<DevNode> devices) {
        List<DevNode> dataTurboDevs = devices.stream().filter(InfoCollectUtil::isA800Om).collect(Collectors.toList());
        if (Utils.isNullList(dataTurboDevs)) {
            log.info("No DataTurbo device selected.");
            return true;
        }
        return this.checkDpcParamSetting(dataTurboDevs);
    }

    private boolean checkDpcParamSetting(List<DevNode> dataTurboDevs) {
        List dpcCollectNodes = dataTurboDevs.stream().filter(dev -> Objects.nonNull(CollectDataContext.getInstance().getCollectNodeMap().get(dev.getIp()))).map(dev -> CollectDataContext.getInstance().getCollectNodeMap().get(dev.getIp())).collect(Collectors.toList());
        if (Utils.isNullList(dpcCollectNodes)) {
            List unSettingDevIps = dataTurboDevs.stream().map(DevNode::getIp).collect(Collectors.toList());
            log.error("No parameter is set for all DataTurbo devices({}). ", unSettingDevIps);
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"collect.task.param.not.set", (Object[])new Object[]{unSettingDevIps}));
            return false;
        }
        List unSettingDevIps = dataTurboDevs.stream().filter(this::unSettingNodes).map(DevNode::getIp).collect(Collectors.toList());
        if (!Utils.isNullList(unSettingDevIps)) {
            log.error("No parameter is set for this devices({}).", unSettingDevIps);
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"collect.task.param.not.set", (Object[])new Object[]{unSettingDevIps}));
            return false;
        }
        return true;
    }

    private boolean unSettingNodes(DevNode dataTurboDev) {
        DpcCollectNode dpcCollectNode = CollectDataContext.getInstance().getCollectNodeMap().get(dataTurboDev.getIp());
        return !dpcCollectNode.isSetFinish() || Utils.isNullList(dpcCollectNode.getDpcClusterNodes());
    }

    private void modifyCliCollectionLogic(List<DevNode> devices) {
        for (DevNode device : devices) {
            if (this.needMarkCliCollectLess(device)) {
                CollectDataContext.getInstance().setSomeCmdNeedRemove(true);
                continue;
            }
            CollectDataContext.getInstance().setSomeCmdNeedRemove(false);
        }
    }

    private void doCollect(List<DevNode> devices) {
        InfoCollectService collectService = InfoCollectService.getInstance();
        for (DevNode device : devices) {
            if (!collectService.isSelectedNode(device)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infocollect.remind.onecollectIntegrateNodeleast"));
                continue;
            }
            collectService.startCollect(device);
        }
        CollectDataContext.getInstance().setForeProcessRunning(false);
    }

    private boolean checkStorageParamSetting(List<DevNode> devices) {
        String unableCollectIps = devices.stream().filter(dev -> InfoCollectUtil.isSupportCollectedByScene(dev) || InfoCollectUtil.isNewOceanStor9000(dev)).filter(dev -> !this.hasBeenSet((DevNode)dev)).map(DevNode::getIp).collect(Collectors.joining(IP_SEPARATE));
        if (StringUtils.isNULLStr((String)unableCollectIps)) {
            return true;
        }
        DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"collect.task.param.not.set", (Object[])new Object[]{unableCollectIps}));
        return false;
    }

    private boolean hasBeenSet(DevNode devNode) {
        return Optional.ofNullable(InfoCollectService.getInstance().getCollectInfoInstance(devNode)).map(ICollectInfo::getCollectConfInfo).map(CollectConfInfo::isCompleteStorageParamSetting).orElse(false);
    }

    private void saveCliCollectionInfo(List<DevNode> devices) {
        HashMap<DevNode, String> devCollectCliTypeMap = new HashMap<DevNode, String>();
        devices.forEach(dev -> this.addCliType((Map<DevNode, String>)devCollectCliTypeMap, (DevNode)dev));
        CollectDataContext.getInstance().setDevCollectCliTypeMap(devCollectCliTypeMap);
    }

    private void addCliType(Map<DevNode, String> devCollectCliTypeMap, DevNode dev) {
        if (dev.isDsStorage() || !this.hasCliItem(dev)) {
            return;
        }
        if (this.needCropCliCmd(dev.getProductVersion(), dev.getDeviceType().toString())) {
            this.saveCliType(devCollectCliTypeMap, dev);
            return;
        }
        devCollectCliTypeMap.put(dev, "old_dev");
    }

    private boolean needCropCliCmd(String version, String type) {
        return this.isSpecifiedDoraodoOrNewDorado(version, type) || this.isSpecifiedOceanProtect(version, type);
    }

    private boolean isSpecifiedOceanProtect(String version, String type) {
        return TaskCons.OCEAN_PROTECT_X.contains(type) && Products.compareVersion((String)version, (String)OCEAN_PROTEXT_MIN_PRODUCT_VERSION) >= 0;
    }

    private boolean isSpecifiedDoraodoOrNewDorado(String version, String type) {
        return (type.contains(DORADO) || Products.isNewDoradoDev((String)type)) && Products.compareVersion((String)version, (String)DORADO_MIN_PRODUCT_VERSION) >= 0;
    }

    private void saveCliType(Map<DevNode, String> devCollectCliTypeMap, DevNode dev) {
        List<CollectItem> selectItems = CollectDataContext.getInstance().getCollectInfo(dev).getCollectConfInfo().getSelectItems();
        boolean hasConfig = this.hasConfig(selectItems);
        boolean hasEvent = this.hasSpecifiedItem(selectItems, EVENT);
        if (hasConfig && hasEvent) {
            devCollectCliTypeMap.put(dev, HAS_CONFIG_AND_EVENT);
            return;
        }
        if (hasConfig) {
            devCollectCliTypeMap.put(dev, RUNNING_DATA);
            return;
        }
        if (hasEvent) {
            devCollectCliTypeMap.put(dev, EVENT);
        }
    }

    private boolean hasConfig(List<CollectItem> selectItems) {
        return this.hasSpecifiedItem(selectItems, RUNNING_DATA) || this.hasSpecifiedItem(selectItems, LOG) || this.hasSpecifiedItem(selectItems, ALL_LOG);
    }

    private boolean hasSpecifiedItem(List<CollectItem> selectItems, String itemId) {
        return selectItems.stream().anyMatch(item -> item.getId().equals(itemId));
    }

    private boolean hasCliItem(DevNode dev) {
        return CollectDataContext.getInstance().getCollectInfo(dev).getCollectConfInfo().getSelectItems().stream().anyMatch(item -> item.getId().equals(CLI));
    }

    private void saveDevsPuStartupScenarioResult(List<DevNode> devices) {
        Map<DevNode, Boolean> devStartupScenarioMap = CollectDataContext.getInstance().getDevStartupScenarioMap();
        devices.stream().filter(InfoCollectUtil::needSavePuStartupScenarioResult).filter(dev -> devStartupScenarioMap.getOrDefault(dev, false) == false).forEach(dev -> devStartupScenarioMap.put((DevNode)dev, true));
        CollectDataContext.getInstance().setDevStartupScenarioMap(devStartupScenarioMap);
    }

    private boolean checkParamSetting(List<DevNode> devices) {
        String notCompletedIps = devices.stream().filter(DevNode::isDsStorage).filter(devNode -> !this.isComplete((DevNode)devNode)).map(DevNode::getIp).collect(Collectors.joining(IP_SEPARATE));
        if (StringUtils.isNULLStr((String)notCompletedIps)) {
            return true;
        }
        DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"collect.task.param.not.set", (Object[])new Object[]{notCompletedIps}));
        return false;
    }

    private boolean isComplete(DevNode devNode) {
        ICollectInfo collectInfo = InfoCollectService.getInstance().getCollectInfoInstance(devNode);
        return collectInfo != null && collectInfo.getCollectConfInfo() != null && collectInfo.getCollectConfInfo().isCompleteParamSetting();
    }

    private boolean needMarkCliCollectLess(DevNode device) {
        boolean checkCollectItem = false;
        boolean haveCliItem = false;
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(device);
        List<CollectItem> selectItems = collectInfo.getCollectConfInfo().getSelectItems();
        for (CollectItem item : selectItems) {
            if (this.checkCollectItem(item.getId())) {
                checkCollectItem = true;
            }
            if (!item.getId().equals(CLI) || !item.isConcurrent()) continue;
            haveCliItem = true;
        }
        return checkCollectItem && haveCliItem;
    }

    private boolean checkCollectItem(String item) {
        return item.equals(ALL_LOG) || item.equals(LOG) || item.equals(RUNNING_DATA);
    }

    private boolean checkDiskSize() {
        String infoCollectDir = InfoCollectDirPropertiesUtil.getProperty();
        String userPath = null != infoCollectDir && !"".equals(infoCollectDir) ? infoCollectDir.toString() : FileUtils.getDefaultDirectory().getAbsolutePath() + File.separator + "infoCollect" + File.separator + "data" + File.separator + "collect";
        File selectLocal = new File(userPath);
        long freeSpace = selectLocal.getFreeSpace() / 0x40000000L;
        if (freeSpace < 2L) {
            String description = ResourceUtil.getString((String)"infocollect.remind.checkdisksize");
            WarningDialog warningDialog = DialogUtils.createContinueDialog((JDialog)this, (String)description);
            return 1 != warningDialog.getValue() && -1 != warningDialog.getValue();
        }
        return true;
    }

    private boolean checkDevCollect(List<DevNode> devices) {
        InfoCollectService collectService = InfoCollectService.getInstance();
        HashMap<String, String> unCollectMap = new HashMap<String, String>();
        ArrayList<String> itemIdList = new ArrayList<String>();
        for (DevNode devNode : devices) {
            ICollectInfo collectInfo = collectService.getCollectInfoInstance(devNode);
            if (null == collectInfo) continue;
            List<CollectItem> collectItems = collectInfo.getCollectConfInfo().getSelectItems();
            if (collectItems.isEmpty()) {
                String value = ResourceUtil.getString((String)"infocollect.remind.onecollectIntegrateNodeleast");
                unCollectMap.put(devNode.getIp(), value);
            }
            for (CollectItem collectItem : collectItems) {
                String id = collectItem.getId();
                itemIdList.add(id);
            }
        }
        if (!unCollectMap.isEmpty()) {
            ShowPreCollectItem dialog = new ShowPreCollectItem(this, unCollectMap);
            dialog.setVisible(true);
            return false;
        }
        if (!CollectDataContext.getInstance().isHostInfoCollectPermissionGranted() && itemIdList.contains("host_info")) {
            String confirmMsg;
            String warnMsg = ResourceUtil.getString((String)"infocollect.remind.hostinfo.grant.permission");
            WarningDialog warningDialog = DialogUtils.showWarnConfirmDialog((Window)this, (String)warnMsg, (String)(confirmMsg = ResourceUtil.getString((String)"infocollect.confirm.hostinfo.grant.permission")));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                return false;
            }
            CollectDataContext.getInstance().setHostInfoCollectPermissionGranted(true);
            LOGGER.info("Collect host permission has been granted.");
        }
        return true;
    }

    private boolean queryDevStatus() {
        IDeviceManageUI connUi;
        List<DevNode> devices = this.getSelectedDevNode();
        ArrayList<CheckDevNode> checkDevNodes = new ArrayList<CheckDevNode>();
        HashMap<String, Map<String, String>> deviceMap = new HashMap<String, Map<String, String>>();
        PreConditionServer.getInstance().clearPreCondition();
        HashMap<String, String> childParentMap = new HashMap<String, String>();
        for (DevNode devNode : devices) {
            PreConditionServer.getInstance().addPreCondition(devNode);
            CollectDeviceService deviceService = CollectDeviceService.getInstance();
            List<DevNode> devNodes = deviceService.getIntegratedNodes(devNode);
            ApplyRange rangeType = deviceService.getDevNodeApplyRange(devNode);
            if (ApplyRange.ALL.equals((Object)rangeType)) {
                this.applyRangeByAll(devNode, devNodes, checkDevNodes, deviceMap);
                continue;
            }
            if (ApplyRange.CLUSTER.equals((Object)rangeType)) {
                this.applyRangeByCluster(devNode, devNodes, checkDevNodes, childParentMap, deviceMap);
                continue;
            }
            LOGGER.info("the type is unsupported {}", (Object)rangeType);
        }
        if (!checkDevNodes.isEmpty()) {
            this.addQueryStatusInfo(checkDevNodes, deviceMap, childParentMap);
        }
        if (!(connUi = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class)).showMultiInfoDialog(deviceMap, (Window)this, true)) {
            return false;
        }
        return PreConditionServer.getInstance().isContinueCollect();
    }

    private void applyRangeByAll(DevNode devNode, List<DevNode> devNodes, List<CheckDevNode> checkDevNodes, Map<String, Map<String, String>> deviceMap) {
        String path = InfoConfiguration.getInstance().getPackageScriptPath(devNode);
        File file = new File(new File(path).getParentFile(), "queryDevStatus.py");
        if (!file.exists() && !com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().isSpecificDeviceMode()) {
            BizPackageService bizPackageService = new BizPackageService();
            Map<DevNode, String> debugPasswords = bizPackageService.getNeedDebugDevNode(devNodes, devNode);
            String debugPwd = devNode.getDeveloperPwd();
            if (!debugPasswords.isEmpty() && StringUtils.isNULLStr((String)debugPwd)) {
                HashMap<String, String> remindMap = new HashMap<String, String>();
                remindMap.put(devNode.getIp(), ResourceUtil.getString((String)"infocollect.devicesetup.password.word.error"));
                deviceMap.put(devNode.getIp(), remindMap);
            }
        }
        if (file.exists()) {
            CheckDevNode checkDevNode = new CheckDevNode();
            checkDevNode.setDevNode(devNode);
            checkDevNode.setScriptDir(new File(path).getParentFile());
            checkDevNodes.add(checkDevNode);
        }
    }

    private void applyRangeByCluster(DevNode devNode, List<DevNode> devNodes, List<CheckDevNode> checkDevNodes, Map<String, String> childParentMap, Map<String, Map<String, String>> deviceMap) {
        for (DevNode devNode2 : devNodes) {
            String path = InfoConfiguration.getInstance().getPackageScriptPath(devNode2);
            File file = new File(new File(path).getParentFile(), "queryDevStatus.py");
            if (!file.exists() && !com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().isSpecificDeviceMode()) {
                BizPackageService bizPackageService = new BizPackageService();
                if (!bizPackageService.isExistCollection(devNode, devNode2)) continue;
                this.addStatusInfo(devNode.getIp(), devNode2, deviceMap);
                continue;
            }
            if (!file.exists()) continue;
            CheckDevNode checkDevNode = new CheckDevNode();
            checkDevNode.setDevNode(devNode2);
            checkDevNode.setScriptDir(new File(path).getParentFile());
            checkDevNodes.add(checkDevNode);
            childParentMap.put(devNode2.getIp(), devNode.getIp());
        }
    }

    private void addStatusInfo(String ip, DevNode devNode, Map<String, Map<String, String>> deviceMap) {
        BizPackageService bizPackageService = new BizPackageService();
        boolean isNeedDebug = bizPackageService.isNeedDebug(devNode);
        String tip = ResourceUtil.getString((String)"infocollect.devicesetup.password.word.error");
        String curIp = devNode.getIp();
        if (isNeedDebug) {
            if (deviceMap.get(ip) != null) {
                deviceMap.get(ip).put(curIp, tip);
            } else {
                HashMap<String, String> infoMap = new HashMap<String, String>();
                infoMap.put(curIp, tip);
                deviceMap.put(ip, infoMap);
            }
        }
    }

    private void addQueryStatusInfo(List<CheckDevNode> checkDevNodes, Map<String, Map<String, String>> deviceMap, Map<String, String> childParentMap) {
        String language = com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().getCurrentLanguage().toString();
        BaseExecuter executer = new BaseExecuter(language, checkDevNodes);
        Map devStatusInfo = executer.queryDevStatus();
        Iterator iterator = devStatusInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            String ip = (String)iterator.next().getKey();
            String pId = childParentMap.get(ip);
            ResultDevNode resultDevNode = (ResultDevNode)iterator.next().getValue();
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (!StringUtils.isNULLStr((String)pId) && resultDevNode.isFlag()) {
                if (null != deviceMap.get(pId)) {
                    deviceMap.get(pId).put(ip, resultDevNode.getInfoMsg());
                    continue;
                }
                if (null != deviceMap.get(pId)) continue;
                resultMap.put(ip, resultDevNode.getInfoMsg());
                deviceMap.put(pId, resultMap);
                continue;
            }
            if (!StringUtils.isNULLStr((String)pId) || !resultDevNode.isFlag()) continue;
            resultMap.put(ip, resultDevNode.getInfoMsg());
            deviceMap.put(ip, resultMap);
        }
    }

    private boolean checkSelectDevices(List<DevNode> devices) {
        if (devices.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infocollect.remind.selectnodevice"));
            return false;
        }
        if (!this.isDownloadResFile(this.filterNonA800OmDev(devices))) {
            return false;
        }
        if (!this.isTasksExist(this.filterNonA800OmDev(devices))) {
            return false;
        }
        DevNode devNode = this.getUnsupportDevNode(devices);
        if (devNode != null) {
            String description = ResourceUtil.getString((String)"infocollect.remind.unsupportproduct");
            description = devNode.isMiniSystem() ? ResourceUtil.getString((String)"infocollect.devtype.minisystem") : description.replace("{0}", devNode.getDeviceType().toString() + " " + devNode.getProductVersion());
            DialogUtils.showInfoDialog((JDialog)this, (String)description);
            return false;
        }
        if (this.isCollecting(devices)) {
            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"infocollect.remind.itemiscollecting"));
            return false;
        }
        if (SceneUtils.isSpecialScence((String)System.getenv(JSON_SCENE), (String[])new String[]{TROUBLE_SHOOTING})) {
            try {
                List newDevList = EntityUtils.toNewDevList(devices);
                Map data = ConfirmAction.needOpenDoradoNasDevTipsDialog((List)newDevList, null);
                if (!data.isEmpty()) {
                    HyperMetroDevTipsDialog hyperMetroDevTipsDialog = new HyperMetroDevTipsDialog((Window)this, new HashMap(), data);
                    hyperMetroDevTipsDialog.setVisible(true);
                    if (!hyperMetroDevTipsDialog.isOkPerformed()) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info("check Dorado NAS error", (Throwable)e);
            }
        }
        return true;
    }

    private List<DevNode> filterNonA800OmDev(List<DevNode> devices) {
        return devices.stream().filter(dev -> !InfoCollectUtil.isA800Om(dev)).collect(Collectors.toList());
    }

    private boolean isDownloadResFile(final List<DevNode> devices) {
        List enResult = AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{new Callable<String>(){

            @Override
            public String call() {
                for (DevNode devNode : devices) {
                    String sn = devNode.getDeviceSerialNumber();
                    if (!devNode.isDsStorage() || CollectDeviceService.getDeviceHasDownResFile().contains(sn)) continue;
                    try {
                        if (!CollectDeviceService.getInstance().getResourceFileAndImportAsPackage(devNode)) {
                            devNode.setErrorDecs(ResourceUtil.getString((String)"download.info.res.files.failed"));
                            LOGGER.error("Download dstorage info collect resource file failed.");
                            return sn;
                        }
                        if (CollectDeviceService.getInstance().queryDstorageClusterNodes(devNode)) continue;
                        LOGGER.error("Failed to query nodes of a device. ");
                        devNode.setErrorDecs(ResourceUtil.getString((String)"query.cluster.nodes.info.failed"));
                        return sn;
                    }
                    catch (Exception e) {
                        LOGGER.error("Download dstorage info collect resource file failed.", (Throwable)e);
                        return sn;
                    }
                }
                return "true";
            }
        }});
        if (!"true".equals(enResult.get(0))) {
            DialogUtils.showInfoDialog((JDialog)this, (String)(enResult.get(0) + ResourceUtil.getString((String)"download.info.res.files.failed")));
            return false;
        }
        return true;
    }

    private boolean isTasksExist(List<DevNode> devices) {
        List enResult = AsyncExcutor.execute((Window)this, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> this.checkTasksExist(devices)});
        return this.showYesNoDialogFromTask(enResult);
    }

    private boolean showYesNoDialogFromTask(List<?> enResult) {
        InfoDialog infoDialog;
        if (VerifyUtil.isEmpty(enResult) || enResult.contains("true")) {
            return true;
        }
        int hight = 65;
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            hight += 33;
        }
        return (infoDialog = DialogUtils.showYesNoInfoDialog((Window)this, (String)ResourceUtil.getStringWithParams((String)"has.tasks.already", (Object[])new Object[]{enResult}), (Dimension)new Dimension(365, hight), (boolean)com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().isEnglishEnv())).getValue() != 1 && infoDialog.getValue() != -1;
    }

    private String checkTasksExist(List<DevNode> devices) {
        StringBuilder enResult = new StringBuilder();
        for (DevNode device : devices) {
            String devIp = device.getIp();
            if (!device.isDsStorage()) continue;
            try {
                if (CollectDeviceService.getInstance().checkDevStatusIfHasRunningTask(device)) continue;
                LOGGER.info("device has tasks already, add task now may lead to wait long");
                enResult.append(devIp).append(IP_SEPARATE);
            }
            catch (Throwable e) {
                LOGGER.error("query all task failed.", e);
            }
        }
        if (enResult.length() != 0) {
            return enResult.toString().replaceFirst(", $", "");
        }
        return "true";
    }

    public boolean isCollecting(List<DevNode> devices) {
        for (DevNode device : devices) {
            boolean isCollecting = InfoCollectService.getInstance().isMainDevNodeCollecting(device);
            if (!isCollecting) continue;
            return true;
        }
        return false;
    }

    private DevNode getUnsupportDevNode(List<DevNode> devices) {
        BizPackageService service = new BizPackageService();
        for (DevNode device : devices) {
            CollectConf conf = service.getCollectConf(device);
            if (conf != null) continue;
            return device;
        }
        return null;
    }

    public List<DevNode> getSelectedDevNode() {
        int[] rowIndexs = this.infoCollectMainLayout.getDeviceTable().getSelectedRows();
        ArrayList<DevNode> results = new ArrayList<DevNode>();
        DevNode devNode = null;
        if (rowIndexs.length == 0) {
            return results;
        }
        for (int index : rowIndexs) {
            index = this.infoCollectMainLayout.getDeviceTable().convertRowIndexToModel(index);
            TableRow row = this.infoCollectMainLayout.getDeviceTableModel().getRow(index);
            devNode = (DevNode)row.getUserObject();
            results.add(devNode);
        }
        return results;
    }

    private void refleshTable(DevNode devNode) {
        List tableRows = this.infoCollectMainLayout.getDeviceTableModel().getAllRows();
        TableRow changeRow = null;
        for (TableRow row : tableRows) {
            if (!devNode.equals(row.getUserObject())) continue;
            changeRow = row;
            break;
        }
        if (changeRow == null) {
            LOGGER.error("collect call back error,no such devNode :" + devNode.getIp());
            return;
        }
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo != null) {
            int collectProgress = collectInfo.getCurrentProgress();
            changeRow.setValueAt(4, (Object)new IsmTableCell.ProgressCell(collectProgress));
            if (100 != collectProgress && !collectInfo.isProcessFinished()) {
                changeRow.setValueAt(5, (Object)new CollectStatusCell(CollectStatus.COLLECTING));
            } else {
                List<InfocollectUserOpData> userDataList = CollectDataContext.getInstance().getUserOpList();
                UserOpTaskResult result = UserOpTaskResult.FAILED;
                changeRow.setValueAt(5, (Object)new CollectStatusCell(collectInfo.getCollectStatus()));
                result = this.checkCollectStatus(devNode, collectInfo, result);
                this.checkDevNodeSN(devNode, userDataList, result);
            }
            this.infoCollectMainLayout.getDeviceTable().repaint();
        }
    }

    private void checkDevNodeSN(DevNode devNode, List<InfocollectUserOpData> userDataList, UserOpTaskResult result) {
        for (InfocollectUserOpData infocollectUserOpData : userDataList) {
            if (!infocollectUserOpData.getDeviceSn().equals(devNode.getDeviceSerialNumber())) continue;
            infocollectUserOpData.setTaskResult(result);
        }
    }

    private UserOpTaskResult checkCollectStatus(DevNode devNode, ICollectInfo collectInfo, UserOpTaskResult result) {
        if (collectInfo.getCollectStatus() == CollectStatus.COLLECT_FAILED) {
            LOGGER.info("Collection complete >> Device {} infoCollect end][Failed", (Object)devNode.getIp());
        } else {
            if (collectInfo.getCollectStatus() == CollectStatus.COLLECT_FINISHED || collectInfo.getCollectStatus() == CollectStatus.COLLECT_FINISHED_NOTALL) {
                LOGGER.info("Collection complete >> Device {} infoCollect end][Success", (Object)devNode.getIp());
                return UserOpTaskResult.SUCCESS;
            }
            LOGGER.info("Collection complete >> Device {} infoCollect end][", (Object)devNode.getIp());
        }
        return result;
    }

    @Override
    public void collectCallback(DevNode devNode) {
        this.refleshTable(devNode);
        this.refurbishDetailList();
        this.getBottomDetailList();
    }

    public InfoCollectMainLayout getInfoCollectMainLayout() {
        return this.infoCollectMainLayout;
    }

    public void setInfoCollectMainLayout(InfoCollectMainLayout infoCollectMainLayout) {
        this.infoCollectMainLayout = infoCollectMainLayout;
    }

    public Map<String, Map<String, Thread>> getThreads() {
        return this.threads;
    }

    public void setThreads(Map<String, Map<String, Thread>> threads) {
        this.threads = threads;
    }

    public void updateProgress(DevNode devNode, int progress) {
        this.refreshProgress(devNode, progress);
        this.getBottomDetailList();
    }

    private void refreshProgress(DevNode devNode, int progress) {
        List tableRows = this.infoCollectMainLayout.getDeviceTableModel().getAllRows();
        if (Utils.isNullList((List)tableRows)) {
            log.error("table rows is null.");
            return;
        }
        Optional<TableRow> devRow = tableRows.stream().filter(row -> devNode.equals(row.getUserObject())).findFirst();
        if (!devRow.isPresent()) {
            log.error("Refresh progress error, no such devNode :" + devNode.getIp());
            return;
        }
        TableRow changeRow = devRow.get();
        changeRow.setValueAt(4, (Object)new IsmTableCell.ProgressCell(progress));
    }
}

