/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.support.DetailListCellRenderer;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCollectMainLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectMainLayout.class);
    private static final long serialVersionUID = 1L;
    private static final int NUM_300 = 300;
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 250);
    private ToolHyperLinkLabel addDeviceLabel = null;
    private ToolHyperLinkLabel supportProductLabel = null;
    private ToolHyperLinkLabel hostInfoCollectCmdLinkLbl = null;
    private JButton collectButton = null;
    private JButton exploreButton = null;
    private JButton dirSetupButton = null;
    private JButton splitButton = null;
    private JButton setConcurrentDevButton = null;
    private JButton packageA800ClusterButton = null;
    private IsmTable deviceTable = null;
    private DefaultTableModel deviceTableModel = null;
    private JList detailList = null;
    private DefaultListModel detailListMode = null;
    private JScrollPane detailListScrolPane = null;
    private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"infocollect.devicetable.head.hostname"), ResourceUtil.getString((String)"infocollect.selectdevice.support.devmodel"), ResourceUtil.getString((String)"infocollect.selectdevice.support.devversion"), ResourceUtil.getString((String)"infocollect.devicetable.head.ip"), ResourceUtil.getString((String)"infocollect.devicetable.head.progress"), ResourceUtil.getString((String)"infocollect.devicetable.head.status"), ResourceUtil.getString((String)"infocollect.devicetable.head.operation")};

    public InfoCollectMainLayout() {
        this.initComponent();
        this.layoutComponents();
    }

    private void initComponent() {
        this.addDeviceLabel = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infocollect.superlink.adddevice"));
        this.supportProductLabel = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infocollect.superlink.supportdevice"));
        this.hostInfoCollectCmdLinkLbl = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infocollect.host.info.tip.link"));
        this.collectButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.collect"), (char)'C');
        this.exploreButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.explore"), (char)'O');
        this.dirSetupButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.setup"), (char)'a');
        this.splitButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.splitPakage"), (char)'L');
        this.setConcurrentDevButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.set.concurrent.dev.number"), (char)'S');
        this.setConcurrentDevButton.setToolTipText(ResourceUtil.getString((String)"infocollect.button.set.concurrent.dev.number"));
        this.packageA800ClusterButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.a800.package"), (char)'P');
        this.createDeviceTable();
        this.detailListMode = new DefaultListModel();
        this.detailList = new JList(this.detailListMode);
        this.detailList.setCellRenderer(new DetailListCellRenderer());
        this.detailList.setSelectionMode(0);
        this.sceneEnableComp();
        this.setCompName();
        this.sceneVisibleComp();
    }

    private void sceneVisibleComp() {
        if (InfoCollectUtil.isSupportA800Scene()) {
            log.info("In the A800 scenario, the cluster packing button is displayed.");
            this.packageA800ClusterButton.setVisible(true);
            return;
        }
        this.packageA800ClusterButton.setVisible(false);
    }

    private void setCompName() {
        this.addDeviceLabel.setName("_LinkLabel_addDeviceLabel");
        this.supportProductLabel.setName("_LinkLabel_supportProductLabel");
        this.collectButton.setName("_Button_collectButton");
        this.exploreButton.setName("_Button_exploreButton");
        this.dirSetupButton.setName("_Button_dirSetupButton");
        this.splitButton.setName("_Button_splitButton");
        this.setConcurrentDevButton.setName("_Button_setConcurrentDevButton");
        this.packageA800ClusterButton.setName("_Button_packageA800ClusterButton");
        this.deviceTable.setName("_IsmTable_deviceTable");
        this.detailList.setName("_List_detailList");
    }

    private void sceneEnableComp() {
        if (CollectDataContext.getInstance().isScene()) {
            if (!CollectDataContext.getInstance().isStorageCollectSec()) {
                this.addDeviceLabel.setEnabled(false);
                this.dirSetupButton.setEnabled(false);
            }
            if (InfoCollectUtil.isSupportA800Scene() || SceneUtils.isA800UpgradeCheck()) {
                this.splitButton.setEnabled(false);
            }
        }
    }

    private void createDeviceTable() {
        this.deviceTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.deviceTableModel);
    }

    private void layoutComponents() {
        JSplitPane splitPane = new JSplitPane(0, true);
        JComponent descriptionArea = this.layoutDescrptionArea();
        descriptionArea.setAlignmentX(0.0f);
        JComponent buttonArea = this.layoutButtonArea();
        buttonArea.setAlignmentX(0.0f);
        JComponent tableArea = this.layoutTableArea();
        tableArea.setAlignmentX(0.0f);
        JComponent detailArea = this.layoutDetailArea();
        detailArea.setAlignmentX(0.0f);
        splitPane.setTopComponent(tableArea);
        splitPane.setBottomComponent(detailArea);
        splitPane.setDividerLocation(300);
        splitPane.setBorder(null);
        Box contentArea = Box.createVerticalBox();
        contentArea.add(descriptionArea);
        contentArea.add(Box.createVerticalStrut(12));
        contentArea.add(buttonArea);
        contentArea.add(Box.createVerticalStrut(12));
        contentArea.add(splitPane);
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)contentArea, (int)12));
    }

    private JComponent layoutDescrptionArea() {
        JLabel descriptionLabelA = ApplicationContext.getInstance().isSpecificDeviceMode() ? new JLabel(ResourceUtil.getString((String)"infocollect.adddevice.description.hvs")) : new JLabel(ResourceUtil.getString((String)"infocollect.adddevice.description"));
        JLabel descriptionLabelB = new JLabel(ResourceUtil.getString((String)"infocollect.fullstop"));
        Box descriptionArea1 = Box.createHorizontalBox();
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            descriptionArea1.add(descriptionLabelA);
            descriptionArea1.add(descriptionLabelB);
            descriptionArea1.setAlignmentX(0.0f);
        } else {
            descriptionArea1.add(descriptionLabelA);
            descriptionArea1.add((Component)this.addDeviceLabel);
            descriptionArea1.add(descriptionLabelB);
            descriptionArea1.setAlignmentX(0.0f);
        }
        JLabel descriptionLabelC = new JLabel(ResourceUtil.getString((String)"infocollect.importpackage.descriptionA"));
        JLabel descriptionLabelD = new JLabel(ResourceUtil.getString((String)"infocollect.importpackage.descriptionB"));
        Box descriptionArea2 = Box.createHorizontalBox();
        descriptionArea2.add(descriptionLabelC);
        descriptionArea2.add((Component)this.supportProductLabel);
        descriptionArea2.add(descriptionLabelD);
        descriptionArea2.add(new JLabel(ResourceUtil.getString((String)"infocollect.fullstop")));
        descriptionArea2.add(Box.createHorizontalGlue());
        descriptionArea2.setAlignmentX(0.0f);
        Box descriptionArea = Box.createVerticalBox();
        descriptionArea.add(descriptionArea1);
        descriptionArea.add(Box.createVerticalStrut(8));
        if (!ApplicationContext.getInstance().isSpecificDeviceMode() && !com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isOEM()) {
            descriptionArea.add(descriptionArea2);
            descriptionArea.add(Box.createVerticalStrut(8));
        }
        return descriptionArea;
    }

    private Box createHostInfoCollectDescBox() {
        Box descriptionArea = Box.createHorizontalBox();
        JLabel hostInfoDesLabel = new JLabel(ResourceUtil.getString((String)"infocollect.host.info.tip"));
        descriptionArea.add(hostInfoDesLabel);
        descriptionArea.add((Component)this.hostInfoCollectCmdLinkLbl);
        descriptionArea.add(new JLabel(ResourceUtil.getString((String)"infocollect.fullstop")));
        descriptionArea.setAlignmentX(0.0f);
        return descriptionArea;
    }

    private JComponent layoutButtonArea() {
        Box buttonArea = Box.createHorizontalBox();
        buttonArea.add(this.collectButton);
        buttonArea.add(Box.createHorizontalStrut(8));
        buttonArea.add(this.exploreButton);
        buttonArea.add(Box.createHorizontalStrut(8));
        buttonArea.add(this.dirSetupButton);
        buttonArea.add(Box.createHorizontalStrut(8));
        buttonArea.add(this.splitButton);
        buttonArea.add(Box.createHorizontalStrut(8));
        buttonArea.add(this.setConcurrentDevButton);
        buttonArea.add(Box.createHorizontalStrut(8));
        buttonArea.add(this.packageA800ClusterButton);
        buttonArea.add(Box.createHorizontalGlue());
        return buttonArea;
    }

    private JComponent layoutTableArea() {
        TableScrollPane pane = new TableScrollPane(this.deviceTable, true, true, true);
        pane.setPreferredSize(DEFAULT_SIZE);
        return pane;
    }

    private JComponent layoutDetailArea() {
        this.detailListScrolPane = new JScrollPane(this.detailList);
        this.detailListScrolPane.setPreferredSize(DEFAULT_SIZE);
        return this.detailListScrolPane;
    }

    public JButton getCollectButton() {
        return this.collectButton;
    }

    public JButton getExploreButton() {
        return this.exploreButton;
    }

    public JButton getDirSetupButton() {
        return this.dirSetupButton;
    }

    public JButton getSplitButton() {
        return this.splitButton;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public ToolHyperLinkLabel getAddDeviceLabel() {
        return this.addDeviceLabel;
    }

    public void setAddDeviceLabel(ToolHyperLinkLabel addDeviceLabel) {
        this.addDeviceLabel = addDeviceLabel;
    }

    public ToolHyperLinkLabel getHostInfoCollectCmdLinkLbl() {
        return this.hostInfoCollectCmdLinkLbl;
    }

    public ToolHyperLinkLabel getSupportProductLabel() {
        return this.supportProductLabel;
    }

    public JScrollPane getDetailListScrolPane() {
        return this.detailListScrolPane;
    }

    public DefaultListModel getDetailListMode() {
        return this.detailListMode;
    }

    public void setDetailListMode(DefaultListModel detailListMode) {
        this.detailListMode = detailListMode;
    }

    public JButton getSetConcurrentDevButton() {
        return this.setConcurrentDevButton;
    }

    public JButton getPackageA800ClusterButton() {
        return this.packageA800ClusterButton;
    }
}

