/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui;

import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.ErrorDetailInfoDialog;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;

public class ListMouseAdapter
extends MouseAdapter {
    private InfoCollectMainDialog dialog;

    public ListMouseAdapter(InfoCollectMainDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
            return;
        }
        DevNode devNode = this.dialog.getCurrentChosenDevNode();
        int index = this.getListIndex(mouseEvent.getPoint(), this.dialog.getInfoCollectMainLayout().getDetailList());
        if (-1 == index) {
            return;
        }
        List<ExecuteResult> execResultList = InfoCollectService.getInstance().getExecuteResults(devNode);
        if (null != execResultList) {
            ExecuteResult rec = execResultList.get(index);
            ErrorDetailInfoDialog detailDialog = new ErrorDetailInfoDialog(rec, (JDialog)this.dialog);
            detailDialog.setVisible(true);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

