/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.implement.DateSelectAction;
import com.huawei.ism.tool.infocollect.ui.ErrorDetailInfoDialog;
import com.huawei.ism.tool.infocollect.ui.InfocollectStatus;
import com.huawei.ism.tool.infocollect.ui.splitlistener.CancelBtnActionListener;
import com.huawei.ism.tool.infocollect.ui.splitlistener.ChooseFileAction;
import com.huawei.ism.tool.infocollect.ui.splitlistener.SaveFileAction;
import com.huawei.ism.tool.infocollect.ui.splitlistener.SplitCloseWindowAdapter;
import com.huawei.ism.tool.infocollect.ui.splitlistener.SplitSetProgressRunnable;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.PackageUtils;
import com.huawei.ism.tool.obase.connection.support.IDefineDateSelectAction;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.DateChooseField;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitPakageDialog
extends JDialog
implements ActionListener {
    public static final Dimension PROGRESSBAR_SIZE = new Dimension(360, 20);
    public static final String FILE_TYPE_7Z = "7z";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitPakageDialog.class);
    private static final String PY_FILE_NAME = "logCutProcess";
    private static final String CONFIG_PATH = CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath();
    private static final String PY_FILE_CATALOG = "logCutProcess" + File.separator + "script";
    private static final String PY_SCRIPT_FILE_NAME = "fileCutProcess.py";
    private static final String CHOOSEPATH_DEFAULT_ID = "infocollect_choooseresult_path_id001";
    private static final int UCD_20 = 20;
    private static final int UCD_10 = 10;
    private static final String EQUALS_SIGN = "=";
    private Window window = null;
    private JLabel chooseLable = null;
    private IsmTextField pathText = null;
    private JButton importButton = null;
    private DateChooseField startTimeField = null;
    private DateChooseField endTimeField = null;
    private JButton openDir = null;
    private JButton confirm;
    private JButton cancel;
    private JLabel splitTimeLable;
    private JLabel startTimeLable;
    private JLabel endTimeLable;
    private JLabel timeLable;
    private JLabel saveLable;
    private JLabel limitLable;
    private IsmTextField saveText;
    private JButton browseButton;
    private JLabel splitStatus;
    private JLabel chooseFile;
    private JLabel fileNameLabel;
    private JLabel fileName;
    private JProgressBar splitProgress;
    private File selectFile = null;
    private File saveFile = null;
    private boolean isRunning = false;

    public SplitPakageDialog(Window window) {
        super(window);
        this.window = window;
        this.initComponent();
        this.layoutComponpents();
        this.addListener();
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isrunning) {
        this.isRunning = isrunning;
    }

    public File getSelectFile() {
        return this.selectFile;
    }

    public void setSelectFile(File selectFile) {
        this.selectFile = selectFile;
    }

    public JLabel getFileName() {
        return this.fileName;
    }

    private void addListener() {
        this.importButton.addActionListener(new ChooseFileAction(this));
        this.browseButton.addActionListener(new SaveFileAction(this));
        this.cancel.addActionListener(new CancelBtnActionListener(this));
        this.openDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringUtils.isNULLStr((String)SplitPakageDialog.this.saveText.getText())) {
                    OSCmdUtils.explorerFile((String)SplitPakageDialog.this.saveText.getText());
                } else {
                    DialogUtils.showInfoDialog((JDialog)SplitPakageDialog.this, (String)ResourceUtil.getString((String)"infocollect.save.path.error"));
                }
            }
        });
        this.confirm.addActionListener(new ConfirmListener(this));
        this.addWindowListener(new SplitCloseWindowAdapter(this));
    }

    public void clear() {
        this.saveText.setText("");
        this.pathText.setText("");
        this.fileName.setText("");
        this.fileName.setToolTipText("");
        this.startTimeField.setText("");
        this.endTimeField.setText("");
        this.setProgress(0);
        this.selectFile = null;
        this.saveFile = null;
        this.setSplitStatus(InfocollectStatus.BEFORE_SPLIT);
        this.dispose();
    }

    private void initComponent() {
        this.setMinimumSize(new Dimension(360, 175));
        this.setTitle(ResourceUtil.getString((String)"infocollect.button.splitPakage"));
        this.setLayout(new BorderLayout());
        this.limitLable = new JLabel(ResourceUtil.getString((String)"infocollect.title.limit"));
        this.chooseLable = new JLabel(ResourceUtil.getString((String)"infocollect.choose.pakage.path"));
        this.importButton = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.path.brower"));
        this.chooseFile = new JLabel(ResourceUtil.getString((String)"infocollect.choose.file"));
        this.fileNameLabel = new JLabel(ResourceUtil.getString((String)"infocollect.file.name"));
        this.fileName = new JLabel("");
        this.timeLable = new JLabel(ResourceUtil.getString((String)"infocollect.split.time"));
        this.splitTimeLable = new JLabel(ResourceUtil.getString((String)"infocollect.split.date"));
        this.startTimeLable = new JLabel(ResourceUtil.getString((String)"infocollect.start.date"));
        this.endTimeLable = new JLabel(ResourceUtil.getString((String)"infocollect.end.date"));
        this.saveLable = new JLabel(ResourceUtil.getString((String)"infocollect.save"));
        String scenePath = InfoCollectDirPropertiesUtil.getProperty();
        this.pathText = new IsmTextField(null, null, 30);
        this.saveText = new IsmTextField(null, scenePath, 30);
        this.pathText.setEditable(false);
        this.saveText.setEditable(false);
        this.browseButton = new JButton(ResourceUtil.getString((String)"infocollect.path.brower"));
        this.startTimeField = new DateChooseField(2);
        this.endTimeField = new DateChooseField(2);
        this.splitStatus = new JLabel(ResourceUtil.getString((String)"infocollect.maindialog.desc.status.0"));
        this.openDir = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.split.ui.opendir"));
        this.confirm = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.split.ui.confirm"));
        this.cancel = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.importpackage.ui.close"));
        DateSelectAction timeAction = new DateSelectAction(this.startTimeField, this.endTimeField, this);
        this.startTimeField.setAction((IDefineDateSelectAction)timeAction);
        this.endTimeField.setAction((IDefineDateSelectAction)timeAction);
        this.enableCustomField(true);
    }

    public void enableCustomField(boolean isEnable) {
        this.startTimeField.setEnabled(isEnable);
        this.endTimeField.setEnabled(isEnable);
    }

    private void layoutComponpents() {
        Box row = Box.createVerticalBox();
        row.add(this.limitRow());
        row.add(Box.createVerticalStrut(10));
        row.add(this.createPathAreaRow());
        row.add(Box.createVerticalStrut(20));
        row.add(this.createDateAreaRow());
        row.add(Box.createVerticalStrut(20));
        row.add(this.createWaitBorderRow());
        row.add(Box.createVerticalStrut(10));
        row.add(this.statusRow());
        row.add(Box.createVerticalStrut(10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        row.add((Component)new JSeparator(), gridBagConstraints);
        row.add(Box.createVerticalStrut(15));
        row.add(this.createButtonRow());
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)row, (int)12), "North");
    }

    public void setCompName() {
        this.pathText.setName("_PasswordField_password");
        this.importButton.setName("_IsmTextField_portField");
        this.startTimeField.setName("_DateChooseField_startTimeField");
        this.endTimeField.setName("_DateChooseField_endTimeField");
        this.confirm.setName("_Button_confirm");
        this.cancel.setName("_Button_cancel");
        this.splitTimeLable.setName("_JLalel_splitTimeLable");
        this.startTimeLable.setName("_JLabel_startTimeLable");
        this.endTimeLable.setName("_JLabel_endTimeLable");
        this.saveLable.setName("_JLabel_saveLable");
        this.saveText.setName("_JTextField_saveText");
        this.browseButton.setName("_JButton_browseButton");
        this.splitProgress.setName("_JProgressBar_analyzeProgress");
        this.chooseFile.setName("_JLabel_chooseFile");
    }

    private Box createPathAreaRow() {
        Box productrow = Box.createHorizontalBox();
        productrow.add(this.createPathRow());
        return productrow;
    }

    private JComponent createPathRow() {
        TitledBorder border = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.file"));
        JComponent ipPan = UCD.buildVerticalBox((Border)border, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.chooseLable})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.chooseFile, Box.createHorizontalStrut(0), this.pathText, Box.createHorizontalStrut(0), this.importButton, Box.createHorizontalStrut(0)}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.fileNameLabel, Box.createHorizontalStrut(0), this.fileName, Box.createHorizontalStrut(0)}), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0))});
        return ipPan;
    }

    private Box createDateAreaRow() {
        Box productrow = Box.createHorizontalBox();
        productrow.add(this.createDateRow());
        return productrow;
    }

    private JComponent createDateRow() {
        TitledBorder border = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.button.splitPakage.set"));
        JComponent ipPan = UCD.buildVerticalBox((Border)border, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.timeLable})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.startTimeLable, Box.createHorizontalStrut(0), this.startTimeField, Box.createHorizontalStrut(0), this.endTimeLable, Box.createHorizontalStrut(0), this.endTimeField, Box.createHorizontalStrut(0)}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.saveLable, Box.createHorizontalStrut(12), this.saveText, Box.createHorizontalStrut(0), this.browseButton, Box.createHorizontalStrut(0)}), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0))});
        return ipPan;
    }

    private Box createWaitBorderRow() {
        Box productrow = Box.createHorizontalBox();
        this.splitProgress = new JProgressBar(0);
        this.splitProgress.setStringPainted(true);
        this.splitProgress.setPreferredSize(PROGRESSBAR_SIZE);
        this.splitProgress.setSize(PROGRESSBAR_SIZE);
        this.splitProgress.setMinimumSize(PROGRESSBAR_SIZE);
        this.setSplitStatus(InfocollectStatus.BEFORE_SPLIT);
        productrow.add(this.splitProgress);
        return productrow;
    }

    private Box createButtonRow() {
        Box productrow = Box.createHorizontalBox();
        productrow.add(Box.createHorizontalGlue());
        productrow.add(this.confirm);
        productrow.add(Box.createHorizontalStrut(10));
        productrow.add(this.openDir);
        productrow.add(Box.createHorizontalStrut(10));
        productrow.add(this.cancel);
        return productrow;
    }

    private Box statusRow() {
        Box productrow = Box.createHorizontalBox();
        productrow.add(this.splitStatus);
        productrow.add(Box.createHorizontalGlue());
        return productrow;
    }

    private Box limitRow() {
        Box productrow = Box.createHorizontalBox();
        productrow.add(this.limitLable);
        productrow.add(Box.createHorizontalGlue());
        return productrow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CollectDataContext.getInstance().setLogSplit(true);
        this.setVisible(true);
    }

    public JLabel getChooseLable() {
        return this.chooseLable;
    }

    private void flashSplitStat() {
        Dimension dimension = this.splitStatus.getSize();
        Rectangle rect = new Rectangle(0, 0, dimension.width + 10, dimension.height + 5);
        this.splitStatus.paintImmediately(rect);
    }

    public void setChooseLable(JLabel chooseLable) {
        this.chooseLable = chooseLable;
    }

    public IsmTextField getPathText() {
        return this.pathText;
    }

    public void setPathText(IsmTextField pathText) {
        this.pathText = pathText;
    }

    public JButton getConfirm() {
        return this.confirm;
    }

    public void setConfirm(JButton confirm) {
        this.confirm = confirm;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public void setCancel(JButton cancel) {
        this.cancel = cancel;
    }

    public DateChooseField getStartTimeField() {
        return this.startTimeField;
    }

    public void setStartTimeField(DateChooseField startTimeField) {
        this.startTimeField = startTimeField;
    }

    public DateChooseField getEndTimeField() {
        return this.endTimeField;
    }

    public void setEndTimeField(DateChooseField endTimeField) {
        this.endTimeField = endTimeField;
    }

    public void setimportButton(JButton importbutton) {
        this.importButton = importbutton;
    }

    public JButton getImportButton() {
        return this.importButton;
    }

    public void setImportButton(JButton importButton) {
        this.importButton = importButton;
    }

    public JLabel getSplitTimeLable() {
        return this.splitTimeLable;
    }

    public void setSplitTimeLable(JLabel splitTimeLable) {
        this.splitTimeLable = splitTimeLable;
    }

    public JLabel getStartTimeLable() {
        return this.startTimeLable;
    }

    public void setStartTimeLable(JLabel startTimeLable) {
        this.startTimeLable = startTimeLable;
    }

    public JLabel getEndTimeLable() {
        return this.endTimeLable;
    }

    public void setEndTimeLable(JLabel endTimeLable) {
        this.endTimeLable = endTimeLable;
    }

    public JLabel getSaveLable() {
        return this.saveLable;
    }

    public void setSaveLable(JLabel saveLable) {
        this.saveLable = saveLable;
    }

    public IsmTextField getSaveText() {
        return this.saveText;
    }

    public void setSaveText(IsmTextField saveText) {
        this.saveText = saveText;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public void setBrowseButton(JButton browseButton) {
        this.browseButton = browseButton;
    }

    public JLabel getSplitStatus() {
        return this.splitStatus;
    }

    public void setSplitStatus(InfocollectStatus statusAnalyze) {
        switch (statusAnalyze) {
            case BEFORE_SPLIT: {
                this.splitStatus.setText(ResourceUtil.getString((String)"infocollect.maindialog.desc.status.0"));
                this.flashSplitStat();
                break;
            }
            case ING_SPLIT: {
                this.splitStatus.setText(ResourceUtil.getString((String)"infocollect.maindialog.desc.status.1"));
                this.flashSplitStat();
                break;
            }
            case AFTER_SPLIT: {
                this.splitStatus.setText(ResourceUtil.getString((String)"infocollect.maindialog.desc.status.2"));
                this.flashSplitStat();
                break;
            }
            case SPLIT_FALSE: {
                this.splitStatus.setText(ResourceUtil.getString((String)"infocollect.maindialog.desc.status.3"));
                this.flashSplitStat();
                break;
            }
        }
    }

    public void setSplitStatus(JLabel splitStatus) {
        this.splitStatus = splitStatus;
    }

    public JProgressBar getSplitProgress() {
        return this.splitProgress;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean setProgress(int progressValue) {
        SwingUtilities.invokeLater(new SplitSetProgressRunnable(progressValue, this));
        return true;
    }

    private void checkResult(List<Object> resultList) {
        Boolean result = (Boolean)resultList.get(0);
        String reason = (String)resultList.get(1);
        if (!result.booleanValue()) {
            this.setSplitStatus(InfocollectStatus.SPLIT_FALSE);
            this.splitProgress.setForeground(Color.red);
        } else {
            this.setSplitStatus(InfocollectStatus.AFTER_SPLIT);
        }
        ErrorDetailInfoDialog detailDialog = new ErrorDetailInfoDialog(reason, (JDialog)this);
        detailDialog.setVisible(true);
    }

    private void setEnableTrue() {
        this.confirm.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.importButton.setEnabled(true);
        this.cancel.setEnabled(true);
        this.startTimeField.setEnabled(true);
        this.endTimeField.setEnabled(true);
    }

    private void setEnableFalse() {
        this.confirm.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.importButton.setEnabled(false);
        this.cancel.setEnabled(false);
        this.startTimeField.setEnabled(false);
        this.endTimeField.setEnabled(false);
    }

    class ConfirmListener
    implements ActionListener {
        private SplitPakageDialog dialog;
        private Date startDate = null;
        private Date endDate = null;

        public ConfirmListener(SplitPakageDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolThreadFactory.newDefaultThread((Runnable)new ExecSplitRunnable(this), (String)"Thread_split").start();
        }

        private void invokePyParam() {
            String workerSpace = CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath() + File.separator + PY_FILE_CATALOG + File.separator + SplitPakageDialog.PY_SCRIPT_FILE_NAME;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            String filePath = "";
            try {
                filePath = SplitPakageDialog.this.selectFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("get select File path error.");
            }
            paramMap.put("filePath", filePath);
            paramMap.put("fileSavePath", SplitPakageDialog.this.saveText.getText());
            paramMap.put("startTime", SplitPakageDialog.this.startTimeField.getText());
            paramMap.put("endTime", SplitPakageDialog.this.endTimeField.getText());
            paramMap.put("collectManagement", PackageUtils.class);
            paramMap.put("lang", LanguageManager.getInstance().getCurrentLanguage().getLanguage());
            paramMap.put("uiObserver", this.dialog);
            paramMap.put("Logger", ToolLoggerFactory.getLogger(this.getClass()));
            SplitPakageDialog.this.setSplitStatus(InfocollectStatus.ING_SPLIT);
            SplitPakageDialog.this.confirm.setEnabled(false);
            SplitPakageDialog.this.browseButton.setEnabled(false);
            SplitPakageDialog.this.importButton.setEnabled(false);
            SplitPakageDialog.this.cancel.setEnabled(false);
            SplitPakageDialog.this.startTimeField.setEnabled(false);
            SplitPakageDialog.this.endTimeField.setEnabled(false);
            String jthonFile = CONFIG_PATH + File.separator + PY_FILE_CATALOG;
            try {
                JythonExecuter executer = new JythonExecuter(new File(jthonFile));
                executer.compileScript(new File(workerSpace));
                List resultList = executer.invokeFunction("execute", paramMap);
                SplitPakageDialog.this.checkResult(resultList);
                SplitPakageDialog.this.setEnableTrue();
                SplitPakageDialog.this.isRunning = false;
            }
            catch (SignException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("verify Script error!", (Throwable)e);
                SplitPakageDialog.this.setSplitStatus(InfocollectStatus.SPLIT_FALSE);
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("py file {} not found!", (Object)SplitPakageDialog.PY_SCRIPT_FILE_NAME);
                SplitPakageDialog.this.setSplitStatus(InfocollectStatus.SPLIT_FALSE);
            }
            catch (ToolException e) {
                LOGGER.error("Excute Py File error!", (Throwable)e);
                SplitPakageDialog.this.setSplitStatus(InfocollectStatus.SPLIT_FALSE);
            }
            catch (Exception e) {
                LOGGER.error("Excute Py Script error!", (Throwable)e);
                SplitPakageDialog.this.setSplitStatus(InfocollectStatus.SPLIT_FALSE);
            }
        }

        public boolean checkInput() {
            if (StringUtils.hasNULLStr((String[])new String[]{SplitPakageDialog.this.pathText.getText()})) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.pakage.path.error"));
                return false;
            }
            String path = SplitPakageDialog.this.pathText.getText();
            if (!path.endsWith(SplitPakageDialog.FILE_TYPE_7Z)) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.pakage.type.error"));
                return false;
            }
            if (StringUtils.hasNULLStr((String[])new String[]{SplitPakageDialog.this.saveText.getText()})) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.save.path.error"));
                return false;
            }
            if (SplitPakageDialog.this.saveFile != null && SplitPakageDialog.this.saveFile.isFile()) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.save.path.file.error"));
                return false;
            }
            if (StringUtils.hasNULLStr((String[])new String[]{SplitPakageDialog.this.startTimeField.getText(), SplitPakageDialog.this.endTimeField.getText()})) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.customdatetimeerror"));
                return false;
            }
            if (!this.isValidDate()) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.custemdate.error"));
                return false;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(path))) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.pakage.size.error"));
                return false;
            }
            if (!this.isValidPackage(path)) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.pakage.empty.error"));
                return false;
            }
            return true;
        }

        private boolean isValidPackage(String path) {
            try {
                String responseInfo = FileAssistant.queryPackageFiles((String)path);
                String[] lines = responseInfo.split(System.lineSeparator());
                if (lines.length == 0) {
                    LOGGER.error("Failed to query the number of files. ResponseInfo is null.");
                    return false;
                }
                String physicalSize = "";
                String headersSize = "";
                for (String line : lines) {
                    if (line.contains("Physical Size") && line.split(SplitPakageDialog.EQUALS_SIGN).length == 2) {
                        physicalSize = line.split(SplitPakageDialog.EQUALS_SIGN)[1].trim();
                    }
                    if (!line.contains("Headers Size") || line.split(SplitPakageDialog.EQUALS_SIGN).length != 2) continue;
                    headersSize = line.split(SplitPakageDialog.EQUALS_SIGN)[1].trim();
                }
                return !physicalSize.isEmpty() && !headersSize.isEmpty() && !physicalSize.equals(headersSize);
            }
            catch (IOException e) {
                LOGGER.error("Failed to query the number of files in the package.", (Throwable)e);
                return false;
            }
        }

        public boolean isValidDate() {
            String startTime = SplitPakageDialog.this.startTimeField.getText();
            String endTime = SplitPakageDialog.this.endTimeField.getText();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                this.startDate = format.parse(startTime);
                this.endDate = format.parse(endTime);
                LOGGER.info("choose split package startTime-->{} endTime-->{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)startTime), (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)endTime));
                return this.startDate.before(this.endDate);
            }
            catch (ParseException e) {
                LOGGER.error("the starttime / endtime input error!!", (Throwable)e);
                return false;
            }
        }
    }

    class ExecSplitRunnable
    implements Runnable {
        private ConfirmListener confirmListener;

        public ExecSplitRunnable(ConfirmListener confirmListener) {
            this.confirmListener = confirmListener;
        }

        @Override
        public void run() {
            SplitPakageDialog.this.setEnableFalse();
            if (!this.confirmListener.checkInput()) {
                SplitPakageDialog.this.setEnableTrue();
                return;
            }
            SplitPakageDialog.this.isRunning = true;
            this.confirmListener.invokePyParam();
            SplitPakageDialog.this.confirm.setEnabled(true);
        }
    }
}

