/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.ItemConditionTag;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.rest.entity.CollectParam;
import com.huawei.ism.tool.infocollect.rest.entity.DstorageCollectParam;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.CollectInfoBuilder;
import com.huawei.ism.tool.infocollect.ui.setup.CollectSetupLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.common.util.DistributeRestUriUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemSelectionCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(ItemSelectionCard.class);
    private static final String PRODUCT_SERIES_URI = "/config/public-rundata.json";
    private static final String ANTIVIRUS_LOG = "antivirus_log";
    private static final String PRODUCT_SERIES_KEY = "productSeries";
    private static final String DATA_KEY = "data";
    private static final String BOMCODES_KEY = "bomCodes";
    private static final String BOMCODE_KEY = "bomCode";
    private static final List<String> FILE_SERVICES = ItemSelectionCard.getFileServicesBomCodes();
    private DevNode devNode;
    private ToolWizardDialog toolWizardDialog;
    private CollectSetupLayout collectSetupLayout;
    private boolean isSimpleCollect;
    private AdvancedOptionsPanel advancedOptionsPanel;

    public ItemSelectionCard(DevNode devNode, ToolWizardDialog toolWizardDialog, ToolWizardDialog.Card previousCard, boolean isSimpleCollect, AdvancedOptionsPanel advancedOptionsPanel) {
        super(previousCard, new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Previous, ToolWizardDialog.Navigation.Complete});
        this.devNode = devNode;
        this.toolWizardDialog = toolWizardDialog;
        this.isSimpleCollect = isSimpleCollect;
        this.advancedOptionsPanel = advancedOptionsPanel;
        this.collectSetupLayout = new CollectSetupLayout(false, this.getDateString(), true, null);
        this.collectSetupLayout.setName("_Panel_collectlayout");
        this.initData();
        this.setLayout(new BorderLayout());
        this.add(this.collectSetupLayout, "Center");
    }

    public static List<String> getFileServicesBomCodes() {
        return Arrays.asList(ResourceBundle.getBundle("config.infocollect").getString("file_service_bomcodes").split(","));
    }

    private String getDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(this.devNode.getDevCurrentTime()));
    }

    private void initData() {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(this.devNode);
        CollectConfInfo mainConfInfo = collectInfo.getCollectConfInfo();
        this.initDStorageCollectItemTree();
        if (this.isSimpleCollect) {
            this.initCollectConfInfoItem(mainConfInfo.getSimpleCollectSelectItems().stream().distinct().collect(Collectors.toList()));
        } else {
            this.initCollectConfInfoItem(mainConfInfo.getDefaultSelectItems().stream().distinct().collect(Collectors.toList()));
        }
    }

    void initDStorageCollectItemTree() {
        this.collectSetupLayout.getItemRootNode().removeAllChildren();
        this.attachItemTreeNode();
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectSetupLayout.getItemRootNode(), false);
        this.collectSetupLayout.getItemTree().setModel((TreeModel)newTreeModel);
        this.collectSetupLayout.getItemTree().setRootVisible(true);
        this.collectSetupLayout.getItemTree().setShowsRootHandles(true);
        this.collectSetupLayout.getItemTree().expandPath(new TreePath(this.collectSetupLayout.getItemRootNode()));
    }

    public static String getProductSeriesUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead((DevNode)devNode).append(PRODUCT_SERIES_URI).toString();
    }

    private String queryEnvInfo(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
        ResponseInfo envInfoResponse = conn.execGet(ItemSelectionCard.getProductSeriesUri(devNode));
        Optional<String> envInfo = Optional.ofNullable(envInfoResponse.getContent()).map(JSONObject::new).map(envJson -> envJson.get(PRODUCT_SERIES_KEY).toString());
        if (!envInfo.isPresent()) {
            return "NoSuccess";
        }
        return envInfo.get();
    }

    private boolean isBomCodesContainFileMode(JSONArray bomCodes) {
        for (int i = 0; i < bomCodes.length(); ++i) {
            JSONObject bomCode;
            if (!(bomCodes.get(i) instanceof JSONObject) || !(bomCode = (JSONObject)bomCodes.get(i)).has(BOMCODE_KEY) || !FILE_SERVICES.contains(bomCode.get(BOMCODE_KEY).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isFileMode(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
        ResponseInfo licensesResponse = conn.execGet(DistributeRestUriUtil.getActiveLicensesUri((DevNode)devNode));
        return Optional.ofNullable(licensesResponse.getContent()).map(JSONObject::new).map(contentJson -> contentJson.getJSONObject(DATA_KEY)).filter(data -> data.keySet().contains(BOMCODES_KEY)).map(data -> data.getJSONArray(BOMCODES_KEY)).map(this::isBomCodesContainFileMode).orElse(false);
    }

    private boolean needCollectAntiVirusLog(DevNode devNode) {
        try {
            String envInfo = this.queryEnvInfo(devNode);
            if (!"pacific".equalsIgnoreCase(envInfo)) {
                return false;
            }
            return this.isFileMode(devNode);
        }
        catch (ToolException e) {
            log.error("collect envinfo and servesinfo error", (Throwable)e);
            return false;
        }
    }

    private void attachItemTreeNode() {
        CollectConf currentConf = new BizPackageService().getCollectConf(this.devNode);
        if (currentConf == null) {
            String noSupportDesc = ResourceUtil.getString((String)"infocollect.remind.unsupportdev");
            this.collectSetupLayout.getItemRootNode().setUserObject((Object)noSupportDesc);
            this.collectSetupLayout.getItemRootNode().setToolTips(noSupportDesc);
            return;
        }
        this.collectSetupLayout.getItemRootNode().setUserObject((Object)this.devNode.getIp());
        this.collectSetupLayout.getItemRootNode().setToolTips(this.devNode.getIp());
        List<CollectModule> currentModules = this.isSimpleCollect ? currentConf.getAllSimpleCollectModuleAndSort() : currentConf.getDefaultModules();
        for (CollectModule module : currentModules) {
            CheckTreeNode moduleNode = new CheckTreeNode((Object)module, true, true);
            if (ANTIVIRUS_LOG.equals(module.getModuleId()) && !this.needCollectAntiVirusLog(this.devNode)) continue;
            moduleNode.setPartSingleSelect(module.isPartSingleSelect());
            moduleNode.setGlobalSingleSelect(module.isCancelNonImmediateFamily());
            String moduleTips = module.getTips();
            if (!StringUtils.isNULLStr((String)moduleTips)) {
                moduleNode.setToolTips(moduleTips);
            }
            moduleNode.setNodeId(module.getModuleId());
            moduleNode.addBondingNodeIds(module.getBondingKey());
            int count = 0;
            for (CollectItem item : module.getItems()) {
                if (ItemConditionTag.checkItemTag(item.getItemConditionTag(), this.devNode)) {
                    log.info("Dev {} item {} meet tag {} ", new Object[]{this.devNode.getIp(), item.getId(), item.getItemConditionTag()});
                    continue;
                }
                moduleNode.add((MutableTreeNode)ItemSelectionCard.getItemNode(module, item));
                ++count;
            }
            if (count == 0) continue;
            this.collectSetupLayout.getItemRootNode().add((MutableTreeNode)moduleNode);
        }
    }

    @NotNull
    private static CheckTreeNode getItemNode(CollectModule module, CollectItem item) {
        CheckTreeNode itemNode = new CheckTreeNode((Object)item, false, true);
        itemNode.setSingleSelect(module.isSingleSelect() || item.isSingleSelect());
        itemNode.setDefaultSelect(item.isDefaultChoose());
        itemNode.setGlobalSingleSelect(item.isCancelNonImmediateFamily() || module.isCancelNonImmediateFamily());
        String itemTips = module.getTips();
        if (!StringUtils.isNULLStr((String)itemTips)) {
            itemNode.setToolTips(itemTips);
        }
        return itemNode;
    }

    private void initCollectConfInfoItem(List<CollectItem> selectItems) {
        Enumeration enumeration = this.collectSetupLayout.getItemRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode)) continue;
            CheckTreeNode currentNode = (CheckTreeNode)CheckTreeNode.class.cast(currentObj);
            if (selectItems.contains(currentNode.getUserObject())) {
                currentNode.setSelected(true);
                continue;
            }
            currentNode.setSelected(false);
        }
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"collect.wizard.step2.title");
    }

    public int getStep() {
        return 1;
    }

    protected ToolWizardDialog.Card getNextCard() {
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Complete.equals((Object)navigation)) {
            return this.saveCollectInfo();
        }
        return true;
    }

    private boolean saveCollectInfo() {
        List<CollectItem> collectItems = this.parseChooseCollectItem();
        if (CollectionUtil.isEmpty(collectItems)) {
            DialogUtils.showErrorDialog((JDialog)this.toolWizardDialog, (String)ResourceUtil.getString((String)"infocollect.remind.onecollectitematleast"));
            return false;
        }
        CollectParam param = ((DstorageCollectParam.DstorageCollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)((DstorageCollectParam.DstorageCollectParamBuilder)DstorageCollectParam.builder().devNode(this.devNode)).selectedScene(this.isSimpleCollect ? ModeType.D_STORAGE_BY_FAULT : ModeType.D_STORAGE_BY_COMPONENT)).selectedItems(collectItems)).duration(this.advancedOptionsPanel.getCurrentDuration())).settingConfInfo(this.advancedOptionsPanel.getSettingInfo())).build();
        CollectInfoBuilder collectInfoBuilder = new CollectInfoBuilder(param);
        IntegrateCollectInfo collectInfo = collectInfoBuilder.buildDStorageCollect();
        CollectDataContext.getInstance().putCollectInfo(this.devNode, collectInfo);
        return true;
    }

    public List<CollectItem> parseChooseCollectItem() {
        if (this.collectSetupLayout.getItemRootNode().getChildCount() == 0) {
            log.info("not support device!!!!!");
            return Collections.emptyList();
        }
        Enumeration enumeration = this.collectSetupLayout.getItemRootNode().preorderEnumeration();
        ArrayList<CollectItem> selectItems = new ArrayList<CollectItem>();
        while (enumeration.hasMoreElements()) {
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode)) continue;
            CheckTreeNode current = (CheckTreeNode)currentObj;
            Object object = current.getUserObject();
            if (!current.isSelected() || !(object instanceof CollectItem)) continue;
            CollectItem collectItem = (CollectItem)object;
            selectItems.add(collectItem);
        }
        return selectItems;
    }
}

