/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card;

import com.huawei.ism.tool.infocollect.ui.card.ItemSelectionCard;
import com.huawei.ism.tool.infocollect.ui.card.NodeSelectionLayout;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.BorderLayout;
import java.awt.Window;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSelectionCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(NodeSelectionCard.class);
    private DevNode devNode;
    private ToolWizardDialog toolWizardDialog;
    private NodeSelectionLayout nodeSelectionLayout;

    public NodeSelectionCard(DevNode devNode, ToolWizardDialog toolWizardDialog, ToolWizardDialog.Card previousCard) {
        super(previousCard, new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Next});
        this.devNode = devNode;
        this.toolWizardDialog = toolWizardDialog;
        this.nodeSelectionLayout = new NodeSelectionLayout(devNode, (JDialog)this.toolWizardDialog);
        this.setLayout(new BorderLayout());
        this.add(this.nodeSelectionLayout, "Center");
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"collect.wizard.step1.title");
    }

    public int getStep() {
        return 0;
    }

    protected ToolWizardDialog.Card getNextCard() {
        return new ItemSelectionCard(this.devNode, this.toolWizardDialog, this, this.nodeSelectionLayout.isSimpleCollect(), this.nodeSelectionLayout.getAdvancedOptionsPanel());
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Next.equals((Object)navigation)) {
            log.info("click next card.");
            return this.hasSelectedNodes() && this.checkFirstAllNodeConfirm() && this.nodeSelectionLayout.getAdvancedOptionsPanel().checkTimeInput((JDialog)this.toolWizardDialog);
        }
        return true;
    }

    private boolean checkFirstAllNodeConfirm() {
        if (!this.devNode.isAllClusterNodeSelect() || InfoCollectUtil.hasRecordDeviceSn(this.devNode.getDeviceSerialNumber())) {
            return true;
        }
        return this.isClickConfirm();
    }

    private boolean isClickConfirm() {
        String msg = ResourceUtil.getStringWithParams((String)"infocollect.first.select.all.node.msg", (Object[])new Object[0]);
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)this.toolWizardDialog, (String)msg);
        return warningDialog.isConfirmClick();
    }

    private boolean hasSelectedNodes() {
        if (this.devNode.getClusterNodes().stream().anyMatch(ClusterNode::isSelected)) {
            return true;
        }
        DialogUtils.showErrorDialog((JDialog)this.toolWizardDialog, (String)ResourceUtil.getString((String)"collect.wizard.no.nodes.checked"));
        return false;
    }
}

