/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card;

import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.util.DStoragePackageUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NodeSelectionLayout
extends JPanel {
    private static final String KEY_IS_SHOW_PATCH_IMPORT = "isShowPatchImport";
    private JRadioButton defaultCollectBtn;
    private JRadioButton simpleCollectBtn;
    private ButtonGroup buttonGroup;
    private JLabel defaultTipLabel = new JLabel(ResourceUtil.getImage((String)"questionMark.png"));
    private JLabel simpleCollectTipLabel = new JLabel(ResourceUtil.getImage((String)"questionMark.png"));
    private AdvancedOptionsPanel advancedOptionsPanel;
    private ToolHyperLinkLabel link = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify"));
    private JComponent modifyCon;
    private boolean isSimpleCollect = true;
    private boolean isSupportSimpleCollect;

    public NodeSelectionLayout(DevNode devNode, JDialog parent) {
        this.isSimpleCollect = this.isSupportSimpleCollect = DStoragePackageUtil.isSupportReduceCollect(devNode);
        BizPackageService bizPackageService = new BizPackageService();
        this.initJRadioBtnGrp(devNode);
        this.advancedOptionsPanel = new AdvancedOptionsPanel(bizPackageService.getSettingConf(devNode), devNode, parent);
        Boolean isShowPatchImport = Boolean.valueOf(CollectConfigParser.getConfigureValue(KEY_IS_SHOW_PATCH_IMPORT, Boolean.FALSE.toString()).trim());
        this.advancedOptionsPanel.hidePatchComponent(isShowPatchImport);
        this.modifyCon = this.createModifyCom();
        JComponent jComponent = this.buildJComponent();
        this.add((Component)jComponent, "North");
        this.initListener(parent, devNode);
    }

    private void initJRadioBtnGrp(DevNode devNode) {
        this.defaultCollectBtn = new JRadioButton();
        this.simpleCollectBtn = new JRadioButton();
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.simpleCollectBtn);
        this.buttonGroup.add(this.defaultCollectBtn);
        this.defaultCollectBtn.setText(ResourceUtil.getString((String)"collect.select.scene.default"));
        this.simpleCollectBtn.setText(ResourceUtil.getString((String)"collect.select.scene.simple"));
        this.defaultTipLabel.setToolTipText(ResourceUtil.getString((String)"collect.card.btn.default"));
        this.simpleCollectTipLabel.setToolTipText(ResourceUtil.getString((String)"collect.card.btn.simple"));
        this.simpleCollectBtn.setVisible(this.isSupportSimpleCollect);
        this.simpleCollectTipLabel.setVisible(this.isSupportSimpleCollect);
        this.initScene(devNode);
    }

    private void initScene(DevNode devNode) {
        if (!this.isSupportSimpleCollect) {
            this.defaultCollectBtn.setSelected(true);
            this.simpleCollectBtn.setSelected(false);
            return;
        }
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(devNode);
        if (collectInfo != null && collectInfo.getCollectConfInfo() != null) {
            this.isSimpleCollect = collectInfo.getCollectConfInfo().isSimpleCollect();
        }
        if (this.isSimpleCollect) {
            this.defaultCollectBtn.setSelected(false);
            this.simpleCollectBtn.setSelected(true);
        } else {
            this.defaultCollectBtn.setSelected(true);
            this.simpleCollectBtn.setSelected(false);
        }
    }

    private JComponent createModifyCom() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.desc")));
        box.add((Component)this.link);
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.dot")));
        JComponent com = UiMethod.buildFrameSpace((JComponent)UCD.buildHBoxLeft((Component[])new Component[]{box}), (int)5);
        com.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.title")));
        if (CollectDataContext.getInstance().isScene() && !CollectDataContext.getInstance().isStorageCollectSec()) {
            this.link.setEnabled(false);
        }
        return com;
    }

    private JComponent buildJComponent() {
        JComponent btnComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(30), this.simpleCollectBtn, this.simpleCollectTipLabel, Box.createHorizontalStrut(20), this.defaultCollectBtn, this.defaultTipLabel, Box.createHorizontalGlue()});
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(10), btnComp, Box.createVerticalGlue(), this.advancedOptionsPanel, Box.createVerticalGlue(), this.modifyCon});
    }

    private void initListener(JDialog parent, DevNode currentNode) {
        this.simpleCollectBtn.addActionListener(event -> {
            this.isSimpleCollect = true;
        });
        this.defaultCollectBtn.addActionListener(event -> {
            this.isSimpleCollect = false;
        });
        this.link.addClickListener((ToolHyperLinkLabel.ClickListener & Serializable)event -> this.modifyApplyByAll(parent, currentNode));
    }

    private void modifyApplyByAll(JDialog parent, DevNode currentNode) {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List<DevNode> devs = CollectDeviceService.getInstance().getAllDevNode();
        ArrayList<DevNode> modifyDevs = new ArrayList<DevNode>();
        for (DevNode devNode : devs) {
            if (!InfoCollectUtil.isSupportDev(devNode) || InfoCollectService.getInstance().isDevNodeCollecting(devNode)) continue;
            modifyDevs.add(devNode);
        }
        idm.showModifyDeviceDialog((Window)parent, true, currentNode.getIp(), EntityUtils.toNewDevList(modifyDevs));
    }

    public AdvancedOptionsPanel getAdvancedOptionsPanel() {
        return this.advancedOptionsPanel;
    }

    public boolean isSimpleCollect() {
        return this.isSimpleCollect;
    }
}

