/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card.storage;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskWithNode;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000NodeSelectionCard;
import com.huawei.ism.tool.infocollect.ui.card.storage.SelectDiskWithNodeListener;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.CollectInfoBuilder;
import com.huawei.ism.tool.infocollect.ui.setup.CollectSetupLayout;
import com.huawei.ism.tool.infocollect.ui.setup.QueryDiskForNodeCallable;
import com.huawei.ism.tool.infocollect.ui.setup.SelectDiskWithNodeDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanStor9000ItemSelectionCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(OceanStor9000ItemSelectionCard.class);
    private static final String DISK_PROCESSING_MSG = "DISK_PROCESSING_MSG";
    private static final String NORMAL_DISK_LOG_COLLECT_ITEM_ID = "normal_disklog";
    private static final int EN_WIDTH = 270;
    private static final int CN_WIDTH = 220;
    private DevNode devNode;
    private ToolWizardDialog toolWizardDialog;
    private CollectSetupLayout collectlayout;
    private AdvancedOptionsPanel advancedOptionsPanel;
    private OceanStor9000NodeSelectionCard oceanStor9000NodeSelectionCard;
    private CheckTreeNode normalDiskLogItemNode;
    private List<DiskWithNode> selectedDiskWithNode = new ArrayList<DiskWithNode>();
    private boolean isUserSelectDiskWithNode = false;

    public OceanStor9000ItemSelectionCard(DevNode devNode, ToolWizardDialog toolWizardDialog, OceanStor9000NodeSelectionCard previousCard, AdvancedOptionsPanel advancedOptionsPanel) {
        super((ToolWizardDialog.Card)previousCard, new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Previous, ToolWizardDialog.Navigation.Complete});
        this.devNode = devNode;
        this.toolWizardDialog = toolWizardDialog;
        this.advancedOptionsPanel = advancedOptionsPanel;
        this.oceanStor9000NodeSelectionCard = previousCard;
        this.collectlayout = new CollectSetupLayout(false, InfoCollectUtil.getDateString(devNode), true, null);
        this.collectlayout.setName("_Panel_collectlayout");
        this.initData();
        this.initListener();
        this.setLayout(new BorderLayout());
        this.add(this.collectlayout, "Center");
    }

    private void initListener() {
        this.collectlayout.getItemTree().addMouseListener((MouseListener)new SelectDiskWithNodeListener(this));
    }

    private void initData() {
        this.initCollectItemTree();
        this.initCollectConfInfoItem(CollectDataContext.getInstance().getCollectInfo(this.devNode).getCollectConfInfo().getSelectItems().stream().distinct().collect(Collectors.toList()));
    }

    private void initCollectItemTree() {
        this.collectlayout.getItemRootNode().removeAllChildren();
        this.attachItemTreeNode();
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectlayout.getItemRootNode(), true);
        this.collectlayout.getItemTree().setModel((TreeModel)newTreeModel);
        this.collectlayout.getItemTree().setRootVisible(true);
        this.collectlayout.getItemTree().setShowsRootHandles(true);
        this.collectlayout.getItemTree().expandAll(true);
    }

    private void attachItemTreeNode() {
        CollectConf currentConf = new BizPackageService().getCollectConf(this.devNode);
        if (currentConf == null) {
            String noSupportDesc = ResourceUtil.getString((String)"infocollect.remind.unsupportdev");
            this.collectlayout.getItemRootNode().setUserObject((Object)noSupportDesc);
            this.collectlayout.getItemRootNode().setToolTips(noSupportDesc);
            return;
        }
        this.collectlayout.getItemRootNode().setUserObject((Object)this.devNode.getIp());
        this.collectlayout.getItemRootNode().setToolTips(this.devNode.getIp());
        currentConf.getModules().forEach(this::buildCheckTreeNode);
    }

    private void buildCheckTreeNode(CollectModule module) {
        CheckTreeNode moduleNode = new CheckTreeNode((Object)module, true, false);
        moduleNode.setPartSingleSelect(module.isPartSingleSelect());
        moduleNode.setGlobalSingleSelect(module.isCancelNonImmediateFamily());
        String moduleTips = module.getTips();
        if (!StringUtils.isNULLStr((String)moduleTips)) {
            moduleNode.setToolTips(moduleTips);
        }
        module.getItems().stream().map(item -> this.creatItemNode(module, (CollectItem)item)).forEach(arg_0 -> moduleNode.add(arg_0));
        this.collectlayout.getItemRootNode().add((MutableTreeNode)moduleNode);
    }

    private CheckTreeNode creatItemNode(CollectModule module, CollectItem item) {
        CheckTreeNode itemNode = new CheckTreeNode((Object)item, false, false);
        itemNode.setSingleSelect(module.isSingleSelect() || item.isSingleSelect());
        itemNode.setDefaultSelect(item.isDefaultChoose());
        itemNode.setGlobalSingleSelect(item.isCancelNonImmediateFamily() || module.isCancelNonImmediateFamily());
        String itemTips = module.getTips();
        if (!StringUtils.isNULLStr((String)itemTips)) {
            itemNode.setToolTips(itemTips);
        }
        itemNode.setSelected(item.isDefaultChoose());
        return itemNode;
    }

    private void initCollectConfInfoItem(List<CollectItem> selectItems) {
        Enumeration enumeration = this.collectlayout.getItemRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode)) continue;
            CheckTreeNode currentNode = (CheckTreeNode)CheckTreeNode.class.cast(currentObj);
            currentNode.setSelected(selectItems.contains(currentNode.getUserObject()));
        }
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"collect.wizard.step2.title");
    }

    public int getStep() {
        return 1;
    }

    protected ToolWizardDialog.Card getNextCard() {
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        log.info("navigation is {}", (Object)navigation.toString());
        if (ToolWizardDialog.Navigation.Complete.equals((Object)navigation)) {
            return this.saveCollectInfo();
        }
        return true;
    }

    private boolean saveCollectInfo() {
        List<CollectItem> collectItems = this.parseChooseCollectItem();
        if (CollectionUtil.isEmpty(collectItems)) {
            DialogUtils.showErrorDialog((JDialog)this.toolWizardDialog, (String)ResourceUtil.getString((String)"infocollect.remind.onecollectitematleast"));
            return false;
        }
        this.saveNormalDiskLog(collectItems);
        List selectNodes = this.advancedOptionsPanel.getClusterNodesTbl().getMarkedRows();
        IntegrateCollectInfo collectInfo = new CollectInfoBuilder(collectItems, selectNodes, this.devNode, this.advancedOptionsPanel).buildOceanStor9000Collect();
        CollectDataContext.getInstance().putCollectInfo(this.devNode, collectInfo);
        return true;
    }

    private void saveNormalDiskLog(List<CollectItem> collectItems) {
        Optional<CollectItem> normalDiskLogItem = collectItems.stream().filter(item -> Objects.equals(NORMAL_DISK_LOG_COLLECT_ITEM_ID, item.getId())).findFirst();
        if (!normalDiskLogItem.isPresent()) {
            log.info("Do not collect normal_disklog.");
            return;
        }
        this.selectAndSaveDisks(collectItems, normalDiskLogItem.get());
    }

    private void selectAndSaveDisks(List<CollectItem> collectItems, CollectItem normalDiskLogItem) {
        if (Utils.isNullList(this.selectedDiskWithNode)) {
            log.info("The number of hard disks is 0. Start collecting hard disks.");
            this.selectDisks(normalDiskLogItem);
        }
        this.saveDisksInfo(collectItems, normalDiskLogItem);
    }

    private void saveDisksInfo(List<CollectItem> collectItems, CollectItem normalDiskLogItem) {
        if (Utils.isNullList(this.selectedDiskWithNode)) {
            log.info("No hard disk is selected.");
            collectItems.remove(normalDiskLogItem);
            return;
        }
        log.info("Selected disk is: {}", this.selectedDiskWithNode);
        CollectDataContext.getInstance().updateGlobalCacheCheckStatus(this.selectedDiskWithNode, this.devNode);
    }

    private void selectDisks(CollectItem collectItem) {
        CheckTreeNode normalDiskLogNode = this.collectlayout.getItemTree().getTreeNodeByUserObj((Object)collectItem);
        if (!InfoCollectUtil.usrConfirmRiskProcedure(ResourceUtil.getString((String)"disk.log.collect.time.tip"))) {
            normalDiskLogNode.setSelected(false);
            return;
        }
        this.setNormalDiskLogItemNode(normalDiskLogNode);
        this.showDiskSelectDialog(true, collectItem);
    }

    public List<CollectItem> parseChooseCollectItem() {
        if (this.collectlayout.getItemRootNode().getChildCount() == 0) {
            log.info("not support device!!!!!");
            return Collections.emptyList();
        }
        ArrayList<CollectItem> selectItems = new ArrayList<CollectItem>();
        Enumeration enumeration = this.collectlayout.getItemRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode)) continue;
            CheckTreeNode current = (CheckTreeNode)currentObj;
            Object object = current.getUserObject();
            if (!current.isSelected() || !(object instanceof CollectItem)) continue;
            selectItems.add((CollectItem)object);
        }
        return selectItems;
    }

    public void showDiskSelectDialog(boolean shouldClearAllChecked, CollectItem item) {
        if (!this.normalDiskLogItemNode.isSelected()) {
            this.setSelectedDiskWithNode(new ArrayList<DiskWithNode>());
            return;
        }
        this.showDiskWithNodeSelectDialog(item, shouldClearAllChecked);
    }

    private void showDiskWithNodeSelectDialog(CollectItem item, boolean shouldClearAllChecked) {
        List<DiskWithNode> cacheDisks = CollectDataContext.getInstance().getGlobalConDiskHashMapForDiskWithNode().get(this.devNode);
        if (Utils.isNullList(cacheDisks)) {
            log.info("no disk with node from cache, try getData ");
            cacheDisks = this.queryDiskWithNodeFromPython(item);
        }
        this.setUserSelectDiskWithNode(false);
        SelectDiskWithNodeDialog dialog = new SelectDiskWithNodeDialog(this.toolWizardDialog, this, cacheDisks, shouldClearAllChecked, ResourceUtil.getString((String)"diskwithnode_highwarn"));
        SwingUtil.putScreenCenter((Window)dialog);
        dialog.setVisible(true);
    }

    private List<DiskWithNode> queryDiskWithNodeFromPython(CollectItem item) {
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(new CollectInfo(this.devNode), false);
        command.process();
        QueryDiskForNodeCallable queryDiskCallable = new QueryDiskForNodeCallable(this.oceanStor9000NodeSelectionCard.getInfoCollectMainDialog(), this.devNode, command.getCollectEnv(), item);
        int loadingBoxWidth = Locale.ENGLISH.equals(ResourceManager.getLocale()) ? 270 : 220;
        List fs = AsyncExcutor.execute((Window)this.toolWizardDialog, (String)ResourceManager.getString((String)DISK_PROCESSING_MSG), (int)loadingBoxWidth, (Callable[])new Callable[]{queryDiskCallable});
        List disks = (List)fs.get(0);
        CollectDataContext.getInstance().getGlobalConDiskHashMapForDiskWithNode().put(this.devNode, disks);
        return disks;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public CollectSetupLayout getCollectlayout() {
        return this.collectlayout;
    }

    public CheckTreeNode getNormalDiskLogItemNode() {
        return this.normalDiskLogItemNode;
    }

    public void setNormalDiskLogItemNode(CheckTreeNode normalDiskLogItemNode) {
        this.normalDiskLogItemNode = normalDiskLogItemNode;
    }

    public List<DiskWithNode> getSelectedDiskWithNode() {
        return this.selectedDiskWithNode;
    }

    public void setSelectedDiskWithNode(List<DiskWithNode> selectedDiskWithNode) {
        this.selectedDiskWithNode = selectedDiskWithNode;
    }

    public boolean isUserSelectDiskWithNode() {
        return this.isUserSelectDiskWithNode;
    }

    public void setUserSelectDiskWithNode(boolean isUserSelectDiskWithNode) {
        this.isUserSelectDiskWithNode = isUserSelectDiskWithNode;
    }
}

