/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card.storage;

import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000ItemSelectionCard;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000NodeSelectionLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.BorderLayout;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanStor9000NodeSelectionCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(OceanStor9000NodeSelectionCard.class);
    private DevNode devNode;
    private InfoCollectMainDialog infoCollectMainDialog;
    private ToolWizardDialog toolWizardDialog;
    private OceanStor9000NodeSelectionLayout nodeSelectionLayout;

    public OceanStor9000NodeSelectionCard(InfoCollectMainDialog parent, DevNode devNode, ToolWizardDialog toolWizardDialog, ToolWizardDialog.Card previousCard) {
        super(previousCard, new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Next});
        this.devNode = devNode;
        this.toolWizardDialog = toolWizardDialog;
        this.infoCollectMainDialog = parent;
        this.nodeSelectionLayout = new OceanStor9000NodeSelectionLayout(devNode, this);
        this.setLayout(new BorderLayout());
        this.add(this.nodeSelectionLayout, "Center");
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"collect.wizard.step1.title");
    }

    public int getStep() {
        return 0;
    }

    protected ToolWizardDialog.Card getNextCard() {
        return new OceanStor9000ItemSelectionCard(this.devNode, this.toolWizardDialog, this, this.nodeSelectionLayout.getAdvancedOptionsPanel());
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        log.info("navigation is {}", (Object)navigation.toString());
        if (ToolWizardDialog.Navigation.Next.equals((Object)navigation)) {
            log.info("click next card. Into the 9000 item selection card.");
            return this.hasSelectedNodes() && this.nodeSelectionLayout.getAdvancedOptionsPanel().checkTimeInput((JDialog)this.toolWizardDialog);
        }
        return true;
    }

    private boolean hasSelectedNodes() {
        if (this.nodeSelectionLayout.getAdvancedOptionsPanel().getClusterNodesTbl().getMarkedRows().size() > 0) {
            return true;
        }
        DialogUtils.showErrorDialog((JDialog)this.toolWizardDialog, (String)ResourceUtil.getString((String)"collect.wizard.no.nodes.checked"));
        return false;
    }

    public InfoCollectMainDialog getInfoCollectMainDialog() {
        return this.infoCollectMainDialog;
    }

    public ToolWizardDialog getToolWizardDialog() {
        return this.toolWizardDialog;
    }
}

