/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card.storage;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.service.QueryNodesInfoTask;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000NodeSelectionCard;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanStor9000NodeSelectionLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(OceanStor9000NodeSelectionLayout.class);
    private static final String KEY_IS_SHOW_PATCH_IMPORT = "isShowPatchImport";
    private AdvancedOptionsPanel advancedOptionsPanel;
    private ToolHyperLinkLabel link = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify"));
    private JComponent modifyCon;

    public OceanStor9000NodeSelectionLayout(DevNode devNode, OceanStor9000NodeSelectionCard parent) {
        InfoCollectMainDialog infoCollectMainDialog = parent.getInfoCollectMainDialog();
        this.advancedOptionsPanel = new AdvancedOptionsPanel(this.waitingForQueryNodesInfo(infoCollectMainDialog, devNode), devNode, infoCollectMainDialog);
        Boolean isShowPatchImport = Boolean.valueOf(CollectConfigParser.getConfigureValue(KEY_IS_SHOW_PATCH_IMPORT, Boolean.FALSE.toString()).trim());
        this.advancedOptionsPanel.hidePatchComponent(isShowPatchImport);
        this.modifyCon = this.createModifyCom();
        JComponent jComponent = this.buildJComponent();
        this.add((Component)jComponent, "North");
        this.initListener((JDialog)parent.getToolWizardDialog(), devNode);
    }

    private SettingConfInfo waitingForQueryNodesInfo(InfoCollectMainDialog parent, DevNode devNode) {
        ProgressDialog progressDialog = new ProgressDialog((Window)parent);
        QueryNodesInfoTask queryNodesInfoTask = new QueryNodesInfoTask(progressDialog, devNode);
        Future queryNodesInfoFuture = AsyncExcutor.submit((Callable)queryNodesInfoTask);
        progressDialog.setVisible(true);
        try {
            return (SettingConfInfo)queryNodesInfoFuture.get();
        }
        catch (InterruptedException e) {
            log.error("query nodes info get InterruptedException: ", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("query nodes info get ExecutionException:", (Throwable)e);
        }
        return queryNodesInfoTask.getSettingConfInfo();
    }

    private JComponent createModifyCom() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.desc")));
        box.add((Component)this.link);
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.dot")));
        JComponent com = UiMethod.buildFrameSpace((JComponent)UCD.buildHBoxLeft((Component[])new Component[]{box}), (int)5);
        com.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.title")));
        if (CollectDataContext.getInstance().isScene() && !CollectDataContext.getInstance().isStorageCollectSec()) {
            this.link.setEnabled(false);
        }
        return com;
    }

    private JComponent buildJComponent() {
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(10), Box.createVerticalGlue(), this.advancedOptionsPanel, Box.createVerticalGlue(), this.modifyCon});
    }

    private void initListener(JDialog parent, DevNode currentNode) {
        this.link.addClickListener((ToolHyperLinkLabel.ClickListener & Serializable)event -> this.modifyApplyByAll(parent, currentNode));
    }

    private void modifyApplyByAll(JDialog parent, DevNode currentNode) {
        List modifyDevs = CollectDeviceService.getInstance().getAllDevNode().stream().filter(this::canModifyDev).collect(Collectors.toList());
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        idm.showModifyDeviceDialog((Window)parent, true, currentNode.getIp(), EntityUtils.toNewDevList(modifyDevs));
    }

    private boolean canModifyDev(DevNode devNode) {
        return InfoCollectUtil.isSupportDev(devNode) && !InfoCollectService.getInstance().isDevNodeCollecting(devNode);
    }

    public AdvancedOptionsPanel getAdvancedOptionsPanel() {
        return this.advancedOptionsPanel;
    }
}

