/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.card.storage;

import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000ItemSelectionCard;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDiskWithNodeListener
extends MouseAdapter {
    private static final Logger log = LoggerFactory.getLogger(SelectDiskWithNodeListener.class);
    private static final String NORMAL_DISK_LOG_COLLECT_ITEM_ID = "normal_disklog";
    private final OceanStor9000ItemSelectionCard oceanStor9000ItemSelectionCard;

    @Override
    public void mouseClicked(MouseEvent event) {
        if (!(this.oceanStor9000ItemSelectionCard.getCollectlayout().getItemTree().getLastSelectedPathComponent() instanceof CheckTreeNode)) {
            log.error("The selected node is not a CheckTreeNode.");
            return;
        }
        CheckTreeNode node = (CheckTreeNode)this.oceanStor9000ItemSelectionCard.getCollectlayout().getItemTree().getLastSelectedPathComponent();
        Object clickObj = node.getUserObject();
        if (clickObj == null || !(clickObj instanceof CollectItem)) {
            log.info("Click object is not collect item object, ignored.");
            return;
        }
        CollectItem ci = (CollectItem)clickObj;
        if (Objects.equals(NORMAL_DISK_LOG_COLLECT_ITEM_ID, ci.getId())) {
            this.oceanStor9000ItemSelectionCard.setNormalDiskLogItemNode(node);
            this.settingHardDisks(node, ci);
        }
    }

    private void settingHardDisks(CheckTreeNode node, CollectItem item) {
        boolean shouldShowHighWarning = true;
        if (!StringUtils.isNULLStr((String)item.getCollectDiskWithNode()) && "Y".equalsIgnoreCase(item.getCollectDiskWithNode())) {
            shouldShowHighWarning = node.isSelected();
        }
        if (shouldShowHighWarning && !InfoCollectUtil.usrConfirmRiskProcedure(ResourceUtil.getStringWithParams((String)"disk.log.collect.time.tip", (Object[])new Object[0]))) {
            this.oceanStor9000ItemSelectionCard.getNormalDiskLogItemNode().setSelected(!node.isSelected());
            return;
        }
        this.oceanStor9000ItemSelectionCard.showDiskSelectDialog(false, item);
    }

    public SelectDiskWithNodeListener(OceanStor9000ItemSelectionCard oceanStor9000ItemSelectionCard) {
        this.oceanStor9000ItemSelectionCard = oceanStor9000ItemSelectionCard;
    }
}

