/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.main;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.entity.ProductConf;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.implement.NodeObserver;
import com.huawei.ism.tool.infocollect.service.InfoCollectNodeQuery;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainLayout;
import com.huawei.ism.tool.infocollect.ui.main.InfoCollectINodeSupport;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceAddListener
extends MouseAdapter {
    private InfoCollectMainDialog dialog;
    private InfoCollectMainLayout layout;

    public DeviceAddListener(InfoCollectMainDialog dialog, InfoCollectMainLayout layout) {
        this.dialog = dialog;
        this.layout = layout;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.layout.getAddDeviceLabel().isEnabled()) {
            return;
        }
        DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)new NodeObserver(this.layout, this.dialog));
        List<DeviceType> supportDevTypes = this.getSupports();
        InfoCollectNodeQuery nodeTypeQuery = this.createNodeytpeQuery(supportDevTypes);
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicatebyupgrade");
        DeviceManageSetting setting = new DeviceManageSetting(true, true, true);
        this.initDeviceAddDialogData(setting);
        this.setAddDialogVisible(nodeTypeQuery, tips, setting);
    }

    private InfoCollectNodeQuery createNodeytpeQuery(List<DeviceType> supportDevTypes) {
        InfoCollectNodeQuery nodeTypeQuery = new InfoCollectNodeQuery(supportDevTypes, new InfoCollectINodeSupport(this), ShowSysConstans.getShowSysCmds());
        nodeTypeQuery.setExcludeDevTypes(this.getExcludeTypes());
        nodeTypeQuery.setCheckMap(this.getSupportModelVersions());
        return nodeTypeQuery;
    }

    private void setAddDialogVisible(InfoCollectNodeQuery nodeTypeQuery, DeviceAddDialog.InfoTips tips, DeviceManageSetting setting) {
        DeviceAddDialog deviceAddDialog = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isOEM() || !ApplicationContext.getInstance().isWindowsOS() ? new DeviceAddDialog((Window)this.dialog, (INodeTypeQuery)nodeTypeQuery, tips, DeviceDialogType.StorageOnly, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward}) : new DeviceAddDialog((Window)this.dialog, (INodeTypeQuery)nodeTypeQuery, tips, setting, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        if (!ApplicationContext.getInstance().isJunit()) {
            deviceAddDialog.setVisible(true);
        }
    }

    private void initDeviceAddDialogData(DeviceManageSetting setting) {
        LinkedList<ItDeviceType> itDeviceList = new LinkedList<ItDeviceType>();
        itDeviceList.add(ItDeviceType.Storage);
        itDeviceList.add(ItDeviceType.T3000);
        itDeviceList.add(ItDeviceType.Switch);
        itDeviceList.add(ItDeviceType.FUSIONCUBE);
        HashMap deviceTypel2 = new HashMap();
        LinkedList<String> strList = new LinkedList<String>();
        strList.add("Linux");
        LinkedList<String> strSNSList = new LinkedList<String>();
        strSNSList.add("IP Scale-Out");
        deviceTypel2.put(ItDeviceType.Switch, strSNSList);
        deviceTypel2.put(ItDeviceType.T3000, strList);
        deviceTypel2.put(ItDeviceType.Storage, null);
        deviceTypel2.put(ItDeviceType.FUSIONCUBE, null);
        setting.setItDeviceList(itDeviceList);
        setting.setDeviceTypel2(deviceTypel2);
    }

    public List<DeviceType> getSupports() {
        ArrayList<DeviceType> supports = new ArrayList<DeviceType>();
        Set<PackageConf> confs = InfoConfiguration.getInstance().getPackageConfs();
        for (PackageConf conf : confs) {
            List<ProductConf> productConfs = conf.getProductConfigs();
            ArrayList<String> typesList = new ArrayList<String>();
            for (ProductConf productConf : productConfs) {
                typesList.addAll(productConf.getSupportProductVersion());
            }
            for (String type : typesList) {
                supports.add(DeviceType.valueOf((String)type));
            }
        }
        return supports;
    }

    public List<DeviceType> getExcludeTypes() {
        ArrayList<DeviceType> excludeTyps = new ArrayList<DeviceType>();
        Set<PackageConf> confs = InfoConfiguration.getInstance().getPackageConfs();
        for (PackageConf conf : confs) {
            List<ProductConf> productConfs = conf.getProductConfigs();
            ArrayList<String> typesList = new ArrayList<String>();
            for (ProductConf productConf : productConfs) {
                typesList.addAll(productConf.getExcludeProductVersion());
            }
            for (String type : typesList) {
                excludeTyps.add(DeviceType.valueOf((String)type));
            }
        }
        return excludeTyps;
    }

    public Map<DeviceType, String> getSupportModelVersions() {
        HashMap<DeviceType, String> typeMap = new HashMap<DeviceType, String>();
        Set<PackageConf> confs = InfoConfiguration.getInstance().getPackageConfs();
        for (PackageConf conf : confs) {
            List<SupportVersionConf> versionConfs = conf.getVersionConfigs();
            for (SupportVersionConf versionConf : versionConfs) {
                typeMap.put(DeviceType.valueOf((String)versionConf.getModelVersion()), versionConf.getScript());
            }
        }
        return typeMap;
    }
}

