/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.main;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.util.FilesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirSetupButtonListener
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirSetupButtonListener.class);
    private InfoCollectMainDialog dialog;

    public DirSetupButtonListener(InfoCollectMainDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String path;
        String defaultPath = InfoCollectDirPropertiesUtil.getProperty();
        if (SceneUtils.isScene()) {
            HibernateContainer.getInstance().put("info.collect.directory", (Object)defaultPath);
        }
        if (CollectDataContext.getInstance().isCollecting()) {
            DialogUtils.showErrorDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.nochangewhencollecting"));
            return;
        }
        String[] exts = new String[]{};
        File file = ToolFileChooser.selectFile((Window)this.dialog, (String)ResourceUtil.getString((String)"infocollect.set.directory.title"), (String[])exts, (String)"info.collect.directory", (String)ResourceUtil.getString((String)"infocollect.folder"), (int)1);
        if (file == null) {
            return;
        }
        try {
            LOGGER.info("Change collection directory >> {} -> {} ][Success", (Object)defaultPath, (Object)file.getCanonicalPath());
            path = file.getCanonicalPath();
        }
        catch (IOException e1) {
            LOGGER.error("save collect dir failed!!!", (Throwable)e1);
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.dirchangefail"));
            return;
        }
        if (!FilesUtil.checkNormalPath(path)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.dirchangefail.character"));
            this.actionPerformed(actionEvent);
            return;
        }
        if (!FilesUtil.checkBlankPath(path)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.dirchangefail.noblank"));
            this.actionPerformed(actionEvent);
            return;
        }
        try {
            InfoCollectDirPropertiesUtil.setProperty(path);
            InfoCollectDirPropertiesUtil.setUseSceneEnvPath(false);
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.dirchangesuccess"));
        }
        catch (Exception ex) {
            LOGGER.error("save collect dir failed!!!", (Throwable)ex);
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.dirchangefail"));
        }
    }
}

