/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.main;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.main.DeviceAddListener;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import utils.Products;

public class InfoCollectINodeSupport
implements INodeSupport {
    private DeviceAddListener deviceAdd;

    public InfoCollectINodeSupport(DeviceAddListener deviceAdd) {
        this.deviceAdd = deviceAdd;
    }

    public boolean isNodeSupport(DevNode dev) {
        List<DeviceType> excludeDevTypes;
        List<DeviceType> supportDevTypes;
        Map<DeviceType, String> checkMap = this.deviceAdd.getSupportModelVersions();
        boolean isSupport = this.isDeviceTypeSupport(dev, checkMap, supportDevTypes = this.deviceAdd.getSupports(), excludeDevTypes = this.deviceAdd.getExcludeTypes());
        return isSupport || dev.isDstorage();
    }

    private boolean isDeviceTypeSupport(DevNode dev, Map<DeviceType, String> checkMap, List<DeviceType> supportDevTypes, List<DeviceType> excludeDevTypes) {
        boolean isSupport = true;
        if (!(isSupport = this.checkT3000ByScript(dev, checkMap, isSupport))) {
            return isSupport;
        }
        String tempType = dev.getDeviceType() + " " + dev.getProductVersion();
        Set<Map.Entry<DeviceType, String>> entrys = checkMap.entrySet();
        for (Map.Entry<DeviceType, String> entry : entrys) {
            if (!tempType.contains(entry.getKey().toString())) continue;
            isSupport = this.checkStorageVersionByScript(dev, entry.getValue());
            break;
        }
        if (!isSupport) {
            return isSupport;
        }
        for (DeviceType devTpye : excludeDevTypes) {
            if (!tempType.toLowerCase(Locale.US).contains(devTpye.toString().toLowerCase(Locale.US).trim())) continue;
            return false;
        }
        for (DeviceType devType : supportDevTypes) {
            String temp = this.checkSpace(devType.toString());
            if (!Products.containsIgnoreCase((String)tempType.toLowerCase(Locale.US), (String)temp.toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private boolean checkStorageVersionByScript(DevNode dev, String scriptPath) {
        HashMap<String, DevNode> paramMap = new HashMap<String, DevNode>();
        paramMap.put("dev", dev);
        File pyFile = new File(scriptPath);
        try {
            JythonExecuter jythonExecuter = new JythonExecuter();
            jythonExecuter.compileScript(pyFile);
            Object ret = jythonExecuter.simpleInvokeFunction("execute", paramMap);
            return (Boolean)ret;
        }
        catch (SignException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("SignException.");
            return true;
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("py file {} is not exists.", (Object)pyFile.getName());
            return true;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.");
            return true;
        }
    }

    private boolean checkT3000ByScript(DevNode dev, Map<DeviceType, String> checkMap, boolean isSupport) {
        if (ItDeviceType.T3000.equals((Object)dev.getItDeviceType())) {
            String tempType = (dev.getDeviceName() + " " + dev.getDeviceType()).toLowerCase(Locale.US);
            List<Object> pyInfo = this.getPyInfo(dev, checkMap, tempType);
            return this.checkT300(dev, isSupport, pyInfo);
        }
        return isSupport;
    }

    private List<Object> getPyInfo(DevNode dev, Map<DeviceType, String> checkMap, String tempType) {
        String script = null;
        Set<Map.Entry<DeviceType, String>> entries = checkMap.entrySet();
        List<Object> pyInfo = null;
        for (Map.Entry<DeviceType, String> entry : entries) {
            if (!tempType.contains(entry.getKey().toString().toLowerCase(Locale.US))) continue;
            script = tempType;
            pyInfo = this.checkVersionByScript(dev, entry.getValue());
            break;
        }
        if (script == null) {
            ToolLoggerFactory.getLogger(this.getClass()).info("supportloic script is null.devide type is:" + dev.getDeviceType());
        }
        return pyInfo;
    }

    private boolean checkT300(DevNode dev, boolean isSupport, List<Object> pyInfo) {
        if (pyInfo != null) {
            boolean supportResult = (Boolean)pyInfo.get(0);
            this.checkSupport(dev, supportResult, pyInfo);
            return supportResult;
        }
        return isSupport;
    }

    private void checkSupport(DevNode dev, boolean isSupport, List<Object> pyInfo) {
        if (isSupport) {
            CollectDataContext.getInstance().addT3000ShownName(EntityUtils.toOldDev((DevNode)dev), (String)pyInfo.get(1));
        } else if (pyInfo.size() > 1) {
            dev.setErrorDecs((String)pyInfo.get(1));
        }
    }

    public List<Object> checkVersionByScript(DevNode dev, String scriptPath) {
        try {
            ICliConnection con = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)dev), null, (boolean)true, (boolean)true);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
            paramMap.put("lang", language);
            paramMap.put("dev", (String)dev);
            paramMap.put("ssh", (String)con);
            try {
                JythonExecuter jythonExecuter = new JythonExecuter();
                File pyFile = new File(scriptPath);
                jythonExecuter.compileScript(pyFile);
                List ret = (List)jythonExecuter.simpleInvokeFunction("execute", paramMap);
                return ret;
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("py file is not exists.");
                return null;
            }
            catch (SignException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error(" ", (Throwable)e);
                return null;
            }
            catch (ToolException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.");
                return null;
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.", (Throwable)e);
                return null;
            }
        }
        catch (ToolException e1) {
            ToolLoggerFactory.getLogger(this.getClass()).error("DefaultNodeTypeQuery.queryNodeInfo() error normal", (Object)e1.getMessage());
            return null;
        }
    }

    private String checkSpace(String model) {
        byte[] tempByte = new byte[model.length()];
        int i = 0;
        int findCount = 0;
        int modelLen = model.getBytes(Charset.defaultCharset()).length;
        for (int index = 0; index < modelLen; ++index) {
            byte b = model.getBytes(Charset.defaultCharset())[index];
            if (b != 92) {
                tempByte[i] = b;
            } else if (index < modelLen && 115 == model.getBytes(Charset.defaultCharset())[index + 1]) {
                tempByte[i] = 32;
                ++index;
                ++findCount;
            }
            ++i;
        }
        return new String(tempByte, 0, tempByte.length - findCount, Charset.defaultCharset());
    }
}

