/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.main;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCons;
import com.huawei.ism.tool.infocollect.ui.main.SupportDevDetailDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowSupportDevLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ShowSupportDevLayout.class);
    private static final long serialVersionUID = -1866574799462546098L;
    private static final String KEY_WHITE_LIST = "whitelist";
    private static final String KEY_BLACK_LIST = "blacklist";
    private static final String ALL_VERSION_STRING = "ALL";
    private static final String VER_REGEX = "V\\d{3}R\\d{3}";
    private static final String VER_REGEX_NEW = "[\\d]{1,4}\\.[\\d]{1,4}\\.[a-zA-Z0-9]{1,14}(\\.[a-zA-Z0-9]{1,8})?(\\.[a-zA-Z0-9]{4})?";
    private String[] tableColumn = new String[]{ResourceUtil.getString((String)"infocollect.selectdevice.support.devmodel"), ResourceUtil.getString((String)"infocollect.selectdevice.support.devversion"), ResourceUtil.getString((String)"infocollect.selectdevice.support.devdetail")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.tableColumn, new int[0]);
    private IsmTable devListTable = new IsmTable((TableModel)this.tableModel);
    private TableScrollPane tableScrollPane = new TableScrollPane(false, true, false, this.devListTable);
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.selectdevice.support.closebtn"), (char)'C');
    private final List<String> linuxSupportDevices = Arrays.asList(CollectConfigParser.getConfigureValue("linuxSupportDeviceModels", "").trim().split(","));

    public ShowSupportDevLayout() {
        this(new BizPackageService().getSupportProductsWitchVersion());
    }

    public ShowSupportDevLayout(Set<String> vers) {
        this.setLayout(new BorderLayout());
        JLabel suggestion = new JLabel(ResourceUtil.getString((String)"infocollect.selectdevice.support.suggestion"));
        TableScrollPane tempTableScrollPane = new TableScrollPane(false, true, false, new IsmTable((TableModel)this.tableModel));
        JComponent vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)suggestion), tempTableScrollPane, UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)vBox, (int)12), "Center");
        this.initData(vers);
    }

    private void initData(Set<String> deviceInfo) {
        if (SceneUtils.isA800UpgradeCheck()) {
            log.info("init a800 upgrade support devices data.");
            this.initA800UpgradeTableData(deviceInfo);
            return;
        }
        if (!InfoCollectUtil.isSupportA800Scene()) {
            log.info("init support devices data.");
            this.initTableData(deviceInfo);
            return;
        }
        log.info("init a800 support devices data.");
        this.initA800TableData(deviceInfo);
    }

    private void initA800UpgradeTableData(Set<String> deviceInfo) {
        Map<String, List<String>> supportModelTypes = this.getModelTypes(deviceInfo);
        if (!supportModelTypes.containsKey(ItDeviceType.A800_NODE.getName())) {
            log.error("The supportModelTypes does not contain OceanStor A800.");
            return;
        }
        this.addOneRow(supportModelTypes, ItDeviceType.A800_NODE.getName());
    }

    private void initA800TableData(Set<String> deviceInfo) {
        Map<String, List<String>> supportModelTypes = this.getModelTypes(deviceInfo);
        if (!supportModelTypes.containsKey(ItDeviceType.A800_NODE.getName()) && !supportModelTypes.containsKey(ItDeviceType.A800_OM.getName())) {
            log.error("The supportModelTypes does not contain OceanStor A800.");
            return;
        }
        TaskCons.A800_NODES_DEVICE_TYPE.forEach(type -> this.addOneRow(supportModelTypes, (String)type));
    }

    @NotNull
    private void addOneRow(Map<String, List<String>> supportModelTypes, String type) {
        List<String> versions = supportModelTypes.get(type);
        this.sortVersions(versions);
        HashMap<String, List<String>> versionMap = new HashMap<String, List<String>>();
        versionMap.put(KEY_WHITE_LIST, versions);
        DefaultTableRow row = new DefaultTableRow(this.tableColumn.length, (Object)type);
        row.setValueAt(0, (Object)type);
        row.setValueAt(1, (Object)StringUtils.deleteFirstLast((String)versions.toString()));
        row.setValueAt(2, (Object)this.createHyperlinkCell(versionMap));
        this.tableModel.addRow(new TableRow[]{row});
    }

    private void initTableData(Set<String> vers) {
        Map<String, List<String>> supportModelTypes = this.getModelTypes(vers);
        TaskCons.A800_NODES_DEVICE_TYPE.forEach(supportModelTypes::remove);
        Set<String> excludeVers = new BizPackageService().getExcludeProductsWitchVersion();
        Map<String, List<String>> excludeModelTypes = this.getModelTypes(excludeVers);
        Set<SupportVersionConf> versionConf = new BizPackageService().getSupportVersionConfs();
        ArrayList<String> keySet = new ArrayList<String>(supportModelTypes.keySet());
        Collections.sort(keySet);
        for (String model : keySet) {
            if ("--".equals(model) || !this.checkDeviceConformingScene(model)) {
                log.info("{} is not applicable to the current scenario.", (Object)model);
                continue;
            }
            DefaultTableRow row = new DefaultTableRow(this.tableColumn.length, (Object)model);
            List<String> supportVer = supportModelTypes.get(model);
            this.sortVersions(supportVer);
            List<String> excludeVer = excludeModelTypes.get(model);
            this.sortVersions(excludeVer);
            int i = 0;
            if ("Red Hat,SUSE".contains(model)) {
                model = "T3000-" + model;
            }
            row.setValueAt(i++, (Object)model);
            Map<String, List<String>> detailedVers = this.putVersion2Map(model, supportVer, versionConf, excludeVer);
            if ("[]".equals(supportVer.toString())) {
                ArrayList<String> allVer = new ArrayList<String>();
                allVer.add(ALL_VERSION_STRING);
                detailedVers.put(KEY_WHITE_LIST, allVer);
                row.setValueAt(i++, (Object)ALL_VERSION_STRING);
                row.setValueAt(i++, (Object)this.createHyperlinkCell(detailedVers));
            } else {
                row.setValueAt(i++, (Object)StringUtils.deleteFirstLast((String)supportVer.toString()));
                row.setValueAt(i++, (Object)(detailedVers.isEmpty() ? "" : this.createHyperlinkCell(detailedVers)));
            }
            this.tableModel.addRow(new TableRow[]{row});
        }
        this.initExtendVersion();
    }

    private void initExtendVersion() {
        Map<String, String> versionMap = BizPackageService.loadExtendSysconf();
        if (versionMap == null || versionMap.isEmpty()) {
            return;
        }
        for (String name : versionMap.keySet()) {
            if (!this.checkDeviceConformingScene(name)) {
                log.info("{} is not applicable to the current scenario.", (Object)name);
                continue;
            }
            String ver = versionMap.get(name);
            DefaultTableRow row = new DefaultTableRow(this.tableColumn.length, (Object)name);
            HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
            ArrayList<String> versions = new ArrayList<String>();
            versions.add(ver);
            verionMap.put(KEY_WHITE_LIST, versions);
            row.setValueAt(0, (Object)name);
            row.setValueAt(1, (Object)ver);
            row.setValueAt(2, (Object)this.createHyperlinkCell(verionMap));
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private boolean checkDeviceConformingScene(String devModel) {
        log.info("Scenario matching is being performed for the {}", (Object)devModel);
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            return !StringUtils.isNULLStr((String)devModel) && this.linuxSupportDevices.contains(devModel);
        }
        return true;
    }

    private void sortVersions(List<String> vers) {
        if (null != vers) {
            Collections.sort(vers, new SortVersionsComparator());
        }
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    private IsmTableCell.HyperlinkCell createHyperlinkCell(Map<String, List<String>> detailedVersions) {
        return new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infocollect.selectdevice.support.view"), (ActionListener)new HyperlinkCellListener(detailedVersions));
    }

    private Map<String, List<String>> putVersion2Map(String model, List<String> baseVersion, Set<SupportVersionConf> versionConf, List<String> blacklistVersion) {
        boolean isEngEnv = ApplicationContext.getInstance().isEnglishEnv();
        HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
        ArrayList<String> detailedVersions = new ArrayList<String>();
        for (SupportVersionConf version : versionConf) {
            if (!model.equals(version.getModel())) continue;
            String desc = isEngEnv ? version.getDescEn() : version.getDescZh();
            Collections.addAll(detailedVersions, desc.split(","));
        }
        detailedVersions.addAll(this.filterVersions(baseVersion, detailedVersions));
        this.sortVersions(detailedVersions);
        verionMap.put(KEY_WHITE_LIST, detailedVersions);
        ArrayList<String> blacklist = new ArrayList<String>();
        if (null != blacklistVersion && !blacklistVersion.isEmpty()) {
            blacklist.addAll(blacklistVersion);
            this.sortVersions(blacklist);
            verionMap.put(KEY_BLACK_LIST, blacklist);
        }
        return verionMap;
    }

    private List<String> filterVersions(List<String> baseVersion, List<String> whitelist) {
        return this.filterOutSupportVersion(baseVersion, whitelist);
    }

    private List<String> filterOutSupportVersion(List<String> baseVersion, List<String> whitelist) {
        ArrayList<String> templist = new ArrayList<String>();
        templist.addAll(baseVersion);
        block0: for (String base : baseVersion) {
            for (String white : whitelist) {
                if (!white.contains(base)) continue;
                templist.remove(base);
                continue block0;
            }
        }
        return templist;
    }

    private Map<String, List<String>> getModelTypes(Set<String> vers) {
        HashMap<String, List<String>> modelTypes = new HashMap<String, List<String>>();
        for (String ver : vers) {
            String matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX, (int)0);
            String version = "";
            if (StringUtils.isNULLStr((String)matchStr)) {
                matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX_NEW, (int)0);
                if (!StringUtils.isNULLStr((String)matchStr)) {
                    version = ver.substring(ver.indexOf(matchStr)).trim();
                } else {
                    String[] types = ver.split(" ");
                    if (types.length > 1) {
                        version = types[types.length - 1].trim();
                    }
                }
            } else {
                version = ver.substring(ver.indexOf(matchStr)).trim();
            }
            String model = ver.replace(version, "").trim();
            model = this.checkSpace(model);
            version = this.checkSpace(version);
            if (modelTypes.containsKey(model)) {
                ((List)modelTypes.get(model)).add(version);
                continue;
            }
            ArrayList<String> verions = new ArrayList<String>();
            verions.add(version);
            modelTypes.put(model, verions);
        }
        return modelTypes;
    }

    private String checkSpace(String model) {
        byte[] tempByte = new byte[model.length()];
        int i = 0;
        int findCount = 0;
        int modelLen = model.getBytes(Charset.defaultCharset()).length;
        for (int index = 0; index < modelLen; ++index) {
            byte b = model.getBytes(Charset.defaultCharset())[index];
            if (b != 92) {
                tempByte[i] = b;
            } else if (index < modelLen && 115 == model.getBytes(Charset.defaultCharset())[index + 1]) {
                tempByte[i] = 32;
                ++index;
                ++findCount;
            }
            ++i;
        }
        return new String(tempByte, 0, tempByte.length - findCount, Charset.defaultCharset());
    }

    static class HyperlinkCellListener
    implements ActionListener {
        Map<String, List<String>> detailedVersions;

        public HyperlinkCellListener(Map<String, List<String>> detailedVersions) {
            this.detailedVersions = detailedVersions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SupportDevDetailDialog detailDialog = new SupportDevDetailDialog(this.detailedVersions);
            detailDialog.setVisible(true);
        }
    }

    static class SortVersionsComparator<String>
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SortVersionsComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return Collator.getInstance().compare(s1, s2);
        }
    }
}

