/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.parser;

import com.huawei.ism.tool.infocollect.entity.IntegrateNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IntegrateXmlParser {
    private static final String ROOT_NODE = "<devices>";
    private static final String ROOT_END_NODE = "</devices>";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String IP = "ip";
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrateXmlParser.class);
    private Document document = null;
    private boolean initResult = false;
    private DevNode mainDevNode = null;

    public IntegrateXmlParser(DevNode mainDevNode) {
        this.mainDevNode = mainDevNode;
    }

    public boolean init(String xmlString) {
        String xml = xmlString;
        try {
            int indexXML = xml.indexOf(ROOT_NODE);
            if (indexXML == -1) {
                throw new ToolException("invaliable xml string");
            }
            if ((indexXML = (xml = xml.substring(indexXML)).indexOf(ROOT_END_NODE)) == -1) {
                throw new ToolException("invaliable xml string");
            }
            xml = xml.substring(0, indexXML + ROOT_END_NODE.length()).replaceAll("\r", "").replaceAll("\n", "").replaceAll("  ", "");
            this.document = XmlUtils.parseDocument((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            this.initResult = true;
        }
        catch (RuntimeException e) {
            LOGGER.error("init xml parser error,the file is:" + xml, (Object)e.getMessage());
            this.initResult = false;
        }
        catch (Exception e) {
            LOGGER.error("init xml parser error,the file is:" + xml, (Object)e.getMessage());
            this.initResult = false;
        }
        return this.initResult;
    }

    public IntegrateNode parse() {
        IntegrateNode rootNode = new IntegrateNode();
        ArrayList<IntegrateNode> integrateNodeList = new ArrayList<IntegrateNode>();
        Element root = this.document.getDocumentElement();
        NodeList nodeList = root.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            IntegrateNode node = this.parseIntegrateNode((Element)nodeList.item(index));
            integrateNodeList.add(node);
        }
        rootNode.setSubNodes(integrateNodeList);
        rootNode.setNodeIP(this.mainDevNode.getIp());
        return rootNode;
    }

    private IntegrateNode parseIntegrateNode(Element nodeElement) {
        IntegrateNode integrateNode = new IntegrateNode();
        ArrayList<IntegrateNode> integrateNodeList = new ArrayList<IntegrateNode>();
        String name = nodeElement.getAttribute(NAME);
        String type = nodeElement.getAttribute(TYPE);
        String ip = nodeElement.getAttribute(IP);
        NodeList nodeList = nodeElement.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            IntegrateNode node = this.parseIntegrateNode((Element)nodeList.item(index));
            integrateNodeList.add(node);
        }
        integrateNode.setNodeName(name);
        integrateNode.setNodeType(type);
        integrateNode.setNodeIP(ip);
        integrateNode.setSubNodes(integrateNodeList);
        return integrateNode;
    }
}

