/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.entity.SettingParserInfo;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.DateChooseField;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.ui.PatchComponent;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedOptionsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(AdvancedOptionsPanel.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AdvancedOptionsPanel.class);
    private static final long serialVersionUID = 2801787505888923784L;
    private static final Dimension LABEL_SIZE = new Dimension(100, 21);
    private static final Dimension FIELD_SIZE = new Dimension(200, 21);
    private static final Dimension FILE_FIELD_SIZE = new Dimension(220, 21);
    private static final String TYPE_DATE = "date";
    private static final String TYPE_INPUT = "input";
    private static final String TYPE_LIST = "list";
    private static final String TYPE_TABLE = "table";
    private static JButton addBtn;
    private static JButton delBtn;
    private static JList locList;
    private static JList selectList;
    private static DefaultListModel listModel;
    private transient SettingConfInfo settingInfo;
    private transient SettingConfInfo preSettingInfo;
    private transient CollectDuration duration = null;
    private JTextField field;
    private DateChooseField startTime;
    private DateChooseField endTime;
    private TableScrollPane nodesScroll = null;
    private IsmTable clusterNodesTbl = null;
    private DefaultTableModel clusterNodesTblModel = null;
    private DevNode devNode;
    private JDialog dialog;
    private PatchComponent patchComponent;
    private List<DstoragePatchInfo.Type> support = Arrays.asList(DstoragePatchInfo.Type.COLLECT);

    public AdvancedOptionsPanel(SettingConfInfo settingInfo, DevNode devNode, JDialog dialog) {
        this.settingInfo = settingInfo;
        this.devNode = devNode;
        this.patchComponent = new PatchComponent((Window)dialog, this.support, false);
        this.patchComponent.setCurrentNode(devNode);
        this.dialog = dialog;
        this.setPreSettingInfo();
        this.initUI();
    }

    public boolean isTimeEmpty() {
        return this.getStartTime().getText().isEmpty() || this.getEndTime().getText().isEmpty();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)this.createScollPanel(), (int)12), "Center");
        this.patchComponent.getPathField().setPreferredSize(FILE_FIELD_SIZE);
    }

    private void setPreSettingInfo() {
        CollectDataContext context = CollectDataContext.getInstance();
        Map<DevNode, CollectInfo> collectInfo = context.getCollectInfo(this.devNode).getCollectInfoes();
        this.preSettingInfo = collectInfo.get(this.devNode).getSettingConfInfo();
    }

    private JComponent createScollPanel() {
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)this.createInfoPanel(), "North");
        JScrollPane srollPanel = new JScrollPane(listPanel);
        srollPanel.setHorizontalScrollBarPolicy(30);
        srollPanel.setVerticalScrollBarPolicy(20);
        return srollPanel;
    }

    private JComponent createInfoPanel() {
        if (null == this.settingInfo) {
            String msg = InfoCollectUtil.isNewOceanStor9000(this.devNode) ? ResourceUtil.getString((String)"infocollect.devicesetup.9000.options.error") : ResourceUtil.getString((String)"infocollect.devicesetup.options.error");
            JLabel errmsg = new JLabel("<html>" + msg + "</html>", 0);
            return UiMethod.buildFrameSpace((JComponent)errmsg, (int)12);
        }
        Box box = Box.createVerticalBox();
        List<SettingParserInfo> infolist = this.settingInfo.getParserList();
        for (SettingParserInfo pinfo : infolist) {
            this.createEachCom(pinfo, box);
            box.add(Box.createVerticalStrut(10));
        }
        if (null != this.devNode && this.devNode.isDsStorage()) {
            this.patchComponent.getDesc().setText(ResourceUtil.getString((String)"infocollect.patch.import.desc"));
            box.add(this.patchComponent.getComponent());
        }
        box.add(Box.createGlue());
        return UiMethod.buildFrameSpace((JComponent)box, (int)12);
    }

    private void processEdit() {
        List selectedRows = this.clusterNodesTbl.getMarkedRows();
        ArrayList<String> selectedIps = new ArrayList<String>();
        for (TableRow tr : selectedRows) {
            selectedIps.add(((ClusterNode)tr.getUserObject()).getManagementIp());
        }
        for (ClusterNode node : this.devNode.getClusterNodes()) {
            boolean isRowSelected = selectedIps.contains(node.getManagementIp());
            node.setSelected(isRowSelected);
        }
    }

    private void createEachCom(SettingParserInfo pinfo, Box box) {
        if (TYPE_INPUT.equals(pinfo.getType())) {
            this.createTextField(pinfo, box);
        } else if (TYPE_DATE.equals(pinfo.getType())) {
            this.createDateField(pinfo, box);
        } else if (TYPE_LIST.equals(pinfo.getType())) {
            this.createListPanel(pinfo, box);
        } else if (TYPE_TABLE.equals(pinfo.getType())) {
            this.createTablePanel(pinfo, box);
            this.addListSelectionListener();
        }
    }

    private void addListSelectionListener() {
        if (InfoCollectUtil.isNewOceanStor9000(this.devNode)) {
            return;
        }
        this.clusterNodesTbl.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AdvancedOptionsPanel.this.processEdit();
            }
        });
    }

    private void createTextField(SettingParserInfo pinfo, Box box) {
        JLabel title = UiMethod.createColonLabel((String)pinfo.getTitle());
        UiMethod.setComponentSize((Dimension)LABEL_SIZE, (Component[])new Component[]{title});
        this.field = new JTextField();
        UiMethod.setComponentSize((Dimension)FIELD_SIZE, (Component[])new Component[]{this.field});
        this.field.setName(pinfo.getKey());
        if (this.preSettingInfo != null) {
            String val = (String)this.preSettingInfo.getSettingInfo().get(pinfo.getKey());
            this.field.setText(val);
        }
        box.add(UCD.buildHBoxLeft((Component[])new Component[]{title, this.field, Box.createGlue()}));
    }

    private void createDateField(SettingParserInfo pinfo, Box box) {
        JLabel title = UiMethod.createColonLabel((String)pinfo.getTitle());
        UiMethod.setComponentSize((Dimension)LABEL_SIZE, (Component[])new Component[]{title});
        if (pinfo.getKey().equals("startTime")) {
            this.startTime = new DateChooseField();
            this.setTimeContent(this.startTime, pinfo, box, title);
        } else {
            this.endTime = new DateChooseField();
            this.setTimeContent(this.endTime, pinfo, box, title);
        }
    }

    private void setTimeContent(DateChooseField timeField, SettingParserInfo pinfo, Box box, JLabel title) {
        UiMethod.setComponentSize((Dimension)FIELD_SIZE, (Component[])new Component[]{timeField});
        timeField.setDateChooseModel(2);
        timeField.setName(pinfo.getKey());
        timeField.setEditable(true);
        if (this.preSettingInfo != null) {
            String val = (String)this.preSettingInfo.getSettingInfo().get(pinfo.getKey());
            timeField.setText(val);
        }
        box.add(UCD.buildHBoxLeft((Component[])new Component[]{title, timeField, Box.createGlue()}));
    }

    private void createListPanel(SettingParserInfo pinfo, Box box) {
        JLabel title = UiMethod.createColonLabel((String)this.getTitle(pinfo.getTitle()));
        UiMethod.setComponentSize((Dimension)LABEL_SIZE, (Component[])new Component[]{title});
        JComponent listPanel = this.createlistPane(pinfo);
        box.add(UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{title}), UCD.buildHBoxLeft((Component[])new Component[]{listPanel})}));
    }

    private String getTitle(String itemTitle) {
        if (!ItDeviceType.COMPUTE_STORAGE.equals((Object)this.devNode.getStorageDeviceType())) {
            return itemTitle;
        }
        return ResourceUtil.getString((String)"list.mode");
    }

    private void createTablePanel(SettingParserInfo pinfo, Box box) {
        JLabel title = UiMethod.createColonLabel((String)pinfo.getTitle());
        UiMethod.setComponentSize((Dimension)LABEL_SIZE, (Component[])new Component[]{title});
        TableScrollPane tablePanel = this.buildNodesScrollPane();
        if (InfoCollectUtil.isNewOceanStor9000(this.devNode)) {
            this.addDevNodesToTable(pinfo);
        } else {
            this.addClusterNodesToTable(this.devNode);
        }
        box.add(UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{title}), UCD.buildHBoxLeft((Component[])new Component[]{tablePanel})}));
    }

    private void addDevNodesToTable(SettingParserInfo pinfo) {
        pinfo.getNodesList().stream().map(this::constructNodeRow).forEach(xva$0 -> this.clusterNodesTblModel.addRow(new TableRow[]{xva$0}));
        this.setupSelectRows();
        this.clusterNodesTbl.updateUI();
    }

    private void setupSelectRows() {
        List<TableRow> selectNodes = CollectDataContext.getInstance().getCollectInfo(this.devNode).getCollectConfInfo().getSelectNodes();
        if (!Utils.isNullList(selectNodes)) {
            selectNodes.forEach(xva$0 -> this.clusterNodesTbl.markTableRow(new TableRow[]{xva$0}));
            log.info("Display the default selected rows.");
            return;
        }
        this.clusterNodesTbl.selectAll();
    }

    private TableRow<String, String> constructNodeRow(Map<String, String> nodes) {
        DefaultTableRow row = new DefaultTableRow(this.clusterNodesTblModel.getColumnCount(), (Object)nodes.get("name"), (Object)nodes.get("name"));
        int index = 0;
        row.setValueAt(index++, (Object)nodes.get("name"));
        row.setValueAt(index++, (Object)nodes.get("SUBDOMAIN_ID"));
        row.setValueAt(index++, (Object)nodes.get("NODEPOOLID"));
        row.setValueAt(index++, (Object)nodes.get("Leader"));
        return row;
    }

    public IsmTable getClusterNodesTbl() {
        return this.clusterNodesTbl;
    }

    public void setClusterNodesTbl(IsmTable clusterNodesTbl) {
        this.clusterNodesTbl = clusterNodesTbl;
    }

    private String[] getTableHeader() {
        String[] headers = new String[]{ResourceUtil.getString((String)"cluster.nodes.table.storage.pool.id"), ResourceUtil.getString((String)"cluster.nodes.table.mgt.ip"), ResourceUtil.getString((String)"cluster.nodes.table.cabinet"), ResourceUtil.getString((String)"cluster.nodes.table.mgt.role"), ResourceUtil.getString((String)"cluster.nodes.table.name"), ResourceUtil.getString((String)"cluster.nodes.table.id")};
        return headers;
    }

    private void setTableHeaderSize() {
        if (this.clusterNodesTbl == null) {
            return;
        }
        TableColumnModel colModel = this.clusterNodesTbl.getColumnModel();
        IntStream.range(0, colModel.getColumnCount()).forEach(index -> colModel.getColumn(index).setPreferredWidth(64));
    }

    private TableScrollPane buildNodesScrollPane() {
        boolean isNewOceanStor9000 = InfoCollectUtil.isNewOceanStor9000(this.devNode);
        String[] headers = isNewOceanStor9000 ? this.get9000TableHeader() : this.getTableHeader();
        this.clusterNodesTblModel = this.creatClusterNodesTblModel(isNewOceanStor9000, headers);
        this.clusterNodesTbl = new IsmTable((TableModel)this.clusterNodesTblModel);
        if (isNewOceanStor9000) {
            this.set9000TableHeaderSize();
        } else {
            this.setTableHeaderSize();
        }
        this.nodesScroll = new TableScrollPane(this.clusterNodesTbl, true, true, true);
        if (null != this.devNode && (this.devNode.isDsStorage() || isNewOceanStor9000)) {
            this.nodesScroll.setPreferredSize(new Dimension(570, 250));
        } else {
            this.nodesScroll.setSize(new Dimension(480, 240));
        }
        return this.nodesScroll;
    }

    @NotNull
    private DefaultTableModel creatClusterNodesTblModel(boolean isNewOceanStor9000, String[] strArray) {
        return isNewOceanStor9000 ? new DefaultTableModel(strArray, new int[]{0, 1, 2, 3}) : new DefaultTableModel(strArray, new int[]{0, 1, 2, 3, 4, 5});
    }

    private String[] get9000TableHeader() {
        return new String[]{ResourceUtil.getString((String)"cluster.nodes.table.ocean.stor.9000.name"), ResourceUtil.getString((String)"cluster.nodes.table.ocean.stor.9000.subdomain.id"), ResourceUtil.getString((String)"cluster.nodes.table.ocean.stor.9000.node.pool.id"), ResourceUtil.getString((String)"cluster.nodes.table.ocean.stor.9000.leader")};
    }

    private void set9000TableHeaderSize() {
        if (this.clusterNodesTbl == null) {
            return;
        }
        TableColumnModel colModel = this.clusterNodesTbl.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(80);
        colModel.getColumn(1).setPreferredWidth(60);
        colModel.getColumn(2).setPreferredWidth(60);
        colModel.getColumn(3).setPreferredWidth(120);
    }

    private TableRow<ClusterNode, ClusterNode> constructClusterNodeRow(ClusterNode cn) {
        DefaultTableRow row = new DefaultTableRow(this.clusterNodesTblModel.getColumnCount(), (Object)cn, (Object)cn);
        int index = 0;
        row.setValueAt(index++, (Object)this.getStoragePoolId(cn));
        row.setValueAt(index++, (Object)cn.getManagementIp());
        row.setValueAt(index++, (Object)cn.getCabinet());
        row.setValueAt(index++, (Object)String.join((CharSequence)",", cn.getRoles()));
        row.setValueAt(index++, (Object)cn.getName());
        row.setValueAt(index++, (Object)cn.getId());
        return row;
    }

    private String getStoragePoolId(ClusterNode cn) {
        return Objects.isNull(cn.getJoinedStoragePool()) ? "" : cn.getJoinedStoragePool().getId();
    }

    private void addClusterNodesToTable(DevNode clusterNode) {
        for (ClusterNode cn : clusterNode.getClusterNodes()) {
            TableRow<ClusterNode, ClusterNode> row = this.constructClusterNodeRow(cn);
            this.clusterNodesTblModel.addRow(new TableRow[]{row});
            if (!cn.isSelected()) continue;
            this.clusterNodesTbl.markTableRow(new TableRow[]{row});
        }
    }

    private JComponent createlistPane(SettingParserInfo pinfo) {
        AdvancedOptionsPanel.createLocalList(pinfo);
        JScrollPane locPane = new JScrollPane(locList);
        AdvancedOptionsPanel.createSelectList();
        JScrollPane selPane = new JScrollPane(selectList);
        listModel = this.createListModel(pinfo);
        selectList.setModel(listModel);
        selectList.setName(pinfo.getKey());
        AdvancedOptionsPanel.createAddBtn();
        delBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.devicesetup.options.del"));
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{addBtn, delBtn});
        addBtn.setEnabled(false);
        delBtn.setEnabled(false);
        locList.addListSelectionListener(new AddSelectionListener());
        selectList.addListSelectionListener(new DelSelectionListener());
        addBtn.addActionListener(new AddElementListener());
        delBtn.addActionListener(new RemoveElementListener());
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        btnPanel.add(addBtn);
        btnPanel.add(delBtn);
        UiMethod.setComponentSize((Dimension)new Dimension(140, 160), (Component[])new Component[]{locPane, selPane});
        UiMethod.setComponentSize((Dimension)new Dimension(100, 160), (Component[])new Component[]{btnPanel});
        return UCD.buildHBoxLeft((Component[])new Component[]{locPane, btnPanel, selPane});
    }

    private static void createAddBtn() {
        addBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.devicesetup.options.add"));
    }

    private DefaultListModel createListModel(SettingParserInfo pinfo) {
        return this.getPreSelectResult(pinfo.getKey());
    }

    private static void createSelectList() {
        selectList = new JList();
    }

    private static void createLocalList(SettingParserInfo pinfo) {
        locList = new JList<Object>(pinfo.getResultList().toArray());
    }

    public SettingConfInfo getSettingInfo() {
        if (null == this.settingInfo) {
            return this.settingInfo;
        }
        Map<String, Object> infoMap = this.settingInfo.getSettingInfo();
        this.setOptionsValue(infoMap, this);
        return this.settingInfo;
    }

    public boolean checkInput(JDialog modelDialog, AdvancedOptionsPanel optionsPanel) {
        if (null == this.settingInfo) {
            return true;
        }
        if (this.devNode.getDeviceType().equals((Object)DeviceType.valueOf((String)"OceanStor9000")) || this.devNode.isDsStorage()) {
            String endTimeString;
            String startTimeString = this.getStartTime().getText();
            if (StringUtils.hasNULLStr((String[])new String[]{startTimeString, endTimeString = this.getEndTime().getText()})) {
                if (this.devNode.isDsStorage()) {
                    if (StringUtils.isNULLStr((String)startTimeString) && StringUtils.isNULLStr((String)endTimeString)) {
                        return true;
                    }
                    if (StringUtils.isNULLStr((String)startTimeString)) {
                        DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.selectstarttime"));
                    } else {
                        DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.selectendtime"));
                    }
                    return false;
                }
                return true;
            }
            this.duration = this.getDuration();
            if (!this.duration.isValid()) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"infocollect.remind.custemdateerror3"));
                return false;
            }
        }
        return true;
    }

    public boolean checkTimeInput(JDialog modelDialog) {
        if (this.devNode.isFusionCube()) {
            this.duration = this.getDefaultDuration();
            return true;
        }
        String startTimeString = this.getStartTime().getText();
        String endTimeString = this.getEndTime().getText();
        if (StringUtils.isNULLStr((String)startTimeString) && StringUtils.isNULLStr((String)endTimeString)) {
            DialogUtils.showInfoDialog((JDialog)modelDialog, (String)ResourceUtil.getString((String)"collect.wizard.no.time.checked"));
            return false;
        }
        if (StringUtils.isNULLStr((String)startTimeString) && !StringUtils.isNULLStr((String)endTimeString)) {
            DialogUtils.showInfoDialog((JDialog)modelDialog, (String)ResourceUtil.getString((String)"infocollect.remind.selectstarttime"));
            return false;
        }
        if (!StringUtils.isNULLStr((String)startTimeString) && StringUtils.isNULLStr((String)endTimeString)) {
            DialogUtils.showInfoDialog((JDialog)modelDialog, (String)ResourceUtil.getString((String)"infocollect.remind.selectendtime"));
            return false;
        }
        LOGGER.info("Both startTime and end Time are not empty.");
        this.duration = this.getDuration();
        if (!this.duration.isValid()) {
            DialogUtils.showInfoDialog((JDialog)modelDialog, (String)ResourceUtil.getString((String)"infocollect.remind.custemdateerror3"));
            return false;
        }
        return true;
    }

    private CollectDuration getDefaultDuration() {
        CollectDuration custom = new CollectDuration();
        custom.setStartDate(new Date());
        custom.setEndDate(new Date());
        return custom;
    }

    public CollectDuration getCurrentDuration() {
        return this.duration;
    }

    public void hidePatchComponent(boolean isShow) {
        this.patchComponent.getComponent().setVisible(isShow);
    }

    public JTextField getField() {
        return this.field;
    }

    public void setField(JTextField field) {
        this.field = field;
    }

    private DefaultListModel getPreSelectResult(String key) {
        if (this.preSettingInfo != null) {
            return (DefaultListModel)this.preSettingInfo.getSettingInfo().get(key);
        }
        return new DefaultListModel();
    }

    public DateChooseField getStartTime() {
        return this.startTime;
    }

    private void setOptionsValue(Map<String, Object> infoMap, JComponent com) {
        for (Component c : com.getComponents()) {
            String name;
            if (c instanceof DateChooseField) {
                name = c.getName();
                if (!infoMap.containsKey(name)) continue;
                DateChooseField datefield = (DateChooseField)c;
                String date = this.changeDateFormat(String.valueOf(infoMap.get(name)), datefield.getText());
                infoMap.put(name, date);
                continue;
            }
            if (c instanceof JTextField) {
                name = c.getName();
                if (!infoMap.containsKey(name)) continue;
                JTextField textfield = (JTextField)c;
                String text = textfield.getText();
                if (null == text) {
                    LOGGER.error("Get text error!the key is:" + name);
                }
                infoMap.put(name, text);
                continue;
            }
            if (c instanceof JList) {
                name = c.getName();
                if (!infoMap.containsKey(name)) continue;
                JList list = (JList)c;
                DefaultListModel mode = (DefaultListModel)list.getModel();
                infoMap.put(name, mode);
                continue;
            }
            if (!(c instanceof JComponent)) continue;
            JComponent co = (JComponent)c;
            this.setOptionsValue(infoMap, co);
        }
    }

    private String changeDateFormat(String format, String text) {
        SimpleDateFormat locFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date inputDate = null;
        try {
            inputDate = locFormat.parse(text);
            SimpleDateFormat newFormat = new SimpleDateFormat(format);
            return newFormat.format(inputDate);
        }
        catch (ParseException e) {
            LoggerFactory.getLogger(this.getClass()).error("ParseException.", (Object)e.getMessage());
            return "";
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(this.getClass()).error("RuntimeException.", (Throwable)e);
            if (null != inputDate) {
                return String.valueOf(inputDate.getTime());
            }
            return "";
        }
    }

    public void setStartTime(DateChooseField startTime) {
        this.startTime = startTime;
    }

    private CollectDuration getDuration() {
        CollectDuration custom = new CollectDuration();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar starttime = Calendar.getInstance();
            Calendar endtime = Calendar.getInstance();
            starttime.setTime(format.parse(this.getStartTime().getText()));
            endtime.setTime(format.parse(this.getEndTime().getText()));
            custom.setStartDate(starttime.getTime());
            custom.setEndDate(endtime.getTime());
        }
        catch (ParseException e) {
            LOGGER.error("the starttime / endtime input error!!", (Throwable)e);
            custom.setStartDate(new Date());
            custom.setEndDate(new Date());
        }
        return custom;
    }

    public DateChooseField getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateChooseField endTime) {
        this.endTime = endTime;
    }

    public PatchComponent getPatchComponent() {
        return this.patchComponent;
    }

    static class RemoveElementListener
    implements ActionListener {
        RemoveElementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Object o : selectList.getSelectedValues()) {
                listModel.removeElement(o);
            }
            if (listModel.isEmpty()) {
                delBtn.setEnabled(false);
            }
            selectList.setModel(listModel);
        }
    }

    static class AddElementListener
    implements ActionListener {
        AddElementListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Object o : locList.getSelectedValues()) {
                if (listModel.contains(o)) continue;
                listModel.addElement(o);
            }
            selectList.setModel(listModel);
        }
    }

    static class DelSelectionListener
    implements ListSelectionListener {
        DelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            delBtn.setEnabled(-1 != selectList.getSelectedIndex());
        }
    }

    static class AddSelectionListener
    implements ListSelectionListener {
        AddSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            addBtn.setEnabled(-1 != locList.getSelectedIndex());
        }
    }
}

