/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.ui.support.devselect.DevChooseDialog;
import com.huawei.ism.tool.infocollect.ui.support.devselect.DevNodeFilter;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiNodeApplyListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(AiNodeApplyListener.class);
    private CollectNewSetupDialog dialog;
    private DevNode devNode;

    public AiNodeApplyListener(CollectNewSetupDialog dialog, DevNode devNode) {
        this.dialog = dialog;
        this.devNode = devNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("{} click the apply button", (Object)this.devNode.getIp());
        CollectDataContext.getInstance().setUseApply(true);
        DevChooseDialog devChooseDialog = this.dialog.getDevChooseDialog();
        if (Objects.isNull(devChooseDialog)) {
            log.info("init device choose dialog. ip is {}", (Object)this.devNode.getIp());
            devChooseDialog = new DevChooseDialog((JDialog)((Object)this.dialog), this.devNode);
            this.dialog.setDevChooseDialog(devChooseDialog);
        }
        devChooseDialog.initData(this.filterChooseDevs());
        devChooseDialog.setVisible(true);
    }

    private List<DevNode> filterChooseDevs() {
        DevNodeFilter devNodeFilter = new DevNodeFilter();
        List<DevNode> devNodes = devNodeFilter.filterDevNode(CollectDeviceService.getInstance().getAllDevNode());
        devNodes = devNodeFilter.filterCollectingDev(devNodes);
        devNodes = devNodeFilter.filterA800Dev(devNodes);
        PackageConf conf = InfoConfiguration.getInstance().getPackageConf(this.devNode);
        if (Objects.nonNull(conf)) {
            devNodes = devNodeFilter.filterNoSameTypeDev(conf, devNodes);
        }
        devNodes.remove(this.devNode);
        log.info("all apply device{}", devNodes.stream().map(DevNode::getIp).collect(Collectors.toList()));
        return devNodes;
    }
}

