/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.ui.support.devselect.DevChooseDialog;
import com.huawei.ism.tool.infocollect.ui.support.devselect.DevNodeFilter;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

public class ApplyActionListener
implements ActionListener {
    private IntegrateCollectSetupDialog dialog;

    public ApplyActionListener(IntegrateCollectSetupDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CollectDataContext.getInstance().setUseApply(true);
        DevChooseDialog devChooseDialog = this.dialog.getDevChooseDialog();
        if (devChooseDialog == null) {
            devChooseDialog = new DevChooseDialog((JDialog)((Object)this.dialog), this.dialog.getDeviceNode());
            this.dialog.setDevChooseDialog(devChooseDialog);
        }
        devChooseDialog.initData(this.filterChooseDevs());
        devChooseDialog.setVisible(true);
    }

    private List<DevNode> filterChooseDevs() {
        List<DevNode> devs = CollectDeviceService.getInstance().getAllDevNode();
        devs = new DevNodeFilter().filterCollectingDev(devs);
        PackageConf conf = InfoConfiguration.getInstance().getPackageConf(this.dialog.getDeviceNode());
        if (null != conf) {
            devs = new DevNodeFilter().filterNoSameTypeDev(conf, devs);
        }
        devs = new DevNodeFilter().filterDevNode(devs);
        devs.remove(this.dialog.getDeviceNode());
        return devs;
    }
}

