/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemTreeMouseListener
extends MouseAdapter {
    private static final Logger log = LoggerFactory.getLogger(CheckItemTreeMouseListener.class);
    private static final String NORMAL_DISK_LOG_COLLECT_ITEM_ID = "normal_disklog";
    private final CollectNewSetupDialog collectNewSetupDialog;
    private final DevNode devNode;

    @Override
    public void mouseClicked(MouseEvent event) {
        if (!(this.collectNewSetupDialog.getCollectNewSetupLayout().getItemTree().getLastSelectedPathComponent() instanceof CheckTreeNode)) {
            log.error("The selected node is not a CheckTreeNode.");
            return;
        }
        CheckTreeNode node = (CheckTreeNode)this.collectNewSetupDialog.getCollectNewSetupLayout().getItemTree().getLastSelectedPathComponent();
        Object clickObj = node.getUserObject();
        if (clickObj == null || !(clickObj instanceof CollectItem)) {
            log.info("Click object is not collect item object, ignored.");
            return;
        }
        CollectItem ci = (CollectItem)clickObj;
        if (Objects.equals(NORMAL_DISK_LOG_COLLECT_ITEM_ID, ci.getId())) {
            this.collectNewSetupDialog.setNormalDiskLogItemNode(node);
            this.settingHardDisks(node);
        }
    }

    private void settingHardDisks(CheckTreeNode node) {
        if (!this.isShowDiskSelectDialog()) {
            this.collectNewSetupDialog.getNormalDiskLogItemNode().setSelected(!node.isSelected());
            return;
        }
        this.collectNewSetupDialog.showDiskSelectDialog();
    }

    private boolean isShowDiskSelectDialog() {
        return !this.isSelectedDisks(CollectDataContext.getInstance().getDiskTotalNumMap().get(this.devNode), CollectDataContext.getInstance().getGlobalConDiskHashMap().get(this.devNode)) || InfoCollectUtil.usrConfirmRiskProcedure(ResourceUtil.getStringWithParams((String)"disk.log.collect.time.tip", (Object[])new Object[0]));
    }

    private boolean isSelectedDisks(Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        if (InfoCollectUtil.isDiskTreeMapEmptyOrNull(diskInt, diskTreeMap)) {
            log.info("The disk tree map is empty or null.");
            return true;
        }
        if (this.collectNewSetupDialog.getSelectedDiskLocs().isEmpty()) {
            log.info("The SelectedDiskLocs is empty.");
            return diskTreeMap.values().stream().noneMatch(Disk::isChecked);
        }
        return false;
    }

    public CheckItemTreeMouseListener(CollectNewSetupDialog collectNewSetupDialog, DevNode devNode) {
        this.collectNewSetupDialog = collectNewSetupDialog;
        this.devNode = devNode;
    }
}

