/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.entity.SettingConfInfo;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSettingInfoTask
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(CheckSettingInfoTask.class);
    private final CollectNewSetupDialog collectNewSetupDialog;

    @Override
    public Boolean call() throws Exception {
        Optional<SettingConfInfo> settingConfInfo = Optional.ofNullable(new BizPackageService().getSettingConf(this.collectNewSetupDialog.getDevNode()));
        if (!settingConfInfo.isPresent() || Utils.isNullList(settingConfInfo.get().getParserList())) {
            log.error("Failed to query advanced settings.");
            this.collectNewSetupDialog.add(InfoCollectUtil.createErrorInfoPanel(ResourceUtil.getString((String)"infocollect.flash.device.init.setup.options.error")));
            return false;
        }
        if (this.checkNodesList(settingConfInfo.get())) {
            log.error("Failed to query advanced settings.");
            this.collectNewSetupDialog.add(InfoCollectUtil.createErrorInfoPanel(ResourceUtil.getString((String)"infocollect.flash.device.init.setup.options.no.node.error")));
            return false;
        }
        this.collectNewSetupDialog.setParserInfos(settingConfInfo.get().getParserList());
        return true;
    }

    boolean checkNodesList(SettingConfInfo settingConfInfo) {
        return settingConfInfo.getParserList().stream().anyMatch(settingParserInfo -> Utils.isNullList(settingParserInfo.getNodesList()) || this.isNullNode(settingParserInfo.getNodesList()));
    }

    boolean isNullNode(List<Map<String, String>> nodes) {
        return nodes.stream().anyMatch(node -> StringUtils.isNULLStr((String)((String)node.get("ID"))) || StringUtils.isNULLStr((String)((String)node.get("Enclosure"))));
    }

    public CheckSettingInfoTask(CollectNewSetupDialog collectNewSetupDialog) {
        this.collectNewSetupDialog = collectNewSetupDialog;
    }
}

