/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.rest.entity.CollectParam;
import com.huawei.ism.tool.infocollect.rest.entity.DstorageCollectParam;
import com.huawei.ism.tool.infocollect.rest.entity.FlashCollectParam;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.CollectSetupLayout;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.TimeSettingPanel;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.Pair;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectInfoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectInfoBuilder.class);
    private static final int MAXNODESELECTED = 80;
    private CollectDuration duration = null;
    private IntegrateCollectSetupDialog dialog = null;
    private CollectSetupLayout layout = null;
    private AdvancedOptionsPanel optionsPanel = null;
    private TimeSettingPanel timeSettingPanel;
    private DevNode currentDevNode;
    private List<CollectItem> selectedItems;
    private boolean isSimpleCollect;
    private List<TableRow> selectNodes;
    private FlashCollectParam flashCollectParam;
    private DstorageCollectParam dstorageCollectParam;

    public CollectInfoBuilder(IntegrateCollectSetupDialog dialog) {
        this(dialog, null, null, null, null);
    }

    public CollectInfoBuilder(CollectParam param) {
        this.currentDevNode = param.getDevNode();
        this.selectedItems = param.getSelectedItems();
        if (param instanceof FlashCollectParam) {
            this.flashCollectParam = (FlashCollectParam)param;
        } else if (param instanceof DstorageCollectParam) {
            this.dstorageCollectParam = (DstorageCollectParam)param;
        }
    }

    public CollectInfoBuilder(List<CollectItem> selectedItems, List<TableRow> selectNodes, DevNode devNode, AdvancedOptionsPanel optionsPanel) {
        this.selectedItems = selectedItems;
        this.selectNodes = selectNodes;
        this.currentDevNode = devNode;
        this.optionsPanel = optionsPanel;
    }

    public CollectInfoBuilder(IntegrateCollectSetupDialog dialog, DevNode devNode, CollectSetupLayout layout, List<CollectItem> selectedItems, Pair<AdvancedOptionsPanel, Boolean> pair) {
        if (dialog != null) {
            this.dialog = dialog;
            this.layout = dialog.getCollectlayout();
            this.optionsPanel = dialog.getOptionsPanel();
            this.timeSettingPanel = dialog.getTimeSettingPanel();
        } else {
            this.currentDevNode = devNode;
            this.layout = layout;
            this.selectedItems = selectedItems;
            this.optionsPanel = (AdvancedOptionsPanel)pair.getKey();
            this.duration = this.optionsPanel.getCurrentDuration();
            this.isSimpleCollect = (Boolean)pair.getValue();
        }
    }

    public boolean checkInput() {
        if (this.layout.getCustomRadio().isSelected()) {
            String startTimeString = this.layout.getStartTimeField().getText();
            String endTimeString = this.layout.getEndTimeField().getText();
            if (StringUtils.hasNULLStr((String[])new String[]{startTimeString, endTimeString})) {
                DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.customdatetimeerror"));
                return false;
            }
        }
        this.duration = this.getDuration();
        if (this.layout.getCustomRadio().isSelected()) {
            if (!this.duration.isValid()) {
                DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.custemdateerror"));
                return false;
            }
            if (!this.duration.isValid(this.layout.getDevicedate(), false)) {
                DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.custemdateerror2"));
                return false;
            }
        }
        if (!this.checkChooseCollectItem()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.onecollectitematleast"));
            return false;
        }
        if (!this.checkSelectedNode()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.onecollectIntegrateNodeleast"));
            return false;
        }
        if (!this.checkSelectedMax()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.collectIntegrateNodemax"));
            return false;
        }
        if (!this.checkChooseMainDev()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.remind.mustchoosemainnode"));
            return false;
        }
        return true;
    }

    private boolean checkSelectedNode() {
        if (!this.dialog.getIntegrateXMLFile().isEmpty()) {
            return 0 != this.dialog.getSelectedIntegrate().length();
        }
        return true;
    }

    private boolean checkSelectedMax() {
        if (!this.dialog.getIntegrateXMLFile().isEmpty()) {
            String selectedNode = this.dialog.getSelectedIntegrate().toString();
            String[] node = selectedNode.split(",");
            return node.length <= 80;
        }
        return true;
    }

    private boolean checkChooseCollectItem() {
        for (List<CollectItem> collectItems : this.dialog.getAllCollectItems().values()) {
            if (collectItems == null || collectItems.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean checkChooseMainDev() {
        List<CollectItem> collectItems = this.dialog.getAllCollectItems().get(this.dialog.getDeviceNode());
        return collectItems != null && !collectItems.isEmpty();
    }

    public boolean checkOptionsInput() {
        if (this.optionsPanel == null) {
            return true;
        }
        return this.optionsPanel.checkInput((JDialog)((Object)this.dialog), this.optionsPanel);
    }

    private CollectDuration getDuration() {
        if (!this.layout.getLastDayRadio().isEnabled()) {
            return CollectDuration.INVALIDD;
        }
        if (this.layout.getLastDayRadio().isSelected()) {
            return CollectDuration.LASTDAY;
        }
        if (this.layout.getLastWeekRadio().isSelected()) {
            return CollectDuration.LASTWEEK;
        }
        if (this.layout.getLastMonthRadio().isSelected()) {
            return CollectDuration.LASTMONTH;
        }
        if (this.layout.getCustomRadio().isSelected()) {
            CollectDuration custom = new CollectDuration();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar startTime = Calendar.getInstance();
                Calendar endTime = Calendar.getInstance();
                startTime.setTime(format.parse(this.layout.getStartTimeField().getText()));
                endTime.setTime(format.parse(this.layout.getEndTimeField().getText()));
                custom.setStartDate(startTime.getTime());
                custom.setEndDate(endTime.getTime());
            }
            catch (ParseException e) {
                LOGGER.error("the starttime / endtime input error!!", (Throwable)e);
                custom.setStartDate(new Date());
                custom.setEndDate(new Date());
            }
            return custom;
        }
        return CollectDuration.INVALIDD;
    }

    public IntegrateCollectInfo build() {
        HashMap<DevNode, CollectInfo> integrateCollectInfoes = new HashMap<DevNode, CollectInfo>();
        for (DevNode devNode : this.dialog.getDevNodes()) {
            List<CollectItem> currentCollectItems = this.dialog.getAllCollectItems().get(devNode);
            if (currentCollectItems == null || currentCollectItems.isEmpty()) continue;
            CollectInfo currentCollectInfo = this.createCollectInfo(devNode, currentCollectItems);
            if (null != this.optionsPanel) {
                currentCollectInfo.setSettingConfInfo(this.optionsPanel.getSettingInfo());
            }
            integrateCollectInfoes.put(devNode, currentCollectInfo);
        }
        IntegrateCollectInfo collectInfo = new IntegrateCollectInfo(this.dialog.getDeviceNode());
        collectInfo.initIntergrateCollectInfoes(integrateCollectInfoes);
        collectInfo.cashExecuteResult(this.dialog.getResults());
        return collectInfo;
    }

    public IntegrateCollectInfo buildOceanStor9000Collect() {
        CollectInfo currentCollectInfo = new CollectInfo(this.currentDevNode);
        CollectConfInfo confInfo = new CollectConfInfo();
        confInfo.setSelectItems(this.selectedItems);
        confInfo.setSelectNodes(this.selectNodes);
        confInfo.setCompleteStorageParamSetting(true);
        currentCollectInfo.setCollectConfInfo(confInfo);
        if (this.optionsPanel != null) {
            currentCollectInfo.setSettingConfInfo(this.optionsPanel.getSettingInfo());
        }
        HashMap<DevNode, CollectInfo> oceanStor9000CollectInfos = new HashMap<DevNode, CollectInfo>();
        oceanStor9000CollectInfos.put(this.currentDevNode, currentCollectInfo);
        IntegrateCollectInfo collectInfo = new IntegrateCollectInfo(this.currentDevNode);
        collectInfo.initIntergrateCollectInfoes(oceanStor9000CollectInfos);
        collectInfo.cashExecuteResult(this.getResult());
        return collectInfo;
    }

    public IntegrateCollectInfo buildScenarioBasedCollect() {
        HashMap<DevNode, CollectInfo> integrateCollectInfoes = new HashMap<DevNode, CollectInfo>();
        CollectInfo currentCollectInfo = new CollectInfo(this.currentDevNode);
        CollectConfInfo confInfo = this.buildScenarioBasedCollectConfInfo();
        currentCollectInfo.setCollectConfInfo(confInfo);
        integrateCollectInfoes.put(this.currentDevNode, currentCollectInfo);
        IntegrateCollectInfo collectInfo = new IntegrateCollectInfo(this.currentDevNode);
        collectInfo.initIntergrateCollectInfoes(integrateCollectInfoes);
        collectInfo.cashExecuteResult(this.getResult());
        return collectInfo;
    }

    private CollectConfInfo buildScenarioBasedCollectConfInfo() {
        CollectConfInfo collectConfInfo = this.createCollectConfInfo();
        if (this.flashCollectParam.getSelectedScene() == ModeType.CUSTOM_COLLECT) {
            collectConfInfo.setCustomCollect(true);
            collectConfInfo.setCustomCollectSelectItems(this.selectedItems);
        }
        if (this.flashCollectParam.getSelectedScene() == ModeType.QUICKLY_COLLECT) {
            collectConfInfo.setQuicklyCollect(true);
            collectConfInfo.setQuicklyCollectSelectItems(this.selectedItems);
        }
        if (this.flashCollectParam.getSelectedScene() == ModeType.DEPTH_COLLECT) {
            collectConfInfo.setDepthCollect(true);
            collectConfInfo.setDepthCollectSelectItems(this.selectedItems);
        }
        return collectConfInfo;
    }

    private CollectConfInfo createCollectConfInfo() {
        CollectConfInfo collectConfInfo = new CollectConfInfo();
        collectConfInfo.setSelectItems(this.selectedItems);
        collectConfInfo.setCompleteStorageParamSetting(true);
        collectConfInfo.setCustomCollect(false);
        collectConfInfo.setQuicklyCollect(false);
        collectConfInfo.setDepthCollect(false);
        CollectConfInfo hisConfInfo = InfoCollectService.getInstance().getCollectInfoInstance(this.currentDevNode).getCollectConfInfo();
        collectConfInfo.setCustomCollectSelectItems(hisConfInfo.getCustomCollectSelectItems());
        collectConfInfo.setQuicklyCollectSelectItems(hisConfInfo.getQuicklyCollectSelectItems());
        collectConfInfo.setDepthCollectSelectItems(hisConfInfo.getDepthCollectSelectItems());
        collectConfInfo.setSelectedControllerNodeIds(this.flashCollectParam.getSelectedControllerIds());
        collectConfInfo.setSelectedExpansionModuleIds(this.flashCollectParam.getSelectedExpansionModuleIds());
        collectConfInfo.setCollectByNodes(this.flashCollectParam.isCollectByNode());
        return collectConfInfo;
    }

    public IntegrateCollectInfo buildDStorageCollect() {
        HashMap<DevNode, CollectInfo> integrateCollectInfo = new HashMap<DevNode, CollectInfo>();
        CollectInfo currentCollectInfo = new CollectInfo(this.currentDevNode);
        CollectConfInfo confInfo = this.buildDStorageCollectConfInfo();
        currentCollectInfo.setCollectConfInfo(confInfo);
        currentCollectInfo.setSettingConfInfo(this.dstorageCollectParam.getSettingConfInfo());
        integrateCollectInfo.put(this.currentDevNode, currentCollectInfo);
        IntegrateCollectInfo collectInfo = new IntegrateCollectInfo(this.currentDevNode);
        collectInfo.initIntergrateCollectInfoes(integrateCollectInfo);
        collectInfo.cashExecuteResult(this.getResult());
        return collectInfo;
    }

    private List<ExecuteResult> getResult() {
        return CollectDataContext.getInstance().getCollectInfo(this.currentDevNode).getExecuteResults();
    }

    private CollectConfInfo buildDStorageCollectConfInfo() {
        CollectConfInfo currentConfInfo = this.constructDsCollectConfInfo(this.selectedItems);
        currentConfInfo.setSimpleCollect(this.dstorageCollectParam.getSelectedScene() == ModeType.D_STORAGE_BY_FAULT);
        currentConfInfo.setCompleteParamSetting(true);
        CollectConfInfo hisConfInfo = CollectDataContext.getInstance().getCollectInfo(this.currentDevNode).getCollectConfInfo();
        if (currentConfInfo.isSimpleCollect()) {
            currentConfInfo.setSimpleCollectSelectItems(this.selectedItems);
            currentConfInfo.setDefaultSelectItems(hisConfInfo.getDefaultSelectItems());
        } else {
            currentConfInfo.setSimpleCollectSelectItems(hisConfInfo.getSimpleCollectSelectItems());
            currentConfInfo.setDefaultSelectItems(this.selectedItems);
        }
        return currentConfInfo;
    }

    private CollectInfo createCollectInfo(DevNode devNode, List<CollectItem> collectItems) {
        CollectConfInfo confInfo = this.constructCollectConfInfo(collectItems);
        if (this.dialog.getDebugPasswords().containsKey(devNode)) {
            String debugPwd = devNode.getDeveloperPwd();
            confInfo.getCollectProperties().put("debug_password", debugPwd);
            debugPwd = null;
        }
        CollectInfo collectInfo = new CollectInfo(devNode);
        collectInfo.setCollectConfInfo(confInfo);
        return collectInfo;
    }

    private CollectConfInfo constructDsCollectConfInfo(List<CollectItem> selectItems) {
        CollectConfInfo confInfo = new CollectConfInfo();
        CollectDuration collectDuration = this.dstorageCollectParam.getDuration();
        if (CollectDuration.INVALIDD.equals(this.dstorageCollectParam.getDuration())) {
            collectDuration = CollectDuration.LASTDAY;
        }
        collectDuration.setDeviceDate(this.getDateString());
        confInfo.setDuration(collectDuration);
        confInfo.setSelectItems(selectItems);
        return confInfo;
    }

    private String getDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(this.currentDevNode.getDevCurrentTime()));
    }

    private CollectConfInfo constructCollectConfInfo(List<CollectItem> selectItems) {
        CollectConfInfo confInfo = new CollectConfInfo();
        if (CollectDuration.INVALIDD.equals(this.duration)) {
            this.duration = CollectDuration.LASTDAY;
        }
        this.duration.setDeviceDate(this.layout.getDevicedate());
        confInfo.setDuration(this.duration);
        confInfo.setSelectItems(selectItems);
        if (this.dialog != null && !this.dialog.getIntegrateXMLFile().isEmpty()) {
            confInfo.setSelectedIntegrateNode(this.dialog.getSelectedIntegrate().toString());
            confInfo.getCollectProperties().put("integrate_selected_node", confInfo.getSelectedIntegrateNode());
        }
        return confInfo;
    }

    public boolean checkTimeSettingInput() {
        return this.timeSettingPanel.isInputValid();
    }
}

