/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.SettingParserInfo;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.setup.AiNodeApplyListener;
import com.huawei.ism.tool.infocollect.ui.setup.CheckItemTreeMouseListener;
import com.huawei.ism.tool.infocollect.ui.setup.CheckSettingInfoTask;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupLayout;
import com.huawei.ism.tool.infocollect.ui.setup.DiskInfoCallable;
import com.huawei.ism.tool.infocollect.ui.setup.NodeSelectCheckBoxListener;
import com.huawei.ism.tool.infocollect.ui.setup.QryDiskPythonCallable;
import com.huawei.ism.tool.infocollect.ui.setup.SelectDiskMainDialog;
import com.huawei.ism.tool.infocollect.ui.setup.SelectSceneListener;
import com.huawei.ism.tool.infocollect.ui.setup.SettingSaveListener;
import com.huawei.ism.tool.infocollect.ui.support.devselect.DevChooseDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections4.ListUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectNewSetupDialog
extends PublicDialog {
    private static final Logger log = LoggerFactory.getLogger(CollectNewSetupDialog.class);
    private static final String DISK_PROCESSING_MSG = "DISK_PROCESSING_MSG";
    private int quicklyCollectIndex = 0;
    private int depthCollectIndex = 1;
    private int customCollectIndex = 2;
    private CollectNewSetupLayout collectNewSetupLayout;
    private InfoCollectMainDialog parent;
    private DevNode devNode;
    private List<SettingParserInfo> parserInfos = new ArrayList<SettingParserInfo>();
    private CheckTreeNode normalDiskLogItemNode;
    private List<DiskLocation> selectedDiskLocs = new ArrayList<DiskLocation>();
    private boolean isCustomCollect;
    private boolean isQuicklyCollect = true;
    private boolean isDepthCollect;
    private DevChooseDialog devChooseDialog = null;

    public CollectNewSetupDialog(InfoCollectMainDialog parent, DevNode devNode) {
        super((JDialog)parent, true);
        this.parent = parent;
        this.devNode = devNode;
        this.collectNewSetupLayout = new CollectNewSetupLayout();
        this.initUI();
        this.addListener();
        this.initScene();
    }

    private void initUI() {
        this.setModal(true);
        this.add(this.collectNewSetupLayout);
        this.validate();
        this.setDefaultCloseOperation(2);
        if (!InfoCollectUtil.isA800Zone(this.devNode)) {
            this.setAppButtonVisible(false);
        }
        this.setHelpButtonVisiable(false);
    }

    private void addListener() {
        this.collectNewSetupLayout.getModeComboBox().addActionListener(new SelectSceneListener(this));
        this.collectNewSetupLayout.getCbxConfirm().addActionListener(new NodeSelectCheckBoxListener(this));
        this.collectNewSetupLayout.getItemTree().addMouseListener((MouseListener)new CheckItemTreeMouseListener(this, this.devNode));
        this.okBtn.addActionListener(new SettingSaveListener(this, this.devNode));
        this.appBtn.addActionListener(new AiNodeApplyListener(this, this.devNode));
    }

    private void initScene() {
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(this.devNode);
        AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new CheckSettingInfoTask(this)});
        if (Utils.isNullList(this.parserInfos) || collectInfo == null || collectInfo.getCollectConfInfo() == null) {
            log.error("the parserInfos or collectInfo or collectConfInfo is null");
            this.add(InfoCollectUtil.createErrorInfoPanel(ResourceUtil.getString((String)"infocollect.flash.device.init.setup.options.error")));
            this.setAppButtonVisible(false);
            this.showCloseButton();
            return;
        }
        this.isCustomCollect = collectInfo.getCollectConfInfo().isCustomCollect();
        this.isQuicklyCollect = collectInfo.getCollectConfInfo().isQuicklyCollect();
        this.isDepthCollect = collectInfo.getCollectConfInfo().isDepthCollect();
        this.collectNewSetupLayout.getTableScrollPane().setEnabled(collectInfo.getCollectConfInfo().isCollectByNodes());
        this.collectNewSetupLayout.getCbxConfirm().setSelected(collectInfo.getCollectConfInfo().isCollectByNodes());
        if (this.isCustomCollect) {
            this.collectNewSetupLayout.getModeComboBox().setSelectedIndex(this.customCollectIndex);
            this.initData(false, ModeType.CUSTOM_COLLECT);
            log.info("init the custom collection interface.");
            return;
        }
        if (this.isQuicklyCollect) {
            this.collectNewSetupLayout.getModeComboBox().setSelectedIndex(this.quicklyCollectIndex);
            this.initData(true, ModeType.QUICKLY_COLLECT);
            log.info("init the quick fault locating page.");
            return;
        }
        this.collectNewSetupLayout.getModeComboBox().setSelectedIndex(this.depthCollectIndex);
        this.initData(false, ModeType.DEPTH_COLLECT);
        log.info("init the in-depth problem analysis page.");
    }

    private void initData(boolean isQuicklyScene, ModeType modeType) {
        this.initNodesTable(isQuicklyScene);
        this.initItemTree(modeType);
        this.initDeviceTree();
    }

    private void initDeviceTree() {
        String allDevice = ResourceUtil.getString((String)"infocollect.devicesetup.alldevice");
        this.collectNewSetupLayout.getDeviceRootNode().setUserObject((Object)allDevice);
        this.collectNewSetupLayout.getDeviceRootNode().setToolTips(allDevice);
        CheckTreeNode deviceNode = this.creatTreeNode();
        this.collectNewSetupLayout.getDeviceRootNode().add((MutableTreeNode)deviceNode);
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectNewSetupLayout.getDeviceRootNode(), false);
        this.collectNewSetupLayout.getDeviceTree().setModel((TreeModel)newTreeModel);
        this.collectNewSetupLayout.getDeviceTree().setRootVisible(true);
        this.collectNewSetupLayout.getDeviceTree().setShowsRootHandles(true);
    }

    @NotNull
    private CheckTreeNode creatTreeNode() {
        CheckTreeNode deviceNode = new CheckTreeNode((Object)this.devNode.getIp(), true, true);
        deviceNode.setPartSingleSelect(true);
        deviceNode.setGlobalSingleSelect(true);
        deviceNode.setToolTips(this.devNode.getIp());
        return deviceNode;
    }

    private void initItemTree(ModeType modeType) {
        this.attachItemTreeNode(modeType);
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectNewSetupLayout.getItemRootNode(), true);
        this.collectNewSetupLayout.getItemTree().setModel((TreeModel)newTreeModel);
        this.collectNewSetupLayout.getItemTree().setRootVisible(true);
        this.collectNewSetupLayout.getItemTree().setShowsRootHandles(true);
        this.collectNewSetupLayout.getItemTree().expandAll(true);
        CollectConfInfo mainConfInfo = CollectDataContext.getInstance().getCollectInfo(this.devNode).getCollectConfInfo();
        this.initCollectConfInfoItem(this.getItems(mainConfInfo, modeType).stream().distinct().collect(Collectors.toList()));
    }

    private void initCollectConfInfoItem(List<CollectItem> selectItems) {
        Enumeration enumeration = this.collectNewSetupLayout.getItemRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode)) continue;
            CheckTreeNode currentNode = (CheckTreeNode)CheckTreeNode.class.cast(currentObj);
            currentNode.setSelected(selectItems.contains(currentNode.getUserObject()));
        }
    }

    private List<CollectItem> getItems(CollectConfInfo mainConfInfo, ModeType modeType) {
        if (modeType == ModeType.QUICKLY_COLLECT) {
            return mainConfInfo.getQuicklyCollectSelectItems();
        }
        if (modeType == ModeType.DEPTH_COLLECT) {
            return mainConfInfo.getDepthCollectSelectItems();
        }
        return mainConfInfo.getCustomCollectSelectItems();
    }

    private void attachItemTreeNode(ModeType modeType) {
        this.collectNewSetupLayout.getItemRootNode().removeAllChildren();
        CollectConf currentConf = new BizPackageService().getCollectConf(this.devNode);
        if (currentConf == null) {
            String notSupportDesc = ResourceUtil.getString((String)"infocollect.remind.unsupportdev");
            this.collectNewSetupLayout.getItemRootNode().setUserObject((Object)notSupportDesc);
            this.collectNewSetupLayout.getItemRootNode().setToolTips(notSupportDesc);
            return;
        }
        this.collectNewSetupLayout.getItemRootNode().setUserObject((Object)this.devNode.getIp());
        this.collectNewSetupLayout.getItemRootNode().setToolTips(this.devNode.getIp());
        currentConf.getSpecifiedModules(modeType).forEach(this::buildCheckTreeNode);
    }

    private void buildCheckTreeNode(CollectModule module) {
        CheckTreeNode moduleNode = new CheckTreeNode((Object)module, true, false);
        moduleNode.setPartSingleSelect(module.isPartSingleSelect());
        moduleNode.setGlobalSingleSelect(module.isCancelNonImmediateFamily());
        String moduleTips = module.getTips();
        if (!StringUtils.isNULLStr((String)moduleTips)) {
            moduleNode.setToolTips(moduleTips);
        }
        for (CollectItem item : module.getItems()) {
            CheckTreeNode itemNode = this.creatItemNode(module, item);
            moduleNode.add((MutableTreeNode)itemNode);
        }
        this.collectNewSetupLayout.getItemRootNode().add((MutableTreeNode)moduleNode);
    }

    @NotNull
    private CheckTreeNode creatItemNode(CollectModule module, CollectItem item) {
        CheckTreeNode itemNode = new CheckTreeNode((Object)item, false, false);
        itemNode.setSingleSelect(module.isSingleSelect() || item.isSingleSelect());
        itemNode.setDefaultSelect(item.isDefaultChoose());
        itemNode.setGlobalSingleSelect(item.isCancelNonImmediateFamily() || module.isCancelNonImmediateFamily());
        String itemTips = module.getTips();
        if (!StringUtils.isNULLStr((String)itemTips)) {
            itemNode.setToolTips(itemTips);
        }
        itemNode.setSelected(item.isDefaultChoose());
        return itemNode;
    }

    private void initNodesTable(boolean isQuicklyScene) {
        this.collectNewSetupLayout.getNodesTableModel().removeAll();
        String listName = ResourceUtil.getString((String)"node.list");
        if (this.collectNewSetupLayout.getModeComboBox().getSelectedIndex() == this.customCollectIndex) {
            ((List)this.parserInfos.stream().filter(info -> info.getTitle().equals(listName)).map(SettingParserInfo::getNodesList).findFirst().orElse(new ArrayList())).stream().filter(node -> ((String)node.get("Type")).equalsIgnoreCase("controller")).forEach(this::writeRow);
            this.setupSelectionRow(isQuicklyScene);
            this.collectNewSetupLayout.getNodesListTable().updateUI();
            return;
        }
        ((List)this.parserInfos.stream().filter(info -> info.getTitle().equals(listName)).map(SettingParserInfo::getNodesList).findFirst().orElse(new ArrayList())).forEach(this::writeRow);
        this.setupSelectionRow(isQuicklyScene);
        this.collectNewSetupLayout.getNodesListTable().updateUI();
    }

    private void setupSelectionRow(boolean isQuicklyCollect) {
        CollectConfInfo collectConfInfo = CollectDataContext.getInstance().getCollectInfo(this.devNode).getCollectConfInfo();
        List selectedNodes = ListUtils.union(collectConfInfo.getSelectedControllerNodeIds(), collectConfInfo.getSelectedExpansionModuleIds());
        if (!Utils.isNullList((List)selectedNodes)) {
            IsmTable nodesListTable = this.collectNewSetupLayout.getNodesListTable();
            nodesListTable.markTableRows(this.querySelectedIdentify(selectedNodes));
            log.info("These nodes selected last time are selected by default.");
            return;
        }
        if (isQuicklyCollect) {
            this.collectNewSetupLayout.getNodesListTable().getAllRows().stream().filter(row -> row.getValueAt(1).equals(ResourceUtil.getString((String)"collect.node.type.controllers"))).forEach(row -> this.collectNewSetupLayout.getNodesListTable().markTableRow(new TableRow[]{row}));
            log.info("Controller nodes are selected by default.");
            return;
        }
        this.collectNewSetupLayout.getNodesListTable().selectAll();
    }

    private Object[] querySelectedIdentify(List<String> selectedNodes) {
        return this.collectNewSetupLayout.getNodesListTable().getAllRows().stream().filter(row -> selectedNodes.contains((String)row.getValueAt(0))).map(TableRow::getIdentifier).toArray();
    }

    private void writeRow(Map<String, String> node) {
        String id = node.get("ID");
        DefaultTableRow row = new DefaultTableRow(this.collectNewSetupLayout.getNodeTableColumn().length, (Object)id);
        row.setValueAt(0, (Object)id);
        String type = node.get("Type").equalsIgnoreCase("controller") ? ResourceUtil.getString((String)"collect.node.type.controllers") : ResourceUtil.getString((String)"collect.node.type.smart.enclosure");
        row.setValueAt(1, (Object)type);
        row.setValueAt(2, (Object)node.get("Enclosure"));
        this.collectNewSetupLayout.getNodesTableModel().addRow(new TableRow[]{row});
    }

    public void itemAreaRefresh(int index) {
        this.collectNewSetupLayout.getItemRootNode().removeAllChildren();
        if (index == this.quicklyCollectIndex) {
            this.initItemTree(ModeType.QUICKLY_COLLECT);
            this.initNodesTable(true);
            return;
        }
        if (index == this.depthCollectIndex) {
            this.initItemTree(ModeType.DEPTH_COLLECT);
            this.initNodesTable(false);
            return;
        }
        this.initItemTree(ModeType.CUSTOM_COLLECT);
        this.initNodesTable(false);
    }

    public void showDiskSelectDialog() {
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(this.devNode);
        Integer diskInt = CollectDataContext.getInstance().getDiskTotalNumMap().get(this.devNode);
        if (InfoCollectUtil.isDiskTreeMapEmptyOrNull(diskInt, diskTreeMap)) {
            diskTreeMap = this.queryDiskInfo();
            diskInt = InfoCollectCache.getInstance().queryDiskNum(this.devNode);
            if (this.isQueryDisksInfoFailed((JDialog)((Object)this), diskInt, diskTreeMap)) {
                return;
            }
            CollectDataContext.getInstance().getGlobalConDiskHashMap().put(this.devNode, diskTreeMap);
            if (diskInt != null) {
                CollectDataContext.getInstance().getDiskTotalNumMap().put(this.devNode, diskInt);
            }
        }
        if (!this.isAllEngineSuccess(this.devNode)) {
            return;
        }
        SelectDiskMainDialog sdmdlg = new SelectDiskMainDialog(this, diskTreeMap, this.isAllDiskDetailInfoGot(diskTreeMap, diskInt), this.isDiskLocationShown(diskTreeMap));
        SwingUtil.putScreenCenter((Window)sdmdlg);
        sdmdlg.setVisible(true);
    }

    private boolean isDiskLocationShown(TreeMap<DiskLocation, Disk> diskTreeMap) {
        return diskTreeMap.firstEntry().getKey().getDiskId() == null;
    }

    private boolean isAllDiskDetailInfoGot(TreeMap<DiskLocation, Disk> diskTreeMap, Integer diskInt) {
        return diskInt != null && diskInt.intValue() == diskTreeMap.size();
    }

    private TreeMap<DiskLocation, Disk> queryDiskInfo() {
        log.info("no disk of the current device node in the context,begin to query disk of the current device node.");
        Future<TreeMap<DiskLocation, Disk>> tmpQryDiskFuture = CollectDataContext.getInstance().getGlobalQryDiskFutureMap().get(this.devNode);
        TreeMap<DiskLocation, Disk> diskTreeMap = this.getDiskLocationDiskTreeMap(tmpQryDiskFuture);
        if (VerifyUtil.isEmpty(diskTreeMap)) {
            diskTreeMap = this.doRetryQryDiskTreeMap();
        }
        return diskTreeMap;
    }

    private TreeMap<DiskLocation, Disk> getDiskLocationDiskTreeMap(Future<TreeMap<DiskLocation, Disk>> tmpQryDiskFuture) {
        DiskInfoCallable diskInfoCallable = new DiskInfoCallable(tmpQryDiskFuture);
        String echoMsg = ResourceManager.getString((String)DISK_PROCESSING_MSG);
        int loadingBoxWidth = Locale.ENGLISH.equals(ResourceManager.getLocale()) ? 270 : 220;
        List fs = AsyncExcutor.execute((Window)((Object)this), (String)echoMsg, (int)loadingBoxWidth, (Callable[])new Callable[]{diskInfoCallable});
        return Utils.isNullList((List)fs) ? new TreeMap() : (TreeMap)fs.get(0);
    }

    private TreeMap<DiskLocation, Disk> doRetryQryDiskTreeMap() {
        ExecutorService cachedThreadPool = CollectDataContext.getInstance().getCachedThredPool();
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(new CollectInfo(this.devNode), false);
        command.process();
        Future<TreeMap<DiskLocation, Disk>> deviceQryFuture = cachedThreadPool.submit(new QryDiskPythonCallable(this.parent, this.devNode, command.getCollectEnv()));
        return this.getDiskLocationDiskTreeMap(deviceQryFuture);
    }

    private boolean isAllEngineSuccess(DevNode devNode) {
        String failedEngines = InfoCollectCache.getInstance().queryFailEngine(devNode);
        if (StringUtils.isNULLStr((String)failedEngines)) {
            log.info("All engines success.");
            return true;
        }
        if (!this.isUserAcceptRiskTip(ResourceUtil.getStringWithParams((String)"disk.qry.high.end.engine.failed", (Object[])new Object[]{failedEngines}))) {
            this.normalDiskLogItemNode.setSelected(false);
            this.collectNewSetupLayout.getItemTree().updateUI();
            return false;
        }
        return true;
    }

    private boolean isUserAcceptRiskTip(String tipStr) {
        WarningDialog warnTip = DialogUtils.showYesNoWarningDialog((Window)this.parent, (String)tipStr, (String)ResourceUtil.getString((String)"disk_select_dialog_ignore.btn.name"), (String)ResourceUtil.getString((String)"disk_select_dialog_cancel.btn.name"), (int)72, (int)72);
        return warnTip.getValue() == 0;
    }

    private boolean isQueryDisksInfoFailed(JDialog parent, Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        if (diskInt != null && diskInt == -1) {
            this.showFailedDialog(parent, ResourceUtil.getString((String)"need.dbg.pwd"));
            return true;
        }
        if (diskInt != null && diskInt == -2) {
            DialogUtils.createWarningDialog((JDialog)parent, (String)ResourceUtil.getString((String)"no.disk.due.to.too.much.sensitive.disk"));
            this.normalDiskLogItemNode.setSelected(false);
            this.collectNewSetupLayout.getItemTree().updateUI();
            return true;
        }
        if (VerifyUtil.isEmpty(diskTreeMap)) {
            this.showFailedDialog(parent, ResourceUtil.getString((String)"call.python.qry.disks.failed"));
            return true;
        }
        return false;
    }

    private void showFailedDialog(JDialog parent, String msg) {
        DialogUtils.showErrorDialog((JDialog)parent, (String)msg);
        this.normalDiskLogItemNode.setSelected(false);
        this.collectNewSetupLayout.getItemTree().updateUI();
    }

    public int getQuicklyCollectIndex() {
        return this.quicklyCollectIndex;
    }

    public int getDepthCollectIndex() {
        return this.depthCollectIndex;
    }

    public int getCustomCollectIndex() {
        return this.customCollectIndex;
    }

    public CollectNewSetupLayout getCollectNewSetupLayout() {
        return this.collectNewSetupLayout;
    }

    public InfoCollectMainDialog getParent() {
        return this.parent;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public List<SettingParserInfo> getParserInfos() {
        return this.parserInfos;
    }

    public CheckTreeNode getNormalDiskLogItemNode() {
        return this.normalDiskLogItemNode;
    }

    public List<DiskLocation> getSelectedDiskLocs() {
        return this.selectedDiskLocs;
    }

    public boolean isCustomCollect() {
        return this.isCustomCollect;
    }

    public boolean isQuicklyCollect() {
        return this.isQuicklyCollect;
    }

    public boolean isDepthCollect() {
        return this.isDepthCollect;
    }

    public void setParserInfos(List<SettingParserInfo> parserInfos) {
        this.parserInfos = parserInfos;
    }

    public void setNormalDiskLogItemNode(CheckTreeNode normalDiskLogItemNode) {
        this.normalDiskLogItemNode = normalDiskLogItemNode;
    }

    public void setSelectedDiskLocs(List<DiskLocation> selectedDiskLocs) {
        this.selectedDiskLocs = selectedDiskLocs;
    }

    public void setCustomCollect(boolean isCustomCollect) {
        this.isCustomCollect = isCustomCollect;
    }

    public void setQuicklyCollect(boolean isQuicklyCollect) {
        this.isQuicklyCollect = isQuicklyCollect;
    }

    public void setDepthCollect(boolean isDepthCollect) {
        this.isDepthCollect = isDepthCollect;
    }

    public void setDevChooseDialog(DevChooseDialog devChooseDialog) {
        this.devChooseDialog = devChooseDialog;
    }

    public DevChooseDialog getDevChooseDialog() {
        return this.devChooseDialog;
    }
}

