/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.TableModel;

public class CollectNewSetupLayout
extends JPanel {
    private static final Dimension LEFT_CONTENT_SIZE = new Dimension(450, 450);
    private static final Dimension RIGHT_CONTENT_SIZE = new Dimension(330, 450);
    private static final Dimension SELECT_COMBO_SIZE = new Dimension(300, 24);
    private CheckBoxTree deviceTree;
    private CheckTreeNode deviceRootNode;
    private CheckTreeNode itemRootNode;
    private CheckBoxTree itemTree;
    private JComboBox<String> modeComboBox;
    private JCheckBox cbxConfirm;
    private IsmTable nodesListTable;
    private DefaultTableModel nodesTableModel;
    private TableScrollPane tableScrollPane;
    private String[] nodeTableColumn = new String[]{ResourceUtil.getString((String)"infocollect.set.node.table.name"), ResourceUtil.getString((String)"infocollect.set.node.table.type"), ResourceUtil.getString((String)"infocollect.set.node.table.controller.enclosure")};

    public CollectNewSetupLayout() {
        this.initUI();
    }

    private void initUI() {
        Box leftContentArea = Box.createVerticalBox();
        UiMethod.setComponentSize((Dimension)LEFT_CONTENT_SIZE, (Component[])new Component[]{leftContentArea});
        Box rightContentArea = Box.createVerticalBox();
        UiMethod.setComponentSize((Dimension)RIGHT_CONTENT_SIZE, (Component[])new Component[]{rightContentArea});
        leftContentArea.add(Box.createVerticalStrut(15));
        leftContentArea.add(UiMethod.buildCompsLeft((Component[])new Component[]{this.initSceneSelectionComponent()}));
        leftContentArea.add(Box.createVerticalStrut(15));
        leftContentArea.add(this.initCollectItemComponent());
        this.initExportByNodeCheckBox();
        this.initSelectNodeComponent();
        rightContentArea.add(Box.createVerticalStrut(15));
        rightContentArea.add(UiMethod.buildCompsLeft((Component[])new Component[]{this.cbxConfirm}));
        rightContentArea.add((Component)this.tableScrollPane);
        this.add((Component)UiMethod.createHorizontalBox((Component[])new Component[]{leftContentArea, rightContentArea}), "Center");
    }

    private void initSelectNodeComponent() {
        this.nodesTableModel = new DefaultTableModel(this.nodeTableColumn, new int[0]);
        this.nodesListTable = new IsmTable((TableModel)this.nodesTableModel);
        this.tableScrollPane = new TableScrollPane(this.nodesListTable, true, true, true);
    }

    private void initExportByNodeCheckBox() {
        this.cbxConfirm = new JCheckBox(ResourceUtil.getString((String)"infocollect.export.by.node"));
    }

    private JSplitPane initCollectItemComponent() {
        this.itemRootNode = new CheckTreeNode(new Object(), true, false);
        this.itemTree = new CheckBoxTree(this.itemRootNode, true);
        this.deviceRootNode = new CheckTreeNode(new Object(), true, false);
        this.deviceTree = new CheckBoxTree(this.deviceRootNode, false);
        JScrollPane leftArea = new JScrollPane((Component)this.deviceTree);
        JScrollPane itemArea = new JScrollPane((Component)this.itemTree);
        JSplitPane splitPane = new JSplitPane(1, true);
        splitPane.setLeftComponent(leftArea);
        splitPane.setDividerLocation(-1);
        splitPane.setRightComponent(itemArea);
        splitPane.setResizeWeight(0.33);
        splitPane.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.collectItem.title")));
        splitPane.setAlignmentX(0.5f);
        return splitPane;
    }

    private Box initSceneSelectionComponent() {
        JLabel title = new JLabel(ResourceUtil.getString((String)"infocollect.set.panel.scene.select"));
        this.modeComboBox = new JComboBox();
        this.modeComboBox.addItem(ResourceUtil.getString((String)"infocollect.set.scene.quickly.collect"));
        this.modeComboBox.addItem(ResourceUtil.getString((String)"infocollect.set.scene.depth.collect"));
        this.modeComboBox.addItem(ResourceUtil.getString((String)"infocollect.set.scene.custom.collect"));
        Box box = UCD.buildHBoxLeft((Component[])new Component[]{title, this.modeComboBox});
        UiMethod.setComponentSize((Dimension)SELECT_COMBO_SIZE, (Component[])new Component[]{box});
        return box;
    }

    public CheckBoxTree getDeviceTree() {
        return this.deviceTree;
    }

    public CheckTreeNode getDeviceRootNode() {
        return this.deviceRootNode;
    }

    public CheckTreeNode getItemRootNode() {
        return this.itemRootNode;
    }

    public CheckBoxTree getItemTree() {
        return this.itemTree;
    }

    public JComboBox<String> getModeComboBox() {
        return this.modeComboBox;
    }

    public JCheckBox getCbxConfirm() {
        return this.cbxConfirm;
    }

    public IsmTable getNodesListTable() {
        return this.nodesListTable;
    }

    public DefaultTableModel getNodesTableModel() {
        return this.nodesTableModel;
    }

    public TableScrollPane getTableScrollPane() {
        return this.tableScrollPane;
    }

    public String[] getNodeTableColumn() {
        return this.nodeTableColumn;
    }

    public void setDeviceTree(CheckBoxTree deviceTree) {
        this.deviceTree = deviceTree;
    }

    public void setDeviceRootNode(CheckTreeNode deviceRootNode) {
        this.deviceRootNode = deviceRootNode;
    }

    public void setItemRootNode(CheckTreeNode itemRootNode) {
        this.itemRootNode = itemRootNode;
    }

    public void setItemTree(CheckBoxTree itemTree) {
        this.itemTree = itemTree;
    }

    public void setModeComboBox(JComboBox<String> modeComboBox) {
        this.modeComboBox = modeComboBox;
    }

    public void setCbxConfirm(JCheckBox cbxConfirm) {
        this.cbxConfirm = cbxConfirm;
    }

    public void setNodesListTable(IsmTable nodesListTable) {
        this.nodesListTable = nodesListTable;
    }

    public void setNodesTableModel(DefaultTableModel nodesTableModel) {
        this.nodesTableModel = nodesTableModel;
    }

    public void setTableScrollPane(TableScrollPane tableScrollPane) {
        this.tableScrollPane = tableScrollPane;
    }

    public void setNodeTableColumn(String[] nodeTableColumn) {
        this.nodeTableColumn = nodeTableColumn;
    }
}

