/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.obase.ui.component.DateChooseField;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class CollectSetupLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension SIZE = new Dimension(480, 250);
    private static final int NUM_170 = 170;
    private ButtonGroup timeGroup = new ButtonGroup();
    private JRadioButton lastDayRadio = null;
    private JRadioButton lastWeekRadio = null;
    private JRadioButton lastMonthRadio = null;
    private JRadioButton customRadio = null;
    private DateChooseField startTimeField = null;
    private JLabel toLabel = null;
    private DateChooseField endTimeField = null;
    private JComponent timeArea = null;
    private JLabel datel = null;
    private CheckBoxTree deviceTree = null;
    private CheckTreeNode deviceRootNode = null;
    private CheckBoxTree itemTree = null;
    private CheckTreeNode itemRootNode = null;
    private AdvancedOptionsPanel optionsPanel = null;
    private Box contentArea = null;
    private boolean showPane = false;
    private ToolHyperLinkLabel link = new ToolHyperLinkLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify"));
    private String devicedate = "";
    private JComponent promotCom = null;

    public CollectSetupLayout(boolean showPane, String devicedate, boolean isReduceCollect, IntegrateCollectSetupDialog dialog) {
        this.showPane = showPane;
        this.devicedate = devicedate;
        this.initItemArea();
        if (isReduceCollect) {
            this.initLayoutComponent();
            this.itemTree.setName("_CheckBoxTree_itemTree");
            return;
        }
        if (dialog != null) {
            this.optionsPanel = dialog.getOptionsPanel();
        }
        this.initTimeArea();
        this.layoutComponent(isReduceCollect);
        this.setCompName();
    }

    private void initLayoutComponent() {
        JScrollPane itemArea = new JScrollPane((Component)this.itemTree);
        this.contentArea = Box.createVerticalBox();
        this.contentArea.add(itemArea);
        this.contentArea.add(Box.createVerticalStrut(12));
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)this.contentArea, (int)12), "Center");
    }

    private void layoutComponent(boolean isReduceCollect) {
        this.timeArea = this.layoutTimeArea();
        this.timeArea.setAlignmentX(0.0f);
        JComponent itemArea = this.layoutItemArea(isReduceCollect);
        itemArea.setAlignmentX(0.0f);
        this.contentArea = Box.createVerticalBox();
        this.contentArea.add(this.timeArea);
        this.contentArea.add(Box.createVerticalStrut(12));
        this.contentArea.add(itemArea);
        this.contentArea.add(Box.createVerticalStrut(12));
        if (!ApplicationContext.getInstance().isSpecificDeviceMode()) {
            JComponent modifyCon = this.createModifyCom();
            modifyCon.setAlignmentX(0.0f);
            this.contentArea.add(modifyCon);
            this.contentArea.add(Box.createVerticalStrut(12));
        }
        this.promotCom = this.createPromotCom();
        this.promotCom.setAlignmentX(0.0f);
        this.contentArea.add(this.promotCom);
        this.contentArea.add(Box.createVerticalStrut(12));
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)this.contentArea, (int)12), "Center");
    }

    private JComponent createPromotCom() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.time.desc")));
        JComponent com = UiMethod.buildFrameSpace((JComponent)UCD.buildHBoxLeft((Component[])new Component[]{box}), (int)5);
        com.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.time.title")));
        return com;
    }

    public void remorvePromotCom() {
        this.contentArea.remove(this.promotCom);
    }

    private JComponent createModifyCom() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.desc")));
        box.add((Component)this.link);
        box.add(new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.dot")));
        JComponent com = UiMethod.buildFrameSpace((JComponent)UCD.buildHBoxLeft((Component[])new Component[]{box}), (int)5);
        com.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.options.modify.title")));
        if (CollectDataContext.getInstance().isScene() && !CollectDataContext.getInstance().isStorageCollectSec()) {
            this.link.setEnabled(false);
        }
        return com;
    }

    public void removeTimeArea() {
        this.contentArea.remove(this.timeArea);
    }

    private void initItemArea() {
        this.itemRootNode = new CheckTreeNode(new Object(), true, true);
        this.itemTree = new CheckBoxTree(this.itemRootNode, true);
        this.deviceRootNode = new CheckTreeNode(new Object(), true, false);
        this.deviceTree = this.showPane ? new CheckBoxTree(this.deviceRootNode, true) : new CheckBoxTree(this.deviceRootNode, false);
    }

    private void initTimeArea() {
        this.lastDayRadio = new JRadioButton(ResourceUtil.getString((String)"infocollect.devicesetup.date.lastday"));
        this.lastWeekRadio = new JRadioButton(ResourceUtil.getString((String)"infocollect.devicesetup.date.lastweek"));
        this.lastMonthRadio = new JRadioButton(ResourceUtil.getString((String)"infocollect.devicesetup.date.lastmonth"));
        this.customRadio = new JRadioButton(ResourceUtil.getString((String)"infocollect.devicesetup.date.custom"));
        this.timeGroup.add(this.lastDayRadio);
        this.timeGroup.add(this.lastWeekRadio);
        this.timeGroup.add(this.lastMonthRadio);
        this.timeGroup.add(this.customRadio);
        if (!StringUtils.isNULLStr((String)this.devicedate)) {
            this.datel = new JLabel(ResourceUtil.getStringWithParams((String)"infocollect.devicesetup.options.date.desc", (Object[])new Object[]{this.devicedate}));
        }
        this.startTimeField = new DateChooseField(2);
        this.toLabel = new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.date.to"));
        this.endTimeField = new DateChooseField(2);
        UiMethod.setComponentSize((Dimension)new Dimension(170, this.startTimeField.getPreferredSize().height), (Component[])new Component[]{this.startTimeField, this.endTimeField});
        this.enableCustomField(false);
    }

    public void enableCustomField(boolean isEnable) {
        this.startTimeField.setEnabled(isEnable);
        this.toLabel.setEnabled(isEnable);
        this.endTimeField.setEnabled(isEnable);
    }

    private JComponent layoutTimeArea() {
        Box firstRowBox = Box.createHorizontalBox();
        firstRowBox.add(this.lastDayRadio);
        firstRowBox.add(Box.createHorizontalStrut(12));
        firstRowBox.add(Box.createHorizontalStrut(12));
        firstRowBox.add(this.lastWeekRadio);
        firstRowBox.add(Box.createHorizontalStrut(12));
        firstRowBox.add(Box.createHorizontalStrut(12));
        firstRowBox.add(this.lastMonthRadio);
        firstRowBox.add(Box.createHorizontalGlue());
        firstRowBox.setAlignmentX(0.0f);
        Box secRowBox = Box.createHorizontalBox();
        secRowBox.add(this.customRadio);
        secRowBox.add(Box.createHorizontalStrut(8));
        secRowBox.add((Component)this.startTimeField);
        secRowBox.add(Box.createHorizontalStrut(8));
        secRowBox.add(this.toLabel);
        secRowBox.add(Box.createHorizontalStrut(8));
        secRowBox.add((Component)this.endTimeField);
        secRowBox.add(Box.createHorizontalGlue());
        secRowBox.setAlignmentX(0.0f);
        Box contentBox = Box.createVerticalBox();
        if (null != this.datel) {
            contentBox.add(this.datel);
            contentBox.add(Box.createVerticalStrut(10));
        }
        contentBox.add(firstRowBox);
        contentBox.add(Box.createVerticalStrut(10));
        contentBox.add(secRowBox);
        JComponent area = UiMethod.buildFrameSpace((JComponent)contentBox, (int)12);
        area.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.date.title")));
        return area;
    }

    private JComponent layoutItemArea(boolean isReduceCollect) {
        JScrollPane leftArea = new JScrollPane((Component)this.deviceTree);
        JScrollPane itemArea = new JScrollPane((Component)this.itemTree);
        JSplitPane splitPane = new JSplitPane(1, true);
        if (isReduceCollect) {
            splitPane.setLeftComponent(this.optionsPanel);
            splitPane.setDividerLocation(650);
        } else {
            splitPane.setLeftComponent(leftArea);
            splitPane.setDividerLocation(-1);
        }
        splitPane.setRightComponent(itemArea);
        splitPane.setResizeWeight(0.33);
        splitPane.setBorder(BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.devicesetup.collectItem.title")));
        splitPane.setPreferredSize(SIZE);
        return splitPane;
    }

    public void setCompName() {
        this.lastDayRadio.setName("_RadioButton_lastDayRadio");
        this.lastWeekRadio.setName("_RadioButton_lastWeekRadio");
        this.lastMonthRadio.setName("_RadioButton_lastMonthRadio");
        this.customRadio.setName("_RadioButton_customRadio");
        this.startTimeField.setName("_DateChooseField_startTimeField");
        this.endTimeField.setName("_DateChooseField_endTimeField");
        this.deviceTree.setName("_CheckBoxTree_endTimeField");
        this.itemTree.setName("_CheckBoxTree_itemTree");
        this.link.setName("_ToolHyperLinkLabel_link");
    }

    public JRadioButton getLastDayRadio() {
        return this.lastDayRadio;
    }

    public JRadioButton getLastWeekRadio() {
        return this.lastWeekRadio;
    }

    public JRadioButton getLastMonthRadio() {
        return this.lastMonthRadio;
    }

    public JRadioButton getCustomRadio() {
        return this.customRadio;
    }

    public DateChooseField getStartTimeField() {
        return this.startTimeField;
    }

    public DateChooseField getEndTimeField() {
        return this.endTimeField;
    }

    public JComponent getTimeArea() {
        return this.timeArea;
    }

    public CheckBoxTree getDeviceTree() {
        return this.deviceTree;
    }

    public CheckTreeNode getDeviceRootNode() {
        return this.deviceRootNode;
    }

    public CheckBoxTree getItemTree() {
        return this.itemTree;
    }

    public CheckTreeNode getItemRootNode() {
        return this.itemRootNode;
    }

    public ToolHyperLinkLabel getLink() {
        return this.link;
    }

    public String getDevicedate() {
        return this.devicedate;
    }

    public AdvancedOptionsPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    public Box getContentArea() {
        return this.contentArea;
    }

    public JComponent getPromotCom() {
        return this.promotCom;
    }

    public void setPromotCom(JComponent promotCom) {
        this.promotCom = promotCom;
    }
}

