/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.CollectInfoBuilder;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSelectionListener
implements TreeSelectionListener,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(DeviceSelectionListener.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceSelectionListener.class);
    private IntegrateCollectSetupDialog dialog = null;
    private DevNode currentDevNode = null;

    public DeviceSelectionListener(IntegrateCollectSetupDialog dialog) {
        this.dialog = dialog;
    }

    private boolean hasSelectedNodes() {
        if (!this.currentDevNode.isDsStorage()) {
            return true;
        }
        boolean hasClusterNodeSelected = false;
        for (ClusterNode cn : this.currentDevNode.getClusterNodes()) {
            if (!cn.isSelected()) continue;
            hasClusterNodeSelected = true;
            break;
        }
        if (!hasClusterNodeSelected) {
            DialogUtils.showErrorDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getStringWithParams((String)"select.nodes.no.nodes.checked", (Object[])new Object[]{this.currentDevNode.getIp()}));
            return false;
        }
        return true;
    }

    private boolean hasSelectedTimes() {
        if (!this.currentDevNode.isDsStorage()) {
            return true;
        }
        AdvancedOptionsPanel optionsPanel = this.dialog.getCollectlayout().getOptionsPanel();
        if (optionsPanel != null && optionsPanel.isTimeEmpty()) {
            LOGGER.error("did not choose time");
            DialogUtils.showErrorDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getStringWithParams((String)"select.nodes.no.times.checked", (Object[])new Object[]{this.currentDevNode.getIp()}));
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CollectInfoBuilder builder;
        if (this.currentDevNode == null) {
            this.currentDevNode = this.dialog.getDeviceNode();
        }
        this.saveCurrentCollectItem();
        if (!(!this.dialog.getDeviceNode().isDsStorage() || this.hasSelectedTimes() && this.hasSelectedNodes())) {
            return;
        }
        if (!this.dialog.getIntegrateXMLFile().isEmpty()) {
            this.saveCurrentSelectedNode();
        }
        if (!(builder = new CollectInfoBuilder(this.dialog)).checkInput() || !builder.checkOptionsInput()) {
            return;
        }
        IntegrateCollectInfo collectInfo = builder.build();
        if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(this.currentDevNode)) {
            if (!builder.checkTimeSettingInput()) {
                return;
            }
            this.saveComputeNodesInfo(collectInfo);
        }
        CollectDataContext.getInstance().putCollectInfo(this.dialog.getDeviceNode(), collectInfo);
        this.applySendModeToSelectDevice();
        LOGGER.info("Confirm >> Set device {} collect items][Success", (Object)this.currentDevNode.getIp());
        LOGGER.info("dispose dialog:{}", (Object)this.dialog);
        this.dialog.dispose();
    }

    private void saveComputeNodesInfo(ICollectInfo collectInfo) {
        CollectDuration duration = this.dialog.getTimeSettingPanel().getDuration();
        Map<String, ComputeNodeParam> computeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.currentDevNode);
        for (ComputeNodeParam param : computeNodesInfo.values()) {
            param.setStartTime(duration.getStartDate().getTime());
            param.setEndTime(duration.getEndDate().getTime());
            List collectItems = Optional.ofNullable(collectInfo).map(ICollectInfo::getCollectInfoes).map(mp -> (CollectInfo)mp.get(this.currentDevNode)).map(CollectInfo::getCollectConfInfo).map(CollectConfInfo::getSelectItems).orElse(Collections.emptyList());
            this.clearLogInfo(param);
            if (CollectionUtils.isEmpty(collectItems)) {
                log.error("collectItems is empty");
                return;
            }
            param.setLogInfo(collectItems.stream().filter(item -> item.getModuleId().equals(param.getShowName())).map(CollectItem::getNameKey).collect(Collectors.toList()));
        }
    }

    private void clearLogInfo(ComputeNodeParam param) {
        param.setLogInfo(new ArrayList<String>());
    }

    private void applySendModeToSelectDevice() {
        if (this.dialog.getDevChooseDialog() == null) {
            return;
        }
        ICollectInfo collinfo = InfoCollectService.getInstance().getCollectInfoInstance(this.currentDevNode);
        if (null == collinfo) {
            throw new NullPointerException();
        }
        List<DevNode> devNodes = this.dialog.getDevChooseDialog().getSelectDevNode();
        List<CollectItem> curNodeSelItems = this.dialog.getAllCollectItems().get(this.currentDevNode);
        for (DevNode current : devNodes) {
            ICollectInfo collectInfo = InfoCollectService.getInstance().getCollectInfoInstance(current);
            CollectItem prvNormalDiskLogItem = null;
            if (null == collectInfo) continue;
            prvNormalDiskLogItem = this.getPreviousSelectedNormalDiskLogCollectItem(collectInfo);
            List<CollectItem> oldSelectedItems = collectInfo.getCollectConfInfo().getSelectItems();
            List<CollectItem> allItems = this.getAllItems(current);
            oldSelectedItems.clear();
            for (CollectItem ci : curNodeSelItems) {
                if (ci.getId().equals("normal_disklog") || !allItems.contains(ci)) continue;
                oldSelectedItems.add(ci);
            }
            if (null != prvNormalDiskLogItem) {
                collectInfo.getCollectConfInfo().getSelectItems().add(prvNormalDiskLogItem);
            }
            collectInfo.getCollectConfInfo().setSelectItems(oldSelectedItems);
        }
    }

    private List<CollectItem> getAllItems(DevNode devNode) {
        List<CollectItem> allItems = new ArrayList<CollectItem>();
        CollectConf conf = new BizPackageService().getCollectConf(devNode);
        if (conf == null) {
            return allItems;
        }
        allItems = conf.getAllCollectItems();
        return allItems;
    }

    private CollectItem getPreviousSelectedNormalDiskLogCollectItem(ICollectInfo collectInfo) {
        CollectItem normalDiskLogCollectItem = new CollectItem("normal_disklog");
        List<CollectItem> oldSelectedItems = collectInfo.getCollectConfInfo().getSelectItems();
        boolean isNormalDisklogItemPreviouslySelected = oldSelectedItems.contains(normalDiskLogCollectItem);
        if (isNormalDisklogItemPreviouslySelected) {
            for (CollectItem ci : oldSelectedItems) {
                if (!ci.equals(normalDiskLogCollectItem)) continue;
                return ci;
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.dialog.getIntegrateXMLFile().isEmpty()) {
            CheckTreeNode lastCheckTreeNode = this.getOldTreeNode(treeSelectionEvent);
            lastCheckTreeNode.setSelected(false);
            lastCheckTreeNode.setHilight(false);
            if (this.currentDevNode == null) {
                this.currentDevNode = this.dialog.getDeviceNode();
            }
            if (lastCheckTreeNode.equals(this.dialog.getCollectlayout().getDeviceRootNode())) {
                LOGGER.info("last choose is root node...");
            } else {
                this.saveCurrentCollectItem();
            }
            CheckTreeNode newTreeNode = this.getNewTreeNode(treeSelectionEvent);
            if (!newTreeNode.equals(this.dialog.getCollectlayout().getDeviceRootNode())) {
                String ip = newTreeNode.getUserObject().toString();
                this.currentDevNode = this.getDevNodebyIP(ip);
                if (null != this.currentDevNode) {
                    this.dialog.initCollectItemTree(this.currentDevNode);
                    this.dialog.initCollectConfInfoItem(this.dialog.getAllCollectItems().get(this.currentDevNode));
                }
            }
            this.dialog.repaint();
        }
    }

    private void saveCurrentCollectItem() {
        List<CollectItem> items = this.dialog.parseChooseCollectItem();
        this.dialog.getAllCollectItems().put(this.currentDevNode, items);
    }

    private void saveCurrentSelectedNode() {
        this.dialog.parseChooseSelectedNode();
    }

    private DevNode getDevNodebyIP(String ip) {
        for (DevNode devNode : this.dialog.getDevNodes()) {
            if (!devNode.getIp().equals(ip)) continue;
            return devNode;
        }
        return null;
    }

    private CheckTreeNode getOldTreeNode(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
        if (treePath == null) {
            return (CheckTreeNode)this.dialog.getCollectlayout().getDeviceRootNode().getFirstChild();
        }
        return (CheckTreeNode)treePath.getLastPathComponent();
    }

    private CheckTreeNode getNewTreeNode(TreeSelectionEvent treeSelectionEvent) {
        return (CheckTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
    }
}

