/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.util.concurrent.Callable;
import javax.swing.JDialog;

public class InitOptionsPanel
implements Callable<Boolean> {
    private DevNode devNode;
    private IntegrateCollectSetupDialog dialog;

    public InitOptionsPanel(DevNode devNode, IntegrateCollectSetupDialog dialog) {
        this.devNode = devNode;
        this.dialog = dialog;
    }

    @Override
    public Boolean call() {
        BizPackageService bizPackageService = new BizPackageService();
        this.dialog.setOptionsPanel(new AdvancedOptionsPanel(bizPackageService.getSettingConf(this.devNode), this.devNode, (JDialog)((Object)this.dialog)));
        this.dialog.getOptionsPanel().setName("_Panel_optionsPanel");
        this.bindListener();
        return true;
    }

    private void bindListener() {
        if (null != this.devNode && this.devNode.isDsStorage()) {
            this.dialog.getOptionsPanel().getPatchComponent().setPostHandler(() -> {
                TaskResult result = new TaskResult();
                PackageConf packageConfig = InfoConfiguration.getInstance().getPackageConf(this.devNode);
                if (null != packageConfig) {
                    String path = CollectDataContext.getInstance().getIgetPackagesPath().getPackagePath() + File.separator + packageConfig.getFolder();
                    FileUtils.clearDir((String)FilePathUtils.checkFile((String)path));
                }
                if (!CollectDeviceService.getInstance().getResourceFileAndImportAsPackage(this.devNode)) {
                    result.setResult(TaskResult.Result.FAILED);
                    result.setErrorLocaleDescription(ResourceUtil.getString((String)"download.info.res.files.failed"));
                    return result;
                }
                result.setResult(TaskResult.Result.SUCCESS);
                this.dialog.initCollectItemTree(this.devNode);
                return result;
            });
        }
    }
}

