/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.SVPModuleInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskWithNode;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectConfInfo;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.CollectInfo;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.IntegrateNode;
import com.huawei.ism.tool.infocollect.entity.ItemConditionTag;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.service.logic.command.CreateCollectEnvCommand;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.parser.IntegrateXmlParser;
import com.huawei.ism.tool.infocollect.ui.setup.AdvancedOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.ApplyActionListener;
import com.huawei.ism.tool.infocollect.ui.setup.CancelBtnActionListener;
import com.huawei.ism.tool.infocollect.ui.setup.CollectSetupLayout;
import com.huawei.ism.tool.infocollect.ui.setup.ConfirmationWithSignDialog;
import com.huawei.ism.tool.infocollect.ui.setup.CustomDateSelectListener;
import com.huawei.ism.tool.infocollect.ui.setup.DeviceSelectionListener;
import com.huawei.ism.tool.infocollect.ui.setup.DiskInfoCallable;
import com.huawei.ism.tool.infocollect.ui.setup.InieTimeSettingPanel;
import com.huawei.ism.tool.infocollect.ui.setup.InitOptionsPanel;
import com.huawei.ism.tool.infocollect.ui.setup.ModifyClickApplyListener;
import com.huawei.ism.tool.infocollect.ui.setup.MyCustAddListner;
import com.huawei.ism.tool.infocollect.ui.setup.QryDiskPythonCallable;
import com.huawei.ism.tool.infocollect.ui.setup.QueryDiskForNodeCallable;
import com.huawei.ism.tool.infocollect.ui.setup.SelectDiskMainDialog;
import com.huawei.ism.tool.infocollect.ui.setup.SelectDiskWithNodeDialog;
import com.huawei.ism.tool.infocollect.ui.setup.TimeSettingPanel;
import com.huawei.ism.tool.infocollect.ui.support.devselect.DevChooseDialog;
import com.huawei.ism.tool.infocollect.util.ApplyRange;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.DateChooseField;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrateCollectSetupDialog
extends PublicDialog {
    protected static final String NORMAL_DISK_LOG_COLLECT_ITEM_ID = "normal_disklog";
    protected static final String ALL_FAULT_DISK_LOG_COLLECT_ITEM_ID = "all_fault_disklog";
    protected static final String RECENT_FAULT_DISK_LOG_COLLECT_ITEM_ID = "recent_fault_disklog";
    protected static final String DIAGNOSTIC_COLLECT_ITEM_ID = "diagnostic";
    private static final long serialVersionUID = 1L;
    private static final String DISK_PROCESSING_MSG = "DISK_PROCESSING_MSG";
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrateCollectSetupDialog.class);
    private static final Dimension DSTORAGE_SIZE = new Dimension(650, 610);
    private Map<String, Object> qryDiskEnv = new HashMap<String, Object>();
    private CollectSetupLayout collectlayout = null;
    private boolean isSimpleCollect;
    private CheckTreeNode normalDiskLogItemNode = null;
    private CheckTreeNode faultDiskLogItemNode = null;
    private CheckTreeNode diagnosticItemNode = null;
    private boolean isUserSelectDiskWithNode = false;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private DevNode deviceNode = null;
    private List<ExecuteResult> results = new ArrayList<ExecuteResult>();
    private DevChooseDialog devChooseDialog = null;
    private List<DevNode> devNodes = null;
    private Map<DevNode, List<CollectItem>> allCollectItems = new HashMap<DevNode, List<CollectItem>>();
    private Map<DevNode, String> debugPasswords = new HashMap<DevNode, String>();
    private boolean integrate = false;
    private String integrateXML = "";
    private StringBuffer selectedIntegrate = null;
    private AdvancedOptionsPanel optionsPanel = null;
    private TimeSettingPanel timeSettingPanel;
    private String deviceDate = "";
    private boolean diskSelectDlgConfirmed = false;
    private List<DiskLocation> selectedDiskLocs = new ArrayList<DiskLocation>();
    private List<DiskWithNode> selectedDiskWithNode = new ArrayList<DiskWithNode>();
    private InfoCollectMainDialog collectMainDlg;

    private IntegrateCollectSetupDialog(JDialog parent, String xml, String devicedate) {
        this(parent, xml, devicedate, null, false);
    }

    private IntegrateCollectSetupDialog(JDialog parent, String xml, String devicedate, DevNode node, boolean isChooseSimpleCollect) {
        super(parent, true);
        this.deviceNode = node;
        this.deviceDate = devicedate;
        if (parent instanceof InfoCollectMainDialog) {
            this.collectMainDlg = (InfoCollectMainDialog)parent;
        }
        this.integrateXML = xml;
        if (!this.integrateXML.isEmpty()) {
            this.integrate = true;
        }
        this.isSimpleCollect = isChooseSimpleCollect;
        this.collectlayout = new CollectSetupLayout(this.integrate, devicedate, this.isSimpleCollect, this);
        this.initUI();
        this.addListener();
        this.setCompName();
    }

    public static void showCollectSetupDialog(JDialog parent, DevNode deviceNode, String tempXML, String devicedate, boolean isChooseSimpleCollect) {
        IntegrateCollectSetupDialog dialog = null;
        if (deviceNode.isDsStorage()) {
            dialog = new IntegrateCollectSetupDialog(parent, tempXML, devicedate, deviceNode, isChooseSimpleCollect);
            dialog.setPreferredSize(DSTORAGE_SIZE);
            dialog.setResizable(true);
        } else {
            dialog = new IntegrateCollectSetupDialog(parent, tempXML, devicedate);
        }
        if (!dialog.initData(deviceNode)) {
            LOGGER.info("Device is not supported,device:{}", (Object)deviceNode.getDeviceType());
            String descrtipion = ResourceUtil.getString((String)"infocollect.remind.unsupportproduct");
            descrtipion = deviceNode.isMiniSystem() ? ResourceUtil.getString((String)"infocollect.devtype.minisystem") : descrtipion.replace("{0}", deviceNode.getDeviceType().toString() + " " + deviceNode.getProductVersion());
            if (!ApplicationContext.getInstance().isJunit()) {
                DialogUtils.showInfoDialog((JDialog)parent, (String)descrtipion);
            }
            return;
        }
        if (!ApplicationContext.getInstance().isJunit()) {
            dialog.setVisible(true);
        }
    }

    public CheckTreeNode getDiagnosticItemNode() {
        return this.diagnosticItemNode;
    }

    public void setDiagnosticItemNode(CheckTreeNode diagnosticItemNode) {
        this.diagnosticItemNode = diagnosticItemNode;
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"infocollect.devicesetup.title"));
        JPanel comPanel = this.getContentPanel();
        comPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab(ResourceUtil.getString((String)"infocollect.devicesetup.basesetuptitle"), this.collectlayout);
        comPanel.add((Component)this.tabbedPane, "Center");
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            this.setAppButtonVisible(false);
        }
        this.setHelpButtonVisiable(false);
        JButton appB = this.getAppBtn();
        appB.setText(ResourceUtil.getString((String)"infocollect.button.apply"));
        appB.setMnemonic('A');
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)((Object)this));
        this.setModal(true);
    }

    private boolean initData(DevNode devNode) {
        CollectDeviceService deviceService = CollectDeviceService.getInstance();
        BizPackageService bizPackageService = new BizPackageService();
        this.deviceNode = devNode;
        this.devNodes = deviceService.getIntegratedNodes(devNode);
        CollectConf mainConf = bizPackageService.getCollectConf(devNode);
        if (mainConf == null) {
            return false;
        }
        if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode) && mainConf.getModules().isEmpty()) {
            this.addErrorInfoPanel();
            return true;
        }
        ICollectInfo collectInfo = CollectDataContext.getInstance().getCollectInfo(this.deviceNode);
        this.results = collectInfo.getExecuteResults();
        CollectConfInfo mainConfInfo = collectInfo.getCollectConfInfo();
        this.remindDebug(devNode);
        this.initSelectItems(collectInfo);
        this.setEnableDate(mainConf);
        if (this.integrate) {
            this.initIntegrateNodeTree();
        } else {
            this.initCollectDeviceTree();
        }
        this.initSelectedIntegratedNode(collectInfo);
        this.initCollectItemTree(this.deviceNode);
        this.initCollectConfInfoToUI(mainConf, mainConfInfo);
        this.checkSettingScenarios(devNode, bizPackageService);
        return true;
    }

    private void checkSettingScenarios(DevNode devNode, BizPackageService bizPackageService) {
        JButton appB;
        if (!this.isSimpleCollect && bizPackageService.hasAdvancedOptions(devNode) && !InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode)) {
            if (devNode.getDeviceType().equals((Object)DeviceType.valueOf((String)"OceanStor9000")) || devNode.isDsStorage()) {
                appB = this.getAppBtn();
                appB.setEnabled(false);
            }
            AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new InitOptionsPanel(devNode, this)});
            this.tabbedPane.addTab(ResourceUtil.getString((String)"infocollect.devicesetup.optionstitle"), this.optionsPanel);
        }
        if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(devNode)) {
            AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new InieTimeSettingPanel(devNode, this, this.deviceDate)});
            this.tabbedPane.addTab(ResourceUtil.getString((String)"infocollect.time.devicesetup"), this.timeSettingPanel);
        } else {
            this.collectlayout.remorvePromotCom();
        }
        if (ItDeviceType.T3000.equals((Object)this.deviceNode.getItDeviceType()) || InfoCollectUtil.isComputeStorageDev(this.deviceNode)) {
            this.collectlayout.getLink().setEnabled(false);
            appB = this.getAppBtn();
            appB.setEnabled(false);
        }
    }

    private void addErrorInfoPanel() {
        this.getCollectlayout().getContentArea().removeAll();
        this.getCollectlayout().getContentArea().add(InfoCollectUtil.createErrorInfoPanel(ResourceUtil.getString((String)"infocollect.flash.device.init.setup.options.error")));
    }

    private void remindDebug(DevNode devNode) {
        CollectDeviceService deviceService = CollectDeviceService.getInstance();
        ApplyRange rangeType = deviceService.getDevNodeApplyRange(devNode);
        if (ApplyRange.ALL.equals((Object)rangeType) && !this.checkAllRange()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"infocollect.devicesetup.needdeveloper"));
        } else if (ApplyRange.CLUSTER.equals((Object)rangeType) && !this.checkCluster()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"infocollect.devicesetup.needdeveloper"));
        } else {
            LOGGER.info("the type is unsupported {}", (Object)rangeType);
        }
    }

    private boolean checkAllRange() {
        BizPackageService bizPackageService = new BizPackageService();
        this.debugPasswords = bizPackageService.getNeedDebugDevNode(this.devNodes, this.deviceNode);
        String debugPwd = this.deviceNode.getDeveloperPwd();
        return this.debugPasswords.isEmpty() || !StringUtils.isNULLStr((String)debugPwd);
    }

    private boolean checkCluster() {
        BizPackageService bizPackageService = new BizPackageService();
        for (DevNode node : this.devNodes) {
            if (!bizPackageService.isExistCollection(this.deviceNode, node) || !bizPackageService.isNeedDebug(node)) continue;
            return false;
        }
        return true;
    }

    private void initSelectedIntegratedNode(ICollectInfo collectInfo) {
        for (DevNode devNode : this.devNodes) {
            CollectConfInfo confInfo;
            String diviceType = devNode.getDeviceType().toString();
            String path = CollectDeviceService.getInstance().getIntegrateScriptPath(devNode);
            if (!path.contains("real_integrate_find.py") || (confInfo = collectInfo.getCollectConfInfo(devNode)) == null) continue;
            this.setSelectStatus(confInfo, diviceType);
        }
    }

    private void setSelectStatus(CollectConfInfo confInfo, String deviceType) {
        String seletctedNodeNames = confInfo.getSelectedIntegrateNode();
        String[] selectedNodeName = seletctedNodeNames.split(",");
        Set allNodes = this.collectlayout.getDeviceTree().getAllNodes(this.collectlayout.getDeviceRootNode());
        for (String nodeName : selectedNodeName) {
            for (CheckTreeNode node : allNodes) {
                if (nodeName.equals(node.getUserObject()) && deviceType.contains("UDS") && node.isLeaf()) {
                    node.setSelected(true);
                    continue;
                }
                if (!nodeName.equals(node.getUserObject()) || deviceType.contains("UDS")) continue;
                node.setSelected(true);
            }
        }
    }

    private void initSelectItems(ICollectInfo collectInfo) {
        for (DevNode devNode : this.devNodes) {
            ArrayList<CollectItem> selectItems = new ArrayList<CollectItem>();
            CollectConfInfo confInfo = collectInfo.getCollectConfInfo(devNode);
            if (confInfo != null) {
                selectItems.addAll(confInfo.getSelectItems());
            }
            this.allCollectItems.put(devNode, selectItems);
        }
    }

    private void initCollectConfInfoToUI(CollectConf mainConf, CollectConfInfo mainConfInfo) {
        this.initCollectConfInfoTime(mainConf, mainConfInfo);
        this.initCollectConfInfoItem(mainConfInfo.getSelectItems());
    }

    void initCollectConfInfoItem(List<CollectItem> selectItems) {
        Enumeration e = this.collectlayout.getItemRootNode().preorderEnumeration();
        while (e.hasMoreElements()) {
            CheckTreeNode currentNode = (CheckTreeNode)e.nextElement();
            if (selectItems.contains(currentNode.getUserObject())) {
                currentNode.setSelected(true);
                continue;
            }
            currentNode.setSelected(false);
        }
    }

    private void initCollectConfInfoTime(CollectConf mainConf, CollectConfInfo mainConfInfo) {
        if (!mainConfInfo.getDuration().equals(CollectDuration.INVALIDD)) {
            if (mainConfInfo.getDuration().equals(CollectDuration.LASTDAY)) {
                this.collectlayout.getLastDayRadio().setSelected(true);
            } else if (mainConfInfo.getDuration().equals(CollectDuration.LASTMONTH)) {
                this.collectlayout.getLastMonthRadio().setSelected(true);
            } else if (mainConfInfo.getDuration().equals(CollectDuration.LASTWEEK)) {
                this.collectlayout.getLastWeekRadio().setSelected(true);
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.collectlayout.enableCustomField(true);
                this.collectlayout.getCustomRadio().setSelected(true);
                Date start = mainConfInfo.getStartDate();
                if (null == start) {
                    throw new NullPointerException();
                }
                DateChooseField startTimeField = this.collectlayout.getStartTimeField();
                if (null == startTimeField) {
                    throw new NullPointerException();
                }
                startTimeField.setText(format.format(start));
                DateChooseField endTimeField = this.collectlayout.getEndTimeField();
                Date end = mainConfInfo.getEndDate();
                if (null == endTimeField || null == end) {
                    throw new NullPointerException();
                }
                endTimeField.setText(format.format(end));
            }
        }
    }

    void initCollectItemTree(DevNode devNode) {
        this.collectlayout.getItemRootNode().removeAllChildren();
        this.attachItemTreeNode(devNode);
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectlayout.getItemRootNode(), false);
        this.collectlayout.getItemTree().setModel((TreeModel)newTreeModel);
        this.collectlayout.getItemTree().setRootVisible(true);
        this.collectlayout.getItemTree().setShowsRootHandles(true);
        this.collectlayout.getItemTree().expandAll(true);
    }

    private void initCollectDeviceTree() {
        this.collectlayout.getDeviceRootNode().removeAllChildren();
        String allDevice = ResourceUtil.getString((String)"infocollect.devicesetup.alldevice");
        this.collectlayout.getDeviceRootNode().setUserObject((Object)allDevice);
        this.collectlayout.getDeviceRootNode().setToolTips(allDevice);
        this.attachDeviceTreeNode(this.collectlayout.getDeviceRootNode(), this.devNodes);
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectlayout.getDeviceRootNode(), false);
        this.collectlayout.getDeviceTree().setModel((TreeModel)newTreeModel);
        this.collectlayout.getDeviceTree().setRootVisible(true);
        this.collectlayout.getDeviceTree().setShowsRootHandles(true);
        this.collectlayout.getDeviceTree().expandAll(true);
    }

    private void initIntegrateNodeTree() {
        this.collectlayout.getDeviceRootNode().removeAllChildren();
        IntegrateNode rootNode = this.getRootNode();
        String allDevice = ResourceUtil.getString((String)"infocollect.devicesetup.alldevice");
        this.collectlayout.getDeviceRootNode().setUserObject((Object)allDevice);
        this.collectlayout.getDeviceRootNode().setToolTips(allDevice);
        if (null != rootNode) {
            this.constructDeviceTree(this.collectlayout.getDeviceRootNode(), rootNode);
        }
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.collectlayout.getDeviceRootNode(), false);
        this.collectlayout.getDeviceTree().setModel((TreeModel)newTreeModel);
        this.collectlayout.getDeviceTree().setRootVisible(true);
        this.collectlayout.getDeviceTree().setShowsRootHandles(true);
        this.collectlayout.getDeviceTree().expandAll(false);
    }

    private void constructDeviceTree(CheckTreeNode parent, IntegrateNode rootNode) {
        List<IntegrateNode> subNodes = rootNode.getSubNodes();
        for (IntegrateNode integrateNode : subNodes) {
            CheckTreeNode checkTreeNode = new CheckTreeNode((Object)integrateNode.getNodeName(), true, true);
            checkTreeNode.setToolTips(integrateNode.getNodeType() + " " + integrateNode.getNodeIP());
            checkTreeNode.setUserObject((Object)integrateNode.getNodeName());
            parent.add((MutableTreeNode)checkTreeNode);
            checkTreeNode.setSelected(false);
            this.constructDeviceTree(checkTreeNode, integrateNode);
        }
    }

    private IntegrateNode getRootNode() {
        IntegrateNode rootNode = null;
        IntegrateXmlParser parser = new IntegrateXmlParser(this.deviceNode);
        if (parser.init(this.integrateXML)) {
            rootNode = parser.parse();
        } else {
            LOGGER.error("!!@@##rootNode is not got normally!!@@##");
        }
        return rootNode;
    }

    private void attachItemTreeNode(DevNode devNode) {
        CollectConf currentConf = new BizPackageService().getCollectConf(devNode);
        if (currentConf == null) {
            String noSupportDesc = ResourceUtil.getString((String)"infocollect.remind.unsupportdev");
            this.collectlayout.getItemRootNode().setUserObject((Object)noSupportDesc);
            this.collectlayout.getItemRootNode().setToolTips(noSupportDesc);
            this.allCollectItems.put(devNode, new ArrayList());
            return;
        }
        this.collectlayout.getItemRootNode().setUserObject((Object)devNode.getIp());
        this.collectlayout.getItemRootNode().setToolTips(devNode.getIp());
        for (CollectModule module : currentConf.getModules()) {
            if (this.isSimpleCollect && ModeType.of(module.getMode()) != ModeType.SIMPLE_COLLECT || !this.isSimpleCollect && ModeType.of(module.getMode()) == ModeType.SIMPLE_COLLECT) continue;
            CheckTreeNode moduleNode = new CheckTreeNode((Object)module, true, true);
            moduleNode.setPartSingleSelect(module.isPartSingleSelect());
            moduleNode.setGlobalSingleSelect(module.isCancelNonImmediateFamily());
            String moduleTips = module.getTips();
            if (!StringUtils.isNULLStr((String)moduleTips)) {
                moduleNode.setToolTips(moduleTips);
            }
            int count = 0;
            for (CollectItem item : module.getItems()) {
                if (ItemConditionTag.checkItemTag(item.getItemConditionTag(), devNode)) {
                    String log = "Dev %s item %s is meet tag %s ";
                    LOGGER.info(String.format(Locale.ROOT, log, devNode.getIp(), item.getId(), item.getItemConditionTag()));
                    continue;
                }
                CheckTreeNode itemNode = new CheckTreeNode((Object)item, false, true);
                itemNode.setSingleSelect(module.isSingleSelect() || item.isSingleSelect());
                itemNode.setDefaultSelect(item.isDefaultChoose());
                itemNode.setGlobalSingleSelect(item.isCancelNonImmediateFamily() || module.isCancelNonImmediateFamily());
                String itemTips = module.getTips();
                if (!StringUtils.isNULLStr((String)itemTips)) {
                    itemNode.setToolTips(itemTips);
                }
                moduleNode.add((MutableTreeNode)itemNode);
                ++count;
            }
            if (count == 0) continue;
            this.collectlayout.getItemRootNode().add((MutableTreeNode)moduleNode);
        }
    }

    private void attachDeviceTreeNode(CheckTreeNode parent, List<DevNode> nodes) {
        for (DevNode devNode : nodes) {
            CheckTreeNode checkTreeNode = new CheckTreeNode((Object)devNode.getIp(), true, false);
            checkTreeNode.setToolTips(devNode.getDeviceType() + " " + devNode.getProductVersion());
            parent.add((MutableTreeNode)checkTreeNode);
        }
        ((CheckTreeNode)parent.getFirstChild()).setHilight(true);
        ((CheckTreeNode)parent.getFirstChild()).setSelected(true);
    }

    private void addListener() {
        JRadioButton lastDay = this.collectlayout.getLastDayRadio();
        lastDay.addActionListener(new CustomDateSelectListener(this.collectlayout));
        JRadioButton lastMon = this.collectlayout.getLastMonthRadio();
        lastMon.addActionListener(new CustomDateSelectListener(this.collectlayout));
        JRadioButton lastWeek = this.collectlayout.getLastWeekRadio();
        lastWeek.addActionListener(new CustomDateSelectListener(this.collectlayout));
        JRadioButton custRa = this.collectlayout.getCustomRadio();
        custRa.addActionListener(new CustomDateSelectListener(this.collectlayout));
        DeviceSelectionListener listener = new DeviceSelectionListener(this);
        this.collectlayout.getDeviceTree().addTreeSelectionListener((TreeSelectionListener)listener);
        this.collectlayout.getItemTree().addMouseListener((MouseListener)new CheckItemTreeMouseListener());
        JButton app = this.getAppBtn();
        app.addActionListener(new ApplyActionListener(this));
        JButton canb = this.getCancelBtn();
        canb.addActionListener(new CancelBtnActionListener(this));
        JButton okb = this.getOkBtn();
        okb.addActionListener(new MyCustAddListner(this, listener));
        ToolHyperLinkLabel link = this.collectlayout.getLink();
        link.addClickListener((ToolHyperLinkLabel.ClickListener)new ModifyClickApplyListener(this));
    }

    public void showDiskSelectDialog(IntegrateCollectSetupDialog inteCollectSetupDlg, boolean normalDiskLogItemSelected, boolean clearAllChecked, CollectItem item) {
        boolean isAllDiskDetailInfoGot;
        DevNode devNode = inteCollectSetupDlg.getDeviceNode();
        if (this.isCollectDiskWithNode(item)) {
            if (!normalDiskLogItemSelected) {
                this.setSelectedDiskWithNode(new ArrayList<DiskWithNode>());
                return;
            }
            List<DiskWithNode> cacheDisks = CollectDataContext.getInstance().getGlobalConDiskHashMapForDiskWithNode().get(devNode);
            this.showDiskWithNodeSelectDialog(inteCollectSetupDlg, cacheDisks, item, clearAllChecked);
            return;
        }
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
        Integer diskInt = CollectDataContext.getInstance().getDiskTotalNumMap().get(devNode);
        if (this.isDiskTreeMapEmptyOrNull(diskInt, diskTreeMap)) {
            diskTreeMap = this.queryDiskInfo(inteCollectSetupDlg, devNode);
            diskInt = InfoCollectCache.getInstance().queryDiskNum(devNode);
            if (!this.checkQueryInfo((JDialog)((Object)inteCollectSetupDlg), diskInt, diskTreeMap)) {
                return;
            }
            this.syncDiskInfo2Context(devNode, diskInt, diskTreeMap);
        } else {
            LOGGER.info("There is disk of the current device node in the context.");
        }
        boolean isDiskLocationShown = diskTreeMap.firstEntry().getKey().getDiskId() == null;
        boolean bl = isAllDiskDetailInfoGot = diskInt != null && diskInt.intValue() == diskTreeMap.size();
        if (!this.check4EngineStatus(devNode)) {
            return;
        }
        SelectDiskMainDialog sdmdlg = new SelectDiskMainDialog(inteCollectSetupDlg, diskTreeMap, normalDiskLogItemSelected, isAllDiskDetailInfoGot, isDiskLocationShown);
        SwingUtil.putScreenCenter((Window)sdmdlg);
        sdmdlg.setVisible(true);
    }

    private void showFaildDialog(JDialog parent, String msg) {
        DialogUtils.showErrorDialog((JDialog)parent, (String)msg);
        this.getNormalDiskLogItemNode().setSelected(false);
        this.getCollectlayout().getItemTree().updateUI();
    }

    private void syncDiskInfo2Context(DevNode devNode, Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        CollectDataContext.getInstance().getGlobalConDiskHashMap().put(devNode, diskTreeMap);
        if (null != diskInt) {
            CollectDataContext.getInstance().getDiskTotalNumMap().put(devNode, diskInt);
        }
    }

    private boolean checkQueryInfo(JDialog parent, Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        if (diskInt != null && diskInt == -1) {
            this.showFaildDialog(parent, ResourceUtil.getString((String)"need.dbg.pwd"));
            return false;
        }
        if (diskInt != null && diskInt == -2) {
            DialogUtils.createWarningDialog((JDialog)parent, (String)ResourceUtil.getString((String)"no.disk.due.to.too.much.sensitive.disk"));
            this.getNormalDiskLogItemNode().setSelected(false);
            this.getCollectlayout().getItemTree().updateUI();
            return false;
        }
        if (this.isMapEmptyOrNull(diskTreeMap)) {
            this.showFaildDialog(parent, ResourceUtil.getString((String)"call.python.qry.disks.failed"));
            return false;
        }
        return true;
    }

    private void showDiskWithNodeSelectDialog(IntegrateCollectSetupDialog inteCollectSetupDlg, List<DiskWithNode> cacheDisks, CollectItem item, boolean clearAllChecked) {
        List<DiskWithNode> actualCacheDisks = cacheDisks;
        if (actualCacheDisks == null || actualCacheDisks.isEmpty()) {
            LOGGER.info("no disk with node from cache, try getData ");
            actualCacheDisks = this.queryDiskWithNodeFromPython(inteCollectSetupDlg, item);
        }
        this.setUserSelectDiskWithNode(false);
        SelectDiskWithNodeDialog dialog = new SelectDiskWithNodeDialog(this, actualCacheDisks, clearAllChecked, ResourceUtil.getString((String)"diskwithnode_highwarn"));
        SwingUtil.putScreenCenter((Window)dialog);
        dialog.setVisible(true);
    }

    private TreeMap<DiskLocation, Disk> queryDiskInfo(IntegrateCollectSetupDialog inteCollectSetupDlg, DevNode devNode) {
        LOGGER.info("no disk of the current device node in the context,begin to query disk of the current device node.");
        Future<TreeMap<DiskLocation, Disk>> tmpQryDiskFuture = CollectDataContext.getInstance().getGlobalQryDiskFutureMap().get(devNode);
        DiskInfoCallable diskInfoCallable = new DiskInfoCallable(tmpQryDiskFuture);
        String echoMsg = ResourceManager.getString((String)DISK_PROCESSING_MSG);
        int loadingBoxWidth = Locale.ENGLISH.equals(ResourceManager.getLocale()) ? 270 : 220;
        List fs = AsyncExcutor.execute((Window)((Object)inteCollectSetupDlg), (String)echoMsg, (int)loadingBoxWidth, (Callable[])new Callable[]{diskInfoCallable});
        TreeMap<DiskLocation, Disk> diskTreeMap = (TreeMap<DiskLocation, Disk>)fs.get(0);
        if (this.isMapEmptyOrNull(diskTreeMap)) {
            diskTreeMap = this.doRetryQryDiskTreeMap(inteCollectSetupDlg, devNode);
        }
        return diskTreeMap;
    }

    private boolean isCollectDiskWithNode(CollectItem item) {
        return !StringUtils.isNULLStr((String)item.getCollectDiskWithNode()) && "Y".equalsIgnoreCase(item.getCollectDiskWithNode());
    }

    private boolean isDiskTreeMapEmptyOrNull(Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        return null == diskInt || this.isMapEmptyOrNull(diskTreeMap);
    }

    private List<DiskWithNode> queryDiskWithNodeFromPython(IntegrateCollectSetupDialog inteCollectSetupDlg, CollectItem item) {
        ExecutorService cachedThreadPool = CollectDataContext.getInstance().getCachedThredPool();
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(new CollectInfo(this.deviceNode), false);
        command.process();
        QueryDiskForNodeCallable queryDiskCallable = new QueryDiskForNodeCallable(this.collectMainDlg, this.deviceNode, command.getCollectEnv(), item);
        String echoMsg = ResourceManager.getString((String)DISK_PROCESSING_MSG);
        int loadingBoxWidth = Locale.ENGLISH.equals(ResourceManager.getLocale()) ? 270 : 220;
        List fs = AsyncExcutor.execute((Window)((Object)inteCollectSetupDlg), (String)echoMsg, (int)loadingBoxWidth, (Callable[])new Callable[]{queryDiskCallable});
        List disks = (List)fs.get(0);
        CollectDataContext.getInstance().getGlobalConDiskHashMapForDiskWithNode().put(inteCollectSetupDlg.getDeviceNode(), disks);
        return disks;
    }

    private TreeMap<DiskLocation, Disk> doRetryQryDiskTreeMap(IntegrateCollectSetupDialog inteCollectSetupDlg, DevNode devNode) {
        ExecutorService cachedThreadPool = CollectDataContext.getInstance().getCachedThredPool();
        CreateCollectEnvCommand command = new CreateCollectEnvCommand(new CollectInfo(this.deviceNode), false);
        command.process();
        Future<TreeMap<DiskLocation, Disk>> deviceQryFuture = cachedThreadPool.submit(new QryDiskPythonCallable(this.collectMainDlg, this.deviceNode, command.getCollectEnv()));
        DiskInfoCallable diskInfoCallable = new DiskInfoCallable(deviceQryFuture);
        String echoMsg = ResourceManager.getString((String)DISK_PROCESSING_MSG);
        int loadingBoxWidth = Locale.ENGLISH.equals(ResourceManager.getLocale()) ? 270 : 220;
        List fs = AsyncExcutor.execute((Window)((Object)inteCollectSetupDlg), (String)echoMsg, (int)loadingBoxWidth, (Callable[])new Callable[]{diskInfoCallable});
        if (null == fs || fs.isEmpty()) {
            return null;
        }
        return (TreeMap)fs.get(0);
    }

    private boolean check4EngineStatus(DevNode devNode) {
        String tipStr;
        String failedEngines = InfoCollectCache.getInstance().queryFailEngine(devNode);
        if (!StringUtils.isNULLStr((String)failedEngines) && !this.isUserAcceptRiskTip(tipStr = ResourceUtil.getStringWithParams((String)"disk.qry.high.end.engine.failed", (Object[])new Object[]{failedEngines}))) {
            this.getNormalDiskLogItemNode().setSelected(false);
            this.getCollectlayout().getItemTree().updateUI();
            return false;
        }
        return true;
    }

    private boolean isUserAcceptRiskTip(String tipStr) {
        String okInfo = ResourceUtil.getString((String)"disk_select_dialog_ignore.btn.name");
        String cancelInfo = ResourceUtil.getString((String)"disk_select_dialog_cancel.btn.name");
        int okWidth = 72;
        int cancelWith = 72;
        WarningDialog warnTip = DialogUtils.showYesNoWarningDialog((Window)((Object)this), (String)tipStr, (String)okInfo, (String)cancelInfo, (int)okWidth, (int)cancelWith);
        int result = warnTip.getValue();
        warnTip.setVisible(false);
        return result == 0;
    }

    public void modifyClickApply() {
        CollectDeviceService deviceService = CollectDeviceService.getInstance();
        ApplyRange rangeType = deviceService.getDevNodeApplyRange(this.deviceNode);
        if (ApplyRange.ALL.equals((Object)rangeType)) {
            this.modifyApplyByAll();
        } else if (ApplyRange.CLUSTER.equals((Object)rangeType)) {
            this.modifyApplyByAllCluster();
        } else {
            LOGGER.info("the type is unsupported {}", (Object)rangeType);
        }
    }

    private void modifyApplyByAll() {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List<DevNode> devs = CollectDeviceService.getInstance().getAllDevNode();
        ArrayList<DevNode> modifyDevs = new ArrayList<DevNode>();
        for (DevNode devNode : devs) {
            if (!InfoCollectUtil.isSupportDev(devNode) || InfoCollectService.getInstance().isDevNodeCollecting(devNode)) continue;
            modifyDevs.add(devNode);
        }
        idm.showModifyDeviceDialog((Window)((Object)this), true, this.deviceNode.getIp(), EntityUtils.toNewDevList(modifyDevs));
    }

    private void modifyApplyByAllCluster() {
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List<DevNode> devs = CollectDeviceService.getInstance().getAllDevNode();
        ArrayList<DevNode> modifyDevs = new ArrayList<DevNode>();
        for (DevNode devNode : devs) {
            if (!InfoCollectUtil.isSupportDev(devNode) || InfoCollectService.getInstance().isDevNodeCollecting(devNode)) continue;
            modifyDevs.add(devNode);
        }
        CheckBoxTree deviceTree = this.collectlayout.getDeviceTree();
        List<DevNode> integratedNodes = CollectDeviceService.getInstance().getIntegratedNodes(this.deviceNode);
        if (integratedNodes.size() > 1) {
            int[] selectionRows = deviceTree.getSelectionRows();
            if (null == selectionRows) {
                throw new NullPointerException();
            }
            if (selectionRows.length > 0) {
                int row = selectionRows[0];
                DevNode devNode = integratedNodes.get(row - 1);
                idm.showModifyIntegrateDeviceDialog((Window)((Object)this), true, devNode.getIp(), EntityUtils.toNewDevList(integratedNodes));
                CollectDeviceService.getInstance().putIntegratedDebug(integratedNodes);
            } else {
                idm.showModifyIntegrateDeviceDialog((Window)((Object)this), true, this.deviceNode.getIp(), EntityUtils.toNewDevList(integratedNodes));
            }
        } else {
            idm.showModifyDeviceDialog((Window)((Object)this), true, this.deviceNode.getIp(), EntityUtils.toNewDevList(modifyDevs));
        }
    }

    public void setCompName() {
        this.collectlayout.setName("_Panel_collectlayout");
    }

    private void setEnableDate(CollectConf mainConf) {
        if (mainConf.isEnableDate()) {
            this.collectlayout.getTimeArea().setEnabled(true);
            this.collectlayout.getLastDayRadio().setEnabled(true);
            this.collectlayout.getLastWeekRadio().setEnabled(true);
            this.collectlayout.getLastMonthRadio().setEnabled(true);
            this.collectlayout.getCustomRadio().setEnabled(true);
            this.collectlayout.getLastDayRadio().setSelected(true);
        } else {
            this.collectlayout.getTimeArea().setEnabled(false);
            this.collectlayout.getLastDayRadio().setEnabled(false);
            this.collectlayout.getLastWeekRadio().setEnabled(false);
            this.collectlayout.getLastMonthRadio().setEnabled(false);
            this.collectlayout.getCustomRadio().setEnabled(false);
            this.collectlayout.getTimeArea().setToolTipText(ResourceUtil.getString((String)"infocollect.remind.collecttimeunsupport"));
            this.collectlayout.removeTimeArea();
            this.pack();
        }
    }

    List<CollectItem> parseChooseCollectItem() {
        if (this.collectlayout.getItemRootNode().getChildCount() == 0) {
            LOGGER.info("not support device!!!!!");
            return Collections.emptyList();
        }
        Enumeration e = this.collectlayout.getItemRootNode().preorderEnumeration();
        ArrayList<CollectItem> selectItems = new ArrayList<CollectItem>();
        ArrayList<CollectItem> moveItems = new ArrayList<CollectItem>();
        while (e.hasMoreElements()) {
            CheckTreeNode current = (CheckTreeNode)e.nextElement();
            Object object = current.getUserObject();
            if (!current.isSelected() || !(object instanceof CollectItem)) continue;
            CollectItem collectItem = (CollectItem)object;
            if (collectItem.getMode() == ModeType.MOVE) {
                moveItems.add(collectItem);
            }
            selectItems.add(collectItem);
        }
        selectItems.addAll(this.getMoveOriginItems(moveItems));
        return selectItems;
    }

    private List<CollectItem> getMoveOriginItems(List<CollectItem> moveItems) {
        if (this.isSimpleCollect) {
            return Collections.emptyList();
        }
        Enumeration ele = this.collectlayout.getItemRootNode().preorderEnumeration();
        ArrayList<CollectItem> originItems = new ArrayList<CollectItem>();
        while (ele.hasMoreElements()) {
            CollectItem collectItem;
            Object obj = ele.nextElement();
            if (!(obj instanceof CheckTreeNode)) continue;
            CheckTreeNode current = (CheckTreeNode)obj;
            Object userObject = current.getUserObject();
            if (current.isSelected() || !(userObject instanceof CollectItem) || !this.isOriginItem(collectItem = (CollectItem)userObject, moveItems)) continue;
            originItems.add(collectItem);
        }
        return originItems;
    }

    private List<CollectItem> getSimpleCollectOriginItems(List<CollectItem> moveItems) {
        CollectConf currentConf = new BizPackageService().getCollectConf(this.deviceNode);
        return currentConf.getAllCollectItems().stream().filter(collectItem -> this.isOriginItem((CollectItem)collectItem, moveItems)).distinct().collect(Collectors.toList());
    }

    private boolean isOriginItem(CollectItem collectItem, List<CollectItem> moveItems) {
        return collectItem.getMode() != ModeType.MOVE && moveItems.stream().anyMatch(item -> item.getId().equals(collectItem.getId()));
    }

    public void parseChooseSelectedNode() {
        Enumeration e = this.collectlayout.getDeviceRootNode().preorderEnumeration();
        StringBuffer integrateName = new StringBuffer();
        while (e.hasMoreElements()) {
            CheckTreeNode current = (CheckTreeNode)e.nextElement();
            if (!current.isSelected() || !current.isLeaf()) continue;
            integrateName.append(current.getUserObject());
            integrateName.append(',');
        }
        if (integrateName.length() != 0) {
            integrateName.deleteCharAt(integrateName.lastIndexOf(","));
        }
        this.selectedIntegrate = integrateName;
    }

    public CollectSetupLayout getCollectlayout() {
        return this.collectlayout;
    }

    public void setCollectlayout(CollectSetupLayout collectlayout) {
        this.collectlayout = collectlayout;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public DevNode getDeviceNode() {
        return this.deviceNode;
    }

    public void setDeviceNode(DevNode deviceNode) {
        this.deviceNode = deviceNode;
    }

    public List<ExecuteResult> getResults() {
        return this.results;
    }

    public DevChooseDialog getDevChooseDialog() {
        return this.devChooseDialog;
    }

    public void setDevChooseDialog(DevChooseDialog devChooseDialog) {
        this.devChooseDialog = devChooseDialog;
    }

    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }

    public boolean isIntegrate() {
        return this.integrate;
    }

    public Map<DevNode, List<CollectItem>> getAllCollectItems() {
        return this.allCollectItems;
    }

    public Map<DevNode, String> getDebugPasswords() {
        return this.debugPasswords;
    }

    public String getIntegrateXMLFile() {
        return this.integrateXML;
    }

    public StringBuffer getSelectedIntegrate() {
        return this.selectedIntegrate;
    }

    public void setSelectedIntegrate(StringBuffer selectedIntegrate) {
        this.selectedIntegrate = selectedIntegrate;
    }

    public AdvancedOptionsPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    public void setOptionsPanel(AdvancedOptionsPanel optionsPanel) {
        this.optionsPanel = optionsPanel;
    }

    public Map<String, Object> getCollectEnv() {
        return this.qryDiskEnv;
    }

    public void setCollectEnv(Map<String, Object> collectEnv) {
        this.qryDiskEnv = collectEnv;
    }

    public CheckTreeNode getNormalDiskLogItemNode() {
        return this.normalDiskLogItemNode;
    }

    public void setNormalDiskLogItemNode(CheckTreeNode normalDiskLogItemNode) {
        this.normalDiskLogItemNode = normalDiskLogItemNode;
    }

    protected CheckTreeNode getFaultDiskLogItemNode() {
        return this.faultDiskLogItemNode;
    }

    protected void setFaultDiskLogItemNode(CheckTreeNode faultDiskLogItemNode) {
        this.faultDiskLogItemNode = faultDiskLogItemNode;
    }

    public boolean isUserSelectDiskWithNode() {
        return this.isUserSelectDiskWithNode;
    }

    public void setUserSelectDiskWithNode(boolean userSelectDiskWithNode) {
        this.isUserSelectDiskWithNode = userSelectDiskWithNode;
    }

    public void setDiskSelectDlgConfirmed(boolean diskSelectDlgConfirmed) {
        this.diskSelectDlgConfirmed = diskSelectDlgConfirmed;
    }

    public boolean isDiskSelectDlgConfirmed() {
        return this.diskSelectDlgConfirmed;
    }

    public List<DiskLocation> getSelectedDiskLocs() {
        return this.selectedDiskLocs;
    }

    public void setSelectedDiskLocs(List<DiskLocation> selectedDiskLocs) {
        this.selectedDiskLocs = selectedDiskLocs;
    }

    public List<DiskWithNode> getSelectedDiskWithNode() {
        return this.selectedDiskWithNode;
    }

    public void setSelectedDiskWithNode(List<DiskWithNode> selectedDiskWithNode) {
        this.selectedDiskWithNode = selectedDiskWithNode;
    }

    private boolean isMapEmptyOrNull(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public void setTimeSettingPanel(TimeSettingPanel timeSettingPanel) {
        this.timeSettingPanel = timeSettingPanel;
    }

    public TimeSettingPanel getTimeSettingPanel() {
        return this.timeSettingPanel;
    }

    class CheckItemTreeMouseListener
    extends MouseAdapter {
        CheckItemTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            CheckTreeNode node = (CheckTreeNode)IntegrateCollectSetupDialog.this.collectlayout.getItemTree().getLastSelectedPathComponent();
            if (null == node) {
                LOGGER.warn("Last selected item node is null, return.");
                return;
            }
            Object clickObj = node.getUserObject();
            if (null == clickObj || !(clickObj instanceof CollectItem)) {
                LOGGER.info("Click object is not collect item object, ignored.");
                return;
            }
            CollectItem ci = (CollectItem)clickObj;
            if (ci.getId().equalsIgnoreCase(IntegrateCollectSetupDialog.ALL_FAULT_DISK_LOG_COLLECT_ITEM_ID) || ci.getId().equalsIgnoreCase(IntegrateCollectSetupDialog.RECENT_FAULT_DISK_LOG_COLLECT_ITEM_ID)) {
                if (this.isHighEndDevice()) {
                    this.informOuterSVPNotPermited(node);
                    return;
                }
            } else if (ci.getId().equals(IntegrateCollectSetupDialog.NORMAL_DISK_LOG_COLLECT_ITEM_ID)) {
                IntegrateCollectSetupDialog.this.setNormalDiskLogItemNode(node);
                if (this.isHighEndDevice()) {
                    this.informOuterSVPNotPermited(node);
                    return;
                }
                try {
                    this.settingJudgment(node, ci);
                }
                catch (Throwable t) {
                    LOGGER.error("Showing disk select dialog exception:" + t.toString());
                }
            }
        }

        private void settingJudgment(CheckTreeNode node, CollectItem item) {
            boolean showHighWarning = true;
            String warningStr = ResourceUtil.getStringWithParams((String)"disk.log.collect.time.tip", (Object[])new Object[0]);
            DevNode devNode = IntegrateCollectSetupDialog.this.getDeviceNode();
            Integer diskInt = 0;
            if (!StringUtils.isNULLStr((String)item.getCollectDiskWithNode()) && "Y".equalsIgnoreCase(item.getCollectDiskWithNode())) {
                List<DiskWithNode> totalDisk = CollectDataContext.getInstance().getGlobalConDiskHashMapForDiskWithNode().get(devNode);
                showHighWarning = node.isSelected();
            } else {
                diskInt = CollectDataContext.getInstance().getDiskTotalNumMap().get(devNode);
                TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
                showHighWarning = this.checkHighWarning(diskInt, diskTreeMap, showHighWarning);
            }
            if (showHighWarning && !this.usrConfirmRiskProcedure(IntegrateCollectSetupDialog.this.collectMainDlg, warningStr)) {
                IntegrateCollectSetupDialog.this.normalDiskLogItemNode.setSelected(!node.isSelected());
                return;
            }
            IntegrateCollectSetupDialog.this.showDiskSelectDialog(IntegrateCollectSetupDialog.this, node.isSelected(), false, item);
        }

        private boolean checkHighWarning(Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap, boolean showHighWarning) {
            if (null != diskInt && !IntegrateCollectSetupDialog.this.isMapEmptyOrNull(diskTreeMap)) {
                List<DiskLocation> cacheSelectedDiskLocs = IntegrateCollectSetupDialog.this.getSelectedDiskLocs();
                return this.surveyHW(cacheSelectedDiskLocs, showHighWarning, diskTreeMap);
            }
            return showHighWarning;
        }

        public boolean surveyHW(List<DiskLocation> cacheSelectedDiskLocs, boolean showHighWarning, TreeMap<DiskLocation, Disk> diskTreeMap) {
            if (cacheSelectedDiskLocs.isEmpty()) {
                for (Disk disk : diskTreeMap.values()) {
                    if (!disk.isChecked()) continue;
                    showHighWarning = false;
                    break;
                }
            } else {
                showHighWarning = false;
            }
            return showHighWarning;
        }

        private boolean usrConfirmRiskProcedure(JDialog parent, String warningStr) {
            LOGGER.info("pop up collection risk warning dialog !");
            ConfirmationWithSignDialog signialog = new ConfirmationWithSignDialog((Window)parent, warningStr);
            signialog.setVisible(true);
            if (0 == signialog.getResultValue()) {
                LOGGER.info("detected user confirmed this operation!");
                return true;
            }
            LOGGER.info("detected user canceled this operation!");
            return false;
        }

        private void informOuterSVPNotPermited(CheckTreeNode node) {
            String qryDiskFailErrMsg = ResourceUtil.getString((String)"svp.outter.not.support.disklog.collect");
            DialogUtils.showErrorDialog((JDialog)((Object)IntegrateCollectSetupDialog.this), (String)qryDiskFailErrMsg);
            node.setSelected(false);
            IntegrateCollectSetupDialog.this.getCollectlayout().getItemTree().updateUI();
        }

        private boolean isHighEndDevice() {
            DevNode devNode = IntegrateCollectSetupDialog.this.getDeviceNode();
            boolean ipListAreInnerIp = devNode.isIpListAreInnerIp();
            boolean is18000DevType = false;
            is18000DevType = SVPModuleInfo.OLD_TOOLBOX.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo()) ? DeviceTypeUtil.isDeviceHasSVPModule((String)devNode.getProductVersion(), (String)devNode.getDeviceType().toString()) : DeviceTypeUtil.isDeviceHasSVPModule((String)devNode.getProductVersion(), (String)devNode.getDeviceType().toString(), (boolean)SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo()));
            return is18000DevType && !ipListAreInnerIp && !devNode.canEnterDiagnose();
        }
    }
}

