/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.pubservice.entity.enums.SVPModuleInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.ui.setup.ConfirmationWithSignDialog;
import com.huawei.ism.tool.infocollect.ui.setup.DeviceSelectionListener;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCustAddListner
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyCustAddListner.class);
    private final IntegrateCollectSetupDialog collectSetupDialog;
    private final DeviceSelectionListener listener;

    MyCustAddListner(IntegrateCollectSetupDialog collectSetupDialog, DeviceSelectionListener listener) {
        this.collectSetupDialog = collectSetupDialog;
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (null != this.collectSetupDialog.getOptionsPanel() && !this.collectSetupDialog.getOptionsPanel().getPatchComponent().leaveCheck()) {
            return;
        }
        List<CollectItem> selectedItems = this.collectSetupDialog.parseChooseCollectItem();
        Iterator<CollectItem> itr = selectedItems.iterator();
        DevNode devNode = this.collectSetupDialog.getDeviceNode();
        boolean isNormalDiskLogItemSelected = false;
        boolean isHighEndDeviceOtrSvp = this.isHighEndDeviceRunOtrSvp();
        boolean isTipRequired = false;
        while (!devNode.isDsStorage() && itr.hasNext()) {
            boolean isContinue;
            int selectNum;
            CollectItem ci = itr.next();
            if (this.isTipRequired(ci, isHighEndDeviceOtrSvp)) {
                this.disSelectTreenode(ci);
                isTipRequired = true;
                continue;
            }
            if (!ci.getId().equals("normal_disklog")) continue;
            boolean isCollectDiskWithNode = !StringUtils.isNULLStr((String)ci.getCollectDiskWithNode()) && "Y".equalsIgnoreCase(ci.getCollectDiskWithNode());
            isNormalDiskLogItemSelected = true;
            if (isHighEndDeviceOtrSvp) {
                isTipRequired = true;
                this.disSelectTreenode(ci);
                continue;
            }
            int n = selectNum = isCollectDiskWithNode ? this.collectSetupDialog.getSelectedDiskWithNode().size() : this.collectSetupDialog.getSelectedDiskLocs().size();
            if (selectNum > 0 && !isCollectDiskWithNode) {
                List<DiskLocation> selectedLocs = this.collectSetupDialog.getSelectedDiskLocs();
                LOGGER.info("Selected disk is: {}", selectedLocs);
                CollectDataContext.getInstance().updateDevSelectedDiskCheckStatus(devNode, selectedLocs);
                continue;
            }
            if (this.isDiskCheckedButNoCache(isCollectDiskWithNode, devNode)) {
                this.isReturn(ci);
                return;
            }
            if (!isCollectDiskWithNode) continue;
            boolean bl = isContinue = this.collectSetupDialog.getSelectedDiskWithNode().isEmpty() && !this.collectSetupDialog.isUserSelectDiskWithNode();
            if (isContinue) continue;
            CollectDataContext.getInstance().updateGlobalCacheCheckStatus(this.collectSetupDialog.getSelectedDiskWithNode(), devNode);
        }
        this.handler(actionEvent, devNode, isNormalDiskLogItemSelected, isHighEndDeviceOtrSvp, isTipRequired);
    }

    private void handler(ActionEvent actionEvent, DevNode devNode, boolean isNormalDiskLogItemSelected, boolean isHighEndDeviceOtrSvp, boolean isTipRequired) {
        boolean showDialog;
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(devNode);
        if (!isNormalDiskLogItemSelected) {
            CollectDataContext.getInstance().clearDiskCheckStatus(diskTreeMap);
            CollectDataContext.getInstance().clearDiskWithNodeAllSelected(devNode);
        }
        boolean bl = showDialog = isHighEndDeviceOtrSvp && isTipRequired;
        if (showDialog) {
            this.informOuterSVPNotPermited();
            return;
        }
        this.listener.actionPerformed(actionEvent);
    }

    private void isReturn(CollectItem ci) {
        CheckTreeNode normalDiskLogNode = this.collectSetupDialog.getCollectlayout().getItemTree().getTreeNodeByUserObj((Object)ci);
        if (null == normalDiskLogNode) {
            return;
        }
        String warningStr = ResourceUtil.getStringWithParams((String)"disk.log.collect.time.tip", (Object[])new Object[0]);
        if (!this.usrConfirmRiskProcedure((JDialog)((Object)this.collectSetupDialog), warningStr)) {
            normalDiskLogNode.setSelected(false);
            return;
        }
        this.collectSetupDialog.setNormalDiskLogItemNode(normalDiskLogNode);
        this.collectSetupDialog.showDiskSelectDialog(this.collectSetupDialog, true, true, ci);
    }

    private boolean isTipRequired(CollectItem ci, boolean isHighEndDeviceOtrSvp) {
        return ("all_fault_disklog".equalsIgnoreCase(ci.getId()) || "recent_fault_disklog".equalsIgnoreCase(ci.getId())) && isHighEndDeviceOtrSvp;
    }

    private boolean isDiskCheckedButNoCache(boolean isCollectDiskWithNode, DevNode devNode) {
        return isCollectDiskWithNode && (this.collectSetupDialog.isUserSelectDiskWithNode() && this.collectSetupDialog.getSelectedDiskWithNode().isEmpty() || !this.collectSetupDialog.isUserSelectDiskWithNode() && CollectDataContext.getInstance().getSelectedDiskWithNodeForPython(devNode).isEmpty()) || !isCollectDiskWithNode && CollectDataContext.getInstance().getSelectedDiskFromContext(devNode).isEmpty();
    }

    private boolean usrConfirmRiskProcedure(JDialog parent, String warningStr) {
        LOGGER.info("pop up collection risk warning dialog !");
        ConfirmationWithSignDialog signialog = new ConfirmationWithSignDialog((Window)parent, warningStr);
        signialog.setVisible(true);
        if (0 == signialog.getResultValue()) {
            LOGGER.info("detected user confirmed this operation!");
            return true;
        }
        LOGGER.info("detected user canceled this operation!");
        return false;
    }

    private void disSelectTreenode(CollectItem ci) {
        if (null == ci) {
            return;
        }
        CheckTreeNode selectedTreeNode = this.collectSetupDialog.getCollectlayout().getItemTree().getTreeNodeByUserObj((Object)ci);
        if (null != selectedTreeNode) {
            selectedTreeNode.setSelected(false);
        }
    }

    private void informOuterSVPNotPermited() {
        String qryDiskFailErrMsg = ResourceUtil.getString((String)"svp.outter.not.support.disklog.collect");
        DialogUtils.showErrorDialog((JDialog)((Object)this.collectSetupDialog), (String)qryDiskFailErrMsg);
        this.collectSetupDialog.getCollectlayout().getItemTree().updateUI();
    }

    private boolean isHighEndDeviceRunOtrSvp() {
        DevNode devNode = this.collectSetupDialog.getDeviceNode();
        String devTypeStr = devNode.getDeviceType().toString();
        String devVersionStr = devNode.getProductVersion();
        boolean ipListAreInnerIp = devNode.isIpListAreInnerIp();
        boolean is18000DevType = false;
        is18000DevType = SVPModuleInfo.OLD_TOOLBOX.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo()) ? DeviceTypeUtil.isDeviceHasSVPModule((String)devVersionStr, (String)devTypeStr) : DeviceTypeUtil.isDeviceHasSVPModule((String)devVersionStr, (String)devTypeStr, (boolean)SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo()));
        return is18000DevType && !ipListAreInnerIp && !devNode.canEnterDiagnose();
    }
}

